/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.AbstractStructure;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPEEntity;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.io.Serializable;

public class ZPEModule
extends ZPEEntity
implements ZPEPropertyWrapper {
    String name;
    BinarySearchTree<String, ZPEFunction> functions = new BinarySearchTree();
    BinarySearchTree<String, ZPEType> constants = new BinarySearchTree();

    public ZPEModule(ZPERuntimeEnvironment runtime, String name, IAST code) throws ExitHalt, BreakPointHalt, ZPEException {
        Serializable struc;
        this.name = name;
        this.ownerRuntime = runtime;
        ZPERuntimeEnvironment x = new ZPERuntimeEnvironment();
        x.globalTraverse(code);
        for (String f : x.globalFunction.functionMap.keySet()) {
            ZPEFunction func = x.globalFunction.functionMap.get(f);
            func.setParent(this);
            func.ownerRuntime = runtime;
            this.functions.put(f, func);
        }
        for (String f : x.globalFunction.variableMap.keySet()) {
            this.constants.put(f, x.globalFunction.variableMap.get((String)f).value);
        }
        for (String s : x.globalFunction.structureMap.keySet()) {
            struc = (ZPEStructure)x.globalFunction.structureMap.get(s);
            struc.parent = this;
            struc.ownerRuntime = runtime;
            this.structureMap.put(s, struc);
        }
        for (String s : x.globalFunction.abstractStructureMap.keySet()) {
            struc = (AbstractStructure)x.globalFunction.abstractStructureMap.get(s);
            this.abstractStructureMap.put(s, struc);
        }
        runtime.modules.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ZPEType getVariable(String n) {
        return this.constants.get(n);
    }

    @Override
    public void setProperty(String n, ZPEType value) throws ZPERuntimeException {
        throw new ZPERuntimeException("Cannot set constant " + n + " in module " + this.getName());
    }

    @Override
    public void setProperty(String n, ZPEType value, byte type) throws ZPERuntimeException {
        throw new ZPERuntimeException("Cannot set constant " + n + " in module " + this.getName());
    }

    @Override
    public void removeProperty(String n) {
        throw new ZPERuntimeException("Cannot remove constant " + n + " in module " + this.getName());
    }

    @Override
    public boolean hasVariable(String key) {
        return this.constants.containsKey(key);
    }

    @Override
    public ZPEVariable getRawVariable(String n) {
        return null;
    }

    @Override
    public ZPEPropertyWrapper getParent() {
        return this.ownerRuntime.globalFunction;
    }

    @Override
    public ZPEType copyOfMe() {
        return null;
    }

    public ZPEFunction getFunction(String id) {
        if (this.functions.containsKey(id)) {
            return this.functions.get(id);
        }
        return ((ZPEFunction)this.getParent()).getFunction(id);
    }
}

