/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.zpe.core.AbstractRecord;
import jamiebalfour.zpe.core.AbstractStructure;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPERecord;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

abstract class ZPEEntity
implements ZPEPropertyWrapper,
ZPEType {
    protected ZPERuntimeEnvironment ownerRuntime;
    Map<String, ZPEStructure> structureMap = new HashMap<String, ZPEStructure>();
    Map<String, ZPERecord> recordMap = new HashMap<String, ZPERecord>();
    Map<String, AbstractStructure> abstractStructureMap = new HashMap<String, AbstractStructure>();
    Map<String, AbstractRecord> abstractRecordMap = new HashMap<String, AbstractRecord>();

    ZPEEntity() {
    }

    public AbstractStructure getAbstractStructure(String id) {
        ZPEEntity current = this;
        while (!current.hasStructure(id)) {
            if (current.getParent() == null) continue;
            current = (ZPEEntity)current.getParent();
        }
        if (current.hasStructure(id)) {
            return current.abstractStructureMap.get(id);
        }
        return null;
    }

    protected ZPERuntimeEnvironment getRuntime() {
        return this.ownerRuntime;
    }

    public AbstractRecord getAbstractRecord(String id) {
        ZPEEntity current = this;
        while (!current.hasRecord(id)) {
            if (current.getParent() == null) continue;
            current = (ZPEEntity)current.getParent();
        }
        if (current.hasRecord(id)) {
            return current.abstractRecordMap.get(id);
        }
        return null;
    }

    static ZPEObject abstractModelToObject(String id, ZPEEntity caller, ZPEEntity owner) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        Serializable v;
        ZPEStructure newStructure = new ZPEStructure(owner.ownerRuntime, owner, id);
        ZPERuntimeEnvironment temp = new ZPERuntimeEnvironment();
        AbstractStructure struct = owner.abstractStructureMap.get(id);
        newStructure.scope = (byte)struct.access;
        if (newStructure.scope != 2) {
            if (newStructure.scope == 1 && !caller.isDescendantOf(owner)) {
                ZPECore.printError("The structure " + id + " is private and cannot be accessed.");
                return null;
            }
            if (newStructure.scope == 0 && !caller.isDescendantOf(owner) && !caller.isDescendantOf(owner.ownerRuntime.globalFunction)) {
                ZPECore.printError("The structure " + id + " is private and cannot be accessed.");
                return null;
            }
        }
        if (struct.code == null) {
            throw new ZPERuntimeException("Empty structure was created.");
        }
        temp.globalTraverse(IAST.copy(struct.code));
        for (String str : temp.globalFunction.functionMap.keySet()) {
            ZPEFunction func = temp.globalFunction.functionMap.get(str);
            func.parent = newStructure;
            func.ownerRuntime = newStructure.getRuntime();
            newStructure.properties.put(str, new ZPEVariable(str, func, func.scope, newStructure, 124));
        }
        for (String str : temp.getGlobalVariableKeyset()) {
            v = temp.globalFunction.variableMap.get(str);
            newStructure.properties.put(str, owner.createGeneralVariable(str, v.getValue(), v.scope, newStructure, v.type));
        }
        for (String str : temp.globalFunction.abstractStructureMap.keySet()) {
            v = (AbstractStructure)temp.globalFunction.abstractStructureMap.get(str);
            newStructure.abstractStructureMap.put(str, v);
        }
        if (!struct.inherits.isEmpty()) {
            ZPEObject inherit = owner.getStructure(struct.inherits, caller);
            for (String var : inherit.properties.keySet()) {
                if (newStructure.properties.containsKey(var)) continue;
                newStructure.properties.put(var, inherit.properties.get(var));
            }
        }
        newStructure.parent = caller;
        return newStructure;
    }

    public ZPERecord getZPERecord(String id) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        AbstractRecord prototype = this.getAbstractRecord(id);
        IAST current = prototype.code;
        ZPERecord newRecord = new ZPERecord(this, id);
        while (current != null) {
            String identifier = current.id;
            byte type = current.type;
            ZPEType value = null;
            if (current.value != null) {
                value = this.ownerRuntime.evaluateExpression((IAST)current.value, this);
            }
            newRecord.addField(identifier, this.createGeneralVariable(identifier, value, type));
            current = current.next;
        }
        newRecord.lock();
        return newRecord;
    }

    public ZPEObject getStructure(String id, ZPEEntity caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEEntity current = this;
        if (!this.hasStructure(id)) {
            boolean found = false;
            while (current != null && !found) {
                if (!(current = (ZPEEntity)current.getParent()).hasStructure(id)) continue;
                found = true;
            }
        }
        if (!id.equals("object") && current.hasStructure(id)) {
            return ZPEEntity.abstractModelToObject(id, caller, current);
        }
        return null;
    }

    public boolean hasRecord(String key) {
        return this.abstractRecordMap.containsKey(key);
    }

    public boolean hasStructure(String key) {
        return this.abstractStructureMap.containsKey(key);
    }

    @Override
    public ZPEPropertyWrapper getParentObject() {
        if (this.getParent() != null) {
            if (this.getParent() instanceof ZPEObject) {
                return this.getParent();
            }
            return this.getParent().getParentObject();
        }
        return null;
    }

    public ZPEObject generateStructure(IAST structure_tree, ZPEEntity caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEObject out = this.getStructure(structure_tree.id, caller);
        if (out == null) {
            throw new ZPERuntimeException("Structure '" + structure_tree.id + "' not found.");
        }
        try {
            out.construct((IAST)structure_tree.value);
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
        return out;
    }

    public ZPERecord generateRecord(IAST structure_tree, ZPEFunction caller) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPERecord out = this.getZPERecord(structure_tree.id);
        if (out == null) {
            return null;
        }
        ZPEType[] params = this.ownerRuntime.generateArguments((IAST)structure_tree.value);
        int i = 0;
        for (ZPEType o : params) {
            String current = out.getFieldNames().get(i).toString();
            out.setField(current, o);
            ++i;
        }
        return out;
    }

    public boolean isDescendantOf(ZPEPropertyWrapper o) {
        for (ZPEPropertyWrapper cur = this; cur != null; cur = cur.getParent()) {
            if (cur != o) continue;
            return true;
        }
        return false;
    }

    public ZPEVariable createGeneralVariable(String id, ZPEType value, byte type) throws ZPERuntimeException {
        return this.createGeneralVariable(id, value, 0, null, type);
    }

    public ZPEVariable createGeneralVariable(String id, ZPEType value, int scope, ZPEPropertyWrapper container, byte type) throws ZPERuntimeException {
        return ZPEHelperFunctions.createTypedVariable(id, value, scope, container, type);
    }

    @Override
    public abstract ZPEType getVariable(String var1);

    @Override
    public abstract void setProperty(String var1, ZPEType var2) throws ZPERuntimeException;

    @Override
    public abstract void setProperty(String var1, ZPEType var2, byte var3) throws ZPERuntimeException;

    @Override
    public abstract void removeProperty(String var1);

    @Override
    public abstract boolean hasVariable(String var1);

    @Override
    public abstract ZPEVariable getRawVariable(String var1);

    @Override
    public abstract ZPEPropertyWrapper getParent();
}

