/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.UnacceptableTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.Undefined;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;

class LAMEX2 {
    private final ZPERuntimeEnvironment zx;
    public static String VERSION = "X2";

    public LAMEX2(ZPERuntimeEnvironment z) {
        this.zx = z;
    }

    private static boolean isMathsOperator(int s) {
        return s >= 55 && s <= 60;
    }

    private static boolean isValue(int s) {
        return s == 57 || s == -4 || s >= 4 && s <= 8;
    }

    private static boolean isComparison(int s) {
        return s >= 34 && s <= 41;
    }

    private static boolean isLogicalJoin(int s) {
        return s == 42 || s == 43;
    }

    private static boolean isValueAssignSymbol(int s) {
        return s >= 44 && s <= 47;
    }

    private boolean isLogical(byte type, byte inner_value) {
        return LAMEX2.isLogicalJoin(type) || LAMEX2.isComparison(type) || type == 18 && (LAMEX2.isLogicalJoin(inner_value) || LAMEX2.isComparison(inner_value));
    }

    private ZPEType evaluateTernary(IAST expr, ZPEType value) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (ZPEHelperFunctions.ToBoolean(value)) {
            if (LAMEX2.isValue(expr.left.left.type)) {
                return this.zx.evaluateExpression(expr.left.left, this.zx.getCurrentFunction());
            }
            return this.zx.getCurrentFunction().traverse(expr.left.left);
        }
        if (LAMEX2.isValue(expr.left.middle.type)) {
            return this.zx.evaluateExpression(expr.left.middle, this.zx.getCurrentFunction());
        }
        return this.zx.getCurrentFunction().traverse(expr.left.middle);
    }

    private ZPEType evaluateAltValue(IAST expr, ZPEType value) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (value != null && !(value instanceof Undefined)) {
            return value;
        }
        if (LAMEX2.isValue(expr.left.left.type)) {
            return this.zx.evaluateExpression(expr.left.left, this.zx.getCurrentFunction());
        }
        return this.zx.getCurrentFunction().traverse(expr.left.left);
    }

    public ZPEType evaluateExpressions(IAST expr) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType results;
        byte inner_value = -1;
        switch (expr.type) {
            case 4: 
            case 87: {
                return this.zx.evaluateExpression(expr, this.zx.getCurrentFunction());
            }
            case 3: {
                return this.zx.evaluateNode(expr);
            }
            case -16: {
                return this.zx.getCurrentFunction().evaluateTemplate(expr);
            }
            case 70: {
                return this.zx.getCurrentFunction().getParent();
            }
            case 88: {
                ZPEType v = this.zx.evaluateExpression(expr.left, this.zx.getCurrentFunction());
                ZPEType index = this.zx.evaluateExpression((IAST)expr.value, this.zx.getCurrentFunction());
                try {
                    return ZPERuntimeEnvironment.getIndex(v, index);
                }
                catch (UnacceptableTypeException e) {
                    ZPECore.printWarning(e.getMessage());
                }
            }
            case 66: {
                return this.zx.evaluateExpression(expr, this.zx.getCurrentFunction());
            }
        }
        if (expr.value != null) {
            if (expr.value instanceof IAST) {
                IAST value = (IAST)expr.value;
                while (value != null && value.type == 18) {
                    expr.value = ((IAST)expr.value).value;
                    value = (IAST)expr.value;
                }
                if (expr.type == 18) {
                    assert (value != null);
                    inner_value = value.type;
                }
                if (value != null) {
                    if (value.type == 67) {
                        return this.zx.evaluateExpression(value, this.zx.getCurrentFunction());
                    }
                    if (value.type == 12) {
                        return this.zx.evaluateExpression(value, this.zx.getCurrentFunction());
                    }
                    if (value.left == null) {
                        ZPEType output = this.zx.evaluateExpression(value, this.zx.getCurrentFunction());
                        if (expr.left != null) {
                            if (expr.left.type == 73) {
                                output = this.evaluateTernary(expr, output);
                            } else if (expr.left.type == 96) {
                                return this.evaluateAltValue(expr, output);
                            }
                        }
                        return output;
                    }
                }
            } else {
                if (expr.value instanceof Number) {
                    return new ZPENumber((Number)expr.value);
                }
                if (expr.value instanceof Boolean) {
                    return new ZPEBoolean((Boolean)expr.value);
                }
                if (expr.value instanceof String) {
                    return new ZPEString((String)expr.value);
                }
                return null;
            }
        }
        assert (expr.value != null);
        if (((IAST)expr.value).type == 77) {
            results = new ZPEString(this.evaluateConcatenation((IAST)expr.value));
        } else if (this.isLogical(((IAST)expr.value).type, inner_value)) {
            results = new ZPEBoolean(this.evaluateLogic((IAST)expr.value));
        } else if (expr.value instanceof IAST && LAMEX2.isMathsOperator(((IAST)expr.value).type)) {
            results = this.evaluateMathematics((IAST)expr.value);
        } else {
            assert (expr.value instanceof IAST);
            results = this.zx.evaluateExpression((IAST)expr.value, this.zx.getCurrentFunction());
        }
        if (expr.left != null) {
            if (expr.left.type == 73) {
                return this.evaluateTernary(expr, results);
            }
            if (expr.left.type == 96) {
                return this.evaluateAltValue(expr, results);
            }
        }
        return results;
    }

    public String evaluateConcatenation(IAST m) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType s;
        String l = m.left.value instanceof ZPEString ? m.left.value.toString() : this.evaluateExpressions(m.left).toString();
        String r = m.next.value instanceof ZPEString ? m.next.value.toString() : ((s = this.evaluateExpressions(m.next)) != null ? s.toString() : "");
        return l + r;
    }

    public boolean evaluateEquality(ZPEType v1, ZPEType v2) {
        ZPENumber n2;
        ZPENumber n1;
        boolean v = v1 instanceof Undefined && v2 instanceof Undefined ? true : (v1 == null || v2 == null ? v1 == v2 : (v1 instanceof ZPENumber && v2 instanceof ZPENumber ? (n1 = (ZPENumber)v1).compareTo(n2 = (ZPENumber)v2) == 0 : v1.equals(v2)));
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean evaluateLogic(IAST m) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        while (m.type == 18) {
            m = (IAST)m.value;
        }
        if (m.type == 7) {
            return ZPEHelperFunctions.ToBoolean(m.value);
        }
        if (LAMEX2.isComparison(m.type)) {
            ZPEType v1 = this.getLogicValue(m.left);
            ZPEType v2 = this.getLogicValue(m.middle);
            if (v1 instanceof Number) {
                v1 = new ZPENumber((Number)((Object)v1));
            }
            if (v2 instanceof Number) {
                v2 = new ZPENumber((Number)((Object)v2));
            }
            if (m.type == 40) {
                return v1.equals(v2);
            }
            if (m.type == 34 || m.type == 35) {
                boolean v = this.evaluateEquality(v1, v2);
                if (m.type != 35) return v;
                if (v) return false;
                return true;
            }
            if (v1 instanceof ZPENumber && v2 instanceof ZPENumber) {
                ZPENumber n1 = (ZPENumber)v1;
                ZPENumber n2 = (ZPENumber)v2;
                if (m.type == 36) {
                    if (n1.compareTo(n2) <= 0) return false;
                    return true;
                }
                if (m.type == 37) {
                    if (n1.compareTo(n2) >= 0) return false;
                    return true;
                }
                if (m.type == 38) {
                    if (n1.compareTo(n2) < 0) return false;
                    return true;
                }
                if (m.type != 39) return false;
                if (n1.compareTo(n2) > 0) return false;
                return true;
            }
            if (!(v1 instanceof ZPEString)) return false;
            if (!(v2 instanceof ZPEString)) return false;
            ZPEString value1 = (ZPEString)v1;
            ZPEString value2 = (ZPEString)v2;
            int res = value1.compareNumerically(value2);
            if (m.type == 36) {
                if (res != 1) return false;
                return true;
            }
            if (m.type == 37) {
                if (res != -1) return false;
                return true;
            }
            if (m.type == 38) {
                if (res == 1) return true;
                if (!value1.equals(value2)) return false;
                return true;
            }
            if (m.type != 39) return false;
            if (res == -1) return true;
            if (!value1.equals(value2)) return false;
            return true;
        }
        if (m.type == 42) {
            boolean v1 = this.evaluateLogic(m.left);
            if (v1) return this.evaluateLogic(m.next);
            return false;
        }
        if (m.type == 43) {
            boolean v1 = this.evaluateLogic(m.left);
            if (!v1) return this.evaluateLogic(m.next);
            return true;
        }
        ZPEType v = this.zx.evaluateNode(m);
        return ZPEHelperFunctions.ToBoolean(v);
    }

    private ZPEType getLogicValue(IAST m) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        while (m.type == 18) {
            m = (IAST)m.value;
        }
        if (LAMEX2.isMathsOperator(m.type)) {
            return this.evaluateMathematics(m);
        }
        return this.zx.evaluateNode(m);
    }

    private ZPENumber evaluateMathematics(IAST m) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPENumber start = new ZPENumber(0);
        start = m.left != null ? this.getSingleValue(m.left) : this.getSingleValue(m);
        return this.evaluateMath(m, start);
    }

    private ZPENumber evaluateMath(IAST m, ZPENumber left) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (m.type == 18) {
            return this.evaluateMath((IAST)m.value, new ZPENumber(0));
        }
        if (m.next == null) {
            return left;
        }
        if (this.hasPrecedence(m.type, m.next.type)) {
            ZPENumber right = m.next.next == null ? this.getSingleValue(m.next) : this.getSingleValue(m.next.left);
            if (m.next.left == null) {
                return this.eval(m.type, left, right);
            }
            return this.evaluateMath(m.next, this.eval(m.type, left, right));
        }
        if (m.next.type == 18) {
            return this.eval(m.type, left, this.evaluateMath((IAST)m.next.value, this.getSingleValue(((IAST)m.next.value).left)));
        }
        return this.eval(m.type, left, this.evaluateMath(m.next, this.getSingleValue(m.next.left)));
    }

    private ZPENumber eval(byte type, ZPENumber left, ZPENumber right) {
        switch (type) {
            case 59: {
                return new ZPENumber(left.doubleValue() % right.doubleValue());
            }
            case 60: {
                return new ZPENumber(Math.pow(left.doubleValue(), right.doubleValue()));
            }
            case 55: {
                return new ZPENumber(left.doubleValue() + right.doubleValue());
            }
            case 57: {
                return new ZPENumber(left.doubleValue() - right.doubleValue());
            }
            case 56: {
                return new ZPENumber(left.doubleValue() * right.doubleValue());
            }
            case 58: {
                return new ZPENumber(left.doubleValue() / right.doubleValue());
            }
        }
        return new ZPENumber(Float.valueOf(Float.NaN));
    }

    private boolean hasPrecedence(byte op1, byte op2) {
        if (op2 == 18) {
            return false;
        }
        if (op2 == 60) {
            return false;
        }
        return op2 != 56 && op2 != 58 || op1 != 55 && op1 != 57;
    }

    private ZPENumber modifyValue(IAST m) throws ZPERuntimeException {
        ZPENumber l = (ZPENumber)this.zx.getCurrentFunction().getVariable(m.id);
        switch (m.type) {
            case 45: {
                l.increment(1);
                this.zx.getCurrentFunction().setProperty(m.id, l);
                break;
            }
            case 47: {
                l.decrement(1);
                this.zx.getCurrentFunction().setProperty(m.id, l);
                break;
            }
            case 44: {
                this.zx.getCurrentFunction().setProperty(m.id, new ZPENumber(l.doubleValue() + 1.0));
                break;
            }
            case 46: {
                this.zx.getCurrentFunction().setProperty(m.id, new ZPENumber(l.doubleValue() - 1.0));
            }
        }
        return l;
    }

    private ZPENumber getSingleValue(IAST m) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        Object output = null;
        switch (m.type) {
            case 18: {
                return this.evaluateMathematics((IAST)m.value);
            }
            case 4: 
            case 87: {
                output = this.zx.getCurrentFunction().getVariable(m.id);
                break;
            }
            case 3: {
                output = this.zx.evaluateFunction(m);
                break;
            }
            case -11: {
                output = ZPEHelperFunctions.typeCast(this.zx.evaluateExpression(m.left, this.zx.getCurrentFunction()), m.middle.type);
                break;
            }
            case 66: 
            case 67: 
            case 91: 
            case 95: {
                output = this.zx.evaluateExpression(m, this.zx.getCurrentFunction());
                break;
            }
            case 88: {
                try {
                    output = ZPERuntimeEnvironment.getIndex(this.zx.evaluateExpression(m.left, this.zx.getCurrentFunction()), this.zx.evaluateExpression((IAST)m.value, this.zx.getCurrentFunction()));
                }
                catch (UnacceptableTypeException e) {
                    ZPECore.printError(e.getMessage());
                }
                break;
            }
            default: {
                if (m.left != null && m.left.value != null) {
                    if (m.left.value instanceof Number) {
                        output = new ZPENumber((Number)m.left.value);
                        break;
                    }
                    output = m.left.value;
                    break;
                }
                if (m.left != null && m.left.type == 4) {
                    output = this.zx.getCurrentFunction().getVariable(m.left.id);
                    break;
                }
                if (m.left != null && LAMEX2.isValueAssignSymbol(m.left.type)) {
                    output = this.modifyValue(m.left);
                    break;
                }
                if (LAMEX2.isValueAssignSymbol(m.type)) {
                    output = this.modifyValue(m);
                    break;
                }
                if (m.value == null) break;
                output = m.value;
            }
        }
        if (output == null) {
            return new ZPENumber(0);
        }
        return new ZPENumber(HelperFunctions.stringToDouble(output.toString()));
    }
}

