/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.api;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import java.io.File;
import java.io.IOException;

public class ZPEFile {
    private final File file;

    public ZPEFile(String pathname) {
        if (ZPEInstance.useSandbox()) {
            String safeName = pathname.replaceAll("[^a-zA-Z0-9._-]", "_");
            this.file = new File(ZPEInstance.getInstallPath() + "tmp/", safeName);
        } else {
            this.file = new File(pathname);
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public void mkdirs() {
        this.file.mkdirs();
    }

    public void renameTo(String newName) {
        this.file.renameTo(new File(newName));
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public String[] listFiles() {
        File[] files = this.file.listFiles();
        if (files == null) {
            return new String[0];
        }
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        return names;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getParent() {
        return this.file.getParent();
    }

    public long length() {
        return this.file.length();
    }

    public void writeString(String s) throws IOException {
        FileHelperFunctions.writeFile(this.file.getAbsolutePath(), s, false);
    }
}

