/*
 * Decompiled with CFR 0.152.
 */
import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEString;
import java.sql.SQLException;

public class ZPEMySQLObject
extends ZPEStructure {
    private static final long serialVersionUID = 5811011685776858084L;
    MySQLAccess sql;
    ZPEMySQLObject _this = this;

    public ZPEMySQLObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent) {
        super(z, parent, "ZPEMySQLConnection");
        System.out.println("MySQL loaded");
        this.addNativeMethod("connect", new connect_Command());
        this.addNativeMethod("query", new query_Command());
        this.addNativeMethod("prepare", new prepare_Command());
        this.addNativeMethod("get_columns", new get_columns_Command());
        this.addNativeMethod("get_tables", new get_tables_Command());
        this.addNativeMethod("query_to_json", new query_to_json_Command());
    }

    public boolean connect(String host, int port, String db, String user, String password) {
        try {
            this.sql = new MySQLAccess();
        }
        catch (Exception e) {
            ZPE.log((String)e.getMessage());
            System.err.println("Cannot create MySQL connection. Please refer to ZPE log for more information.");
            return false;
        }
        try {
            this.sql.connect(host, port, db, user, password);
            return true;
        }
        catch (SQLException e) {
            ZPE.log((String)e.getMessage());
            System.err.println("Cannot connect to MySQL database. Please refer to ZPE log for more information.");
            return false;
        }
    }

    class prepare_Command
    implements ZPEObjectNativeMethod {
        prepare_Command() {
        }

        public String[] getParameterNames() {
            return new String[]{"query_str"};
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                ZPEMySQLPreparedStatementObject prep = new ZPEMySQLPreparedStatementObject(ZPEMySQLObject.this.getRuntime(), (ZPEPropertyWrapper)parent);
                prep.sqlConn = ZPEMySQLObject.this._this;
                prep.prepare(((ZPEType)parameters.get((Comparable)((Object)"query_str"))).toString());
                return prep;
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 0;
        }

        public String getName() {
            return "prepare";
        }
    }

    class query_Command
    implements ZPEObjectNativeMethod {
        query_Command() {
        }

        public String[] getParameterNames() {
            return new String[]{"query_str"};
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                return ZPEMySQLObject.this.sql.query(((ZPEType)parameters.get((Comparable)((Object)"query_str"))).toString());
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 0;
        }

        public String getName() {
            return "query";
        }
    }

    class get_columns_Command
    implements ZPEObjectNativeMethod {
        get_columns_Command() {
        }

        public String[] getParameterNames() {
            return new String[]{"table"};
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                return ZPEMySQLObject.this.sql.getColumnNames(((ZPEType)parameters.get((Comparable)((Object)"table"))).toString());
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 0;
        }

        public String getName() {
            return "get_columns";
        }
    }

    class query_to_json_Command
    implements ZPEObjectNativeMethod {
        query_to_json_Command() {
        }

        public String[] getParameterNames() {
            return new String[]{"query_str"};
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                ZPEList l = ZPEMySQLObject.this.sql.query(((ZPEType)parameters.get((Comparable)((Object)"query_str"))).toString());
                ZenithJSONParser parser = new ZenithJSONParser();
                return new ZPEString(parser.jsonEncode((Object)l));
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 0;
        }

        public String getName() {
            return "query_to_json";
        }
    }

    class get_tables_Command
    implements ZPEObjectNativeMethod {
        get_tables_Command() {
        }

        public String[] getParameterNames() {
            return new String[0];
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                return ZPEMySQLObject.this.sql.getTableNames();
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 3;
        }

        public String getName() {
            return "get_tables";
        }
    }

    class connect_Command
    implements ZPEObjectNativeMethod {
        connect_Command() {
        }

        public String[] getParameterNames() {
            String[] params = new String[]{"host", "database", "user", "password", "port"};
            return params;
        }

        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            try {
                String host = ((ZPEType)parameters.get((Comparable)((Object)"host"))).toString();
                int port = HelperFunctions.stringToInteger((String)((ZPEType)parameters.get((Comparable)((Object)"port"))).toString());
                String database = ((ZPEType)parameters.get((Comparable)((Object)"database"))).toString();
                String username = ((ZPEType)parameters.get((Comparable)((Object)"user"))).toString();
                String password = ((ZPEType)parameters.get((Comparable)((Object)"password"))).toString();
                return new ZPEBoolean(((ZPEMySQLObject)parent).connect(host, port, database, username, password));
            }
            catch (Exception e) {
                return new ZPEBoolean(false);
            }
        }

        public int getRequiredPermissionLevel() {
            return 0;
        }

        public String getName() {
            return "connect";
        }
    }
}

