/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPEKit;
import java.util.ArrayList;
import java.util.HashMap;

public class PythonTranspiler {
    int indentation = 0;
    boolean inClassDef = false;
    HashMap<String, String> yassToPythonFunctionMapping = new HashMap();
    HashMap<String, String> pythonImports = new HashMap();
    ArrayList<String> imports = new ArrayList();
    ArrayList<String> usedFunctions = new ArrayList();
    ArrayList<String> addedFunctions = new ArrayList();

    public String Transpile(IAST code, String s) {
        this.yassToPythonFunctionMapping.put("std_in", "print");
        this.yassToPythonFunctionMapping.put("auto_input", "input");
        this.yassToPythonFunctionMapping.put("floor", "math.floor");
        this.yassToPythonFunctionMapping.put("list_get_length", "len");
        this.yassToPythonFunctionMapping.put("time", "datetime.datetime.now");
        this.pythonImports.put("floor", "math");
        this.pythonImports.put("ceiling", "math");
        this.pythonImports.put("random_number", "random");
        this.pythonImports.put("time", "datetime");
        StringBuilder output = new StringBuilder();
        IAST current = code;
        while (current != null) {
            output.append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        Object importStr = "";
        for (String i : this.imports) {
            importStr = (String)importStr + "import " + i + System.lineSeparator();
        }
        StringBuilder additionalFuncs = new StringBuilder();
        for (String fun : HelperFunctions.GetResource((String)"/jamiebalfour/zpe/additional_functions.txt", this.getClass()).split("--")) {
            StringBuilder funcName = new StringBuilder();
            if (!fun.isEmpty() && fun.charAt(0) == '\n') {
                fun = fun.substring(1);
            }
            for (int i = 4; i < fun.length() && fun.charAt(i) != ' ' && fun.charAt(i) != '('; ++i) {
                funcName.append(fun.charAt(i));
            }
            if (!this.usedFunctions.contains(funcName.toString()) || this.addedFunctions.contains(funcName.toString())) continue;
            additionalFuncs.append(fun);
        }
        ZPE.Print((String)System.lineSeparator());
        return (String)importStr + additionalFuncs + output;
    }

    private void addImport(String i) {
        if (!this.imports.contains(i)) {
            this.imports.add(i);
        }
    }

    private String addIndentation() {
        if (this.indentation > 0) {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < this.indentation; ++i) {
                out.append("  ");
            }
            return out.toString();
        }
        return "";
    }

    private String inner_transpile(IAST n) {
        switch (n.type) {
            case 3: {
                return this.transpile_identifier(n);
            }
            case 4: 
            case 87: 
            case 106: {
                return this.transpile_var(n);
            }
            case 12: {
                return this.transpile_function(n);
            }
            case 7: {
                return n.value.toString().substring(0, 1).toUpperCase() + n.value.toString().substring(1);
            }
            case 64: {
                return this.transpile_structure(n);
            }
            case 66: {
                return this.inner_transpile(n.middle) + "." + this.inner_transpile((IAST)n.value);
            }
            case 70: {
                return "self";
            }
            case 65: {
                return n.id + "(" + this.generateParameters((IAST)n.value) + ")";
            }
            case 77: {
                return "str(" + this.inner_transpile(n.left) + ") + str(" + this.inner_transpile(n.next) + ")";
            }
            case -4: {
                return "None";
            }
            case 95: {
                return "len(" + this.generateParameters(n.left) + ")";
            }
            case 86: {
                return "not(" + this.inner_transpile(((IAST)n.value).next) + ")";
            }
            case 16: {
                return this.transpile_assign(n);
            }
            case -9: {
                return this.transpile_expression(n);
            }
            case 101: {
                return this.transpile_match(n);
            }
            case 34: {
                return this.transpile_equal_to(n);
            }
            case 35: {
                return this.transpile_not_equal_to(n);
            }
            case 36: {
                return this.transpile_greater_than(n);
            }
            case 38: {
                return this.transpile_greater_than_or_equal(n);
            }
            case 37: {
                return this.transpile_less_than(n);
            }
            case 39: {
                return this.transpile_less_than_or_equal(n);
            }
            case 42: {
                return this.transpile_and(n);
            }
            case 43: {
                return this.transpile_or(n);
            }
            case 59: {
                return this.transpile_modulo(n);
            }
            case 55: {
                return this.transpile_addition(n);
            }
            case 57: {
                return this.transpile_subtraction(n);
            }
            case 56: {
                return this.transpile_multiplication(n);
            }
            case 58: {
                return this.transpile_division(n);
            }
            case 8: {
                return "\"" + n.value.toString().replace('\"', '\'') + "\"";
            }
            case 44: 
            case 45: {
                return this.transpile_var(n) + " += 1";
            }
            case 46: 
            case 47: {
                return this.transpile_var(n) + " -= 1";
            }
            case 67: {
                return this.transpile_dot_expression(n);
            }
            case 10: {
                return "[" + this.generateParameters((IAST)n.value) + "]";
            }
            case 11: {
                return this.transpile_map(n);
            }
            case 91: {
                return "-" + this.inner_transpile((IAST)n.value);
            }
            case 5: 
            case 6: {
                return n.value.toString();
            }
            case 32: {
                return this.transpile_for(n);
            }
            case 33: {
                return this.transpile_for_to(n);
            }
            case 61: {
                return this.transpile_for_each(n);
            }
            case 21: {
                return this.transpile_if(n);
            }
            case 30: {
                return this.transpile_while(n);
            }
            case 127: {
                return this.inner_transpile(n.left);
            }
            case 88: {
                return this.inner_transpile(n.left) + "[" + this.inner_transpile((IAST)n.value) + "]";
            }
            case 18: {
                return "(" + this.inner_transpile((IAST)n.value) + ")";
            }
            case 84: {
                return "return " + this.inner_transpile(n.left);
            }
        }
        return "";
    }

    private String generateParameters(IAST n) {
        StringBuilder output = new StringBuilder();
        IAST current = n;
        while (current != null) {
            output.append(this.inner_transpile(current));
            current = current.next;
            if (current == null) continue;
            output.append(", ");
        }
        return output.toString();
    }

    private String transpile_identifier(IAST n) {
        Object output = "";
        output = this.yassToPythonFunctionMapping.containsKey(n.id) ? (String)output + this.yassToPythonFunctionMapping.get(n.id) : (String)output + n.id;
        if (this.pythonImports.containsKey(n.id)) {
            this.addImport(this.pythonImports.get(n.id));
        }
        if (ZPEKit.internalFunctionExists((String)n.id)) {
            this.usedFunctions.add(n.id);
        }
        output = (String)output + "(" + this.generateParameters((IAST)n.value) + ")";
        return output;
    }

    private String transpile_var(IAST n) {
        if (n.id.startsWith("$")) {
            return n.id.substring(1);
        }
        return n.id;
    }

    private String transpile_dot_expression(IAST n) {
        if (((IAST)n.value).id.equals("put")) {
            this.usedFunctions.add("_put");
            return "_put(" + this.inner_transpile(n.left) + ", " + n.left + ", " + this.generateParameters((IAST)((IAST)n.value).value) + ")";
        }
        return this.inner_transpile(n.left) + "." + this.inner_transpile((IAST)n.value);
    }

    private String transpile_map(IAST n) {
        StringBuilder output = new StringBuilder();
        output.append("{");
        IAST current = (IAST)n.value;
        while (current != null) {
            output.append(this.inner_transpile(current));
            current = current.next;
            output.append(" : ");
            output.append(this.inner_transpile(current));
            current = current.next;
            if (current == null) continue;
            output.append(", ");
        }
        output.append("}");
        return output.toString();
    }

    public String transpile_match(IAST n) {
        StringBuilder output = new StringBuilder();
        output.append("{");
        IAST current = n.left;
        while (current != null) {
            output.append(this.inner_transpile(current.left));
            output.append(" : ");
            output.append(this.inner_transpile(current.middle));
            current = current.next;
            if (current == null) continue;
            output.append(", ");
        }
        output.append("} [" + this.inner_transpile((IAST)n.value) + "]");
        return output.toString();
    }

    private String transpile_function(IAST n) {
        Object params = this.generateParameters((IAST)n.value);
        if (this.inClassDef) {
            params = ((String)params).length() > 0 ? "self, " + (String)params : "self";
        }
        this.addedFunctions.add(n.id);
        StringBuilder output = new StringBuilder("def " + n.id + "(" + (String)params + "):" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.left;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        return output.toString();
    }

    private String transpile_structure(IAST n) {
        this.inClassDef = true;
        StringBuilder output = new StringBuilder("class " + n.id + ":" + System.lineSeparator());
        ++this.indentation;
        IAST current = (IAST)n.value;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        this.inClassDef = false;
        return output.toString();
    }

    private String transpile_assign(IAST n) {
        return this.inner_transpile(n.middle) + " = " + this.inner_transpile((IAST)n.value);
    }

    private String transpile_expression(IAST n) {
        IAST current = (IAST)n.value;
        return this.inner_transpile(current);
    }

    private String transpile_equal_to(IAST n) {
        return this.inner_transpile(n.left) + " == " + this.inner_transpile(n.middle);
    }

    private String transpile_not_equal_to(IAST n) {
        return this.inner_transpile(n.left) + " != " + this.inner_transpile(n.middle);
    }

    private String transpile_greater_than(IAST n) {
        return this.inner_transpile(n.left) + " > " + this.inner_transpile(n.middle);
    }

    private String transpile_greater_than_or_equal(IAST n) {
        return this.inner_transpile(n.left) + " >= " + this.inner_transpile(n.middle);
    }

    private String transpile_less_than(IAST n) {
        return this.inner_transpile(n.left) + " < " + this.inner_transpile(n.middle);
    }

    private String transpile_less_than_or_equal(IAST n) {
        return this.inner_transpile(n.left) + " <= " + this.inner_transpile(n.middle);
    }

    private String transpile_modulo(IAST n) {
        return this.inner_transpile(n.left) + " % " + this.inner_transpile(n.next);
    }

    private String transpile_addition(IAST n) {
        return this.inner_transpile(n.left) + " + " + this.inner_transpile(n.next);
    }

    private String transpile_subtraction(IAST n) {
        return this.inner_transpile(n.left) + " - " + this.inner_transpile(n.next);
    }

    private String transpile_multiplication(IAST n) {
        return this.inner_transpile(n.left) + " * " + this.inner_transpile(n.next);
    }

    private String transpile_division(IAST n) {
        return this.inner_transpile(n.left) + " / " + this.inner_transpile(n.next);
    }

    private String transpile_and(IAST n) {
        return this.inner_transpile(n.left) + " and " + this.inner_transpile(n.next);
    }

    private String transpile_or(IAST n) {
        return this.inner_transpile(n.left) + " or " + this.inner_transpile(n.next);
    }

    private String transpile_for_to(IAST n) {
        StringBuilder output = new StringBuilder("for " + this.inner_transpile(n.middle.left.middle) + " in range(" + this.inner_transpile((IAST)n.middle.left.value) + ", " + this.inner_transpile((IAST)((IAST)n.value).value) + "):" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.left.next;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        return output.toString();
    }

    private String transpile_for_each(IAST n) {
        String mid = n.left.middle.type == 4 ? n.left.middle.value.toString().replace("$", "") : this.inner_transpile(n.left.middle);
        StringBuilder output = new StringBuilder("for " + mid + " in " + this.inner_transpile(n.left.left) + ":" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.middle;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        return output.toString();
    }

    private String transpile_for(IAST n) {
        Object steps = "";
        if (n.middle.value instanceof String) {
            steps = ", " + n.middle.value;
        }
        StringBuilder output = new StringBuilder("for " + this.inner_transpile(n.middle.left.middle) + " in range(" + this.inner_transpile((IAST)n.middle.left.value) + ", " + this.inner_transpile(((IAST)((IAST)n.value).value).middle) + (String)steps + "):" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.left.next;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        return output.toString();
    }

    private String transpile_if(IAST n) {
        StringBuilder output = new StringBuilder("if " + this.inner_transpile((IAST)n.value) + ":" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.left;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        if (n.middle != null && n.middle.type != 23) {
            output.append(this.addIndentation()).append("else:").append(System.lineSeparator());
            ++this.indentation;
            current = n.middle;
            while (current != null) {
                output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
                current = current.next;
            }
            --this.indentation;
        }
        return output.toString();
    }

    private String transpile_while(IAST n) {
        StringBuilder output = new StringBuilder("while " + this.inner_transpile((IAST)n.value) + ":" + System.lineSeparator());
        ++this.indentation;
        IAST current = n.left;
        while (current != null) {
            output.append(this.addIndentation()).append(this.inner_transpile(current)).append(System.lineSeparator());
            current = current.next;
        }
        --this.indentation;
        return output.toString();
    }
}

