package jamiebalfour;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageEffects {

	public static BufferedImage GreyscaleImage(BufferedImage img) {
		for (int x = 0; x < img.getWidth(); x++) {
			for (int y = 0; y < img.getHeight(); y++) {

				Color rgb = new Color(img.getRGB(x, y));
				int r = (int) (rgb.getRed());
				int g = (int) (rgb.getGreen());
				int b = (int) (rgb.getBlue());

				int t = (r + g + b) / 3;

				Color c = new Color(t, t, t);

				img.setRGB(x, y, c.getRGB());
			}
		}

		return img;
	}

	public static BufferedImage SepiaImage(BufferedImage img) {

		for (int x = 0; x < img.getWidth(); x++) {
			for (int y = 0; y < img.getHeight(); y++) {

				Color rgb = new Color(img.getRGB(x, y));
				int inputRed = (int) (rgb.getRed());
				int inputGreen = (int) (rgb.getGreen());
				int inputBlue = (int) (rgb.getBlue());

				int outputRed = (int) ((inputRed * 0.393) + (inputGreen * 0.769) + (inputBlue * 0.189));
				int outputGreen = (int) ((inputRed * 0.349) + (inputGreen * 0.686) + (inputBlue * 0.168));
				int outputBlue = (int) ((inputRed * 0.272) + (inputGreen * 0.534) + (inputBlue * 0.131));

				outputRed = limitInteger(outputRed, 0, 255);
				outputGreen = limitInteger(outputGreen, 0, 255);
				outputBlue = limitInteger(outputBlue, 0, 255);

				Color c = new Color(outputRed, outputGreen, outputBlue);

				img.setRGB(x, y, c.getRGB());
			}
		}

		return img;
	}

	public static BufferedImage InvertImageColour(BufferedImage img) {

		for (int x = 0; x < img.getWidth(); x++) {
			for (int y = 0; y < img.getHeight(); y++) {

				Color rgb = new Color(img.getRGB(x, y));
				int inputRed = (int) (rgb.getRed());
				int inputGreen = (int) (rgb.getGreen());
				int inputBlue = (int) (rgb.getBlue());

				int outputRed = 255 - inputRed;
				int outputGreen = 255 - inputGreen;
				int outputBlue = 255 - inputBlue;

				outputRed = limitInteger(outputRed, 0, 255);
				outputGreen = limitInteger(outputGreen, 0, 255);
				outputBlue = limitInteger(outputBlue, 0, 255);

				Color c = new Color(outputRed, outputGreen, outputBlue);

				img.setRGB(x, y, c.getRGB());
			}
		}

		return img;
	}

	public static BufferedImage ResizeImage(BufferedImage img, int width, int height) {
		int type = img.getType() == 0 ? BufferedImage.TYPE_INT_ARGB : img.getType();
		BufferedImage resizedImage = new BufferedImage(width, height, type);
		Graphics2D g = resizedImage.createGraphics();
		g.drawImage(img, 0, 0, width, height, null);
		g.dispose();
		g.setComposite(AlphaComposite.Src);
		g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		return resizedImage;
	}

	public static BufferedImage RotateImage(BufferedImage img, int rotation) {
		int type = img.getType() == 0 ? BufferedImage.TYPE_INT_ARGB : img.getType();
		BufferedImage copyImg = new BufferedImage(img.getWidth(), img.getHeight(), type);
		Graphics2D g = copyImg.createGraphics();

		double rotationRequired = Math.toRadians(rotation);
		double locationX = img.getWidth() / 2;
		double locationY = img.getHeight() / 2;
		AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
		AffineTransformOp op = new AffineTransformOp(tx, AffineTransformOp.TYPE_BILINEAR);

		// Drawing the rotated image at the required drawing locations
		g.drawImage(op.filter(img, null), 0, 0, null);
		return copyImg;
	}

	public static boolean TestImageEquality(BufferedImage img1, BufferedImage img2) {

		if (img1.getWidth() != img2.getWidth() || img1.getHeight() != img2.getHeight())
			return false;

		for (int x = 0; x < img1.getWidth(); x++) {
			for (int y = 0; y < img1.getHeight(); y++) {

				int c1 = img1.getRGB(x, y);
				int c2 = img2.getRGB(x, y);

				if (c1 != c2)
					return false;
			}
		}

		return true;
	}

	private static int limitInteger(int i, int min, int max) {
		int out = i;
		if (i > max)
			out = max;
		if (i < min)
			out = min;

		return out;
	}
}
