package jamiebalfour;

import javafx.stage.Window;
import java.util.ArrayList;
import java.util.Optional;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.control.*;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.Pair;

public class JavaFXDialogs {
	
	public static String ShowTextInputDialog(String title, String header, String content, Window owner) {
		return ShowTextInputDialog(title, header, content, "", owner);
	}
		
	public static String ShowTextInputDialog(String title, String header, String content, String defaultValue, Window owner) {
		TextInputDialog d;
		if(defaultValue.equals("")) {
			d = new TextInputDialog();
		} else {
			d = new TextInputDialog(defaultValue);
		}
		d.setTitle(title);
		d.setHeaderText(header);
		d.setContentText(content);
		if(owner != null) {
			d.initOwner(owner);
		}

		Optional<String> result = d.showAndWait();
		if(result.isPresent()) {
			return result.get();
		} else {
			return null;
		}
	}
	
	public static Pair<String, String> ShowUsernameAndPasswordInputDialog(String title, String header, String content, Window owner) {
		// Create the custom dialog.
		Dialog<Pair<String, String>> dialog = new Dialog<Pair<String, String>>();
		dialog.setTitle(title);
		dialog.setHeaderText(header);
		dialog.setContentText(content);
		if(owner != null) {
			dialog.initOwner(owner);
		}


		// Set the button types.
		final ButtonType loginButtonType = new ButtonType("Login", ButtonData.OK_DONE);
		dialog.getDialogPane().getButtonTypes().addAll(loginButtonType, ButtonType.CANCEL);

		// Create the username and password labels and fields.
		GridPane grid = new GridPane();
		grid.setHgap(10);
		grid.setVgap(10);
		grid.setPadding(new Insets(20, 150, 10, 10));

		final TextField username = new TextField();
		username.setPromptText("Username");
		final PasswordField password = new PasswordField();
		password.setPromptText("Password");

		grid.add(new Label("Username:"), 0, 0);
		grid.add(username, 1, 0);
		grid.add(new Label("Password:"), 0, 1);
		grid.add(password, 1, 1);

		// Enable/Disable login button depending on whether a username was entered.
		dialog.getDialogPane().lookupButton(loginButtonType);
		

		dialog.getDialogPane().setContent(grid);

		// Request focus on the password field by default.
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						username.requestFocus();
					}
				});

		// Convert the result to a username-password-pair when the login button is clicked.
		dialog.setResultConverter(new Callback<ButtonType, Pair<String, String>>() {
			@Override
			public Pair<String, String> call(ButtonType dialogButton) {
				if (dialogButton == loginButtonType) {
			        return new Pair<String, String>(username.getText(), password.getText());
			    }
			    return null;
			}
		});

		Optional<Pair<String, String>> result = dialog.showAndWait();
		
		if(result.isPresent()) {
			return result.get();
		}
		
		return null;
	}
	
	public static String ShowPasswordInputDialog(String title, String header, String content, Window owner) {
		javafx.scene.control.Dialog<String> dialog = new Dialog<String>();
		dialog.setTitle(title);
		dialog.setHeaderText(header);
		dialog.setContentText(content);
		if(owner != null) {
			dialog.initOwner(owner);
		}
		
		// Set the icon (must be included in the project).		
		dialog.setGraphic(new ImageView(JavaFXDialogs.class.getClassLoader().getResource("files/key.png").toString()));
		
		
		// Set the button types.
		javafx.scene.control.ButtonType loginButtonType = new javafx.scene.control.ButtonType("Submit");
		dialog.getDialogPane().getButtonTypes().addAll(loginButtonType, javafx.scene.control.ButtonType.CANCEL);

		// Create the username and password labels and fields.
		GridPane grid = new GridPane();
		grid.setHgap(10);
		grid.setVgap(10);
		grid.setPadding(new Insets(20, 150, 10, 10));

		final javafx.scene.control.PasswordField password = new javafx.scene.control.PasswordField();
		password.setPromptText("Password");
		grid.add(new javafx.scene.control.Label("Password:"), 0, 1);
		grid.add(password, 1, 1);


		dialog.getDialogPane().setContent(grid);

		// Request focus on the password field by default.
		Platform.runLater(new Runnable() {
			@Override
			public void run() {
				password.requestFocus();
			}
		});

		Optional<String> result = dialog.showAndWait();
		
		if(result.isPresent()) {
			return password.getText();
		} else {
			return null;
		}

	}
	
	public static void ShowExpandedDialog(Alert.AlertType a, String title, String header, String content, String expanded_text, Window owner) {
		ShowExpandedDialog(a, title, header, content, expanded_text, true, owner);
	}
	
	public static void ShowExpandedDialog(Alert.AlertType a, String title, String header, String content, String expanded_text, boolean open, Window owner) {
		Alert alert = new Alert(a);
		alert.setTitle(title);
		alert.setHeaderText(header);
		alert.setContentText(content);

		TextArea textArea = new TextArea(expanded_text);
		textArea.setEditable(false);
		textArea.setWrapText(true);

		textArea.setMaxWidth(Double.MAX_VALUE);
		textArea.setMaxHeight(Double.MAX_VALUE);
		GridPane.setVgrow(textArea, Priority.ALWAYS);
		GridPane.setHgrow(textArea, Priority.ALWAYS);

		GridPane expContent = new GridPane();
		expContent.setMaxWidth(Double.MAX_VALUE);
		expContent.add(textArea, 0, 1);

		// Set expandable Exception into the dialog pane.
		alert.getDialogPane().setExpandableContent(expContent);
		alert.getDialogPane().setExpanded(open);

		alert.showAndWait();
	}
	
	public static void ShowInfoAlert(String title, String header, String content, Window owner) {
		Alert alert = new Alert(AlertType.INFORMATION);
		alert.setTitle(title);
		alert.setHeaderText(header);
		alert.setContentText(content);
		if(owner != null) {
			alert.initOwner(owner);
		}
		

		alert.showAndWait();
	}
	
	public static boolean ShowYesNoAlert(String title, String header, String content, Window owner) {
		
		Alert alert = new Alert(AlertType.INFORMATION);
		alert.setTitle(title);
		alert.setHeaderText(header);
		alert.setContentText(content);
		if(owner != null) {
			alert.initOwner(owner);
		}
		
		javafx.scene.control.ButtonType yesButton = new javafx.scene.control.ButtonType("Yes");
		javafx.scene.control.ButtonType noButton = new javafx.scene.control.ButtonType("No");
		alert.getDialogPane().getButtonTypes().clear();
		alert.getDialogPane().getButtonTypes().addAll(yesButton, noButton);

		Optional<ButtonType> result = alert.showAndWait();
		
		if(result.isPresent()) {
			if(result.get() == yesButton) {
				return true;
			} else {
				return false;
			}
		}
		
		return false;
	}
	
	public static String ShowChoiceDialog(String title, String header, String content, ArrayList<String> choices, String default_choice, Window owner) {

		ChoiceDialog<String> dialog = new ChoiceDialog<String>(default_choice, choices);
		dialog.setTitle(title);
		dialog.setHeaderText(header);
		dialog.setContentText(content);
		if(owner != null) {
			dialog.initOwner(owner);
		}

		// Traditional way to get the response value.
		Optional<String> result = dialog.showAndWait();
		if (result.isPresent()){
		    return result.get();
		}

		return null;
	}
}
