package jamiebalfour;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import java.net.*;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.*;
import java.util.concurrent.*;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.sound.sampled.*;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HelperFunctions {
	
	public static void main(String[] args) {
		
	}

	static boolean input_redirected = false;
	

	public static boolean FileExists(String f) {
		return new File(f).exists();
	}

	public static boolean IsDirectory(String f) {
		return new File(f).isDirectory();
	}
	
	public static void SystemBeep(double freq, final double millis) throws Exception {

		final Clip clip = AudioSystem.getClip();
		/**
		 * AudioFormat of the reclieved clip. Probably you can alter it someway choosing
		 * proper Line.
		 */
		AudioFormat af = clip.getFormat();

		/**
		 * We assume that encoding uses signed shorts. Probably we could make this code
		 * more generic but who cares.
		 */
		if (af.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
			throw new UnsupportedOperationException("Unknown encoding");
		}

		if (af.getSampleSizeInBits() != 16) {
			System.err.println("Sample size not valid.");
			return;
		}

		/**
		 * Number of bytes in a single frame
		 */
		int bytesPerFrame = af.getFrameSize();
		/**
		 * Number of frames per second
		 */
		double fps = af.getFrameRate();
		/**
		 * Number of frames during the clip .
		 */
		int frames = (int) (fps * (millis / 1000));

		/**
		 * Data
		 */
		ByteBuffer data = ByteBuffer.allocate(frames * bytesPerFrame);

		/**
		 * We will emit sinus, which needs to be scaled so it has proper frequency ---
		 * here is the scaling factor.
		 */
		double freqFactor = (Math.PI / 2) * freq / fps;
		/**
		 * This sinus must also be scaled so it fills short.
		 */
		double ampFactor = Short.MAX_VALUE;

		short sample;

		for (int frame = 0; frame < frames; frame++) {
			sample = (short) (ampFactor * Math.sin(frame * freqFactor));
			data.putShort(sample);
		}
		clip.open(af, data.array(), 0, data.position());

		// This is so Clip releases its data line when done. Otherwise at 32 clips it
		// breaks.
		clip.addLineListener(new LineListener() {
			@Override
			public void update(LineEvent event) {
				if (event.getType() == LineEvent.Type.START) {
					Timer t = new Timer((int) millis + 1, new ActionListener() {
						@Override
						public void actionPerformed(ActionEvent e) {
							clip.close();
						}
					});
					t.setRepeats(false);
					t.start();
				}
			}
		});
		clip.start();

		Thread.sleep((long) millis);

	}

	public static Clip OpenAudioClip(String url) throws Exception {

		InputStream str = new FileInputStream(url);
		AudioInputStream audioIn = AudioSystem.getAudioInputStream(new BufferedInputStream(str));
		// Get a sound clip resource.
		Clip clip = AudioSystem.getClip();
		// Open audio clip and load samples from the audio input stream.
		clip.open(audioIn);

		return clip;
	}

	public static String ShellExec(String cmd) {
		String output = "";
		try {

			Runtime rt = Runtime.getRuntime();
			Process proc = rt.exec(cmd);

			BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
			BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));

			// read the output from the command
			String s = null;
			while ((s = stdInput.readLine()) != null) {
				if (!output.equals("")) {
					output += "\r\n";
				}
				output += s;
			}

			// read any errors from the attempted command
			while ((s = stdError.readLine()) != null) {
				if (!output.equals("")) {
					output += "\r\n";
				}
				output += s;
			}

			return output;
		} catch (Exception e) {

		}
		return output;
	}

	public static String Pad(String s, int to) {

		if (s == null || s.equals("")) {
			return null;
		}

		String out = s;
		int x = 0;
		for (int i = s.length(); i < to; i++) {
			char ch = (char) (s.charAt(x % s.length()) + x);
			out += ch;
			x++;
		}

		return out;
	}

	public static Object NegateValue(Object v) {
		if (v.toString().equals("true"))
			return false;
		else if (v.toString().equals("false"))
			return true;
		else if (IsNumeric(v.toString())) {
			String m = v.toString();
			if (m.startsWith("-"))
				return m.substring(1, m.length());
			else
				return "-" + m;
		} else {
			return false;
		}
	}

	public static boolean UnixProgramExists(String cmd) {
		String s = ShellExec("whereis " + cmd);
		if (!s.equals("")) {
			return true;
		} else {
			return false;
		}
	}

	private static void updateTextArea(final String text, final JTextArea j) {
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				j.setEditable(false);
				j.append(text);
				j.setCaretPosition(j.getDocument().getLength());
				j.update(j.getGraphics());
			}
		});
	}

	public static Properties ReadProperties(String filename) {
		InputStream input = null;
		Properties prop = new Properties();
		try {
			if (!(new File(filename).exists())) {
				return prop;
			}

			input = new FileInputStream(filename);

			// load a properties file from class path, inside static method
			prop.load(input);
		} catch (IOException ex) {
			return prop;
		} finally {
			try {
				if (input != null) {
					input.close();
				}
			} catch (IOException e) {
				// Properties could not be loaded
			}
		}

		return prop;
	}

	public static void SaveProperties(Properties p, String path) {
		try {
			OutputStream os = new FileOutputStream(path);
			p.store(os, "This is a list of ZPE properties and can be modified to change ZPE settings.");
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static String ReadString(String url) {
		Scanner s;
		try {
			s = new Scanner(new URL(url).openStream(), "UTF-8");
			String out = s.useDelimiter("\\A").next();
			s.close();
			return out;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return "";

	}

	public static void RedirectSystemOutput(final JTextArea j) {
		OutputStream out = new OutputStream() {
			@Override
			public void write(int b) throws IOException {
				updateTextArea(String.valueOf((char) b), j);
			}

			@Override
			public void write(byte[] b, int off, int len) throws IOException {
				updateTextArea(new String(b, off, len), j);
			}

			@Override
			public void write(byte[] b) throws IOException {
				write(b, 0, b.length);
			}
		};

		System.setOut(new PrintStream(out, true));
		System.setErr(new PrintStream(out, true));

		input_redirected = true;

	}

	public static PrintStream RedirectSystemOutput(OutputStream outputstream) {
		// Create a stream to hold the output
		PrintStream ps = new PrintStream(outputstream);
		// Tell Java to use your special stream
		System.setOut(ps);

		return ps;
	}

	public static Object StringToNumber(String s) {
		double v = StringToDouble(s);
		if (Math.floor(v) == v) {
			return (int) Math.floor(v);
		}

		return v;
	}

	public static double StringToDouble(String s) {
		if (s.equals("true"))
			return 1;

		if (!IsNumeric(s))
			return 0;

		/*
		 * if (s.contains("E")) { String t[] = s.split("E"); double d =
		 * Double.parseDouble(t[0]); int m = Integer.parseInt(t[1]);
		 * 
		 * int q = (int) Math.pow(10, m); BigDecimal dec1 = BigDecimal.valueOf(d);
		 * BigDecimal dec2 = BigDecimal.valueOf(q);
		 * 
		 * BigDecimal k = dec1.multiply(dec2); return k.doubleValue(); } else {
		 */
		return Double.parseDouble(s);
		// }
	}

	public static int StringToInteger(String s) {
		return (int) Math.floor(StringToDouble(s));
	}

	public static long StringToLong(String s) {
		return (long) Math.floor(StringToDouble(s));
	}

	public static boolean IsNumeric(Object s) {
		if (s == null) {
			return false;
		}
		return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E[0-9]+)?");
	}

	public static String RemoveExcessDecimalPoints(String s) {
		if (s.matches("[0-9]+\\.0") && s.endsWith(".0"))
			s = s.substring(0, s.length() - 2);
		return s;
	}

	public static String encrypt(String key, String initVector, String value) throws Exception {
		IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
		SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");

		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
		cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);

		byte[] encrypted = cipher.doFinal(value.getBytes());

		return Base64.getEncoder().encodeToString(encrypted);

	}
	
	public static byte[] encrypt(String key, String initVector, byte[] value) throws Exception {
		IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
		SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");

		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
		cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);

		byte[] encrypted = cipher.doFinal(value);

		return Base64.getEncoder().encode(encrypted);

	}

	public static String encrypt(String key, String initVector, String value, int rounds) throws Exception {

		String str = encrypt(key, initVector, value);

		for (int i = 1; i < rounds; i++) {
			str = encrypt(key, initVector, str);
		}

		return str;
	}
	
	

	public static String decrypt(String key, String initVector, String encrypted) throws Exception {
		IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
		SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");

		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
		cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);

		byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));

		return new String(original);

	}
	
	public static byte[] decrypt(String key, String initVector, byte[] encrypted) throws Exception {
		IvParameterSpec iv = new IvParameterSpec(initVector.getBytes("UTF-8"));
		SecretKeySpec skeySpec = new SecretKeySpec(key.getBytes("UTF-8"), "AES");

		Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
		cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);

		byte[] original = cipher.doFinal(Base64.getDecoder().decode(encrypted));

		return original;

	}

	public static String decrypt(String key, String initVector, String encrypted, int rounds) throws Exception {

		String str = decrypt(key, initVector, encrypted);

		for (int i = 1; i < rounds; i++) {
			str = decrypt(key, initVector, str);
		}

		return str;
	}

	/*
	 * public static byte[] AESCipher(String cipher, String s) { byte[] key =
	 * cipher.getBytes(); byte[] dataToSend = s.getBytes();
	 * 
	 * int mod = dataToSend.length % cipher.length(); if (mod != 0) {
	 * 
	 * int next = (dataToSend.length - mod) + cipher.length();
	 * 
	 * byte[] output = new byte[next]; for (int i = 0; i < next - 1; i++) { if (i <
	 * dataToSend.length) output[i] = dataToSend[i];
	 * 
	 * }
	 * 
	 * dataToSend = output; }
	 * 
	 * Cipher c; try { c = Cipher.getInstance("AES/CBC/PKCS5Padding"); SecretKeySpec
	 * k = new SecretKeySpec(key, "AES"); c.init(Cipher.ENCRYPT_MODE, k); byte[]
	 * encryptedData = c.doFinal(dataToSend); return encryptedData;
	 * 
	 * } catch (Exception e) { e.printStackTrace(); } return null; }
	 * 
	 * public static byte[] AESDecipher(String cipher, String s) { byte[] key =
	 * cipher.getBytes(); byte[] encryptedData = s.getBytes();
	 * 
	 * Cipher c; try { c = Cipher.getInstance("AES/CBC/PKCS5Padding"); SecretKeySpec
	 * k = new SecretKeySpec(key, "AES"); c.init(Cipher.DECRYPT_MODE, k); byte[]
	 * data = c.doFinal(encryptedData);
	 * 
	 * return data; } catch (Exception e) { e.printStackTrace(); }
	 * 
	 * return null; }
	 */

	public static Object[] ReadFile(String fileName) throws IOException {
		InputStream is = null;
		if (new File(fileName).exists()) {
			is = new FileInputStream(fileName);
		} else {
			is = new BufferedInputStream(new URL(fileName).openStream());
		}

		try {

			final int bufsize = 4096;
			int available = is.available();
			byte[] data = new byte[available < bufsize ? bufsize : available];
			int used = 0;
			while (true) {
				if (data.length - used < bufsize) {
					byte[] newData = new byte[data.length << 1];
					System.arraycopy(data, 0, newData, 0, used);
					data = newData;
				}
				int got = is.read(data, used, data.length - used);
				if (got <= 0)
					break;
				used += got;
			}
			Object[] o = new Object[2];
			o[0] = data;
			o[1] = used;
			return o;
		} finally {
			is.close();
		}
	}

	public static String ReadFileAsString(String fileName, String charsetName) throws IOException {

		Object o[] = ReadFile(fileName);
		byte[] data = (byte[]) o[0];
		int used = (Integer) o[1];

		return charsetName != null ? new String(data, 0, used, charsetName) : new String(data, 0, used);
	}

	public static void WriteFile(String filename, String content, boolean append) throws IOException {
		String[] contents = new String[1];
		contents[0] = content;
		WriteFile(filename, contents, append);
	}

	public static void WriteFile(String filename, String[] content, boolean append) throws IOException {
		PrintWriter out = null;
		out = new PrintWriter(new BufferedWriter(new FileWriter(filename, append)));
		for (int i = 0; i < content.length; i++) {
			out.print(content[i]);
		}
		out.close();

	}

	// Transforms all arguments to a map (e.g. '-e print' to -e => print)
	public static HashMap<String, Object> GenerateArgumentMap(String[] argv) {

		Queue<String> queue = new LinkedList<String>(Arrays.asList(argv));

		HashMap<String, Object> args = new HashMap<String, Object>();

		String zac = "";

		// ZACs start with a dash always
		if (queue.peek() != null && queue.peek().startsWith("-")) {
			zac = queue.poll();

			if (queue.peek() != null && !(queue.peek().startsWith("--") || queue.peek().startsWith("-"))) {
				args.put(zac, queue.poll());
			}
		}

		// Go through the array of arguments
		while (queue.peek() != null && !queue.peek().equals("-args")) {
			String arg = queue.poll();
			if (arg.startsWith("--")) {
				// An individual value must always be true. e.g. --silent is equivalent to
				// --silent => true
				args.put(arg, true);
			} else if (arg.startsWith("-") && !(arg.length() >= 2 && arg.charAt(1) >= 48 && arg.charAt(1) <= 57)) {
				// Need to also be able to deal with negative values in command line (v1.6.8)
				// A pair of key to value
				if (queue.peek() == null) {
					System.err.println("No value provided for " + arg);
					System.exit(0);
				}

				args.put(arg, queue.poll());
			}
		}

		return args;

	}

	public static File GetFile(String f) {
		File file = new File(f);
		if (file.exists()) {
			return file;
		}

		return null;

	}

	public static void OpenWebsite(String path) {
		if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
			try {
				Desktop.getDesktop().browse(new URI(path));
			} catch (IOException e) {
				e.printStackTrace();
			} catch (URISyntaxException e) {
				e.printStackTrace();
			}
		}
	}

	private static String OS = System.getProperty("os.name").toLowerCase();

	public static boolean isWindows() {
		return (OS.indexOf("win") >= 0);
	}

	public static boolean isMac() {
		return (OS.indexOf("mac") >= 0);
	}

	public static boolean isUnix() {
		return (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0);
	}

	public static boolean isSolaris() {
		return (OS.indexOf("sunos") >= 0);
	}

	public static void ConcurrentDelay(Runnable r) {

		final Duration timeout = Duration.ofMillis(500);
		ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

		executor.schedule(r, timeout.toMillis(), TimeUnit.MILLISECONDS);
	}

	public static String MakePOSTRequest(String path, Map<String, String> arguments) throws Exception {
		return MakePOSTRequest(path, "", arguments);
	}

	public static String MakePOSTRequest(String path, String body, Map<String, String> arguments) throws Exception {
		URL url = new URL(path);
		URLConnection con = url.openConnection();
		HttpURLConnection http = (HttpURLConnection) con;
		http.setRequestMethod("POST"); // PUT is another valid option
		http.setDoOutput(true);

		http.addRequestProperty("Content-Type", "application/" + "POST");
		http.setRequestProperty("Content-Length", Integer.toString(body.length()));
		// http.getOutputStream().write(body.getBytes("UTF8"));

		StringJoiner sj = new StringJoiner("&");
		for (Map.Entry<String, String> entry : arguments.entrySet())
			sj.add(URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
		byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
		int length = out.length;

		http.setFixedLengthStreamingMode(length);
		// http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;
		// charset=UTF-8");
		http.connect();

		try {
			OutputStream os = http.getOutputStream();
			os.write(out);
		} catch (Exception e) {

		}

		BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();

		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();

		// print result
		return response.toString();

	}

	public static Date StringToDate(String str, String str_format) throws Exception {
		if (str.length() != str_format.length()) {
			throw new Exception("Date and format must be of the same length.");
		}

		String day = "";
		String month = "";
		String year = "";

		String hour = "";
		String minute = "";
		String second = "";

		int i = 0;
		int yrL = 0;

		yrL = str_format.indexOf("y");
		int yrR = yrL;

		if (yrL > -1) {
			i = yrL;

			while (i < str_format.length() && str_format.charAt(i) == 'y')
				i++;

			yrR = i;

			year = str.substring(yrL, yrR);
		}

		int moL = 0;

		moL = str_format.indexOf("M");
		int moR = moL;

		if (moL > -1) {
			i = moL;
			while (i < str_format.length() && str_format.charAt(i) == 'M')
				i++;

			moR = i;
			month = str.substring(moL, moR);
		}

		int dayL = 0;

		dayL = str_format.indexOf("d");
		int dayR = dayL;

		if (dayL > -1) {
			i = dayL;
			while (i < str_format.length() && str_format.charAt(i) == 'd')
				i++;

			dayR = i;
			day = str.substring(dayL, dayR);
		}

		int hL = 0;

		hL = str_format.indexOf("h");
		int hR = hL;

		if (hL > -1) {
			i = hL;
			while (i < str_format.length() && str_format.charAt(i) == 'h')
				i++;

			hR = i;
			hour = str.substring(hL, hR);
		}

		int mL = 0;

		mL = str_format.indexOf("m");
		int mR = mL;

		if (mL > -1) {
			i = mL;
			while (i < str_format.length() && str_format.charAt(i) == 'm')
				i++;

			mR = i;
			minute = str.substring(mL, mR);
		}

		int sL = 0;

		sL = str_format.indexOf("s");
		int sR = sL;

		if (sL > -1) {
			i = sL;
			while (i < str_format.length() && str_format.charAt(i) == 's')
				i++;

			sR = i;
			second = str.substring(sL, sR);
		}

		String yString = "";
		for (i = yrL; i < yrR; i++)
			yString = yString + 'y';

		String mString = "";
		for (i = moL; i < moR; i++)
			mString = mString + 'M';

		String dString = "";
		for (i = dayL; i < dayR; i++)
			dString = dString + 'd';

		String hrString = "";
		for (i = hL; i < hR; i++)
			hrString = hrString + 'h';

		String minString = "";
		for (i = mL; i < mR; i++)
			minString = minString + 'm';

		String secString = "";
		for (i = sL; i < sR; i++)
			secString = secString + 's';

		DateFormat format = new SimpleDateFormat(yString + mString + dString + hrString + minString + secString,
				Locale.ENGLISH);
		Date date;
		try {
			date = format.parse(year + month + day + hour + minute + second);

			return date;
		} catch (ParseException e) {
			throw new Exception("");
		}
	}

	public static String GetIP() throws Exception {
		URL whatismyip = new URL("http://checkip.amazonaws.com");
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(whatismyip.openStream()));
			String ip = in.readLine();
			return ip;
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public static String GetResource(String r) {

		try {

			InputStream in = HelperFunctions.class.getResourceAsStream(r);

			ByteArrayOutputStream result = new ByteArrayOutputStream();
			byte[] buffer = new byte[1024];
			int length;
			while ((length = in.read(buffer)) != -1) {
				result.write(buffer, 0, length);
			}
			// StandardCharsets.UTF_8.name() > JDK 7
			in.close();
			return result.toString("UTF-8");
		} catch (Exception e) {

		}

		return "";
	}

	public static boolean IsDarkMode() {

		if (isMac()) {
			String cmd = "defaults read -g AppleInterfaceStyle";
			if (ShellExec(cmd).equals("Dark")) {
				return true;
			}
		}

		return false;
	}

	public static class NullOutputStream extends OutputStream {
		@Override
		public void write(int b) {
			return;
		}

		@Override
		public void write(byte[] b) {
			return;
		}

		@Override
		public void write(byte[] b, int off, int len) {
			return;
		}

		public NullOutputStream() {
		}
	}

	public static void Delay(long t) {
		try {
			java.util.concurrent.TimeUnit.MILLISECONDS.sleep(t);
		} catch (InterruptedException e) {
		}
	}

	public static byte[] toByteArray(Object obj) throws IOException {
		byte[] bytes = null;
		ByteArrayOutputStream bos = null;
		ObjectOutputStream oos = null;
		try {
			bos = new ByteArrayOutputStream();
			oos = new ObjectOutputStream(bos);
			oos.writeObject(obj);
			oos.flush();
			bytes = bos.toByteArray();
		} finally {
			if (oos != null) {
				oos.close();
			}
			if (bos != null) {
				bos.close();
			}
		}
		return bytes;
	}
}
