/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.zen;

import extensions.mindrot.BCrypt;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEString;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;

public class ZENServer
implements Runnable {
    public static final String ZEN_VERSION = "20X";
    boolean running = true;
    int port_number = 0;
    int permission_level = 0;
    String password = null;
    byte[] passcode_bytes;
    ArrayList<String> serverCommands = new ArrayList();
    String prepend = null;
    ArrayList<Socket> openSocks = new ArrayList();
    HashMap<String, String> keys = new HashMap();

    public ZENServer() {
        this.serverCommands = new ArrayList();
        this.serverCommands.add("ls");
        this.serverCommands.add("cd");
        this.serverCommands.add("pwd");
        this.serverCommands.add("cat");
        this.serverCommands.add("mkdir");
        this.serverCommands.add("rm");
        this.serverCommands.add("supports");
        this.serverCommands.add("say");
        this.serverCommands.add("exit");
    }

    private String pad(String s) {
        return HelperFunctions.padString(s, 16);
    }

    public void Start(int portNumber, int permissionLevel) {
        this.Start(portNumber, permissionLevel, null, null);
    }

    public void Start(int portNumber, int permissionLevel, String pass, String prependFile) {
        if (prependFile != null) {
            try {
                this.prepend = FileHelperFunctions.readFileAsString(prependFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.port_number = portNumber;
        this.permission_level = permissionLevel;
        this.password = this.pad(pass);
        try {
            this.passcode_bytes = this.password.getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ZPEInstance.setToInteractive(true);
        this.run();
    }

    String processText(String line) throws Exception {
        if (this.password != null) {
            return HelperFunctions.decrypt(this.passcode_bytes, this.passcode_bytes, line);
        }
        return line;
    }

    private ZPEType execute(String code, PrintWriter out, ZPERuntimeEnvironment runtime) {
        if (this.prepend != null) {
            code = this.prepend + (String)code;
        }
        try {
            return ZPEKit.runCode(runtime, (String)code, null);
        }
        catch (Exception e) {
            return new ZPEString(e.getMessage());
        }
    }

    void send(PrintWriter out, String s, boolean encrypted) {
        try {
            if (encrypted) {
                if (this.password != null) {
                    out.println(HelperFunctions.encrypt(this.passcode_bytes, this.passcode_bytes, s));
                } else {
                    out.println(s);
                }
            } else {
                out.println(s);
            }
        }
        catch (Exception e) {
            out.println(s);
        }
    }

    public void Stop() {
        this.running = false;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        this.running = true;
        while (this.running) {
            try {
                try {
                    assert (serverSocket != null);
                    serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serverSocket = new ServerSocket(this.port_number);
                Socket clientSocket = serverSocket.accept();
                ServerThread s = new ServerThread(clientSocket, this);
                s.start();
            }
            catch (Exception e) {
                System.out.println(e);
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!e.getMessage().contains("Address already in use")) continue;
                System.out.println("Server address already in use. Use a different port.");
                break;
            }
        }
        try {
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ServerThread
    extends Thread {
        Socket clientSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        ZPERuntimeEnvironment yri;
        ZENServer parent;
        String root_path;
        ArrayList<String> systemRoots;

        private ServerThread(Socket s, ZENServer parent) {
            this.yri = new ZPERuntimeEnvironment(ZENServer.this.permission_level);
            this.root_path = "";
            this.clientSocket = s;
            this.parent = parent;
            this.systemRoots = new ArrayList();
            for (File f : File.listRoots()) {
                this.systemRoots.add(f.getAbsolutePath());
            }
            this.root_path = new File("").getAbsolutePath();
            try {
                this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String addRoot(String f) {
            if (this.root_path.endsWith(System.getProperty("file.separator"))) {
                return new File(this.root_path + f).getAbsolutePath();
            }
            return new File(this.root_path + System.getProperty("file.separator") + f).getAbsolutePath();
        }

        private boolean containsRoot(String f) {
            for (String s : this.systemRoots) {
                if (!f.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        private void changeRoot(String f) {
            this.root_path = this.containsRoot(f) ? new File(f).getAbsolutePath() : new File(this.addRoot(f)).getAbsolutePath();
        }

        public void sendData(String f, byte[] data) throws Exception {
            try {
                if (ZENServer.this.password != null) {
                    try {
                        data = HelperFunctions.writeEncryptedObject((Object)data, ZENServer.this.passcode_bytes);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ZENServer.this.send(this.out, "put:" + data.length, true);
                String line = "";
                while ((line = this.in.readLine()) != null) {
                    if (!(line = ZENServer.this.processText(line)).startsWith("svr:ready")) continue;
                    this.clientSocket.getOutputStream().write(data);
                    break;
                }
                ZENServer.this.send(this.out, "put:done", true);
                ZENServer.this.send(this.out, "put:file:" + new File(f).getName(), true);
            }
            catch (IOException e) {
                ZPECore.log(e.getMessage());
                System.err.println(e.getMessage());
            }
        }

        private File createCannonicalDir(String dir) {
            Object repDir = this.addRoot(dir);
            while (((String)repDir).contains("..")) {
                int i = ((String)repDir).indexOf("..") + 2;
                String end = ((String)repDir).substring(i);
                String start = ((String)repDir).substring(0, i - 2);
                repDir = new File(start).getParent() + end;
            }
            return new File((String)repDir);
        }

        private void sendReady(boolean encrypt) {
            ZENServer.this.send(this.out, "svr:ready", encrypt);
        }

        private void ls(String content) {
            String dir = "";
            StringBuilder output = new StringBuilder();
            if (content.length() > 3) {
                dir = content.substring(3);
            }
            File directory = this.createCannonicalDir(dir);
            if ((directory = new File(directory.getAbsoluteFile().toString())).exists() && directory.isDirectory()) {
                for (File f : Objects.requireNonNull(directory.listFiles())) {
                    output.append(f.getAbsolutePath()).append(System.lineSeparator());
                }
            }
            ZENServer.this.send(this.out, "msg:" + String.valueOf(output), true);
        }

        private void cd(String content) {
            String dir = "";
            if (content.length() > 2) {
                dir = content.substring(3);
            }
            File directory = this.createCannonicalDir(dir);
            if ((directory = new File(directory.getAbsoluteFile().toString())).exists() && directory.isDirectory()) {
                this.changeRoot(directory.getAbsolutePath());
            }
            String output = "Changed directory to " + this.root_path;
            ZENServer.this.send(this.out, "msg:" + output, true);
        }

        private void pwd(String content) {
            ZENServer.this.send(this.out, "msg:" + this.root_path, true);
        }

        private void cat(String content) {
            String file = "";
            if (content.length() > 3) {
                file = content.substring(4);
                File f = this.createCannonicalDir(file);
                if (f.isDirectory()) {
                    ZENServer.this.send(this.out, "msg:The file " + f.getAbsolutePath() + " is a directory.", true);
                } else {
                    try {
                        ZENServer.this.send(this.out, "msg:" + FileHelperFunctions.readFileAsString(f.getAbsolutePath()), true);
                    }
                    catch (IOException e) {
                        ZENServer.this.send(this.out, "msg:The file " + f.getAbsolutePath() + " could not be read.", true);
                    }
                }
            }
        }

        private void mv(String content) {
        }

        private void rm(String content) {
            String file = "";
            file = content.substring(3);
            File f = this.createCannonicalDir(file);
            Object output = "";
            output = f.exists() ? (f.delete() ? "Deleted path " + f.getAbsolutePath() : "The path " + f.getAbsolutePath() + " could not be deleted.") : "The path " + f.getAbsolutePath() + " could not be deleted because it does not exist.";
            ZENServer.this.send(this.out, "msg:" + (String)output, true);
        }

        private void mkdir(String content) {
            String file = "";
            file = content.substring(6);
            File f = this.createCannonicalDir(file);
            if (!f.exists()) {
                f.mkdirs();
            }
            String output = "Created directory " + f.getAbsolutePath();
            ZENServer.this.send(this.out, "msg:" + output, true);
        }

        private void supports(String content) {
            StringBuilder output = new StringBuilder();
            for (String s : ZENServer.this.serverCommands) {
                output.append(s).append(";");
            }
            ZENServer.this.send(this.out, "msg:" + String.valueOf(output), true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block70: {
                    boolean connected = false;
                    String line = "";
                    while ((line = this.in.readLine()) != null && this.parent.running) {
                        if (!line.equals("clt:open_connection")) continue;
                        connected = true;
                        break;
                    }
                    ZENServer.this.send(this.out, "svr:welcome", false);
                    ZENServer.this.send(this.out, "svr:welcome_message", false);
                    if (ZPEInstance.getServerMessageProperty() != "") {
                        ZENServer.this.send(this.out, ZPEInstance.getServerMessageProperty(), false);
                    } else {
                        ZENServer.this.send(this.out, "Welcome to ZPE Remote.", false);
                    }
                    ZENServer.this.send(this.out, "svr:welcome_message_ends", false);
                    ZENServer.this.send(this.out, "svr:server_command_list", false);
                    for (String s : ZENServer.this.serverCommands) {
                        ZENServer.this.send(this.out, s, false);
                    }
                    ZENServer.this.send(this.out, "svr:server_command_list_ends", false);
                    boolean authenticated = true;
                    if (ZENServer.this.password != null) {
                        authenticated = false;
                        ZENServer.this.send(this.out, "svr:get_password", false);
                        while ((line = this.in.readLine()) != null && this.parent.running) {
                            String cmd = line.substring(0, 4);
                            String content = line.substring(4);
                            if (!cmd.equals("pwd:")) continue;
                            if (BCrypt.checkpw(ZENServer.this.password, content)) {
                                authenticated = true;
                                ZPECore.print("Successful authentication");
                                break;
                            }
                            ZENServer.this.send(this.out, "svr:password_incorrect", false);
                            this.clientSocket.close();
                        }
                    }
                    if (!authenticated) return;
                    this.sendReady(false);
                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
                    Date dateobj = null;
                    String ip_address = "";
                    ip_address = this.clientSocket.getInetAddress().toString();
                    if (ip_address.startsWith("/")) {
                        ip_address = ip_address.substring(1);
                    }
                    while (this.parent.running) {
                        line = this.in.readLine();
                        if (line == null) continue;
                        line = ZENServer.this.processText(line);
                        String cmd = line.substring(0, 4);
                        String content = line.substring(4);
                        switch (cmd) {
                            case "clt:": {
                                if (content.equals("close_connection")) {
                                    ZPECore.print("Connection terminated");
                                    ZENServer.this.openSocks.remove(this.clientSocket);
                                    this.clientSocket.close();
                                    return;
                                }
                                if (!content.equals("open_connection")) break;
                                connected = true;
                                dateobj = new Date();
                                ZENServer.this.openSocks.add(this.clientSocket);
                                ZPECore.print(ip_address + " connected at " + df.format(dateobj));
                                break;
                            }
                            case "zpe:": {
                                Object output = "";
                                ZPECore.print("Executing ZPE/YASS command for " + ip_address + " : " + content);
                                ZPEType result = ZENServer.this.execute(content, this.out, this.yri);
                                if (result != null && !result.toString().isEmpty()) {
                                    output = (String)output + result.toString();
                                }
                                ZENServer.this.send(this.out, "msg:" + (String)output, true);
                                if (((String)output).isEmpty()) {
                                    output = "null";
                                }
                                ZPECore.print("Result: " + (String)output);
                                ZENServer.this.send(this.out, "svr:done", true);
                                this.sendReady(true);
                                break;
                            }
                            case "put:": {
                                if (ZPEInstance.getAllowServerCommandsProperty()) {
                                    ZPECore.print("Incoming data transfer from " + ip_address + ".");
                                    this.sendReady(true);
                                    int len = HelperFunctions.stringToInteger(content);
                                    byte[] bytes = new byte[len];
                                    int readContent = this.clientSocket.getInputStream().read();
                                    for (int i = 0; i < len - 1; ++i) {
                                        bytes[i] = (byte)readContent;
                                        readContent = this.clientSocket.getInputStream().read();
                                    }
                                    bytes[len - 1] = (byte)readContent;
                                    String fname = "out.txt";
                                    while ((line = this.in.readLine()) != null && this.parent.running) {
                                        if (!(line = ZENServer.this.processText(line)).contentEquals("put:done") || !(line = ZENServer.this.processText(this.in.readLine())).startsWith("put:file:")) continue;
                                        fname = line.substring(9);
                                        break;
                                    }
                                    if (ZENServer.this.password != null) {
                                        bytes = (byte[])HelperFunctions.readEncryptedObject(bytes, ZENServer.this.passcode_bytes);
                                    }
                                    FileHelperFunctions.writeByteFile(fname, bytes);
                                    line = this.in.readLine();
                                    line = ZENServer.this.processText(line);
                                    if (line.contentEquals("put:done")) {
                                        ZPECore.print("File transfer from " + ip_address + " complete. The file is located at " + fname);
                                    }
                                } else {
                                    ZENServer.this.send(this.out, "msg:Not accepted", true);
                                }
                                this.sendReady(true);
                                break;
                            }
                            case "get:": {
                                if (ZPEInstance.getAllowServerCommandsProperty()) {
                                    if (new File(content).exists()) {
                                        System.out.println(content + " -> " + ip_address + "[" + ZENServer.this.port_number + "]");
                                        byte[] data = FileHelperFunctions.readFile(content);
                                        try {
                                            this.sendData(content, data);
                                        }
                                        catch (Exception e) {
                                            ZPECore.printError("Data could not be transmitted.");
                                        }
                                        break;
                                    }
                                    ZENServer.this.send(this.out, "msg:File not found", true);
                                    break;
                                }
                                ZENServer.this.send(this.out, "msg:Not accepted", true);
                                this.sendReady(true);
                                break;
                            }
                            case "cmd:": {
                                String command = content.split(" ")[0];
                                if (ZPEInstance.getAllowServerCommandsProperty()) {
                                    if (!command.equals("say")) {
                                        ZPECore.print("Attempting to execute command " + content + " for " + ip_address);
                                    }
                                    switch (command) {
                                        case "ls": {
                                            this.ls(content);
                                        }
                                        case "cd": {
                                            this.cd(content);
                                        }
                                        case "pwd": {
                                            this.pwd(content);
                                        }
                                        case "cat": {
                                            this.cat(content);
                                        }
                                        case "mv": {
                                            this.mv(content);
                                        }
                                        case "mkdir": {
                                            this.mkdir(content);
                                        }
                                        case "rm": {
                                            this.rm(content);
                                        }
                                        case "supports": {
                                            this.supports(content);
                                        }
                                        case "exit": {
                                            ZPECore.print("EXIT COMMAND ISSUED. THE CLIENT HAS CLOSED THE SOCKET.");
                                            ZENServer.this.send(this.out, "svr:close", true);
                                            this.clientSocket.close();
                                        }
                                        case "say": {
                                            if (content.length() > 4) {
                                                ZPECore.print(content.substring(4));
                                            }
                                            ZENServer.this.send(this.out, "msg:Spoken", true);
                                            break;
                                        }
                                    }
                                    ZENServer.this.send(this.out, "svr:done", true);
                                    this.sendReady(true);
                                    break;
                                }
                                if (command.equals("exit")) {
                                    ZPECore.print("EXIT COMMAND ISSUED. THE CLIENT HAS CLOSED THE SOCKET.");
                                    ZENServer.this.send(this.out, "svr:close", true);
                                    this.clientSocket.close();
                                } else {
                                    ZENServer.this.send(this.out, "svr:not-accepted", true);
                                }
                                ZENServer.this.send(this.out, "svr:done", true);
                                this.sendReady(true);
                            }
                        }
                        if (connected) {
                            continue;
                        }
                        break block70;
                    }
                    return;
                }
                this.clientSocket.close();
                return;
            }
            catch (Exception e) {
                try {
                    System.out.println(e.getMessage());
                    this.in.close();
                    this.out.close();
                    this.clientSocket.close();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

