/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.interfaces.ZPEIndexableElement;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ZPEMap
extends ZPEMemberType
implements Iterable<ZPEType>,
Serializable,
Map<ZPEType, ZPEType>,
ZPEIndexableElement,
Comparable {
    private static final long serialVersionUID = 332479554659616391L;
    HashMap<ZPEType, ZPEType> values = new HashMap();

    private void addMethods() {
        this.addMethod("get", new get_Command());
        this.addMethod("put", new put_Command());
        this.addMethod("remove", new remove_Command());
    }

    public ZPEMap() {
        this.addMethods();
    }

    public ZPEMap(ZPEMap a) {
        this.addMethods();
        for (ZPEType ele : a.keySet()) {
            this.put(ele, a.get(ele));
        }
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEMap(this);
    }

    @Override
    public int hashCode() {
        return this.values.toString().hashCode();
    }

    @Override
    public Set<ZPEType> keySet() {
        HashSet<ZPEType> o = new HashSet<ZPEType>();
        for (ZPEType k : this.values.keySet()) {
            o.add(k);
        }
        return o;
    }

    @Override
    public Set<Map.Entry<ZPEType, ZPEType>> entrySet() {
        HashSet<Map.Entry<ZPEType, ZPEType>> out = new HashSet<Map.Entry<ZPEType, ZPEType>>(this.values.entrySet());
        return out;
    }

    public void putAll(ZPEMap x) {
        this.values.putAll(x.values);
    }

    public void flip() {
        HashMap<ZPEType, ZPEType> out = new HashMap<ZPEType, ZPEType>();
        for (ZPEType s : this.values.keySet()) {
            ZPEType val = this.values.get(s);
            out.put(val, s);
        }
        this.values = out;
    }

    public String stringify() {
        StringBuilder out = new StringBuilder();
        for (ZPEType o : this.keySet()) {
            if (!out.toString().isEmpty()) {
                out.append("&");
            }
            out.append(o.toString()).append("=").append(this.get(o).toString());
        }
        return out.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof ZPEType) {
            return this.values.containsKey(key);
        }
        return false;
    }

    public boolean containsKey(ZPEType key) {
        return this.values.containsKey(key);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public ZPEType get(Object key) {
        if (key instanceof ZPEType) {
            return this.values.get(key);
        }
        return null;
    }

    public ZPEType get(ZPEType key) {
        return this.values.get(key);
    }

    public void fromMap(HashMap<ZPEType, ZPEType> m) {
        this.values = m;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("[");
        int i = 0;
        int count = this.values.size();
        if (count > 0) {
            for (Map.Entry<ZPEType, ZPEType> e : this.values.entrySet()) {
                if (i == count - 1) {
                    out.append(e.getKey()).append("=>").append(e.getValue());
                } else {
                    out.append(e.getKey()).append("=>").append(e.getValue()).append(", ");
                }
                ++i;
            }
        } else {
            out.append("=>");
        }
        return String.valueOf(out) + "]";
    }

    @Override
    public Iterator<ZPEType> iterator() {
        return this.values.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof ZPEType) {
            return this.values.containsValue(value);
        }
        return false;
    }

    public boolean containsValue(ZPEType value) {
        return this.values.containsValue(value);
    }

    @Override
    public ZPEType put(ZPEType key, ZPEType value) {
        if (key != null) {
            return this.values.put(key, value);
        }
        return this.values.put(null, value);
    }

    @Override
    public ZPEType remove(Object key) {
        if (key instanceof ZPEType) {
            return this.values.remove(key);
        }
        return null;
    }

    public ZPEType remove(ZPEType key) {
        return this.values.remove(key);
    }

    @Override
    public void putAll(Map m) {
        this.values.putAll(m);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Collection values() {
        return this.values.values();
    }

    @Override
    public Object getIndex(Object i) {
        if (i instanceof ZPEType && this.values.containsKey(i)) {
            return this.values.get(i);
        }
        return null;
    }

    public Object getIndex(ZPEType i) {
        if (this.values.containsKey(i)) {
            return this.values.get(i);
        }
        return null;
    }

    public Map<?, ?> toMap() {
        return this.values;
    }

    public boolean containsEverything(ZPEMap o) {
        if (o.keySet().size() != this.values.keySet().size()) {
            return false;
        }
        for (ZPEType key : this.values.keySet()) {
            if (!o.containsKey(key)) {
                return false;
            }
            if (o.get(key).equals(this.values.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ZPEMap)) {
            return false;
        }
        return this.containsEverything((ZPEMap)o);
    }

    public boolean equals(ZPEMap o) {
        return this.containsEverything(o);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ZPEMap)) {
            return 0;
        }
        if (this.containsEverything((ZPEMap)o)) {
            return 1;
        }
        if (((ZPEMap)o).containsEverything(this)) {
            return -1;
        }
        return 0;
    }

    class remove_Command
    implements ZPEReferenceMethod {
        remove_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEMap.this.remove(arguments[0]);
            return owner;
        }
    }

    class put_Command
    implements ZPEReferenceMethod {
        put_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEMap.this.put(arguments[0], arguments[1]);
            return owner;
        }
    }

    class get_Command
    implements ZPEReferenceMethod {
        get_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEMap.this.get(arguments[0]);
            return owner;
        }
    }
}

