/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPERandomizer;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEIndexableElement;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEArray;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPENumber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ZPEList
extends ZPEMemberType
implements Iterable<ZPEType>,
Serializable,
ZPEIndexableElement,
Comparable,
List<ZPEType> {
    private static final long serialVersionUID = -3732999098229747772L;
    ArrayList<ZPEType> items = new ArrayList();
    private final ZPEList _this = this;

    private void addMethods() {
        this.addMethod("get", new get_Command());
        this.addMethod("put", new put_Command());
        this.addMethod("push", new push_Command());
        this.addMethod("get_circular", new get_circular_Command());
        this.addMethod("sublist", new sublist_Command());
        this.addMethod("remove", new remove_Command());
        this.addMethod("length", new length_Command());
        this.addMethod("copy", new copy_Command());
        this.addMethod("map", new map_Command());
        this.addMethod("filter", new filter_Command());
        this.addMethod("reduce", new reduce_Command());
    }

    public ZPEList() {
        this.addMethods();
    }

    public ZPEList(ZPEList l) {
        this.addMethods();
        this.items.addAll(l.items);
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEList(this);
    }

    public String print() {
        int i;
        StringBuilder output = new StringBuilder();
        ZPECore.print("[", true);
        output.append("[");
        for (i = 0; i < this.items.size() - 1; ++i) {
            ZPEType item = this.items.get(i);
            if (item == null) {
                ZPECore.print("null, ", true);
                output.append("null, ");
                continue;
            }
            ZPECore.print(String.valueOf(item) + ", ", true);
            output.append(item).append(", ");
        }
        if (i < this.items.size()) {
            ZPECore.print(this.items.get(i).toString(), true);
            output.append(this.items.get(i));
        }
        ZPECore.print("]", true);
        output.append("]");
        return output.toString();
    }

    public ZPEList createCopy() {
        return new ZPEList(this);
    }

    @Override
    public void add(int i, ZPEType o) {
        this.items.add(i, o);
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public boolean contains(Object o) {
        String s = o.toString();
        for (ZPEType item : this.items) {
            if (!item.toString().equals(s)) continue;
            return true;
        }
        return false;
    }

    public void shuffle() {
        Collections.shuffle(this.items);
    }

    public String toString() {
        int i;
        StringBuilder out = new StringBuilder("[");
        for (i = 0; i < this.items.size() - 1; ++i) {
            ZPEType item = this.items.get(i);
            if (item == null) {
                out.append("null, ");
                continue;
            }
            out.append(item).append(", ");
        }
        if (i < this.items.size()) {
            out.append(this.items.get(i));
        }
        return String.valueOf(out) + "]";
    }

    public void addAll(ZPEList c) {
        this.items.addAll(c.items);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public ZPEType get(int i) {
        if (ZPEInstance.getOptionBase1Property()) {
            --i;
        }
        if (ZPEInstance.getIndexSafetyProperty()) {
            if (i < 0) {
                i = 0;
            }
        } else {
            while (i < 0) {
                i = this.items.size() - Math.abs(i);
            }
        }
        return this.items.get(i);
    }

    public ZPEType get(ZPENumber index) {
        int i = index.intValue();
        if (ZPEInstance.getOptionBase1Property()) {
            --i;
        }
        if (ZPEInstance.getIndexSafetyProperty()) {
            if (i < 0) {
                i = 0;
            }
        } else {
            while (i < 0) {
                i = this.items.size() - Math.abs(i);
            }
        }
        return this.items.get(i);
    }

    public ZPEList getRange(int i1, int i2) {
        ZPEList output = new ZPEList();
        for (int i = i1; i <= i2; ++i) {
            output.add(this.get(i));
        }
        return output;
    }

    public void fromArrayList(ArrayList<ZPEType> l) {
        this.items = l;
    }

    public byte getDataType() {
        byte dataType = -1;
        for (ZPEType o : this.items) {
            byte type = ZPEHelperFunctions.getDataType(o);
            if (dataType == -1) {
                dataType = type;
                continue;
            }
            if (type == dataType) continue;
            return 118;
        }
        return dataType;
    }

    @Override
    public Iterator<ZPEType> iterator() {
        return this.items.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.items.toArray(a);
    }

    @Override
    public boolean add(ZPEType e) {
        return this.items.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    public void removeAt(ZPENumber o) {
        this.items.remove(o.intValue());
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.items.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.items.retainAll(c);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public ZPEType set(int index, ZPEType element) {
        while (index > this.items.size() - 1) {
            this.items.add(null);
        }
        return this.items.set(index, element);
    }

    public Object set(ZPENumber index, ZPEType element) {
        while (index.intValue() > this.items.size() - 1) {
            this.items.add(null);
        }
        return this.items.set(index.intValue(), element);
    }

    @Override
    public ZPEType remove(int index) {
        return this.items.remove(index);
    }

    public int lastIndexOf(ZPEType o) {
        return this.items.lastIndexOf(o);
    }

    public ArrayList<ZPEType> items() {
        return this.items;
    }

    @Override
    public ListIterator listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    public ZPEList toZPEArray() {
        return new ZPEArray(this);
    }

    @Override
    public Object getIndex(Object e) {
        int i = HelperFunctions.stringToInteger(e.toString());
        if (ZPEInstance.getOptionBase1Property()) {
            --i;
        }
        if (i < this.items.size()) {
            return this.items.get(i);
        }
        return null;
    }

    public boolean isIdentical(ZPEList l) {
        if (l.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (l.get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ZPEList)) {
            return false;
        }
        return this.isIdentical((ZPEList)o);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ZPEList)) {
            return -1;
        }
        if (this.isIdentical((ZPEList)o)) {
            return 1;
        }
        return 0;
    }

    class reduce_Command
    implements ZPEReferenceMethod {
        reduce_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            ZPEType result = arguments[1];
            ZPEFunction f = (ZPEFunction)arguments[0];
            int index = 0;
            for (ZPEType o : ZPEList.this.items) {
                f.setParameter(f.getParameterNames().get(0), result);
                f.setParameter(f.getParameterNames().get(1), o);
                if (f.getParameterNames().size() > 2) {
                    f.setParameter(f.getParameterNames().get(1), new ZPENumber(index++));
                }
                result = f.run();
            }
            return result;
        }
    }

    class filter_Command
    implements ZPEReferenceMethod {
        filter_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            ZPEList newList = new ZPEList();
            ZPEFunction f = (ZPEFunction)arguments[0];
            int index = 0;
            for (ZPEType o : ZPEList.this.items) {
                ZPEType result;
                f.setParameter(f.getParameterNames().get(0), o);
                if (f.getParameterNames().size() > 1) {
                    f.setParameter(f.getParameterNames().get(1), new ZPENumber(index++));
                }
                if (!((result = f.run()) instanceof ZPEBoolean) || !((ZPEBoolean)result).getValue()) continue;
                newList.add(o);
            }
            return newList;
        }
    }

    class map_Command
    implements ZPEReferenceMethod {
        map_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
            ZPEList newList = new ZPEList();
            ZPEFunction f = (ZPEFunction)arguments[0];
            int index = 0;
            for (ZPEType o : ZPEList.this.items) {
                f.setParameter(f.getParameterNames().get(0), o);
                if (f.getParameterNames().size() > 1) {
                    f.setParameter(f.getParameterNames().get(1), new ZPENumber(index++));
                }
                newList.add(f.run());
            }
            return newList;
        }
    }

    class copy_Command
    implements ZPEReferenceMethod {
        copy_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return ZPEList.this.createCopy();
        }
    }

    class length_Command
    implements ZPEReferenceMethod {
        length_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            return new ZPENumber(ZPEList.this.items.size());
        }
    }

    class remove_Command
    implements ZPEReferenceMethod {
        remove_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEList.this.items.remove(HelperFunctions.stringToInteger(arguments[0].toString()));
            return ZPEList.this._this;
        }
    }

    class sublist_Command
    implements ZPEReferenceMethod {
        sublist_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int low = HelperFunctions.stringToInteger(arguments[0].toString());
            int high = HelperFunctions.stringToInteger(arguments[1].toString());
            ZPEList l = new ZPEList();
            for (int i = low; i <= high; ++i) {
                l.add(ZPEList.this.items.get(i));
            }
            return l;
        }
    }

    class get_circular_Command
    implements ZPEReferenceMethod {
        get_circular_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index = HelperFunctions.stringToInteger(arguments[0].toString()) % ZPEList.this.items.size();
            return ZPEList.this.items.get(index);
        }
    }

    class push_Command
    implements ZPEReferenceMethod {
        push_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEList.this.items.add(0, arguments[0]);
            return owner;
        }
    }

    class put_Command
    implements ZPEReferenceMethod {
        put_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            ZPEList.this.items.add(arguments[0]);
            return owner;
        }
    }

    class get_Command
    implements ZPEReferenceMethod {
        get_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int index = HelperFunctions.stringToInteger(arguments[0].toString());
            if (ZPEInstance.getOptionBase1Property()) {
                --index;
            }
            if (arguments[0].toString().equalsIgnoreCase("any")) {
                int maximum = ZPEList.this.items.size() - 1;
                int minimum = 0;
                index = ZPERandomizer.generate(minimum, maximum);
            }
            return ZPEList.this.items.get(index);
        }
    }
}

