/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.types;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.exceptions.IncorrectArrayDataType;
import jamiebalfour.zpe.interfaces.ZPEReferenceMethod;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPENumber;

public class ZPEArray
extends ZPEList {
    private static final long serialVersionUID = -2557413559037569547L;
    private byte dataType = (byte)-1;

    private void addMethods() {
        this.addMethod("resize", new resize_Command());
    }

    public ZPEArray(ZPEList l) {
        this.addMethods();
        this.dataType = ZPEHelperFunctions.getDataType(l.get(0));
        for (ZPEType o : l.items) {
            this.add(o);
        }
    }

    public ZPEArray(ZPEType default_value, long size) {
        this.addMethods();
        this.dataType = ZPEHelperFunctions.getDataType(default_value);
        for (long i = 0L; i < size; ++i) {
            this.items.add(default_value);
        }
    }

    @Override
    public ZPEType set(int index, ZPEType element) {
        byte t = ZPEHelperFunctions.getDataType(element);
        if (this.dataType == -1) {
            this.dataType = t;
        } else if (this.dataType != t) {
            throw new IncorrectArrayDataType(t, this.dataType);
        }
        return this.items.set(index, element);
    }

    @Override
    public Object set(ZPENumber index, ZPEType element) {
        return this.set(index.intValue(), element);
    }

    public ZPEList toList() {
        ZPEList l = new ZPEList();
        l.items.addAll(this.items);
        return l;
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    @Override
    public ZPEType copyOfMe() {
        return new ZPEArray(this);
    }

    class resize_Command
    implements ZPEReferenceMethod {
        resize_Command() {
        }

        @Override
        public ZPEType MainMethod(ZPEMemberType owner, ZPEType[] arguments) {
            int newSize = HelperFunctions.stringToInteger(arguments[0].toString());
            if (newSize > ZPEArray.this.items.size()) {
                for (int index = ZPEArray.this.items.size(); index < newSize; ++index) {
                    ZPEArray.this.items.add(null);
                }
            } else if (ZPEArray.this.items.size() > newSize) {
                ZPEArray.this.items.subList(newSize, ZPEArray.this.items.size()).clear();
            }
            return owner;
        }
    }
}

