/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.objects;

import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;

public class HTMLBuilderObject
extends ZPEStructure {
    private static final long serialVersionUID = 6815367120366638702L;

    public HTMLBuilderObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper p) throws ZPERuntimeException {
        super(z, p, "HTMLBuilderObject");
        this.addNativeMethod("list_to_html_list", new list_to_html_list_Command());
        this.addNativeMethod("map_to_html_definition_list", new map_to_html_definition_list_Command());
        this.addNativeMethod("list_to_html_table", new list_to_html_table_Command());
    }

    class list_to_html_table_Command
    implements ZPEObjectNativeMethod {
        list_to_html_table_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"array"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"list"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            StringBuilder output = new StringBuilder();
            if (!(parameters.get("array") instanceof ZPEList)) {
                return new ZPEBoolean(false);
            }
            ZPEList l = (ZPEList)parameters.get("array");
            output = new StringBuilder("<table>");
            for (ZPEType r : l) {
                if (!(r instanceof ZPEList)) continue;
                output.append("<tr>");
                ZPEList row = (ZPEList)r;
                for (ZPEType item : row) {
                    output.append("<td>").append(item.toString()).append("</td>");
                }
                output.append("</tr>");
            }
            output.append("</table>");
            return new ZPEString(output.toString());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "list_to_html_table";
        }
    }

    class map_to_html_definition_list_Command
    implements ZPEObjectNativeMethod {
        map_to_html_definition_list_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"array"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"map"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            StringBuilder output = new StringBuilder();
            if (!(parameters.get("array") instanceof ZPEMap)) {
                return new ZPEBoolean(false);
            }
            ZPEMap l = (ZPEMap)parameters.get("array");
            output = new StringBuilder("<dl>");
            for (ZPEType k : l.keySet()) {
                output.append("<dt>").append(k.toString()).append("</dt>");
                output.append("<dd>").append(l.get((Object)k).toString()).append("</dd>");
            }
            output.append("</dl>");
            return new ZPEString(output.toString());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "map_to_html_definition_list";
        }
    }

    class list_to_html_list_Command
    implements ZPEObjectNativeMethod {
        list_to_html_list_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"array", "ordered"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"list", "boolean"};
        }

        public String doAction(ZPEList l, boolean ordered) {
            StringBuilder output = new StringBuilder();
            output = ordered ? new StringBuilder("<ol>") : new StringBuilder("<ul>");
            for (ZPEType o : l) {
                if (o instanceof ZPEList) {
                    output.append("<li>").append(this.doAction((ZPEList)o, ordered)).append("</li>");
                    continue;
                }
                output.append("<li>").append(o.toString()).append("</li>");
            }
            if (ordered) {
                output.append("</ol>");
            } else {
                output.append("</ul>");
            }
            return output.toString();
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
            if (!(parameters.get("array") instanceof ZPEList)) {
                return new ZPEBoolean(false);
            }
            boolean ordered = false;
            if (parameters.containsKey("ordered") && parameters.get("ordered").toString().equals("true")) {
                ordered = true;
            }
            ZPEList l = (ZPEList)parameters.get("array");
            return new ZPEString(this.doAction(l, ordered));
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "list_to_html_list";
        }
    }
}

