/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.macOS;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UITheme;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.ui.components.BalfMenuBar;
import jamiebalfour.ui.components.BalfScrollbar;
import jamiebalfour.ui.components.BalfSearchBox;
import jamiebalfour.ui.components.BalfSplitPane;
import jamiebalfour.ui.components.BalfTitleBar;
import jamiebalfour.ui.dialogs.BalfAboutDialog;
import jamiebalfour.ui.dialogs.BalfPropertiesManager;
import jamiebalfour.ui.windows.BalfWindow;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.core.ZPEUpdater;
import jamiebalfour.zpe.daemon.ZPERuntimeDaemon;
import jamiebalfour.zpe.editor.AIAssistant;
import jamiebalfour.zpe.editor.CodeEditorView;
import jamiebalfour.zpe.editor.ConsoleOutputTextArea;
import jamiebalfour.zpe.editor.FunctionInformationWindow;
import jamiebalfour.zpe.editor.YASSUnfoldDialog;
import jamiebalfour.zpe.editor.ZPEChangelogDialog;
import jamiebalfour.zpe.editor.ZPEEditor;
import jamiebalfour.zpe.editor.ZPEEditorZENServerUI;
import jamiebalfour.zpe.editor.ZPEFunctionGenerator;
import jamiebalfour.zpe.editor.ZPEOnlineFileChooser;
import jamiebalfour.zpe.editor.ZPEOnlineLoginPanel;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.gui.ZPEConsole;
import jamiebalfour.zpe.gui.ZPEMacroInterface;
import jamiebalfour.zpe.interfaces.GenericEditor;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.zen.ZENServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class ZPEEditorMain
extends BalfWindow
implements GenericEditor {
    private static final long serialVersionUID = -8251993208396962207L;
    static FileNameExtensionFilter filter1 = new FileNameExtensionFilter("YASS files (*.yas)", "yas");
    static FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Text files (*.txt)", "txt");
    static FileNameExtensionFilter filter3 = new FileNameExtensionFilter("YASS executable files (*.yex)", "yex");
    private static JWindow tooltipWindow;
    private final Map<String, String> autoCompleteSuggestionTypes = new HashMap<String, String>();
    protected UndoHandler undoHandler = new UndoHandler();
    protected UndoManager undoManager = new UndoManager();
    ZPEEditorMain _this = this;
    JEditorPane contentEditor;
    Properties guiProperties;
    boolean propertiesChanged = false;
    String login_username = "";
    String login_password = "";
    String lastCloudFileOpened = "";
    String lastFileOpened = "";
    BalfMenuBar.MenuItem mainLoginMenuItem;
    BalfMenuBar.Menu recentOnlineFilesMenu;
    BalfMenuBar.Separator zpeOnlineSeparator;
    BalfMenuBar.MenuItem loadFromZPEOnlineMenuItem;
    BalfMenuBar.MenuItem saveToZPEOnlineMenuItem;
    BalfMenuBar.MenuItem loginToZPEOnlineMenuItem;
    BalfMenuBar.Menu fontFamilyMenu;
    BalfMenuBar.CheckBoxMenuItem darkModeMenuItem;
    ZPEConsole attachedConsole;
    BalfMenuBar.CheckBoxMenuItem useMacMenuBarMenuItem;
    BalfMenuBar.MenuItem unCommentLinesMenuItem;
    BalfMenuBar.MenuItem commentLinesMenuItem;
    BalfMenuBar.CheckBoxMenuItem useNativeRuntimeMenuItem;
    BalfScrollbar scrollPane;
    CodeEditorView mainSyntax;
    String fontsAllowed = "Aptos,Arial,Calibri,Comic Sans MS,Consolas,Courier New,Garamond,Lucida Sans,Menlo,Monospaced,Quicksand Light,Times New Roman";
    String defaultFontFamily;
    boolean dontUndo = true;
    boolean darkMode = false;
    boolean useMacMenuBar = true;
    boolean useSystemUI = false;
    ZPEString[] runtimeArgs = new ZPEString[0];
    BalfMenuBar.CheckBoxMenuItem fontSizeSmallMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeNormalMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeLargeMenuItem;
    BalfMenuBar.CheckBoxMenuItem fontSizeExtraLargeMenuItem;
    BalfMenuBar.CheckBoxMenuItem caseSensitiveCompileMenuItem;
    BalfMenuBar.CheckBoxMenuItem makeTextBoldMenuItem;
    BalfMenuBar.MenuItem chooseATheme;
    BalfMenuBar.Menu recentItemsMenu;
    BalfMenuBar.MenuItem stopCodeMenuItem;
    ImageIcon lighterLogo;
    ImageIcon lighterLogoFull;
    int permission_level = 3;
    ArrayList<String> recents = ZPEEditor.getRecentFiles("");
    String lastHoveredWord = "";
    Point lastPosition = new Point(0, 0);
    JWindow autoCompletePopup = new JWindow();
    private UndoAction undoAction = null;
    private RedoAction redoAction = null;
    private int currentAutoCompletePosition = 0;
    private List<String> autoCompleteSuggestionWords;
    private String previousAutoCompleteWord = "";
    private Timer autoCompleteDebounceTimer;
    private Color autoCompleteItemBackgroundColor = new Color(241, 241, 241, 255);
    private Timer showTooltipTimer;
    private Timer hideTooltipTimer;
    private final ArrayList<JFrame> currentWindows = new ArrayList();
    BalfWindow _frame;
    BalfMenuBar menuBar;
    private ZPERuntimeEnvironment runtime;
    static Color themeColour;
    static Color menuBarForeColor;
    boolean aboutAdded;
    boolean preferencesAdded;
    ConsoleOutputTextArea consoleOutputTextArea;
    BalfMenuBar.CheckBoxMenuItem useConsoleOutput;
    String themePath = ZPEInstance.getInstallPath() + "theme.blt";
    BalfSplitPane splitPane;
    JPanel bottomPanel;

    ZPEEditorMain(String name, String file, int arc, ImageIcon ico) throws IOException {
        super(name, arc, themeColour, Color.white, ico);
        this.setLayout(new BorderLayout());
        this.runtime = new ZPERuntimeEnvironment();
        this.disableMaximise(true);
        String path = ZPEInstance.getInstallPath() + "gui.properties";
        File f = new File(path);
        if (!f.exists()) {
            this.saveGUISettings(new Properties());
        }
        this.guiProperties = HelperFunctions.readProperties(path);
        if (this.guiProperties.containsKey("USE_MAC_MENUBAR")) {
            this.useMacMenuBar = this.guiProperties.get("USE_MAC_MENUBAR").toString().equals("true");
        }
        if (this.guiProperties.containsKey("USE_SYSTEM_UI")) {
            this.useSystemUI = this.guiProperties.get("USE_SYSTEM_UI").toString().equals("true");
        }
        this._frame = this;
        this.setTitle("ZPE Editor");
        if (!this.useSystemUI) {
            this.initialise();
            this.getTitleBar().setMaximiseButtonListener(e -> {});
            this.getTitleBar().setCloseListener(e -> {
                this.saveUp();
                System.exit(0);
            });
            this.setForeground(Color.WHITE);
            BalfTitleBar.rightPanelButton execButton = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/exec.png"))));
            execButton.setToolTipText("Execute the code");
            execButton.addActionListener(e -> {
                try {
                    this.executeCode();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
                }
            });
            this.getTitleBar().addRightButton(execButton);
            BalfTitleBar.rightPanelButton debug = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/debug.png"))));
            debug.setToolTipText("Debug the code");
            debug.addActionListener(e -> {
                try {
                    this.debugCode();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
                }
            });
            this.getTitleBar().addRightButton(debug);
            BalfTitleBar.rightPanelButton validate = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(ZPEEditorMain.class.getResource("/files/validate.png"))));
            validate.setToolTipText("Validate the code");
            validate.addActionListener(e -> {
                try {
                    if (ZPEKit.validateCode(this.contentEditor.getText())) {
                        JOptionPane.showMessageDialog(this._frame, "Code is valid", "Code analysis", 1, this.lighterLogo);
                    } else {
                        JOptionPane.showMessageDialog(this._frame, "Code is invalid", "Code analysis", 1, this.lighterLogo);
                    }
                }
                catch (CompileException ex) {
                    JOptionPane.showMessageDialog(this._frame, "Code is invalid", "Code analysis", 1, this.lighterLogo);
                }
            });
            this.getTitleBar().addRightButton(validate);
            String string = "<html><center>&copy; Jamie Balfour 2015 - 2025 version 1.13.9</center></html>";
            this.getFooter().setText(string);
        }
        this.lighterLogoFull = ZPEHelperFunctions.getLogo();
        Image newimg = this.lighterLogoFull.getImage().getScaledInstance(60, 60, 4);
        this.lighterLogo = new ImageIcon(newimg);
        this.mainSyntax = new CodeEditorView(ZPEKit.getKeywordSet(), "\"'", "$");
        StringBuilder supportedFontString = new StringBuilder();
        ArrayList<String> supportedFontsList = new ArrayList<String>();
        for (String s2 : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!this.fontsAllowed.contains(s2)) continue;
            supportedFontString.append(s2).append(",");
            supportedFontsList.add(s2);
        }
        this.defaultFontFamily = supportedFontString.toString().contains("Menlo") ? "Menlo" : "Courier New";
        if (ZPEEditorMain.getVersion() < 9) {
            System.err.println("You must be running Java 9 or higher to open the GUI.");
            return;
        }
        this.mainSyntax.setFontSize(18);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int confirmed = JOptionPane.showConfirmDialog(ZPEEditorMain.this._frame, "Are you sure you want to exit the program?", "Exit Program Message Box", 0);
                if (confirmed == 0) {
                    ZPEEditorMain.this.dispose();
                }
                if (ZPEEditorMain.this.consoleOutputTextArea.getProcess() != null) {
                    ZPEEditorMain.this.consoleOutputTextArea.getProcess().destroyForcibly();
                }
                ZPEEditorMain.this.saveUp();
                System.exit(0);
            }
        });
        try {
            this.setIconImage(this.lighterLogoFull.getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aboutAdded = false;
        this.preferencesAdded = false;
        if (HelperFunctions.isMac()) {
            try {
                macOS.addAboutDialog(this::showAbout);
                this.aboutAdded = true;
            }
            catch (Exception exception) {
                this.aboutAdded = false;
            }
            if (this.useMacMenuBar) {
                try {
                    macOS.addPreferencesDialog(this::showPropertyEditor);
                    this.preferencesAdded = true;
                }
                catch (Exception exception) {
                    this.preferencesAdded = false;
                }
            }
            try {
                if (Taskbar.isTaskbarSupported()) {
                    Toolkit.getDefaultToolkit();
                    Taskbar taskbar = Taskbar.getTaskbar();
                    Image image = this.lighterLogoFull.getImage();
                    taskbar.setIconImage(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._frame = this;
        this.setMinimumSize(new Dimension(400, 400));
        this.setDefaultCloseOperation(0);
        this.scrollPane = new BalfScrollbar();
        this.scrollPane.setLightColour(Color.white);
        this.scrollPane.setEnabled(false);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ZPEEditorMain.this.hideTooltip();
            }
        });
        JEditorPane jEditorPane = (JEditorPane)this.mainSyntax.getEditPane();
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        ((JEditorPane)this.mainSyntax.getEditPane()).setDoubleBuffered(true);
        jEditorPane.setFont(new Font(this.defaultFontFamily, 0, 18));
        this.scrollPane.setViewportView(jEditorPane);
        this.scrollPane.setRowHeaderView(this.mainSyntax.getEditor());
        this.consoleOutputTextArea = new ConsoleOutputTextArea("", Color.black);
        this.consoleOutputTextArea.addProcessFinishedListener(() -> {
            if (this.stopCodeMenuItem != null) {
                this.stopCodeMenuItem.setEnabled(false);
            }
        });
        BalfScrollbar scrollPane2 = new BalfScrollbar(this.consoleOutputTextArea);
        scrollPane2.setBorder(new EmptyBorder(0, 0, 0, 0));
        scrollPane2.setLightColour(Color.white);
        JPanel topPanel = new JPanel(new BorderLayout());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.setBackground(Color.black);
        JPanel outerSplit = new JPanel(new BorderLayout());
        outerSplit.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.splitPane = new BalfSplitPane(0);
        this.splitPane.setTopComponent(topPanel);
        this.splitPane.setBottomComponent(this.bottomPanel);
        this.splitPane.setContinuousLayout(false);
        this.splitPane.setResizeWeight(0.7);
        this.splitPane.setDividerSize(4);
        this.splitPane.setDividerLocation(0.7);
        this.bottomPanel.setMinimumSize(new Dimension(0, 200));
        this.splitPane.addPropertyChangeListener("dividerLocation", evt -> {
            int newLocation = (Integer)evt.getNewValue();
            this.setProperty("CONSOLE_DIVIDER_LOCATION", "" + newLocation);
            this.saveGUISettings(this.guiProperties);
        });
        outerSplit.add((Component)this.splitPane, "Center");
        this.add((Component)outerSplit, "Center");
        this.bottomPanel.setPreferredSize(new Dimension(0, 200));
        if (!this.useSystemUI) {
            this.splitPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(68, 68, 69)));
        }
        topPanel.add((Component)this.scrollPane, "Center");
        this.bottomPanel.add((Component)scrollPane2, "Center");
        scrollPane2.setLightColour(Color.black);
        this.contentEditor = jEditorPane;
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if (this.useSystemUI) {
            themeColour = Color.WHITE;
            menuBarForeColor = Color.BLACK;
        }
        this.addMenuItems(supportedFontsList);
        BalfSearchBox searchBox = this.menuBar.addSearchBox();
        searchBox.setSearchText("Search for a function...");
        if (this.useSystemUI) {
            searchBox.addBorder(1, Color.BLACK);
        }
        for (String s3 : ZPEKit.getAllCommands()) {
            BalfSearchBox.SearchSuggestion suggestion = new BalfSearchBox.SearchSuggestion(s3 + " " + ZPEKit.getFunctionManualEntry(s3), s3);
            searchBox.addSuggestion(suggestion);
        }
        searchBox.addSearchSuggestionListener(s -> {
            try {
                searchBox.setText("");
                searchBox.setFocusable(false);
                searchBox.setFocusable(true);
                FunctionInformationWindow f1 = new FunctionInformationWindow((Frame)this._frame, s, ZPEKit.getFunctionManualHeader(s).replace("{", "<span style='font-weight:bold;color:#0af;'>").replace("}", "</span>"), ZPEKit.getFunctionManualEntry(s));
                f1.setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        String defaultFile = "/files/editor_program.txt";
        if (this.guiProperties.containsKey("LOGIN_USERNAME") || this.guiProperties.containsKey("LOGIN_PASSCODE")) {
            this.login_username = this.guiProperties.getProperty("LOGIN_USERNAME");
            this.login_password = this.guiProperties.getProperty("LOGIN_PASSCODE");
        }
        if (this.guiProperties.containsKey("DEFAULT_FILE")) {
            try {
                this.contentEditor.setText(FileHelperFunctions.readFileAsString(this.guiProperties.getProperty("DEFAULT_FILE"), "utf-8"));
            }
            catch (IOException e1) {
                try {
                    this.contentEditor.setText(HelperFunctions.getResource(defaultFile));
                }
                catch (Exception exception) {}
            }
        } else {
            try {
                this.setTextProperly(HelperFunctions.getResource(defaultFile));
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (this.guiProperties.containsKey("USE_BOLD_TEXT") && this.guiProperties.get("USE_BOLD_TEXT").equals("true")) {
            this.mainSyntax.makeBold(true);
            this.makeTextBoldMenuItem.setSelected(true);
        }
        if (this.guiProperties.containsKey("DARK_MODE") && !this.useSystemUI) {
            if (this.guiProperties.get("DARK_MODE").equals("true")) {
                this.switchOnDarkMode();
            } else if (this.guiProperties.get("DARK_MODE").equals("system") && HelperFunctions.isDarkMode()) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        }
        this.readStandardProperties(this.guiProperties);
        if (this.guiProperties.containsKey("FONT_SIZE")) {
            this.changeFontSize(HelperFunctions.stringToInteger(this.guiProperties.get("FONT_SIZE").toString()));
        }
        if (this.guiProperties.containsKey("FONT_FAMILY")) {
            this.changeFontFamily(this.guiProperties.get("FONT_FAMILY").toString());
        }
        if (this.guiProperties.containsKey("USE_CONSOLE_OUTPUT")) {
            if (this.guiProperties.get("USE_CONSOLE_OUTPUT").equals("true")) {
                this.bottomPanel.setVisible(false);
                this.useConsoleOutput.setSelected(true);
                this.splitPane.setDividerSize(0);
            } else {
                this.splitPane.setDividerSize(4);
                if (this.guiProperties.containsKey("CONSOLE_DIVIDER_LOCATION")) {
                    this.splitPane.setDividerLocation(HelperFunctions.stringToInteger(this.guiProperties.get("CONSOLE_DIVIDER_LOCATION").toString()));
                }
            }
        } else {
            this.splitPane.setDividerSize(4);
            if (this.guiProperties.containsKey("CONSOLE_DIVIDER_LOCATION")) {
                this.splitPane.setDividerLocation(HelperFunctions.stringToInteger(this.guiProperties.get("CONSOLE_DIVIDER_LOCATION").toString()));
            }
        }
        this._this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                for (JFrame j : ZPEEditorMain.this.currentWindows) {
                    if (!j.isVisible() || j.isAlwaysOnTop()) continue;
                    j.setAlwaysOnTop(true);
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                for (JFrame j : ZPEEditorMain.this.currentWindows) {
                    if (j.isFocused()) continue;
                    j.setAlwaysOnTop(false);
                }
            }
        });
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            this.setJMenuBar(this.menuBar.toJMenuBar());
        } else {
            this.setMenu(this.menuBar);
            if (!this.useSystemUI) {
                this.getMenu().setPaneColour(new Color(96, 12, 128));
            } else {
                this.getMenu().setPaneColour(new Color(179, 179, 179));
            }
        }
        this.setVisible(true);
        if (new File(this.themePath).exists()) {
            try {
                this.setTheme(UITheme.loadFromFile(this.themePath));
                this.chooseATheme.setText("Remove current Theme");
            }
            catch (ClassNotFoundException e4) {
                throw new RuntimeException(e4);
            }
        }
        if (file != null) {
            try {
                File fil = new File(file);
                this.setTextProperly(FileHelperFunctions.readFileAsString(fil.getAbsolutePath()));
                this._frame.setTitle("ZPE Editor");
                this.setTitleBarText(fil.getName());
            }
            catch (IOException e5) {
                JOptionPane.showMessageDialog(this._frame, "The file could not be opened.", "Error", 0);
            }
        }
        this.autoCompleteDebounceTimer = new Timer();
        this.addKeyBindings();
    }

    private void addMenuItems(ArrayList<String> supportedFontsList) {
        Object helpName;
        int modifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.menuBar = new BalfMenuBar(themeColour, menuBarForeColor);
        BalfMenuBar.Menu fileMenu = new BalfMenuBar.Menu("File", this.menuBar);
        fileMenu.setMnemonic('F');
        BalfMenuBar.MenuItem newMenuItem = new BalfMenuBar.MenuItem("New", this.menuBar);
        newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem saveMenuItem = new BalfMenuBar.MenuItem("Save", this.menuBar);
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem saveAsMenuItem = new BalfMenuBar.MenuItem("Save As", this.menuBar);
        BalfMenuBar.MenuItem openMenuItem = new BalfMenuBar.MenuItem("Open", this.menuBar);
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, HelperFunctions.isMac() ? 256 : 128));
        this.recentItemsMenu = new BalfMenuBar.Menu("Recent files", this.menuBar);
        BalfMenuBar.MenuItem printMenuItem = new BalfMenuBar.MenuItem("Print", this.menuBar);
        printMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem editZPEProperties = new BalfMenuBar.MenuItem("Edit ZPE Properties", this.menuBar);
        boolean addedExit = false;
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            try {
                macOS.addQuitHandler(this::saveUp);
                addedExit = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BalfMenuBar.MenuItem exitMenuItem = new BalfMenuBar.MenuItem("Exit", this.menuBar);
        BalfMenuBar.Menu editMenu = new BalfMenuBar.Menu("Edit", this.menuBar);
        editMenu.setMnemonic('E');
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.contentEditor.getInputMap().put(KeyStroke.getKeyStroke(90, modifierKey), "Undo");
        this.contentEditor.getActionMap().put("Undo", this.undoAction);
        this.contentEditor.getInputMap().put(KeyStroke.getKeyStroke(89, modifierKey), "Redo");
        this.contentEditor.getActionMap().put("Redo", this.redoAction);
        BalfMenuBar.MenuItem undoMenuItem = new BalfMenuBar.MenuItem(this.undoAction, this.menuBar);
        BalfMenuBar.MenuItem redoMenuItem = new BalfMenuBar.MenuItem(this.redoAction, this.menuBar);
        BalfMenuBar.MenuItem cutMenuItem = new BalfMenuBar.MenuItem("Cut", this.menuBar);
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem copyMenuItem = new BalfMenuBar.MenuItem("Copy", this.menuBar);
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem pasteMenuItem = new BalfMenuBar.MenuItem("Paste", this.menuBar);
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem deleteMenuItem = new BalfMenuBar.MenuItem("Delete", this.menuBar);
        BalfMenuBar.MenuItem selectAllMenuItem = new BalfMenuBar.MenuItem("Select All", this.menuBar);
        selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.MenuItem addBreakPointMenuItem = new BalfMenuBar.MenuItem("Add breakpoint", this.menuBar);
        addBreakPointMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, HelperFunctions.isMac() ? 256 : 128));
        this.commentLinesMenuItem = new BalfMenuBar.MenuItem("Comment selected lines", this.menuBar);
        this.commentLinesMenuItem.setAccelerator(KeyStroke.getKeyStroke(47, HelperFunctions.isMac() ? 256 : 128));
        this.unCommentLinesMenuItem = new BalfMenuBar.MenuItem("Uncomment selected lines", this.menuBar);
        this.unCommentLinesMenuItem.setAccelerator(KeyStroke.getKeyStroke(92, HelperFunctions.isMac() ? 256 : 128));
        BalfMenuBar.Menu viewMenu = new BalfMenuBar.Menu("View", this.menuBar);
        viewMenu.setMnemonic('V');
        this.useConsoleOutput = new BalfMenuBar.CheckBoxMenuItem("Use Separate Console Window", this.menuBar);
        BalfMenuBar.Menu fontSizeMenu = new BalfMenuBar.Menu("Font size", this.menuBar);
        this.fontSizeSmallMenuItem = new BalfMenuBar.CheckBoxMenuItem("Small", this.menuBar);
        this.fontSizeNormalMenuItem = new BalfMenuBar.CheckBoxMenuItem("Normal", this.menuBar);
        this.fontSizeNormalMenuItem.setSelected(true);
        this.fontSizeLargeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Large", this.menuBar);
        this.fontSizeExtraLargeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Extra Large", this.menuBar);
        this.fontFamilyMenu = new BalfMenuBar.Menu("Font family", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem defaultFont = new BalfMenuBar.CheckBoxMenuItem("Default font", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem instrumentSansFont = new BalfMenuBar.CheckBoxMenuItem("Instrument Sans", this.menuBar);
        this.makeTextBoldMenuItem = new BalfMenuBar.CheckBoxMenuItem("Make text bold", this.menuBar);
        this.darkModeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Dark Mode", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem useSystemUIMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use System UI", this.menuBar);
        if (this.useSystemUI) {
            useSystemUIMenuItem.setSelected(true);
        }
        this.chooseATheme = new BalfMenuBar.MenuItem("Choose a Theme", this.menuBar);
        if (HelperFunctions.isMac()) {
            this.useMacMenuBarMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use Mac Menubar", this.menuBar);
            if (this.useMacMenuBar) {
                this.useMacMenuBarMenuItem.setSelected(true);
            }
        }
        BalfMenuBar.Menu toolsMenu = new BalfMenuBar.Menu("Tools", this.menuBar);
        toolsMenu.setMnemonic('T');
        BalfMenuBar.MenuItem openMacroEditorMenuItem = new BalfMenuBar.MenuItem("Open ZPE Macro Interface Editor", this.menuBar);
        BalfMenuBar.MenuItem setDefaultFileMenuItem = new BalfMenuBar.MenuItem("Set default file", this.menuBar);
        BalfMenuBar.MenuItem setRuntimeArgumentsMenuItem = new BalfMenuBar.MenuItem("Set runtime arguments", this.menuBar);
        BalfMenuBar.MenuItem buildWithAIAssistantMenuItem = null;
        if (!(ZPEInstance.getChatGPTKey() == null || ZPEInstance.getChatGPTURL() == null || ZPEInstance.getChatGPTModel() == null || ZPEInstance.getChatGPTKey().isEmpty() || ZPEInstance.getChatGPTURL().isEmpty() || ZPEInstance.getChatGPTModel().isEmpty())) {
            buildWithAIAssistantMenuItem = new BalfMenuBar.MenuItem("Build with AI Assistant", this.menuBar);
        }
        BalfMenuBar.MenuItem startZENServerMenuItem = new BalfMenuBar.MenuItem("Start ZEN Server", this.menuBar);
        BalfMenuBar.Menu currentMenu = null;
        String lastCategory = "";
        BalfMenuBar.Menu functionsMenu = new BalfMenuBar.Menu("Functions", this.menuBar);
        functionsMenu.setMnemonic('F');
        HashMap<String, CallSite> allFuncNames = new HashMap<String, CallSite>();
        for (String s : ZPEKit.getAllCommands()) {
            if (!lastCategory.equals(ZPEKit.getFunctionCategory(s))) {
                if (currentMenu != null) {
                    functionsMenu.add(currentMenu);
                }
                lastCategory = ZPEKit.getFunctionCategory(s);
                currentMenu = new BalfMenuBar.Menu(this.menuBar);
                currentMenu.setText(lastCategory);
            }
            allFuncNames.put(s, (CallSite)((Object)(ZPEKit.getFunctionCategory(s).toLowerCase().replace(" ", "_").replace("/", "") + "/" + s)));
            BalfMenuBar.MenuItem commandMenuItem = new BalfMenuBar.MenuItem(this.menuBar);
            commandMenuItem.setText(s);
            String replacement = ZPEKit.getFunctionManualHeader(s);
            String group = lastCategory;
            helpName = s;
            commandMenuItem.addActionListener(arg_0 -> this.lambda$addMenuItems$8((String)helpName, group, replacement, arg_0));
            assert (currentMenu != null);
            currentMenu.add(commandMenuItem);
        }
        BalfMenuBar.Menu scriptMenu = new BalfMenuBar.Menu("Script", this.menuBar);
        scriptMenu.setMnemonic('S');
        this.caseSensitiveCompileMenuItem = new BalfMenuBar.CheckBoxMenuItem("Case sensitive compile", this.menuBar);
        this.caseSensitiveCompileMenuItem.setSelected(true);
        this.useNativeRuntimeMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use native runtime (when available)", this.menuBar);
        if (this.guiProperties.containsKey("USE_NATIVE_RUNTIME") && this.guiProperties.get("USE_NATIVE_RUNTIME").equals("true")) {
            this.useNativeRuntimeMenuItem.setSelected(true);
        }
        BalfMenuBar.MenuItem runCodeMenuItem = new BalfMenuBar.MenuItem("Run code", this.menuBar);
        runCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        BalfMenuBar.MenuItem runCodeWithDebuggingMenuItem = new BalfMenuBar.MenuItem("Debug code", this.menuBar);
        runCodeWithDebuggingMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, HelperFunctions.isMac() ? 256 : 128));
        this.stopCodeMenuItem = new BalfMenuBar.MenuItem("Stop code execution", this.menuBar);
        this.stopCodeMenuItem.setEnabled(false);
        this.stopCodeMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        BalfMenuBar.MenuItem compileCodeMenuItem = new BalfMenuBar.MenuItem("Compile code", this.menuBar);
        BalfMenuBar.Menu transpileCodeMenuItem = new BalfMenuBar.Menu("Transpile code", this.menuBar);
        if (ZPEKit.listTranspilerNames().isEmpty()) {
            transpileCodeMenuItem.setVisible(false);
        } else {
            helpName = ZPEKit.listTranspilerNames().iterator();
            while (helpName.hasNext()) {
                String transpiler;
                String lang = transpiler = (String)helpName.next();
                String transpilerName = ZPEKit.getTranspilerByName(transpiler).transpilerName();
                BalfMenuBar.MenuItem mntmTranspileCodeToMenuItem = new BalfMenuBar.MenuItem("To " + lang + " (" + transpilerName + ")", this.menuBar);
                transpileCodeMenuItem.add(mntmTranspileCodeToMenuItem);
            }
        }
        BalfMenuBar.MenuItem analyseCodeMenuItem = new BalfMenuBar.MenuItem("Analyse code", this.menuBar);
        BalfMenuBar.MenuItem toByteCodeFileMenuItem = new BalfMenuBar.MenuItem("Compile to byte codes", this.menuBar);
        BalfMenuBar.MenuItem createOutlineMenuItem = new BalfMenuBar.MenuItem("Create code outline", this.menuBar);
        BalfMenuBar.MenuItem unfoldCodeMenuItem = new BalfMenuBar.MenuItem("Unfold code", this.menuBar);
        BalfMenuBar.Menu zpeOnlineMenu = new BalfMenuBar.Menu("ZPE Online", this.menuBar);
        zpeOnlineMenu.setMnemonic('O');
        this.mainLoginMenuItem = this.loginToZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Login to ZPE Online", this.menuBar);
        BalfMenuBar.MenuItem registerForZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Register for ZPE Online", this.menuBar);
        BalfMenuBar.MenuItem visitZPEOnlineWebsiteMenuItem = new BalfMenuBar.MenuItem("Visit ZPE Online website", this.menuBar);
        BalfMenuBar.MenuItem viewPublicUploadsMenuItem = new BalfMenuBar.MenuItem("View public uploads", this.menuBar);
        BalfMenuBar.MenuItem loadFromPublicZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Load from public repository", this.menuBar);
        this.zpeOnlineSeparator = new BalfMenuBar.Separator(this.menuBar);
        this.zpeOnlineSeparator.setVisible(false);
        this.recentOnlineFilesMenu = new BalfMenuBar.Menu("Recent online files", this.menuBar);
        this.recentOnlineFilesMenu.setVisible(false);
        this.loadFromZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Load from ZPE Online", this.menuBar);
        this.loadFromZPEOnlineMenuItem.setVisible(false);
        this.saveToZPEOnlineMenuItem = new BalfMenuBar.MenuItem("Save to ZPE Online", this.menuBar);
        this.saveToZPEOnlineMenuItem.setVisible(false);
        BalfMenuBar.Menu windowMenu = new BalfMenuBar.Menu("Window", this.menuBar);
        BalfMenuBar.Menu dock = new BalfMenuBar.Menu("Dock", this.menuBar);
        BalfMenuBar.MenuItem dockToTheTop = new BalfMenuBar.MenuItem("Dock to the Top", this.menuBar);
        dockToTheTop.setAccelerator(KeyStroke.getKeyStroke(38, modifierKey));
        BalfMenuBar.MenuItem dockToTheLeft = new BalfMenuBar.MenuItem("Dock to the Left", this.menuBar);
        dockToTheLeft.setAccelerator(KeyStroke.getKeyStroke(37, modifierKey));
        BalfMenuBar.MenuItem dockToTheRight = new BalfMenuBar.MenuItem("Dock to the Right", this.menuBar);
        dockToTheRight.setAccelerator(KeyStroke.getKeyStroke(39, modifierKey));
        BalfMenuBar.MenuItem filterMenu = new BalfMenuBar.MenuItem("Filter", this.menuBar);
        BalfMenuBar.MenuItem dockToTheBottom = new BalfMenuBar.MenuItem("Dock to the Bottom", this.menuBar);
        dockToTheBottom.setAccelerator(KeyStroke.getKeyStroke(40, modifierKey));
        BalfMenuBar.MenuItem fullScreenMenuItem = new BalfMenuBar.MenuItem("Full screen", this.menuBar);
        BalfMenuBar.Menu helpMenu = new BalfMenuBar.Menu("Help", this.menuBar);
        helpMenu.setMnemonic('H');
        BalfMenuBar.MenuItem mntmAboutMenuItem = null;
        if (!this.aboutAdded) {
            mntmAboutMenuItem = new BalfMenuBar.MenuItem("About ZPE", this.menuBar);
        }
        BalfMenuBar.MenuItem learnZPEYASSMenuItem = new BalfMenuBar.MenuItem("Learn ZPE/YASS", this.menuBar);
        BalfMenuBar.MenuItem openZPEFolderMenuItem = new BalfMenuBar.MenuItem("Open ZPE folder", this.menuBar);
        BalfMenuBar.MenuItem goToZPETrackerMenuItem = new BalfMenuBar.MenuItem("Go to ZPE Tracker", this.menuBar);
        BalfMenuBar.MenuItem contactJamieBalfourMenuItem = new BalfMenuBar.MenuItem("Contact Jamie Balfour", this.menuBar);
        BalfMenuBar.MenuItem provideFeedbackMenuItem = new BalfMenuBar.MenuItem("Provide Feedback", this.menuBar);
        BalfMenuBar.MenuItem checkForUpdateMenuItem = new BalfMenuBar.MenuItem("Check For Updates", this.menuBar);
        BalfMenuBar.MenuItem readChangelogMenuItem = new BalfMenuBar.MenuItem("Read changelog", this.menuBar);
        BalfMenuBar.MenuItem visitOfficialDocumentationMenuItem = new BalfMenuBar.MenuItem("Visit the official documentation", this.menuBar);
        ((JEditorPane)this.mainSyntax.getEditPane()).getDocument().addUndoableEditListener(this.undoHandler);
        this.menuBar.add(fileMenu);
        fileMenu.add(newMenuItem);
        fileMenu.add(saveMenuItem);
        fileMenu.add(saveAsMenuItem);
        fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        fileMenu.add(openMenuItem);
        this.updateRecentFiles();
        if (!this.recents.isEmpty()) {
            fileMenu.add(this.recentItemsMenu);
        }
        fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        fileMenu.add(printMenuItem);
        if (!this.preferencesAdded) {
            fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
            fileMenu.add(editZPEProperties);
        }
        if (!addedExit && !HelperFunctions.isMac()) {
            fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
            fileMenu.add(exitMenuItem);
        }
        this.menuBar.add(editMenu);
        editMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                if (ZPEEditorMain.this.contentEditor.getSelectedText() != null && !ZPEEditorMain.this.contentEditor.getSelectedText().isEmpty()) {
                    ZPEEditorMain.this.commentLinesMenuItem.setEnabled(true);
                    ZPEEditorMain.this.unCommentLinesMenuItem.setEnabled(ZPEEditorMain.this.contentEditor.getSelectedText().startsWith("//"));
                } else {
                    ZPEEditorMain.this.commentLinesMenuItem.setEnabled(false);
                    ZPEEditorMain.this.unCommentLinesMenuItem.setEnabled(false);
                }
            }
        });
        editMenu.add(undoMenuItem);
        editMenu.add(redoMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(cutMenuItem);
        editMenu.add(copyMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.add(deleteMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(selectAllMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(addBreakPointMenuItem);
        editMenu.add(this.commentLinesMenuItem);
        editMenu.add(this.unCommentLinesMenuItem);
        this.menuBar.add(viewMenu);
        viewMenu.add(this.useConsoleOutput);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        viewMenu.add(fontSizeMenu);
        fontSizeMenu.add(this.fontSizeSmallMenuItem);
        fontSizeMenu.add(this.fontSizeNormalMenuItem);
        fontSizeMenu.add(this.fontSizeLargeMenuItem);
        fontSizeMenu.add(this.fontSizeExtraLargeMenuItem);
        viewMenu.add(this.fontFamilyMenu);
        this.fontFamilyMenu.add(defaultFont);
        this.fontFamilyMenu.add(new BalfMenuBar.Separator(this.menuBar));
        for (String s : supportedFontsList) {
            this.createFontDropdown(s);
        }
        this.fontFamilyMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fontFamilyMenu.add(instrumentSansFont);
        viewMenu.add(this.makeTextBoldMenuItem);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        if (!this.useSystemUI) {
            viewMenu.add(this.darkModeMenuItem);
        }
        viewMenu.add(useSystemUIMenuItem);
        if (!this.useSystemUI) {
            viewMenu.add(this.chooseATheme);
        }
        if (HelperFunctions.isMac()) {
            viewMenu.add(this.useMacMenuBarMenuItem);
        }
        viewMenu.add(fullScreenMenuItem);
        this.menuBar.add(toolsMenu);
        toolsMenu.add(openMacroEditorMenuItem);
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        toolsMenu.add(setDefaultFileMenuItem);
        toolsMenu.add(setRuntimeArgumentsMenuItem);
        if (buildWithAIAssistantMenuItem != null) {
            toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
            toolsMenu.add(buildWithAIAssistantMenuItem);
        }
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        toolsMenu.add(startZENServerMenuItem);
        this.menuBar.add(functionsMenu);
        this.menuBar.add(scriptMenu);
        scriptMenu.add(this.caseSensitiveCompileMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        if (new File(ZPEHelperFunctions.getBinaryPath()).exists()) {
            scriptMenu.add(this.useNativeRuntimeMenuItem);
            scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        }
        scriptMenu.add(runCodeMenuItem);
        scriptMenu.add(runCodeWithDebuggingMenuItem);
        scriptMenu.add(this.stopCodeMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(compileCodeMenuItem);
        scriptMenu.add(transpileCodeMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(analyseCodeMenuItem);
        scriptMenu.add(toByteCodeFileMenuItem);
        scriptMenu.add(createOutlineMenuItem);
        scriptMenu.add(new BalfMenuBar.Separator(this.menuBar));
        scriptMenu.add(unfoldCodeMenuItem);
        this.menuBar.add(zpeOnlineMenu);
        zpeOnlineMenu.add(this.loginToZPEOnlineMenuItem);
        zpeOnlineMenu.add(registerForZPEOnlineMenuItem);
        zpeOnlineMenu.add(new BalfMenuBar.Separator(this.menuBar));
        zpeOnlineMenu.add(visitZPEOnlineWebsiteMenuItem);
        zpeOnlineMenu.add(viewPublicUploadsMenuItem);
        zpeOnlineMenu.add(new BalfMenuBar.Separator(this.menuBar));
        zpeOnlineMenu.add(loadFromPublicZPEOnlineMenuItem);
        zpeOnlineMenu.add(this.zpeOnlineSeparator);
        zpeOnlineMenu.add(this.recentOnlineFilesMenu);
        zpeOnlineMenu.add(this.loadFromZPEOnlineMenuItem);
        zpeOnlineMenu.add(this.saveToZPEOnlineMenuItem);
        this.menuBar.add(windowMenu);
        windowMenu.add(dock);
        dock.add(dockToTheTop);
        dock.add(dockToTheLeft);
        dock.add(dockToTheRight);
        dock.add(dockToTheBottom);
        windowMenu.add(fullScreenMenuItem);
        this.menuBar.add(helpMenu);
        if (mntmAboutMenuItem != null) {
            helpMenu.add(mntmAboutMenuItem);
            helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        }
        helpMenu.add(learnZPEYASSMenuItem);
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        helpMenu.add(openZPEFolderMenuItem);
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        helpMenu.add(goToZPETrackerMenuItem);
        helpMenu.add(contactJamieBalfourMenuItem);
        helpMenu.add(provideFeedbackMenuItem);
        helpMenu.add(checkForUpdateMenuItem);
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        helpMenu.add(readChangelogMenuItem);
        helpMenu.add(visitOfficialDocumentationMenuItem);
        newMenuItem.addActionListener(e -> {
            this.setTitleBarText("Untitled");
            this.clearUndoRedoManagers();
            this.setTextProperly("");
            this.lastCloudFileOpened = "";
        });
        saveMenuItem.addActionListener(e -> {
            if (this.lastFileOpened.isEmpty()) {
                this.saveAsDialog();
            } else {
                try {
                    FileHelperFunctions.writeFile(this.lastFileOpened, this.contentEditor.getText(), false);
                }
                catch (IOException ex) {
                    ZPECore.log(ex.getMessage());
                }
            }
        });
        saveAsMenuItem.addActionListener(e -> this.saveAsDialog());
        openMenuItem.addActionListener(e -> this.open());
        printMenuItem.addActionListener(e -> {
            try {
                this.contentEditor.print();
            }
            catch (PrinterException e1) {
                JOptionPane.showMessageDialog(this._frame, "An error was encountered whilst trying to print.", "Error", 0);
            }
        });
        editZPEProperties.addActionListener(e -> this.showPropertyEditor());
        exitMenuItem.addActionListener(e -> {
            this.saveUp();
            System.exit(0);
        });
        cutMenuItem.addActionListener(e -> this.contentEditor.cut());
        this.contentEditor.getInputMap().put(KeyStroke.getKeyStroke(88, modifierKey), "Cut");
        this.contentEditor.getActionMap().put("Cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEEditorMain.this.contentEditor.cut();
            }
        });
        copyMenuItem.addActionListener(e -> this.contentEditor.copy());
        this.contentEditor.getInputMap().put(KeyStroke.getKeyStroke(67, modifierKey), "Copy");
        this.contentEditor.getActionMap().put("Copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEEditorMain.this.contentEditor.copy();
            }
        });
        pasteMenuItem.addActionListener(e -> this.contentEditor.paste());
        this.contentEditor.getInputMap().put(KeyStroke.getKeyStroke(86, modifierKey), "Paste");
        this.contentEditor.getActionMap().put("Paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZPEEditorMain.this.contentEditor.paste();
            }
        });
        deleteMenuItem.addActionListener(e -> {
            int start = this.contentEditor.getSelectionStart();
            int end = this.contentEditor.getSelectionEnd();
            String current = this.contentEditor.getText();
            String newText = current.substring(0, start) + current.substring(end);
            this.contentEditor.setText(newText);
        });
        selectAllMenuItem.addActionListener(e -> this.contentEditor.selectAll());
        addBreakPointMenuItem.addActionListener(e -> {
            int start = this.contentEditor.getSelectionStart();
            int end = this.contentEditor.getSelectionEnd();
            String content = this.contentEditor.getText();
            this.setTextProperly(content.substring(0, start) + "#breakpoint#" + content.substring(end));
            this.contentEditor.setCaretPosition(start + "#breakpoint#".length());
        });
        this.commentLinesMenuItem.addActionListener(e -> {
            int start;
            int end = this.contentEditor.getSelectionEnd();
            String content = this.contentEditor.getText();
            StringBuilder out = new StringBuilder();
            for (start = this.contentEditor.getSelectionStart(); start > 0 && content.charAt(start) != '\n'; --start) {
            }
            if (start == 0) {
                out.append("//");
            }
            for (int i = start; i < end; ++i) {
                out.append(content.charAt(i));
                if (content.charAt(i) != '\n') continue;
                out.append("//");
            }
            this.setTextProperly(content.substring(0, start) + String.valueOf(out) + content.substring(end));
        });
        this.unCommentLinesMenuItem.addActionListener(e -> {
            int start;
            int end = this.contentEditor.getSelectionEnd();
            String content = this.contentEditor.getText();
            String code = content.substring(start, end);
            for (start = this.contentEditor.getSelectionStart(); start > 0 && content.charAt(start) != '\n'; --start) {
            }
            StringBuilder out = new StringBuilder();
            Scanner s = new Scanner(code);
            while (s.hasNextLine()) {
                String line = s.nextLine();
                while (line.startsWith("//")) {
                    line = line.substring(2);
                }
                out.append(line);
                if (!s.hasNextLine()) continue;
                out.append(System.lineSeparator());
            }
            s.close();
            this.setTextProperly(content.substring(0, start) + System.lineSeparator() + String.valueOf(out) + content.substring(end));
        });
        this.useConsoleOutput.addActionListener(e -> {
            this.bottomPanel.setVisible(!this.useConsoleOutput.isSelected());
            if (this.useConsoleOutput.isSelected()) {
                this.splitPane.setDividerSize(0);
            } else {
                this.splitPane.setDividerSize(4);
                if (this.splitPane.getDividerLocation() > this.splitPane.getHeight() - 200) {
                    this.bottomPanel.setSize(this.bottomPanel.getSize().width, 200);
                    this.splitPane.setDividerLocation(this.splitPane.getHeight() - this.bottomPanel.getSize().height);
                }
            }
            this.setProperty("USE_CONSOLE_OUTPUT", "" + this.useConsoleOutput.isSelected());
            this.saveGUISettings(this.guiProperties);
        });
        this.fontSizeSmallMenuItem.addActionListener(e -> {
            this.changeFontSize(-1);
            this.setProperty("FONT_SIZE", "-1");
            this.saveGUISettings(this.guiProperties);
        });
        this.fontSizeNormalMenuItem.addActionListener(e -> {
            this.changeFontSize(0);
            this.setProperty("FONT_SIZE", "0");
            this.saveGUISettings(this.guiProperties);
        });
        this.fontSizeLargeMenuItem.addActionListener(e -> {
            this.changeFontSize(1);
            this.setProperty("FONT_SIZE", "1");
            this.saveGUISettings(this.guiProperties);
        });
        this.fontSizeExtraLargeMenuItem.addActionListener(e -> {
            this.changeFontSize(2);
            this.setProperty("FONT_SIZE", "2");
            this.saveGUISettings(this.guiProperties);
        });
        defaultFont.addActionListener(e -> {
            this.changeFontFamily(this.defaultFontFamily);
            this.setProperty("FONT_FAMILY", this.defaultFontFamily);
            this.saveGUISettings(this.guiProperties);
        });
        instrumentSansFont.addActionListener(e -> {
            this.changeFontFamily("Instrument Sans");
            this.setProperty("FONT_FAMILY", "Instrument Sans");
            this.saveGUISettings(this.guiProperties);
        });
        this.makeTextBoldMenuItem.addActionListener(e -> {
            this.mainSyntax.makeBold(this.makeTextBoldMenuItem.isSelected());
            this.setProperty("USE_BOLD_TEXT", Boolean.toString(this.makeTextBoldMenuItem.isSelected()));
            this.resetScroll();
            this.saveGUISettings(this.guiProperties);
            this.updateEditor();
        });
        this.darkModeMenuItem.addActionListener(e -> {
            if (!this.darkMode) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
            this.setProperty("DARK_MODE", Boolean.toString(this.darkMode));
            this.saveGUISettings(this.guiProperties);
            this.updateEditor();
        });
        useSystemUIMenuItem.addActionListener(e -> {
            this.setProperty("USE_SYSTEM_UI", "" + useSystemUIMenuItem.isSelected());
            this.saveGUISettings(this.guiProperties);
            JOptionPane.showMessageDialog(this, "This will happen on the next start.", "System UI", 2);
        });
        this.chooseATheme.addActionListener(e -> {
            if (BalfLafManager.getInstance().getTheme() != null) {
                BalfLafManager.getInstance().setTheme(null);
                File fx = new File(this.themePath);
                if (fx.exists()) {
                    fx.delete();
                }
                this.chooseATheme.setText("Choose a Theme");
            } else {
                UITheme theme = this.openThemeUsingDialog();
                if (theme != null) {
                    this.chooseATheme.setText("Remove current Theme");
                    try {
                        theme.saveToFile(this.themePath);
                    }
                    catch (IOException iOException) {}
                } else {
                    JOptionPane.showMessageDialog(this, "Failed to load.");
                }
            }
        });
        if (HelperFunctions.isMac()) {
            boolean macMenuBarEnabled = this.useMacMenuBar;
            this.useMacMenuBarMenuItem.addActionListener(e -> {
                this.setProperty("USE_MAC_MENUBAR", Boolean.toString(this.useMacMenuBarMenuItem.isSelected()));
                this.useMacMenuBarMenuItem.setEnabled(false);
                this.saveGUISettings(this.guiProperties);
                JOptionPane.showMessageDialog(this._frame, "This will happen on the next start.", "macOS Menubar", 2);
            });
        }
        openMacroEditorMenuItem.addActionListener(e -> {
            ZPERuntimeEnvironment z = new ZPERuntimeEnvironment();
            ZPEMacroInterface i = new ZPEMacroInterface(z, new ZPEObject[]{new EditorObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), (JEditorPane)this.mainSyntax.getEditPane())}, null);
            i.setVisible(true);
            i.setLocationRelativeTo(this._this);
            this.currentWindows.add(i);
        });
        setDefaultFileMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter1);
            fc.addChoosableFileFilter(filter2);
            int returnVal = fc.showOpenDialog(this._frame.getContentPane());
            if (returnVal == 0) {
                File selectedFile = fc.getSelectedFile();
                if (selectedFile.exists()) {
                    this.setProperty("DEFAULT_FILE", selectedFile.getAbsolutePath());
                    this.saveGUISettings(this.guiProperties);
                } else {
                    JOptionPane.showMessageDialog(this._frame, "The file could not be opened.", "Error", 0);
                }
            }
        });
        setRuntimeArgumentsMenuItem.addActionListener(e -> {
            StringBuilder joined = new StringBuilder();
            for (ZPEString s : this.runtimeArgs) {
                joined.append(" ").append(((Object)s).toString());
            }
            String args2 = JOptionPane.showInputDialog(this._frame, "Please insert your runtime arguments, separated by spaces.", joined.toString());
            if (args2 != null) {
                String[] splitArgs = args2.trim().split(" ");
                ZPEString[] new_args = new ZPEString[splitArgs.length];
                for (int i = 0; i < splitArgs.length; ++i) {
                    new_args[i] = new ZPEString(splitArgs[i]);
                }
                this.runtimeArgs = new_args;
            }
        });
        if (buildWithAIAssistantMenuItem != null) {
            buildWithAIAssistantMenuItem.addActionListener(e -> {
                AIAssistant ai = new AIAssistant(this.contentEditor);
                ai.setVisible(true);
                ai.setLocationRelativeTo(this._this);
                this.currentWindows.add(ai);
            });
        }
        startZENServerMenuItem.addActionListener(e -> {
            ZPEEditorZENServerUI z = new ZPEEditorZENServerUI(this._frame);
            Map<String, String> output = z.display();
            int port = HelperFunctions.stringToInteger(output.get("port"));
            int permission = HelperFunctions.stringToInteger(output.get("permission"));
            String password = output.get("password");
            Object additional = "";
            try {
                additional = " on " + String.valueOf(InetAddress.getLocalHost());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this._frame, "Opening ZENServer on port " + port + (String)additional, "ZENServer", 1);
            this._this.setVisible(false);
            SwingUtilities.invokeLater(() -> {
                class BackgroundServer
                implements Runnable {
                    int port;
                    int permission;
                    String password;
                    Thread thread;

                    BackgroundServer() {
                    }

                    @Override
                    public void run() {
                        this.thread = new Thread((Runnable)this, "ZENServer");
                        this.thread.setDaemon(true);
                        this.thread.start();
                    }

                    public void start() {
                        ZENServer s = new ZENServer();
                        s.Start(this.port, this.permission, this.password, null);
                    }
                }
                BackgroundServer s = new BackgroundServer();
                s.port = port;
                s.permission = permission;
                s.password = password;
                s.start();
            });
        });
        this.useNativeRuntimeMenuItem.addActionListener(e -> {
            this.setProperty("USE_NATIVE_RUNTIME", "" + this.useNativeRuntimeMenuItem.isSelected());
            this.saveGUISettings(this.guiProperties);
        });
        runCodeMenuItem.addActionListener(e -> {
            try {
                this.executeCode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        runCodeWithDebuggingMenuItem.addActionListener(e -> {
            try {
                this.debugCode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Unable to compile or run code.", "Error", 0);
            }
        });
        this.stopCodeMenuItem.addActionListener(e -> {
            if (this.attachedConsole != null && this.attachedConsole.getProcess() != null) {
                this.attachedConsole.destroyCurrentProcess();
            } else if (this.consoleOutputTextArea != null && this.consoleOutputTextArea.getProcess() != null) {
                this.consoleOutputTextArea.destroyCurrentProcess();
            }
            this.stopCodeMenuItem.setEnabled(false);
        });
        compileCodeMenuItem.addActionListener(e -> {
            String name1 = JOptionPane.showInputDialog(this._frame, (Object)"Please insert the name of the compiled application.");
            String extension = "";
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter3);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this._frame.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file12 = fc.getSelectedFile();
            if (!file12.getAbsolutePath().endsWith(ZPEEditorMain.getSaveExtension(fc.getFileFilter()))) {
                extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            }
            try {
                ZPEKit.compile(this.contentEditor.getText(), String.valueOf(file12) + "." + extension, name1, "", !this.caseSensitiveCompileMenuItem.isSelected(), false, null, null);
                JOptionPane.showMessageDialog(this._frame, "YASS compile success. The file has been successfully compiled to " + String.valueOf(file12) + ".", "YASS compiler", 2);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._frame, "YASS compile failure. " + ex.getMessage() + ".", "YASS compiler", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this._frame, "YASS compile failure. The error was -1.", "YASS compiler", 0);
            }
        });
        Iterator<String> iterator2 = ZPEKit.listTranspilerNames().iterator();
        while (iterator2.hasNext()) {
            String transpiler;
            String lang = transpiler = iterator2.next();
            for (Component c : transpileCodeMenuItem.getMenuComponents()) {
                if (!(c instanceof BalfMenuBar.MenuItem) || !((BalfMenuBar.MenuItem)c).getText().contains("To " + lang)) continue;
                ((BalfMenuBar.MenuItem)c).addActionListener(e -> {
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new FileNameExtensionFilter(lang + " files (*." + ZPEKit.getTranspilerByName(lang).getFileExtension() + ")", "txt"));
                    fc.setAcceptAllFileFilterUsed(false);
                    int returnVal = fc.showSaveDialog(this._frame.getContentPane());
                    if (returnVal != 0) {
                        return;
                    }
                    try {
                        Object fpath = fc.getSelectedFile().getPath();
                        if (!((String)fpath).endsWith("." + ZPEKit.getTranspilerByName(lang).getFileExtension())) {
                            fpath = (String)fpath + "." + ZPEKit.getTranspilerByName(lang).getFileExtension();
                        }
                        FileHelperFunctions.writeFile((String)fpath, ZPEKit.convertCode(this.contentEditor.getText(), "", ZPEKit.getTranspilerByName(transpiler)), false);
                        JOptionPane.showMessageDialog(this._frame, "Code transpiled to " + lang + " successfully.\nSaved at: " + (String)fpath, "Successful transpile", 1);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this._frame, "Transpilation failed: " + ex.getMessage(), "Error", 0);
                    }
                });
            }
        }
        analyseCodeMenuItem.addActionListener(e -> {
            try {
                boolean valid = ZPEKit.validateCode(this.contentEditor.getText());
                JOptionPane.showMessageDialog(this._frame, valid ? "Code is valid" : "Code is invalid", "Code analysis", 1, this.lighterLogo);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._frame, "Code is invalid", "Code analysis", 1, this.lighterLogo);
            }
        });
        toByteCodeFileMenuItem.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.addChoosableFileFilter(filter2);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showSaveDialog(this._frame.getContentPane());
            if (returnVal != 0) {
                return;
            }
            File file1 = fc.getSelectedFile();
            String extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                StringBuilder text = new StringBuilder();
                for (byte s : ZPEKit.parseToBytes(this.contentEditor.getText())) {
                    text.append(s).append(" ");
                }
                FileHelperFunctions.writeFile(file1.getAbsolutePath() + "." + extension, text.toString(), false);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this._frame, "The file could not be saved.", "Error", 0);
            }
        });
        createOutlineMenuItem.addActionListener(e -> {
            try {
                StringBuilder output = new StringBuilder();
                for (String s : ZPEKit.generateCodeOutline(this.contentEditor.getText())) {
                    output.append(s).append(System.lineSeparator());
                }
                JOptionPane.showMessageDialog(this._frame, "Functions of this program:\n\n" + String.valueOf(output), "Create code outline", 1, this.lighterLogo);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._frame, "Code is invalid and an outline cannot be made", "Create code outline", 0, this.lighterLogo);
            }
        });
        unfoldCodeMenuItem.addActionListener(e -> {
            try {
                String result = ZPEKit.unfold(this.contentEditor.getText(), false);
                JOptionPane op = new JOptionPane(new YASSUnfoldDialog(result).getContentPane(), -1, -1, this.lighterLogo, new String[0]);
                JDialog dlg = op.createDialog(this._this, "YASS Unfold code explainer");
                dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                dlg.setVisible(true);
            }
            catch (CompileException ex) {
                JOptionPane.showMessageDialog(this._frame, "There was an error when using YASS Unfold.", "YASS Unfold", 1, this.lighterLogo);
            }
        });
        this.loginToZPEOnlineMenuItem.addActionListener(e -> {
            if (this.loginToZPEOnlineMenuItem.getText().equals("Login to ZPE Online")) {
                this.login();
            } else {
                this.login_username = "";
                this.login_password = "";
                this.zpeOnlineSeparator.setVisible(false);
                this.recentOnlineFilesMenu.setVisible(false);
                this.recentOnlineFilesMenu.removeAll();
                this.loadFromZPEOnlineMenuItem.setVisible(false);
                this.saveToZPEOnlineMenuItem.setVisible(false);
                this.loginToZPEOnlineMenuItem.setText("Login to ZPE Online");
                JOptionPane.showMessageDialog(this._frame.getContentPane(), "You have been logged out successfully.", "Logout successful", 1);
            }
        });
        registerForZPEOnlineMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/register/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not connect to ZPE Online", "Failure", 0);
            }
        });
        visitZPEOnlineWebsiteMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not open ZPE Online", "Failure", 0);
            }
        });
        viewPublicUploadsMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/online/code/");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not connect to ZPE Online", "Failure", 0);
            }
        });
        loadFromPublicZPEOnlineMenuItem.addActionListener(e -> this.loadFromPublicCloud());
        this.loadFromZPEOnlineMenuItem.addActionListener(e -> this.loadFromUsersCloud());
        this.saveToZPEOnlineMenuItem.addActionListener(e -> this.saveToTheCloud());
        dockToTheTop.addActionListener(e -> this._frame.dockTop());
        dockToTheLeft.addActionListener(e -> this._frame.dockLeft());
        dockToTheRight.addActionListener(e -> this._frame.dockRight());
        dockToTheBottom.addActionListener(e -> this._frame.dockBottom());
        fullScreenMenuItem.addActionListener(e -> this.goFullScreen());
        if (mntmAboutMenuItem != null) {
            mntmAboutMenuItem.addActionListener(e -> this.showAbout());
        }
        learnZPEYASSMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/courses/software/yass/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not open jamiebalfour.scot", "Failure", 0);
            }
        });
        openZPEFolderMenuItem.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(ZPEKit.getInstallPath()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        goToZPETrackerMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/tracker/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        contactJamieBalfourMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/contact/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        provideFeedbackMenuItem.addActionListener(e -> {
            String message = JOptionPane.showInputDialog(this._frame, (Object)"Please insert your feedback below.");
            try {
                if (ZPEHelperFunctions.sendFeedback(message, null)) {
                    JOptionPane.showMessageDialog(this._frame, "Feedback sent successfully.", "Success", 1);
                } else {
                    JOptionPane.showMessageDialog(this._frame, "Feedback could not be sent at this time.", "Error", 0);
                }
            }
            catch (ZPERuntimeException ex) {
                JOptionPane.showMessageDialog(this._frame, "Feedback could not be sent at this time.", "Error", 0);
            }
        });
        checkForUpdateMenuItem.addActionListener(e -> {
            if (ZPEUpdater.getInstance().isUpdateAvailable()) {
                JOptionPane.showMessageDialog(this._frame, "An update is available.", "Update", -1);
            } else {
                JOptionPane.showMessageDialog(this._frame, "No updates are available right now.", "Update", -1);
            }
        });
        readChangelogMenuItem.addActionListener(e -> {
            String changelog;
            try {
                changelog = HelperFunctions.getResource("/files/zpe_changelog.txt");
            }
            catch (Exception ex) {
                changelog = "";
            }
            JOptionPane op = new JOptionPane(new ZPEChangelogDialog(changelog, "ZPE changelog").getContentPane(), -1, -1, this.lighterLogo, new String[0]);
            JDialog dlg = op.createDialog(this._this, "ZPE changelog");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
        });
        visitOfficialDocumentationMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/documentation/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not open jamiebalfour.scot", "Failure", 0);
            }
        });
    }

    static String getSaveExtension(FileFilter f) {
        if (f.equals(filter1)) {
            return "yas";
        }
        if (f.equals(filter2)) {
            return "txt";
        }
        if (f.equals(filter3)) {
            return "yex";
        }
        return null;
    }

    private static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    private static String getWordAtCaret(JEditorPane editorPane, int pos) throws BadLocationException {
        Document doc = editorPane.getDocument();
        int start = Utilities.getWordStart(editorPane, pos);
        int end = Utilities.getWordEnd(editorPane, pos);
        return doc.getText(start, end - start);
    }

    private void hideTooltip() {
        if (tooltipWindow != null) {
            tooltipWindow.setVisible(false);
            this.lastHoveredWord = "";
            this.lastPosition = new Point(0, 0);
        }
    }

    void createFontDropdown(String s) {
        BalfMenuBar.CheckBoxMenuItem i = new BalfMenuBar.CheckBoxMenuItem(s, this.menuBar);
        String thisFont = s;
        i.addActionListener(e -> {
            this.changeFontFamily(thisFont);
            this.setProperty("FONT_FAMILY", thisFont);
            this.saveGUISettings(this.guiProperties);
        });
        this.fontFamilyMenu.add(i);
    }

    private void showAbout() {
        Object msg = "";
        msg = (String)msg + "ZPE version 1.13.9." + ZPECore.getBuildVersion() + " [Gillygate]\n";
        msg = (String)msg + "Built on: " + ZPECore.getBuildDate() + " at " + ZPECore.getBuildTime() + "\n";
        msg = (String)msg + "Copyright Jamie B Balfour 2011 - 2025";
        msg = (String)msg + "\n\n";
        msg = (String)msg + "Powered by Zenith Parsing Engine version 1.5";
        msg = (String)msg + "\n\nFor more information visit\nhttps://www.jamiebalfour.scot/projects/zpe/";
        BalfButton btnVisitWebsiteButton = new BalfButton("More", 15);
        btnVisitWebsiteButton.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/zpe/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the ZPE website", "Failure", 0);
            }
        });
        JOptionPane op = new JOptionPane(new BalfAboutDialog("ZPE & YASS", (String)msg, btnVisitWebsiteButton).getContentPane(), -1, -1, this.lighterLogo, new String[0]);
        JDialog dlg = op.createDialog(this._frame, "About ZPE");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    private void showPropertyEditor() {
        if (ZPEInstance.isLockedDown()) {
            JOptionPane.showMessageDialog(this, "You may not change properties as ZPE is locked down.", "Properties", 2);
            return;
        }
        try {
            JOptionPane op = new JOptionPane(new BalfPropertiesManager(HelperFunctions.readProperties(ZPEInstance.getConfigurationPath()), new File(ZPEInstance.getConfigurationPath())).getContentPane(), -1, -1, this.lighterLogo, new String[0]);
            JDialog dlg = op.createDialog(this._this, "Manage ZPE Properties");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setSize(800, 500);
            dlg.setLocationRelativeTo(this._this);
            dlg.setVisible(true);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this._frame, "An error was encountered whilst trying to open the ZPE properties file.", "Error", 0);
        }
    }

    private void addRecentsFromCloud(ZPEList recents) {
        if (!recents.isEmpty()) {
            this.zpeOnlineSeparator.setVisible(true);
            this.recentOnlineFilesMenu.setVisible(true);
            this.recentOnlineFilesMenu.removeAll();
            for (ZPEType s : recents) {
                BalfMenuBar.MenuItem recentItemMenuItem = new BalfMenuBar.MenuItem(this.menuBar);
                ZPEMap file = (ZPEMap)s;
                String filename = file.get(new ZPEString("name")).toString();
                recentItemMenuItem.setText(filename);
                this.recentOnlineFilesMenu.add(recentItemMenuItem);
                String id = file.get(new ZPEString("id")).toString();
                recentItemMenuItem.addActionListener(e -> {
                    this.lastCloudFileOpened = filename;
                    this.setTitleBarText(new File(filename).getName().split("\\.")[0]);
                    this.lastFileOpened = "";
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("username", this.login_username);
                    arguments.put("password", this.login_password);
                    arguments.put("id", id);
                    ZenithJSONParser p = new ZenithJSONParser();
                    try {
                        String s1 = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=file&version=10", arguments);
                        ZPEMap results = (ZPEMap)p.jsonDecode(s1, false);
                        ZPEString name = (ZPEString)results.get(new ZPEString("name"));
                        this.setTitleBarText(name.toString());
                        this.setTitle("ZPE Editor");
                        String code = URLDecoder.decode(results.get(new ZPEString("string")).toString(), "UTF-8");
                        code = code.replace("\\n", System.lineSeparator());
                        this.clearUndoRedoManagers();
                        this.setTextProperly(code);
                    }
                    catch (Exception exc) {
                        ZPECore.log(exc.getMessage());
                    }
                });
            }
        }
    }

    public boolean login() {
        boolean autoLogin = false;
        if (this.login_username.isEmpty() && this.login_password.isEmpty()) {
            ZPEOnlineLoginPanel z = new ZPEOnlineLoginPanel(this._frame);
            Map<String, String> output = z.display();
            this.login_username = output.get("username");
            this.login_password = output.get("password");
        } else {
            autoLogin = true;
        }
        try {
            ZPEMap login = this.goLogin();
            if (login != null) {
                if (login.get(new ZPEString("result")).toString().equals("1")) {
                    int res;
                    JOptionPane.showMessageDialog(this._frame.getContentPane(), "You have been logged in successfully.", "Login successful", 1);
                    if (!autoLogin && (res = JOptionPane.showConfirmDialog(this._frame.getContentPane(), "Do you want to save your login details?", "Save log in details?", 0, -1)) == 0) {
                        this.setProperty("LOGIN_USERNAME", this.login_username);
                        this.setProperty("LOGIN_PASSCODE", login.get(new ZPEString("login_token")).toString());
                        this.saveGUISettings(this.guiProperties);
                    }
                    this.loadFromZPEOnlineMenuItem.setVisible(true);
                    this.saveToZPEOnlineMenuItem.setVisible(true);
                    this.loginToZPEOnlineMenuItem.setText("Logout of ZPE Online");
                    this.addRecentsFromCloud((ZPEList)login.get(new ZPEString("list")));
                    return true;
                }
                this.loadFromZPEOnlineMenuItem.setVisible(true);
                this.saveToZPEOnlineMenuItem.setVisible(true);
                JOptionPane.showMessageDialog(this._frame.getContentPane(), "You could not be logged in.", "Login unsuccessful", 0);
                return false;
            }
            this.loadFromZPEOnlineMenuItem.setVisible(true);
            this.saveToZPEOnlineMenuItem.setVisible(true);
            JOptionPane.showMessageDialog(this._frame.getContentPane(), "You could not be logged in.", "Login unsuccessful", 0);
            return false;
        }
        catch (Exception ex1) {
            ZPECore.log(ex1.getMessage());
            this.loadFromZPEOnlineMenuItem.setVisible(true);
            this.saveToZPEOnlineMenuItem.setVisible(true);
            JOptionPane.showMessageDialog(this._frame, "Cannot login.", "Error with ZPE Online", 0);
            this.login_username = "";
            this.login_password = "";
            return false;
        }
    }

    public void saveUp() {
        this.setProperty("HEIGHT", "" + this._frame.getNormalFrameSize().getHeight());
        this.setProperty("WIDTH", "" + this._frame.getNormalFrameSize().getWidth());
        this.setProperty("XPOS", "" + this._frame.getNormalFrameLocation().getX());
        this.setProperty("YPOS", "" + this._frame.getNormalFrameLocation().getY());
        this.setProperty("USE_CONSOLE_OUTPUT", "" + this.useConsoleOutput.isSelected());
        if (this.isMaximised()) {
            this.setProperty("MAXIMISED", "true");
        } else {
            this.setProperty("MAXIMISED", "false");
        }
        if (this.attachedConsole != null && this.attachedConsole.getProcess() != null) {
            this.attachedConsole.destroyCurrentProcess();
        }
        this.saveGUISettings(this.guiProperties);
    }

    public ZPEMap goLogin() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("username", this.login_username);
        arguments.put("password", this.login_password);
        String s = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=login&version=10", arguments);
        ZPEType o = new ZenithJSONParser().jsonDecode(s, false);
        ZPEMap a = (ZPEMap)o;
        if (HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) != 1) {
            this.login_username = "";
            this.login_password = "";
        } else {
            this.mainLoginMenuItem.setText("Logout");
        }
        return a;
    }

    @Override
    public void saveGUISettings(Properties props) {
        if (this.propertiesChanged) {
            String path = ZPEInstance.getInstallPath() + "gui.properties";
            try {
                FileOutputStream output = new FileOutputStream(path);
                props.store(output, "This is a list of properties for the ZPE GUI editor and can be modified manually.");
            }
            catch (Exception e) {
                ZPECore.log("Error saving GUI settings. " + e.getMessage());
            }
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.guiProperties.setProperty(name, value);
        this.propertiesChanged = true;
    }

    private void open() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        fc.addChoosableFileFilter(filter2);
        int returnVal = fc.showOpenDialog(this.getContentPane());
        this.contentEditor.getMouseWheelListeners();
        if (returnVal == 0) {
            this.lastCloudFileOpened = "";
            File file = fc.getSelectedFile();
            try {
                this.clearUndoRedoManagers();
                this.setTextProperly(FileHelperFunctions.readFileAsString(file.getAbsolutePath()));
                SwingUtilities.invokeLater(() -> {
                    this.contentEditor.setCaretPosition(0);
                    this.scrollPane.getVerticalScrollBar().setValue(0);
                });
                this.recents.add(file.getAbsolutePath());
                this.setTitleBarText(file.getName().split("\\.")[0]);
                try {
                    ZPEEditor.storeRecentFiles(this.recents, "");
                    this.recents = ZPEEditor.getRecentFiles("");
                    this.updateRecentFiles();
                }
                catch (IOException ex) {
                    ZPECore.log(ex.getMessage());
                }
                this.setTitleBarText(file.getName());
                this._frame.setTitle("ZPE Editor");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._frame, "The file could not be opened.", "Error", 0);
            }
        }
    }

    private void saveAsDialog() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(filter1);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this.getContentPane());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String extension = ZPEEditorMain.getSaveExtension(fc.getFileFilter());
            try {
                FileHelperFunctions.writeFile(file.getAbsolutePath() + "." + extension, this.contentEditor.getText(), false);
                this.setTitleBarText(file.getName().split("\\.")[0]);
                this.lastFileOpened = file.getAbsolutePath();
                this.lastCloudFileOpened = "";
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._frame, "The file could not be saved.", "Error", 0);
            }
        }
    }

    void setTextProperly(String text) {
        this.dontUndo = true;
        this.contentEditor.setText(text);
        this.dontUndo = false;
    }

    private void updateEditor() {
        this.contentEditor = (JEditorPane)this.mainSyntax.getEditPane();
        this.setTextProperly(this.contentEditor.getText());
    }

    private void clearUndoRedoManagers() {
        this.undoManager.die();
        this.undoAction.update();
        this.redoAction.update();
    }

    private void changeFontFamily(String fam) {
        this.mainSyntax.setFontName(fam);
        if (fam.equals("Instrument Sans")) {
            if (this.mainSyntax != null) {
                this.mainSyntax.updateFont(new Font(fam, this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
                this.mainSyntax.repaint();
            } else {
                this.contentEditor.setFont(new Font(fam, this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
            }
        } else {
            Font f = BalfLafManager.getBalfLafFont().deriveFont(this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize());
            if (this.mainSyntax != null) {
                this.mainSyntax.updateFont(f);
            } else {
                this.contentEditor.setFont(f);
            }
        }
        if (fam.equals("Monospaced")) {
            fam = "Default font";
        }
        for (int i = 0; i < this.fontFamilyMenu.getItemCount(); ++i) {
            BalfMenuBar.MenuItem current = (BalfMenuBar.MenuItem)this.fontFamilyMenu.getItem(i);
            if (current == null || !(current instanceof BalfMenuBar.CheckBoxMenuItem)) continue;
            current.setSelected(current.getText().equals(fam));
        }
        this.resetScroll();
    }

    private void resetScroll() {
        int caretPosition = this.contentEditor.getCaretPosition();
        int scrollPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.contentEditor.setText(this.contentEditor.getText());
        SwingUtilities.invokeLater(() -> {
            this.contentEditor.requestFocus();
            this.contentEditor.setCaretPosition(caretPosition);
            this.scrollPane.getVerticalScrollBar().setValue(scrollPosition);
        });
    }

    private void switchOnDarkMode() {
        this.darkModeMenuItem.setSelected(true);
        Color dark = Color.decode("#282D37");
        this.splitPane.setBackground(dark);
        this.scrollPane.setDarkColour(dark);
        this.setPanelBackground(dark);
        this.contentEditor.setBackground(dark);
        this.contentEditor.setForeground(Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.white);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(198, 120, 221));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(255, 85, 114));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Function, new Color(97, 175, 239));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(102, 217, 239));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(229, 192, 123));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Bool, new Color(189, 147, 249));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Special, new Color(0, 200, 0));
        this.contentEditor.setCaretColor(Color.white);
        this.autoCompleteItemBackgroundColor = new Color(30, 39, 75, 255);
        this.resetScroll();
        BalfLafManager.getInstance().toggleDarkMode(true);
        this.darkMode = true;
    }

    private void switchOffDarkMode() {
        this.darkModeMenuItem.setSelected(false);
        Color light = new Color(255, 255, 255);
        this.scrollPane.setLightColour(Color.white);
        this.setPanelBackground(light);
        this.contentEditor.setBackground(light);
        this.contentEditor.setForeground(Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Normal, Color.black);
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Quote, new Color(0, 128, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Keyword, new Color(135, 16, 148));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Function, new Color(97, 172, 231));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Var, new Color(255, 138, 0));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Type, new Color(2, 87, 172));
        this.mainSyntax.setAttributeColor(CodeEditorView.ATTR_TYPE.Special, new Color(255, 0, 0));
        this.contentEditor.setCaretColor(Color.black);
        this.autoCompleteItemBackgroundColor = new Color(241, 241, 241, 255);
        this.resetScroll();
        BalfLafManager.getInstance().toggleDarkMode(false);
        this.darkMode = false;
    }

    private void changeFontSize(int newSize) {
        this.fontSizeSmallMenuItem.setSelected(false);
        this.fontSizeNormalMenuItem.setSelected(false);
        this.fontSizeLargeMenuItem.setSelected(false);
        this.fontSizeExtraLargeMenuItem.setSelected(false);
        if (newSize == -1) {
            this.fontSizeSmallMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(14);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 14));
        }
        if (newSize == 0) {
            this.fontSizeNormalMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(17);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 17));
        }
        if (newSize == 1) {
            this.fontSizeLargeMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(28);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 28));
        }
        if (newSize == 2) {
            this.fontSizeExtraLargeMenuItem.setSelected(true);
            this.mainSyntax.setFontSize(35);
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getName(), this.contentEditor.getFont().getStyle(), 35));
        }
        if (this.mainSyntax != null) {
            this.mainSyntax.updateFont(new Font(this.contentEditor.getFont().getFontName(), this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
            this.mainSyntax.repaint();
        } else {
            this.contentEditor.setFont(new Font(this.contentEditor.getFont().getFontName(), this.contentEditor.getFont().getStyle(), this.contentEditor.getFont().getSize()));
        }
        this.resetScroll();
        this.contentEditor.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                try {
                    if (ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                        return;
                    }
                    int pos = ZPEEditorMain.this.contentEditor.viewToModel2D(e.getPoint());
                    String hoveredWord = ZPEEditorMain.getWordAtCaret(ZPEEditorMain.this.contentEditor, pos);
                    if (ZPEKit.internalFunctionExists(hoveredWord)) {
                        ZPEEditorMain.this.hideTooltipTimer.cancel();
                        int endOfWordPos = Utilities.getWordEnd(ZPEEditorMain.this.contentEditor, pos);
                        Rectangle2D wordEndBounds = ZPEEditorMain.this.contentEditor.modelToView2D(endOfWordPos);
                        if (wordEndBounds != null) {
                            Point tooltipPosition = new Point((int)wordEndBounds.getX(), (int)wordEndBounds.getY() + (int)wordEndBounds.getHeight());
                            if (!hoveredWord.equals(ZPEEditorMain.this.lastHoveredWord) || tooltipPosition.getX() != ZPEEditorMain.this.lastPosition.getX() || tooltipPosition.getY() != ZPEEditorMain.this.lastPosition.getY()) {
                                ZPEEditorMain.this.lastHoveredWord = hoveredWord;
                                ZPEEditorMain.this.lastPosition = tooltipPosition;
                                ZPEEditorMain.this.startShowTooltipTimer(tooltipPosition, hoveredWord);
                            }
                        }
                    } else {
                        ZPEEditorMain.this.startHideTooltipTimer();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private ArrayList<JLabel> getPopupItems() {
        ArrayList<JLabel> output = new ArrayList<JLabel>();
        JScrollPane pane = (JScrollPane)this.autoCompletePopup.getContentPane().getComponent(0);
        JViewport v = (JViewport)pane.getComponent(0);
        JPanel p = (JPanel)v.getComponent(0);
        for (Component c : p.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            output.add((JLabel)c);
        }
        return output;
    }

    private JLabel getPopupItem(int index) {
        return this.getPopupItems().get(index);
    }

    private void resetItem() {
        this.getPopupItem(this.currentAutoCompletePosition).setBackground(this.autoCompleteItemBackgroundColor);
        if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("keyword")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_KEYWORD));
        } else if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("type")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_TYPE));
        } else if (this.autoCompleteSuggestionTypes.get(this.autoCompleteSuggestionWords.get(this.currentAutoCompletePosition)).equals("function")) {
            this.getPopupItem(this.currentAutoCompletePosition).setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION));
        }
    }

    private void addKeyBindings() {
        this.contentEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ZPEEditorMain.this.hideTooltip();
                if (e.getKeyCode() == 27) {
                    ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                    ZPEEditorMain.this.enableArrows();
                } else if (e.getKeyCode() == 8 || e.getKeyChar() == ' ' || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                    ZPEEditorMain.this.enableArrows();
                } else if ((e.getKeyCode() == 9 || e.getKeyCode() == 10) && ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                    e.consume();
                    ZPEEditorMain.this.insertAutocomplete(ZPEEditorMain.this.autoCompleteSuggestionWords.get(ZPEEditorMain.this.currentAutoCompletePosition));
                } else if (e.getKeyCode() == 40) {
                    if (ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                        e.consume();
                        ArrayList<JLabel> p = ZPEEditorMain.this.getPopupItems();
                        if (!p.isEmpty() && ZPEEditorMain.this.currentAutoCompletePosition < p.size() - 1) {
                            ZPEEditorMain.this.resetItem();
                            ZPEEditorMain.this.getPopupItems().get(++ZPEEditorMain.this.currentAutoCompletePosition).setBackground(SystemColor.controlHighlight);
                            ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).setForeground(Color.WHITE);
                            ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).requestFocus();
                        }
                    }
                } else if (e.getKeyCode() == 38) {
                    if (ZPEEditorMain.this.autoCompletePopup.isVisible()) {
                        e.consume();
                        ArrayList<JLabel> p = ZPEEditorMain.this.getPopupItems();
                        if (!p.isEmpty() && ZPEEditorMain.this.currentAutoCompletePosition > 0) {
                            ZPEEditorMain.this.resetItem();
                            ZPEEditorMain.this.getPopupItems().get(--ZPEEditorMain.this.currentAutoCompletePosition).setBackground(SystemColor.controlHighlight);
                            ZPEEditorMain.this.getPopupItems().get(ZPEEditorMain.this.currentAutoCompletePosition).setForeground(Color.WHITE);
                        }
                    }
                } else if (e.getKeyCode() != 16 && e.getKeyCode() != 157 && e.getKeyCode() != 18 && e.getKeyCode() != 17) {
                    ZPEEditorMain.this.showAutocompletePopup();
                    ZPEEditorMain.this.autoCompleteDebounceTimer.cancel();
                    ZPEEditorMain.this.autoCompleteDebounceTimer = new Timer();
                    ZPEEditorMain.this.autoCompleteDebounceTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ZPEEditorMain.this.hideTooltip();
                                }
                            });
                        }
                    }, 100L);
                }
            }
        });
    }

    private void enableArrows() {
        InputMap inputMap = this.contentEditor.getInputMap(0);
        ActionMap actionMap = this.contentEditor.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("TAB"), null);
        inputMap.put(KeyStroke.getKeyStroke("UP"), null);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), null);
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), null);
        actionMap.put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private void disableArrows() {
        InputMap inputMap = this.contentEditor.getInputMap(0);
        ActionMap actionMap = this.contentEditor.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("TAB"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("UP"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "doNothing");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "doNothing");
        actionMap.put("doNothing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    private String getCurrentWord() {
        try {
            int start;
            int caretPosition = this.contentEditor.getCaretPosition();
            for (start = caretPosition - 1; start >= 0 && (Character.isLetterOrDigit(this.contentEditor.getText(start, 1).charAt(0)) || this.contentEditor.getText(start, 1).charAt(0) == '_' || this.contentEditor.getText(start, 1).charAt(0) == '#' || this.contentEditor.getText(start, 1).charAt(0) == '$'); --start) {
            }
            int next = 0;
            while (caretPosition + next < this.contentEditor.getText().length() && this.contentEditor.getText().charAt(caretPosition + next) != ' ' && this.contentEditor.getText().charAt(caretPosition + next) != '\t' && this.contentEditor.getText().charAt(caretPosition + next) != '\n') {
                ++next;
            }
            return this.contentEditor.getText(start + 1, next + caretPosition - (start + 1));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private String getCurrentLine() {
        try {
            int start;
            int caretPosition = this.contentEditor.getCaretPosition();
            for (start = caretPosition - 1; start >= 0 && this.contentEditor.getText(start, 1).charAt(0) != '\n'; --start) {
            }
            int next = 0;
            while (caretPosition + next < this.contentEditor.getText().length() && this.contentEditor.getText().charAt(caretPosition + next) != '\n') {
                ++next;
            }
            return this.contentEditor.getText(start + 1, next + caretPosition - (start + 1));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private List<String> getAutocompleteSuggestions(String currentWord) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (String keyword : ZPEKit.getKeywords()) {
            if (!keyword.startsWith(currentWord)) continue;
            suggestions.add(keyword);
            this.autoCompleteSuggestionTypes.put(keyword, "keyword");
        }
        for (String keyword : ZPEKit.getTypeKeywords()) {
            if (!keyword.startsWith(currentWord)) continue;
            suggestions.add(keyword);
            this.autoCompleteSuggestionTypes.put(keyword, "type");
        }
        for (String function : ZPEKit.getBuiltInFunctions()) {
            if (!function.startsWith(currentWord)) continue;
            suggestions.add(function);
            this.autoCompleteSuggestionTypes.put(function, "function");
        }
        for (String s : ZPEInstance.getBuiltInStructuresNames()) {
            suggestions.add(s);
            this.autoCompleteSuggestionTypes.put(s, "type");
        }
        return suggestions;
    }

    private boolean isWithinQuotes() {
        try {
            int caretPosition = this.contentEditor.getCaretPosition();
            String text = this.contentEditor.getText(0, caretPosition);
            int doubleQuotesCount = 0;
            int singleQuotesCount = 0;
            for (int i = 0; i < caretPosition; ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    ++doubleQuotesCount;
                    continue;
                }
                if (c != '\'') continue;
                ++singleQuotesCount;
            }
            boolean insideDoubleQuotes = doubleQuotesCount % 2 != 0;
            boolean insideSingleQuotes = singleQuotesCount % 2 != 0;
            return insideDoubleQuotes || insideSingleQuotes;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void showAutocompletePopup() {
        this.currentAutoCompletePosition = 0;
        String currentWord = this.getCurrentWord();
        String currentLine = this.getCurrentLine();
        if (currentWord.equals(this.previousAutoCompleteWord)) {
            return;
        }
        this.previousAutoCompleteWord = currentWord;
        this.autoCompletePopup.getContentPane().removeAll();
        this.autoCompletePopup.getContentPane().setLayout(new BorderLayout());
        this.autoCompletePopup.setFocusableWindowState(false);
        this.autoCompletePopup.setBackground(new Color(255, 255, 255, 0));
        if (currentWord.isEmpty() || currentWord.startsWith("$") || this.isWithinQuotes() || currentLine.trim().startsWith("//")) {
            this.autoCompletePopup.setVisible(false);
            return;
        }
        this.autoCompleteSuggestionWords = this.getAutocompleteSuggestions(currentWord);
        this.autoCompletePopup.setFocusable(false);
        if (!this.autoCompleteSuggestionWords.isEmpty()) {
            HashMap<String, Boolean> added = new HashMap<String, Boolean>();
            this.autoCompletePopup.setLayout(new BorderLayout());
            JPanel suggestionPanel = new JPanel();
            suggestionPanel.setLayout(new GridBagLayout());
            suggestionPanel.setBorder(null);
            suggestionPanel.setOpaque(true);
            suggestionPanel.setBackground(this.autoCompleteItemBackgroundColor);
            suggestionPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("EEK");
                }
            });
            JScrollPane outerScroll = new JScrollPane(suggestionPanel);
            outerScroll.setBorder(null);
            outerScroll.setOpaque(true);
            outerScroll.getVerticalScrollBar().setOpaque(false);
            outerScroll.getVerticalScrollBar().setSize(new Dimension(0, 0));
            this.autoCompletePopup.getContentPane().add((Component)outerScroll, "North");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            for (final String suggestion : this.autoCompleteSuggestionWords) {
                final JLabel suggestionLabel = new JLabel(suggestion);
                suggestionLabel.setHorizontalAlignment(2);
                suggestionLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 0));
                suggestionLabel.setFocusable(true);
                suggestionLabel.setRequestFocusEnabled(true);
                String type = this.autoCompleteSuggestionTypes.get(suggestion);
                if (type.equals("keyword") && !added.containsKey(suggestion)) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_KEYWORD));
                } else if (type.equals("type")) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_TYPE));
                } else if (type.equals("function")) {
                    suggestionLabel.setForeground(StyleConstants.getForeground(CodeEditorView.DEFAULT_PREDEFINED_FUNCTION));
                }
                added.put(suggestion, true);
                suggestionLabel.setOpaque(true);
                suggestionLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ZPEEditorMain.this.insertAutocomplete(suggestion);
                        ZPEEditorMain.this.autoCompletePopup.setVisible(false);
                        ZPEEditorMain.this.hideTooltip();
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        e.getComponent().setBackground(SystemColor.controlHighlight);
                        if (ZPEKit.internalFunctionExists(suggestion)) {
                            Point p = new Point();
                            p.x += e.getComponent().getWidth();
                            p.y = (int)e.getComponent().getLocation().getY();
                            ZPEEditorMain.this.showRoundedTooltip(ZPEEditorMain.this.contentEditor, p, ZPEEditorMain.this.getTooltipFunctionInfo(suggestion), suggestion);
                        } else {
                            ZPEEditorMain.this.hideTooltip();
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        suggestionLabel.setBackground(ZPEEditorMain.this.autoCompleteItemBackgroundColor);
                        ZPEEditorMain.this.startHideTooltipTimer();
                    }
                });
                suggestionLabel.setBackground(this.autoCompleteItemBackgroundColor);
                suggestionPanel.add((Component)suggestionLabel, gbc);
            }
            outerScroll.setBackground(this.autoCompleteItemBackgroundColor);
            suggestionPanel.setBackground(this.autoCompleteItemBackgroundColor);
            this.autoCompletePopup.setBackground(this.autoCompleteItemBackgroundColor);
            this.autoCompletePopup.setPreferredSize(new Dimension(200, this.autoCompleteSuggestionWords.size() * 22));
            this.autoCompletePopup.pack();
            JLabel first = this.getPopupItem(0);
            first.setBackground(SystemColor.controlHighlight);
            try {
                int caretPos = this.contentEditor.getCaretPosition();
                int endOfWordPos = Utilities.getWordEnd(this.contentEditor, caretPos);
                Rectangle wordEndBounds = this.contentEditor.modelToView2D(endOfWordPos - 1).getBounds();
                Point locationOnScreen = this.contentEditor.getLocationOnScreen();
                int popupX = (int)((RectangularShape)wordEndBounds).getX() + locationOnScreen.x;
                int popupY = (int)((RectangularShape)wordEndBounds).getY() + locationOnScreen.y + (int)((RectangularShape)wordEndBounds).getHeight();
                this.disableArrows();
                this.autoCompletePopup.setLocation(popupX, popupY);
                this.autoCompletePopup.setVisible(true);
                this.autoCompletePopup.toFront();
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.autoCompletePopup.setVisible(false);
            this.enableArrows();
        }
    }

    private void insertAutocomplete(String suggestion) {
        try {
            int caretPosition = this.contentEditor.getCaretPosition();
            String currentWord = this.getCurrentWord();
            int wordStart = caretPosition - currentWord.length();
            if (currentWord.equals(suggestion)) {
                this.autoCompletePopup.setVisible(false);
                this.enableArrows();
                return;
            }
            if (this.autoCompleteSuggestionTypes.get(suggestion).equals("function")) {
                suggestion = (String)suggestion + "()";
            }
            this.contentEditor.getDocument().remove(wordStart, currentWord.length());
            this.contentEditor.getDocument().insertString(wordStart, (String)suggestion, null);
            this.autoCompletePopup.setVisible(false);
            this.enableArrows();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void doReplacement(String rep) {
        this.contentEditor.replaceSelection(rep);
    }

    private void startShowTooltipTimer(final Point tooltipPosition, final String hoveredWord) {
        if (this.showTooltipTimer != null) {
            this.showTooltipTimer.cancel();
        }
        this.showTooltipTimer = new Timer();
        this.showTooltipTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZPEEditorMain.this.showRoundedTooltip(ZPEEditorMain.this.contentEditor, tooltipPosition, ZPEEditorMain.this.getTooltipFunctionInfo(hoveredWord), hoveredWord);
                    }
                });
            }
        }, 500L);
    }

    private void startHideTooltipTimer() {
        if (this.hideTooltipTimer != null) {
            this.hideTooltipTimer.cancel();
        }
        this.hideTooltipTimer = new Timer();
        this.hideTooltipTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZPEEditorMain.this.hideTooltip();
                    }
                });
            }
        }, 1000L);
    }

    private void showRoundedTooltip(JEditorPane editorPane, Point position, String info, String functionName) {
        if (tooltipWindow == null) {
            tooltipWindow = new JWindow();
            tooltipWindow.setAlwaysOnTop(true);
            tooltipWindow.setFocusableWindowState(false);
        }
        tooltipWindow.setBackground(new Color(255, 255, 255, 0));
        RoundedPanel tooltipPanel = new RoundedPanel();
        tooltipPanel.setLayout(new BorderLayout());
        tooltipPanel.setBorder(null);
        JLabel tooltipLabel = new JLabel(info);
        tooltipLabel.setHorizontalAlignment(0);
        tooltipPanel.add((Component)tooltipLabel, "Center");
        tooltipLabel.setOpaque(false);
        tooltipLabel.setBorder(null);
        tooltipLabel.setBackground(new Color(0, 0, 0, 0));
        tooltipLabel.setCursor(Cursor.getPredefinedCursor(12));
        final String path = ZPEKit.getFunctionCategory(functionName).toLowerCase().replace(" ", "_").replace("/", "") + "/" + functionName.toLowerCase().replace(" ", "_").replace("/", "");
        tooltipLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    String url = "https://www.jamiebalfour.scot/projects/zpe/documentation/functions/" + path;
                    HelperFunctions.openWebsite(url);
                    ZPEEditorMain.this.hideTooltip();
                }
                catch (IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        tooltipWindow.getContentPane().removeAll();
        tooltipWindow.getContentPane().add(tooltipPanel);
        tooltipWindow.pack();
        Point editorPaneLocationOnScreen = editorPane.getLocationOnScreen();
        tooltipWindow.setLocation(editorPaneLocationOnScreen.x + position.x, editorPaneLocationOnScreen.y + position.y);
        tooltipWindow.setVisible(true);
        tooltipWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ZPEEditorMain.this.hideTooltipTimer != null) {
                    ZPEEditorMain.this.hideTooltipTimer.cancel();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ZPEEditorMain.this.startHideTooltipTimer();
            }
        });
        tooltipLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ZPEEditorMain.this.hideTooltipTimer != null) {
                    ZPEEditorMain.this.hideTooltipTimer.cancel();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ZPEEditorMain.this.startHideTooltipTimer();
            }
        });
    }

    private String getTooltipFunctionInfo(String functionName) {
        Object output = "";
        output = this.darkMode ? (String)output + "<html><div style='padding:10px;width:300px;color:#ddd;'>" : (String)output + "<html><div style='padding:10px;width:300px;color:#333;'>";
        ArrayList<AbstractMap.SimpleEntry<String, String>> params = ZPEEditor.getParams(ZPEKit.getFunctionManualHeader(functionName));
        StringBuilder header = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            AbstractMap.SimpleEntry<String, String> param2 = params.get(i);
            String name = param2.getKey();
            String type = param2.getValue();
            if (this.darkMode) {
                header.append("<span style='color: rgb(105, 143, 163);font-style:italic;'>").append(type).append("</span>").append(" <span style='color:#f60'>").append(name).append("</span>");
            } else {
                header.append("<span style='color: rgb(2, 87, 172);font-style:italic;'>").append(type).append("</span>").append(" <span style='color:#f60'>").append(name).append("</span>");
            }
            if (i + 1 >= params.size()) continue;
            header.append(", ");
        }
        output = this.darkMode ? (String)output + "<div style='margin-bottom:5px;'><code style='font-size:10px;'><span style='font-weight:bold;color:rgb(198, 120, 222)'>" + functionName + "</span> (" + String.valueOf(header) + ") : " + ZPEHelperFunctions.typeByteToString(ZPEKit.getFunctionReturnType(functionName)) + "</code></div>" : (String)output + "<div style='margin-bottom:5px;'><code style='font-size:10px;'><span style='font-weight:bold;margin-bottom:20px;color:rgb(135, 16, 148)'>" + functionName + "</span> (" + String.valueOf(header) + ") : " + ZPEHelperFunctions.typeByteToString(ZPEKit.getFunctionReturnType(functionName)) + "</code></div>";
        output = (String)output + ZPEKit.getFunctionManualEntryAsStyledHtml(functionName, this.darkMode);
        output = !this.darkMode ? (String)output + "<div style='margin:10px 0; color:#222;'>Function version " + ZPEKit.getFunctionVersion(functionName) + "</div>" : (String)output + "<div style='margin:10px 0; color:#bbb;'>Function version " + ZPEKit.getFunctionVersion(functionName) + "</div>";
        output = (String)output + "<div style='font-weight:100;margin-bottom:10px;'>Category: " + ZPEKit.getFunctionCategory(functionName) + "</div>";
        output = (String)output + "<div style='color:#0af'>Click for more information online.</div>";
        output = (String)output + "</div></html>";
        return output;
    }

    public void saveToTheCloud() {
        if ((this.login_username.isEmpty() || this.login_password.isEmpty()) && !this.login()) {
            return;
        }
        try {
            if (!ZPEKit.validateCode(this.contentEditor.getText())) {
                JOptionPane.showMessageDialog(this._frame.getContentPane(), "Your code is not valid. Please validate your code before uploading.", "Save unsuccessful", 1);
                return;
            }
        }
        catch (CompileException e1) {
            System.err.println(e1.getMessage());
            JOptionPane.showMessageDialog(this._frame.getContentPane(), "Your code could not validate. Make sure it is valid before uploading.", "Save unsuccessful", 1);
            return;
        }
        String path = !this.lastCloudFileOpened.isEmpty() ? JOptionPane.showInputDialog(this._frame, "Please insert the name for this file.", this.lastCloudFileOpened) : JOptionPane.showInputDialog(this._frame, (Object)"Please insert the name for this file.");
        int public_or_private = 0;
        int res = JOptionPane.showConfirmDialog(this._frame.getContentPane(), "Do you want to make your code public?", "Make your code public", 0, -1);
        if (res == 0) {
            public_or_private = 1;
        }
        if (path != null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", this.login_username);
            arguments.put("password", this.login_password);
            arguments.put("content", this.contentEditor.getText());
            arguments.put("content_name", path);
            arguments.put("public", "" + public_or_private);
            try {
                String postRes = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/save.php?version=10", arguments);
                if (postRes.isEmpty()) {
                    JOptionPane.showMessageDialog(this._frame, "Your file could not be saved at this time.", "Save failed", 0);
                } else {
                    ZenithJSONParser p = new ZenithJSONParser();
                    ZPEMap a = (ZPEMap)p.jsonDecode(postRes, false);
                    if (a.get(new ZPEString("result")).toString().equals("1")) {
                        this.lastCloudFileOpened = path;
                        this.setTitleBarText(path);
                        this.lastFileOpened = "";
                        JOptionPane.showMessageDialog(this._frame.getContentPane(), "Your file has been saved to your ZPE Online account.", "Save successful", 1);
                        if (a.containsKey(new ZPEString("list"))) {
                            this.addRecentsFromCloud((ZPEList)a.get(new ZPEString("list")));
                        }
                    } else {
                        JOptionPane.showMessageDialog(this._frame, "Your file could not be saved at this time.", "Save failed", 0);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this._frame, "Your file could not be saved at this time.", "Save failed", 0);
                System.err.println(e.getMessage());
            }
        }
    }

    private void loadFromUsersCloud() {
        if ((this.login_username.isEmpty() || this.login_password.isEmpty()) && !this.login()) {
            return;
        }
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", this.login_username);
            arguments.put("password", this.login_password);
            String lst = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=list&version=10", arguments);
            ZenithJSONParser p = new ZenithJSONParser();
            ZPEMap a = (ZPEMap)p.jsonDecode(lst, false);
            if (a.containsKey(new ZPEString("result")) && HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) == 1) {
                ZPEType l = a.get(new ZPEString("list"));
                ZPEList arr = (ZPEList)l;
                ArrayList<String> choices = new ArrayList<String>();
                ZPEMap selections = new ZPEMap();
                String first = "";
                for (ZPEType k : arr) {
                    ZPEMap file = (ZPEMap)k;
                    choices.add(file.get(new ZPEString("name")).toString());
                    selections.put(new ZPEString(file.get(new ZPEString("name")).toString()), new ZPEString(file.get(new ZPEString("id")).toString()));
                    if (!first.isEmpty()) continue;
                    first = file.get(new ZPEString("name")).toString();
                }
                new ZPEOnlineFileChooser(this._this, arguments, selections, choices, false);
            }
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
    }

    private void loadFromPublicCloud() {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String lst = HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/public.php?type=list&version=10", arguments);
            ZenithJSONParser p = new ZenithJSONParser();
            ZPEMap a = (ZPEMap)p.jsonDecode(lst, false);
            if (a.containsKey(new ZPEString("result")) && HelperFunctions.stringToInteger(a.get(new ZPEString("result")).toString()) == 1) {
                ZPEType l = a.get(new ZPEString("list"));
                ZPEList arr = (ZPEList)l;
                ArrayList<String> choices = new ArrayList<String>();
                ZPEMap selections = new ZPEMap();
                String first = "";
                for (ZPEType k : arr) {
                    ZPEMap file = (ZPEMap)k;
                    choices.add(file.get(new ZPEString("name")).toString());
                    selections.put(new ZPEString(file.get(new ZPEString("name")).toString()), new ZPEString(file.get(new ZPEString("id")).toString()));
                    if (!first.isEmpty()) continue;
                    first = file.get(new ZPEString("name")).toString();
                }
                new ZPEOnlineFileChooser(this._this, arguments, selections, choices, true);
            }
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
    }

    void loadFromCloudFile(String file, Map<String, String> arguments, ZPEMap selections, boolean publicrepo) {
        ZenithJSONParser p = new ZenithJSONParser();
        arguments.put("id", selections.get(new ZPEString(file)).toString());
        try {
            String s = !publicrepo ? HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/get.php?type=file&version=10", arguments) : HelperFunctions.makePOSTRequest(ZPEInstance.getOnlinePathProperty() + "/public.php?type=file&version=10", arguments);
            ZPEMap results = (ZPEMap)p.jsonDecode(s, false);
            String code = URLDecoder.decode(results.get(new ZPEString("string")).toString(), "UTF-8");
            code = code.replace("\\n", System.lineSeparator());
            this.clearUndoRedoManagers();
            this.setTextProperly(code);
            this.lastCloudFileOpened = file;
            this.lastFileOpened = "";
            this.setTitleBarText(file);
            this.setTitle("ZPE Editor");
            if (publicrepo) {
                this.lastCloudFileOpened = "";
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this._frame, "File cannot be opened.", "Error", 0);
        }
    }

    @Override
    public Properties getProperties() {
        return this.guiProperties;
    }

    @Override
    public void destroyConsole() {
        this.attachedConsole = null;
    }

    private void updateRecentFiles() {
        this.recentItemsMenu.removeAll();
        for (String fStr : this.recents) {
            BalfMenuBar.MenuItem item = new BalfMenuBar.MenuItem(new File(fStr).getName(), this.menuBar);
            item.addActionListener(e -> {
                try {
                    this.clearUndoRedoManagers();
                    this.setTextProperly(FileHelperFunctions.readFileAsString(new File(fStr).getAbsolutePath()));
                    SwingUtilities.invokeLater(() -> {
                        this.contentEditor.setCaretPosition(0);
                        this.scrollPane.getVerticalScrollBar().setValue(0);
                    });
                    this.setTitleBarText(new File(fStr).getName().split("\\.")[0]);
                    this._frame.setTitle("ZPE Editor");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            this.recentItemsMenu.add((Component)item, 0);
        }
    }

    private void debugCode() throws IOException {
        ZPEKit.setDebugging(true);
        String t = "ZPE";
        if (!this.lastFileOpened.isEmpty()) {
            t = "ZPE Editor";
        } else if (!this.lastCloudFileOpened.isEmpty()) {
            t = "ZPE Editor";
        }
        this.setTitle(t);
        this.setTitleBarText(t);
        Object extras = " -d";
        if (this.caseSensitiveCompileMenuItem.isSelected()) {
            extras = (String)extras + " --case_insensitive";
        }
        if (this.attachedConsole != null && this.attachedConsole.getProcess() != null) {
            this.attachedConsole.destroyCurrentProcess();
        }
        Path tempPath = Files.createTempFile(ZPEHelperFunctions.generateRandomWord(12), ".tmp", new FileAttribute[0]);
        FileHelperFunctions.writeFile(tempPath.toAbsolutePath().toString(), this.contentEditor.getText(), false);
        if (HelperFunctions.isJavaAvailable()) {
            if (!ZPEInstance.getJarExecPath().isEmpty()) {
                if (new File(ZPEInstance.getJarExecPath()).exists()) {
                    this.attachedConsole = new ZPEConsole(5);
                    this.attachedConsole.runCode(tempPath, new ZPEString[0], true);
                    this.stopCodeMenuItem.setEnabled(true);
                    this.stopCodeMenuItem.setVisible(true);
                }
            } else {
                ZPEConsole c = new ZPEConsole(this, t, this.contentEditor.getFont(), this.permission_level);
                c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
                this.stopCodeMenuItem.setVisible(false);
            }
        } else {
            ZPEConsole c = new ZPEConsole(this, t, this.contentEditor.getFont(), this.permission_level);
            c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
            this.stopCodeMenuItem.setVisible(false);
        }
    }

    private void executeCode() throws IOException {
        ZPEKit.setDebugging(false);
        Object t = "ZPE";
        if (!this.lastFileOpened.isEmpty()) {
            t = "ZPE : " + this.lastFileOpened;
        } else if (!this.lastCloudFileOpened.isEmpty()) {
            t = "ZPE : " + this.lastCloudFileOpened;
        }
        Object extras = "";
        if (this.caseSensitiveCompileMenuItem.isSelected()) {
            extras = (String)extras + " --case_insensitive";
        }
        if (this.useConsoleOutput.isSelected()) {
            if (this.attachedConsole != null && this.attachedConsole.getProcess() != null) {
                this.attachedConsole.destroyCurrentProcess();
            }
        } else if (this.consoleOutputTextArea.getProcess() != null) {
            this.consoleOutputTextArea.destroyCurrentProcess();
        }
        Path tempPath = Files.createTempFile(ZPEHelperFunctions.generateRandomWord(12), ".tmp", new FileAttribute[0]);
        if (HelperFunctions.isJavaAvailable()) {
            if (!ZPEInstance.getJarExecPath().isEmpty()) {
                if (new File(ZPEInstance.getJarExecPath()).exists()) {
                    FileHelperFunctions.writeFile(tempPath.toAbsolutePath().toString(), this.contentEditor.getText(), false);
                    if (this.useConsoleOutput.isSelected()) {
                        this.attachedConsole = new ZPEConsole(5);
                        this.attachedConsole.runCode(tempPath, new ZPEString[0], true);
                        this.stopCodeMenuItem.setEnabled(true);
                        this.stopCodeMenuItem.setVisible(true);
                    } else if (ZPERuntimeDaemon.isZPELiteRunning("127.0.0.1", 9342, 100)) {
                        this.consoleOutputTextArea.runOverSocket(tempPath);
                    } else {
                        this.consoleOutputTextArea.runAsProcess(tempPath, this.useNativeRuntimeMenuItem.isSelected(), (String)extras);
                        this.stopCodeMenuItem.setEnabled(true);
                        this.stopCodeMenuItem.setVisible(true);
                    }
                }
            } else if (this.useConsoleOutput.isSelected()) {
                ZPEConsole c = new ZPEConsole(this, (String)t, this.contentEditor.getFont(), this.permission_level);
                c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
                this.stopCodeMenuItem.setVisible(false);
            }
        } else {
            ZPEConsole c = new ZPEConsole(this, (String)t, this.contentEditor.getFont(), this.permission_level);
            c.runCode(this.contentEditor.getText(), new ZPEString[0], this.caseSensitiveCompileMenuItem.isSelected());
            this.stopCodeMenuItem.setVisible(false);
        }
    }

    private /* synthetic */ void lambda$addMenuItems$8(String helpName, String group, String replacement, ActionEvent e) {
        JOptionPane op = new JOptionPane(new ZPEFunctionGenerator(helpName, group, replacement, this._this).getContentPane(), 1, -1, this.lighterLogo, new String[0]);
        JDialog dlg = op.createDialog(this._frame, "ZPE Function Machine");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    static {
        themeColour = new Color(69, 22, 110);
        menuBarForeColor = Color.WHITE;
    }

    class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2308035050104867155L;

        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ZPEEditorMain.this.undoManager.redo();
            }
            catch (CannotRedoException ex) {
                JOptionPane.showMessageDialog(ZPEEditorMain.this._frame, "Cannot redo.", "Error", 0);
            }
            this.update();
            ZPEEditorMain.this.undoAction.update();
        }

        protected void update() {
            if (ZPEEditorMain.this.undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", ZPEEditorMain.this.undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -3804879849241500100L;

        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ZPEEditorMain.this.undoManager.undo();
                this.update();
                ZPEEditorMain.this.redoAction.update();
            }
            catch (CannotUndoException ex) {
                JOptionPane.showMessageDialog(ZPEEditorMain.this._frame, "Cannot undo.", "Error", 0);
            }
        }

        protected void update() {
            if (ZPEEditorMain.this.undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", ZPEEditorMain.this.undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (!e.getEdit().getPresentationName().equals("style change") && !ZPEEditorMain.this.dontUndo) {
                ZPEEditorMain.this.undoManager.addEdit(e.getEdit());
                ZPEEditorMain.this.undoAction.update();
                ZPEEditorMain.this.redoAction.update();
            }
        }
    }

    class RoundedPanel
    extends JPanel {
        private static final int ARC_WIDTH = 20;
        private static final int ARC_HEIGHT = 20;

        public RoundedPanel() {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBackground(new Color(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (ZPEEditorMain.this.darkMode) {
                g2.setColor(new Color(33, 33, 33));
            } else {
                g2.setColor(new Color(255, 255, 255));
            }
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 20, 20);
            g2.setColor(new Color(0, 0, 0, 0));
            g2.drawRoundRect(0, 0, 1, 1, 20, 20);
        }
    }

    static class EditorObject
    extends ZPEStructure {
        JEditorPane editor;

        protected EditorObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent, JEditorPane editor) {
            super(z, parent, "editor");
            this.editor = editor;
            this.addNativeMethod("write", new write_Command());
            this.addNativeMethod("write_line", new write_line_Command());
            this.addNativeMethod("replace", new replace_Command());
        }

        class replace_Command
        implements ZPEObjectNativeMethod {
            replace_Command() {
            }

            @Override
            public String[] getParameterNames() {
                return new String[]{"find", "replace"};
            }

            @Override
            public String[] getParameterTypes() {
                return new String[]{"string", "string"};
            }

            public void replaceText(JEditorPane editorPane, String target, String replacement) {
                try {
                    String currentText = editorPane.getDocument().getText(0, editorPane.getDocument().getLength());
                    String updatedText = currentText.replace(target, replacement);
                    editorPane.getDocument().remove(0, editorPane.getDocument().getLength());
                    editorPane.getDocument().insertString(0, updatedText, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                try {
                    String find = parameters.get("find").toString();
                    String replace = parameters.get("replace").toString();
                    while (EditorObject.this.editor.getText().contains(find)) {
                        this.replaceText(EditorObject.this.editor, find, replace);
                    }
                    return new ZPEBoolean(true);
                }
                catch (Exception e) {
                    return new ZPEBoolean(false);
                }
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "replace";
            }
        }

        class write_line_Command
        implements ZPEObjectNativeMethod {
            write_line_Command() {
            }

            @Override
            public String[] getParameterNames() {
                return new String[]{"text"};
            }

            @Override
            public String[] getParameterTypes() {
                return new String[]{"string"};
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                SwingUtilities.invokeLater(() -> {
                    String txt = ((ZPEType)parameters.get("text")).toString();
                    int caretPosition = EditorObject.this.editor.getCaretPosition();
                    int currentWordLength = 0;
                    if (EditorObject.this.editor.getSelectedText() != null) {
                        currentWordLength = EditorObject.this.editor.getSelectedText().length();
                    }
                    int wordStart = caretPosition - currentWordLength;
                    try {
                        EditorObject.this.editor.getDocument().remove(wordStart, currentWordLength);
                        EditorObject.this.editor.getDocument().insertString(wordStart, txt + System.lineSeparator(), null);
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                });
                return new ZPEBoolean(true);
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "write_line";
            }
        }

        class write_Command
        implements ZPEObjectNativeMethod {
            write_Command() {
            }

            @Override
            public String[] getParameterNames() {
                return new String[]{"text"};
            }

            @Override
            public String[] getParameterTypes() {
                return new String[]{"string"};
            }

            @Override
            public ZPEType MainMethod(BinarySearchTree<String, ZPEType> parameters, ZPEObject parent) {
                SwingUtilities.invokeLater(() -> {
                    String txt = ((ZPEType)parameters.get("text")).toString();
                    int caretPosition = EditorObject.this.editor.getCaretPosition();
                    int currentWordLength = 0;
                    if (EditorObject.this.editor.getSelectedText() != null) {
                        currentWordLength = EditorObject.this.editor.getSelectedText().length();
                    }
                    int wordStart = caretPosition - currentWordLength;
                    try {
                        EditorObject.this.editor.getDocument().remove(wordStart, currentWordLength);
                        EditorObject.this.editor.getDocument().insertString(wordStart, txt, null);
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                });
                return new ZPEBoolean(true);
            }

            @Override
            public int getRequiredPermissionLevel() {
                return 0;
            }

            @Override
            public String getName() {
                return "write";
            }
        }
    }
}

