/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.editor;

import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ConsoleOutputTextArea
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private Process currentProcess;
    private BufferedWriter processWriter;
    private int inputStartOffset = 0;
    private final StyledDocument doc;
    private final Style keyStyle;
    private final Style warningStyle;
    private final Style additionalStyle;
    private final Style outputStyle;
    private final Style errorStyle;
    private final Style assertStyle;
    private final Style inputStyle;
    boolean finished;
    private ArrayList<ProcessFinishedListener> processFinishedListeners = new ArrayList();

    public ConsoleOutputTextArea(String text, Color foreground) {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setFont(new Font("Monospaced", 0, 12));
        this.setBackground(Color.BLACK);
        this.setCaretColor(Color.WHITE);
        this.setEditable(false);
        this.doc = this.getStyledDocument();
        this.outputStyle = this.doc.addStyle("output", null);
        StyleConstants.setForeground(this.outputStyle, Color.WHITE);
        this.keyStyle = this.doc.addStyle("key", null);
        StyleConstants.setForeground(this.keyStyle, new Color(0, 200, 0));
        this.warningStyle = this.doc.addStyle("warning", null);
        StyleConstants.setForeground(this.warningStyle, new Color(255, 128, 0));
        this.additionalStyle = this.doc.addStyle("additional", null);
        StyleConstants.setForeground(this.additionalStyle, new Color(181, 181, 181));
        this.errorStyle = this.doc.addStyle("error", null);
        StyleConstants.setForeground(this.errorStyle, Color.RED);
        this.assertStyle = this.doc.addStyle("assert", null);
        StyleConstants.setForeground(this.assertStyle, new Color(139, 0, 255));
        this.inputStyle = this.doc.addStyle("input", null);
        StyleConstants.setForeground(this.inputStyle, Color.CYAN);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!ConsoleOutputTextArea.this.isEditable()) {
                    return;
                }
                if (ConsoleOutputTextArea.this.getCaretPosition() >= ConsoleOutputTextArea.this.inputStartOffset && !Character.isISOControl(e.getKeyChar())) {
                    try {
                        int pos = ConsoleOutputTextArea.this.getCaretPosition();
                        ConsoleOutputTextArea.this.doc.insertString(pos, String.valueOf(e.getKeyChar()), ConsoleOutputTextArea.this.inputStyle);
                        ConsoleOutputTextArea.this.setCaretPosition(pos + 1);
                        e.consume();
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (!ConsoleOutputTextArea.this.isEditable()) {
                    e.consume();
                    return;
                }
                if (ConsoleOutputTextArea.this.getCaretPosition() < ConsoleOutputTextArea.this.inputStartOffset && !ConsoleOutputTextArea.this.isNavKey(e)) {
                    ConsoleOutputTextArea.this.setCaretPosition(ConsoleOutputTextArea.this.doc.getLength());
                    e.consume();
                }
                if (e.getKeyCode() == 8 && ConsoleOutputTextArea.this.getCaretPosition() <= ConsoleOutputTextArea.this.inputStartOffset) {
                    e.consume();
                }
                if (e.getKeyCode() == 10) {
                    e.consume();
                    try {
                        int inputLen = ConsoleOutputTextArea.this.doc.getLength() - ConsoleOutputTextArea.this.inputStartOffset;
                        String inputLine = ConsoleOutputTextArea.this.doc.getText(ConsoleOutputTextArea.this.inputStartOffset, inputLen).trim();
                        ConsoleOutputTextArea.this.appendStyled("\n", ConsoleOutputTextArea.this.inputStyle);
                        ConsoleOutputTextArea.this.setEditable(false);
                        if (ConsoleOutputTextArea.this.processWriter != null) {
                            ConsoleOutputTextArea.this.processWriter.write(inputLine);
                            ConsoleOutputTextArea.this.processWriter.newLine();
                            ConsoleOutputTextArea.this.processWriter.flush();
                        }
                    }
                    catch (Exception ex) {
                        ConsoleOutputTextArea.this.setEditable(false);
                    }
                }
            }
        });
    }

    public Process getProcess() {
        return this.currentProcess;
    }

    public void destroyCurrentProcess() {
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
            this.currentProcess = null;
        }
    }

    public void addProcessFinishedListener(ProcessFinishedListener listener) {
        this.processFinishedListeners.add(listener);
        listener.onProcessFinished();
    }

    private boolean isNavKey(KeyEvent e) {
        int k = e.getKeyCode();
        return k == 37 || k == 39 || k == 38 || k == 40 || k == 16 || k == 17;
    }

    public void runAsProcess(Path file, boolean useNativeWhenAvailable, String extras) {
        ProcessBuilder pb;
        this.setText("");
        this.setEditable(false);
        this.appendStyled("Using temporary file " + String.valueOf(file.toAbsolutePath()) + "\n\n", this.additionalStyle);
        if (new File(ZPEHelperFunctions.getBinaryPath()).exists() && useNativeWhenAvailable) {
            pb = new ProcessBuilder(ZPEHelperFunctions.getBinaryPath(), "-r", file.toAbsolutePath().toString(), "--silent" + extras);
            this.appendStyled("Running using ZPE native binary.\n\n", this.keyStyle);
        } else {
            String cPath = ZPEInstance.getJarExecPath().isEmpty() ? ZPEInstance.getExecutablePath() : ZPEInstance.getJarExecPath();
            if (HelperFunctions.isWindows() && cPath.startsWith("/")) {
                cPath = cPath.substring(1);
            }
            ArrayList<String> args2 = new ArrayList<String>();
            args2.add("java");
            args2.add("-jar");
            args2.add(cPath);
            args2.add("-r");
            args2.add(file.toAbsolutePath().toString());
            args2.add("--silent");
            if (extras != null && !extras.isEmpty()) {
                args2.addAll(Arrays.asList(extras.split(" ")));
            }
            pb = new ProcessBuilder(args2);
        }
        try {
            this.finished = false;
            long start = System.currentTimeMillis();
            this.currentProcess = pb.start();
            this.pushStreamToTextArea(this.currentProcess.getErrorStream(), this.errorStyle);
            this.processWriter = new BufferedWriter(new OutputStreamWriter(this.currentProcess.getOutputStream()));
            this.pushStreamToTextArea(this.currentProcess.getInputStream(), this.outputStyle);
            new Thread(() -> {
                try {
                    int exitCode = this.currentProcess.waitFor();
                    long end = System.currentTimeMillis();
                    SwingUtilities.invokeLater(() -> {
                        this.setEditable(true);
                        for (ProcessFinishedListener listener : this.processFinishedListeners) {
                            listener.onProcessFinished();
                        }
                        this.appendStyled("\n\nProcess exited with code " + exitCode + ". Executed parse, compile and execute stages for " + (end - start) + " ms.", this.keyStyle);
                        System.out.println("Process exited with code " + exitCode + ". Executed parse, compile and execute stages for " + (end - start) + " ms.");
                        this.setEditable(false);
                        try {
                            Files.delete(file);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    this.finished = true;
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }).start();
        }
        catch (IOException e) {
            this.appendStyled("[Error starting process]\n", this.outputStyle);
        }
    }

    public void runOverSocket(Path file) {
        this.setText("");
        this.setEditable(false);
        this.appendStyled("Running ZPE Lite on localhost socket 9342\n\n", this.additionalStyle);
        this.appendStyled("Using temporary file " + String.valueOf(file.toAbsolutePath()) + "\n\n", this.additionalStyle);
        long start = System.currentTimeMillis();
        try (Socket socket = new Socket("localhost", 9342);
             BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);){
            String line;
            this.pushStreamToTextArea(socket.getInputStream(), this.outputStyle);
            this.processWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            String cmd = "/file=" + String.valueOf(file.toAbsolutePath());
            out.println(cmd);
            while ((line = in.readLine()) != null) {
                this.appendStyled(line + "\n", this.outputStyle);
                this.setCaretPosition(this.doc.getLength());
            }
            long end = System.currentTimeMillis();
            this.appendStyled("Executed parse, compile and execute stages for " + (end - start) + " ms.", this.keyStyle);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void pushStreamToTextArea(InputStream inputStream2, Style style) {
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String outputLine = line;
                    SwingUtilities.invokeLater(() -> {
                        Style actualStyle = style;
                        this.setEditable(false);
                        if (style == this.errorStyle) {
                            if (outputLine.startsWith("Assertion failure exception caused by")) {
                                actualStyle = this.assertStyle;
                            }
                            if (outputLine.startsWith("ZPE WARNING : ")) {
                                actualStyle = this.warningStyle;
                            }
                        }
                        this.appendStyled(outputLine + "\n", actualStyle);
                        this.setCaretPosition(this.doc.getLength());
                        this.inputStartOffset = this.doc.getLength();
                        if (!this.finished) {
                            this.setEditable(true);
                            this.requestFocusInWindow();
                        }
                    });
                }
                if (this.currentProcess != null) {
                    this.currentProcess.waitFor();
                    SwingUtilities.invokeLater(() -> {
                        if (!this.finished) {
                            this.finished = true;
                            this.appendStyled("\n[Process finished]\n", this.outputStyle);
                        }
                        this.setEditable(false);
                    });
                }
            }
            catch (IOException | InterruptedException e) {
                this.appendStyled("[Error reading output]\n", this.outputStyle);
            }
        }).start();
    }

    private void appendStyled(String str, Style style) {
        try {
            this.doc.insertString(this.doc.getLength(), str, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static interface ProcessFinishedListener {
        public void onProcessFinished();
    }
}

