/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import extensions.mindrot.BCrypt;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.AbstractRecord;
import jamiebalfour.zpe.core.AbstractStructure;
import jamiebalfour.zpe.core.ExceptionObject;
import jamiebalfour.zpe.core.FunctionReference;
import jamiebalfour.zpe.core.IAST;
import jamiebalfour.zpe.core.LAMEX2;
import jamiebalfour.zpe.core.Pair;
import jamiebalfour.zpe.core.UndefinedPath;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.YASSCompiledProgram;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEEntity;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPEModule;
import jamiebalfour.zpe.core.ZPEMultipleReturnArray;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPEStartup;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.AssertionHalt;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.InternalException;
import jamiebalfour.zpe.exceptions.NoEntryPointException;
import jamiebalfour.zpe.exceptions.NonExecutableFileException;
import jamiebalfour.zpe.exceptions.PasswordException;
import jamiebalfour.zpe.exceptions.StackFrameDepthExceeded;
import jamiebalfour.zpe.exceptions.TranspilerNotFoundException;
import jamiebalfour.zpe.exceptions.UnacceptableTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPECoreType;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEInternalFunction;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPESyntaxTranspiler;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.objects.AutoGUIObject;
import jamiebalfour.zpe.objects.CalculatorObject;
import jamiebalfour.zpe.objects.ChatGPTObject;
import jamiebalfour.zpe.objects.ColourObject;
import jamiebalfour.zpe.objects.ConverterObject;
import jamiebalfour.zpe.objects.DateObject;
import jamiebalfour.zpe.objects.HTMLBuilderObject;
import jamiebalfour.zpe.objects.ImageObject;
import jamiebalfour.zpe.objects.PairObject;
import jamiebalfour.zpe.objects.ParserObject;
import jamiebalfour.zpe.objects.SequentialFileObject;
import jamiebalfour.zpe.objects.SocketObject;
import jamiebalfour.zpe.objects.ZENClientObject;
import jamiebalfour.zpe.parser.v5.ZenithParsingEngine;
import jamiebalfour.zpe.types.Undefined;
import jamiebalfour.zpe.types.ZPEArray;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEOrderedAssociativeArray;
import jamiebalfour.zpe.types.ZPERecord;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.types.ZPETuple;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ZPERuntimeEnvironment {
    LAMEX2 LAME = new LAMEX2(this);
    String monitorFunction = null;
    String monitorVar = null;
    Map<String, ZPEType> globalVariables = null;
    boolean retainVariableState = false;
    BinarySearchTree<String, ZPEModule> modules = new BinarySearchTree();
    HashMap<String, IAST> labels = new HashMap();
    Runnable traverseAction = null;
    private int currentStackDepth = 0;
    public static final int MAX_STACK_DEPTH = 1024;
    protected ZPEFunction globalFunction = new ZPEFunction(this, "Global", new IAST(), true);
    Stack<ZPEFunction> callStack = new Stack();
    private final int permission_level;

    public void setTraverseAction(Runnable traverseAction) {
        this.traverseAction = traverseAction;
    }

    public ZPERuntimeEnvironment() {
        try {
            this.runStartup();
        }
        catch (ZPERuntimeException e) {
            throw new RuntimeException(e);
        }
        this.permission_level = 5;
    }

    public ZPERuntimeEnvironment(int permissionLevel) {
        try {
            this.runStartup();
        }
        catch (ZPERuntimeException e) {
            throw new RuntimeException(e);
        }
        this.permission_level = permissionLevel;
    }

    public int getPermissionLevel() {
        return this.permission_level;
    }

    static ZPEType getIndex(ZPEType value, ZPEType index) throws UnacceptableTypeException {
        if (value instanceof ZPEList) {
            if (index instanceof Pair) {
                Pair z = (Pair)index;
                return ((ZPEList)value).getRange(HelperFunctions.stringToInteger(z.getName().toString()), HelperFunctions.stringToInteger(z.getValue().toString()));
            }
            return ((ZPEList)value).get((ZPENumber)index);
        }
        if (value instanceof ZPEMap) {
            return ((ZPEMap)value).get(index);
        }
        if (value instanceof ZPEString) {
            return new ZPEString(((ZPEString)value).charAt((ZPENumber)index));
        }
        if (value instanceof ZPETuple) {
            return (ZPEType)((ZPETuple)value).getIndex((ZPENumber)index);
        }
        throw new UnacceptableTypeException("Cannot get index of value from the given value (index access).");
    }

    static ZPEType setIndex(ZPEType current, ZPEType index, ZPEType value) {
        if (current instanceof ZPEList) {
            ZPEList z = (ZPEList)current;
            z.set((ZPENumber)index, value);
            return z;
        }
        if (current instanceof ZPEOrderedAssociativeArray) {
            ZPEOrderedAssociativeArray assoc = (ZPEOrderedAssociativeArray)current;
            assoc.put(index, value);
            return assoc;
        }
        if (current instanceof ZPEMap) {
            ZPEMap assoc = (ZPEMap)current;
            assoc.put(index, value);
            return assoc;
        }
        if (current instanceof ZPEString) {
            String s = current.toString();
            int ch_index = ((ZPENumber)index).intValue();
            String output = s.substring(0, ch_index) + value.toString().charAt(0) + s.substring(ch_index + 1);
            ((ZPEString)current).set(output);
            return current;
        }
        if (current instanceof ZPETuple) {
            ((ZPETuple)current).setValue(value, (ZPENumber)index);
        }
        return null;
    }

    private void addInternalObject(String id, Class<? extends ZPEStructure> c) {
        if (!Arrays.asList(ZPEInstance.DISABLED_OBJECTS).contains(id)) {
            ZPEInstance.BUILT_IN_STRUCTURES.put(id, c);
        }
    }

    void runStartup() throws ZPERuntimeException {
        try {
            if (ZPEInstance.BUILT_IN_COMMANDS == null) {
                ZPEInstance.BUILT_IN_COMMANDS = new YASSPredefinedFunctions();
            }
            if (ZPEInstance.BUILT_IN_STRUCTURES == null) {
                ZPEInstance.BUILT_IN_STRUCTURES = new HashMap<String, Class<? extends ZPEStructure>>();
                this.addInternalObject("AutoGUI", AutoGUIObject.class);
                this.addInternalObject("Calculator", CalculatorObject.class);
                this.addInternalObject("ChatGPT", ChatGPTObject.class);
                this.addInternalObject("Colour", ColourObject.class);
                this.addInternalObject("Converter", ConverterObject.class);
                this.addInternalObject("Date", DateObject.class);
                this.addInternalObject("Exception", ExceptionObject.class);
                this.addInternalObject("HTMLBuilder", HTMLBuilderObject.class);
                this.addInternalObject("Image", ImageObject.class);
                this.addInternalObject("Pair", PairObject.class);
                this.addInternalObject("Parser", ParserObject.class);
                this.addInternalObject("Point", ParserObject.class);
                this.addInternalObject("SequentialFile", SequentialFileObject.class);
                this.addInternalObject("Socket", SocketObject.class);
                this.addInternalObject("ZENClient", ZENClientObject.class);
            }
            ZPEPluginManager.addPlugins();
            ZPEStartup.loadSettings();
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
    }

    YASSCompiler.YASSCompiledExecutable readCompiledApplication(String file) {
        try {
            FileInputStream door = new FileInputStream(file);
            ObjectInputStream reader = new ObjectInputStream(door);
            return (YASSCompiler.YASSCompiledExecutable)reader.readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    ZPEType runApplication(String file, ZPEString[] parameters, String passcode) throws PasswordException, IOException, ZPERuntimeException, BreakPointHalt, ExitHalt {
        ZPEFunction f;
        if (!new File(file).exists()) {
            throw new IOException("Application file not found");
        }
        try {
            this.openCompiledFile(file, passcode);
        }
        catch (PasswordException e) {
            throw new PasswordException();
        }
        catch (Exception e) {
            throw new NonExecutableFileException();
        }
        if (ZPEInstance.EXPERIMENTAL) {
            ZPECore.print("Running in *experimental mode*");
            ZPECore.print();
        }
        if ((f = this.getMainFunction()) == null) {
            throw new NoEntryPointException();
        }
        f.setParent(this.globalFunction);
        ZPEList zl = new ZPEList();
        zl.addAll(Arrays.asList(parameters));
        this.addSystemVariable();
        f.addParameter("$args");
        f.setParameter("$args", zl);
        return f.run();
    }

    void openCompiledFile(String file, String passcode) throws Exception {
        FileInputStream door = new FileInputStream(file);
        ObjectInputStream reader = new ObjectInputStream(door);
        try {
            YASSCompiledProgram program;
            YASSCompiler.YASSCompiledExecutable executable = (YASSCompiler.YASSCompiledExecutable)reader.readObject();
            if (executable.passcode != null && !executable.passcode.isEmpty()) {
                if (passcode == null) {
                    reader.close();
                    throw new PasswordException();
                }
                if (!BCrypt.checkpw(passcode, executable.passcode)) {
                    reader.close();
                    throw new PasswordException();
                }
                String paddedKey = passcode;
                paddedKey = paddedKey.length() > 16 ? HelperFunctions.padString(paddedKey, 32) : HelperFunctions.padString(paddedKey, 16);
                if (executable.files != null) {
                    for (String f : executable.files.keySet()) {
                        FileHelperFunctions.writeByteFile(f, executable.files.get(f));
                    }
                }
                program = (YASSCompiledProgram)HelperFunctions.readEncryptedObject((byte[])executable.program, paddedKey);
            } else {
                program = (YASSCompiledProgram)executable.program;
            }
            if (executable.prevent_auto_includes) {
                ZPEInstance.AUTO_PREPEND = null;
            }
            if (program.functions != null) {
                for (Pair m : program.functions) {
                    ZPEFunction f = this.astToFunction(((IAST)m.getValue()).next);
                    f.scope = ((IAST)m.getValue()).scope;
                    this.addFunction(m.getName().toString(), f);
                }
            }
            if (program.record_structures != null) {
                for (Pair m : program.record_structures) {
                    this.globalFunction.abstractRecordMap.put(m.getName().toString(), (AbstractRecord)m.getValue());
                }
            }
            if (program.structures != null) {
                for (Pair m : program.structures) {
                    this.globalFunction.abstractStructureMap.put(m.getName().toString(), (AbstractStructure)m.getValue());
                }
            }
            if (program.variables != null) {
                for (Pair m : program.variables) {
                    this.addGlobalVariable(m.getName().toString(), (ZPEType)m.getValue(), -1, (byte)118);
                }
            }
            reader.close();
            if (executable.experimental && !ZPEInstance.EXPERIMENTAL) {
                ZPECore.printError("This compiled script requires experimental flag to be enabled.");
            }
        }
        catch (ClassNotFoundException cnf) {
            reader.close();
            throw new Exception("There was a problem reading the file `" + file + "`. It might not be compiled with a valid/newer version of ZPE.");
        }
    }

    void globalTraverse(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (node.type == 12) {
            this.addFunction(node.id, this.astToFunction(node));
        } else if (node.type == 16) {
            ZPEType value = this.evaluateExpression((IAST)node.value, this.globalFunction);
            byte type = 118;
            if (node.left != null && node.left.type == 62) {
                type = (Byte)node.left.value;
            }
            this.addGlobalVariable(node.middle.id, value, node.scope, type);
        } else if (node.type == 64) {
            String inherits = "";
            if (node.middle != null) {
                inherits = node.middle.id;
            }
            AbstractStructure s = new AbstractStructure(this, node.id, node.left, node.scope, inherits);
            s.code = (IAST)node.value;
            s.access = node.scope;
            this.globalFunction.abstractStructureMap.put(node.id, s);
        } else if (node.type == 110) {
            AbstractRecord r = new AbstractRecord(node.id, node.left, node.scope);
            r.code = (IAST)node.value;
            r.access = node.scope;
            this.globalFunction.abstractRecordMap.put(node.id, r);
        }
        if (node.next != null) {
            this.globalTraverse(node.next);
        }
    }

    String convertCode(String code, String className, ZPESyntaxTranspiler c) throws ZPEException, InternalException {
        if (c == null) {
            throw new TranspilerNotFoundException("Transpiler missing.");
        }
        this.globalFunction.functionMap.clear();
        this.initiateProgram(code);
        try {
            this.globalTraverse(this.globalFunction.code);
        }
        catch (BreakPointHalt | ExitHalt exception) {
            // empty catch block
        }
        return c.transpile(this.globalFunction.code, className);
    }

    ZPEType interpret(String code) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        ZPEType[] parameters = new ZPEType[]{};
        return this.interpret(code, parameters, false);
    }

    ZPEType interpret(String code, ZPEType[] parameters) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        return this.interpret(code, parameters, false);
    }

    ZPEType interpret(String code, ZPEType[] parameters, boolean caseInsensitive) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        ZPEInstance.CASE_INSENSITIVE = caseInsensitive;
        this.initiateProgram(code);
        this.globalFunction.run();
        ZPEFunction mainFunction = this.getMainFunction();
        if (mainFunction != null) {
            ZPEList params = new ZPEList();
            mainFunction.setParent(this.globalFunction);
            params.addAll(Arrays.asList(parameters));
            mainFunction.addParameter("$args");
            mainFunction.setParameter("$args", params);
            return mainFunction.run();
        }
        return null;
    }

    void printCodeTree(String code) throws CompileException, ZPERuntimeException {
        YASSCompiler c = new YASSCompiler();
        IAST rootNode = c.compile(code);
        ZPECore.print("Parse tree of program:");
        ZPECore.print("");
        ZPECore.print(ZPECore.ASTtoString(rootNode.next, 0));
        ZPECore.print("");
    }

    Class<? extends ZPEInternalFunction> getInternalMethod(String s) {
        return YASSPredefinedFunctions.getInternalMethod(s);
    }

    public String toString() {
        return "" + this.hashCode();
    }

    byte[] parseToBytes(String code) {
        ZenithParsingEngine parser = new ZenithParsingEngine(code, ZPEInstance.CASE_INSENSITIVE, new YASSByteCodes());
        ArrayList<Byte> out = new ArrayList<Byte>();
        parser.getNextSymbol();
        int pos = 0;
        while (parser.getCurrentSymbol() != -2) {
            out.add(parser.getCurrentSymbol());
            parser.getNextSymbol();
        }
        byte[] arr = new byte[out.size()];
        Iterator iterator2 = out.iterator();
        while (iterator2.hasNext()) {
            byte s = (Byte)iterator2.next();
            arr[pos++] = s;
        }
        return arr;
    }

    ZPEType runInternalFunction(String name, IAST parameters) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (name.equals("return") || name.equals("is_set") || name.equals("unset") || name.equals("!")) {
            throw new ZPERuntimeException("Internal function " + name + " cannot be accessed.");
        }
        return this.evaluateFunction(name, parameters);
    }

    ZPEType runCode(String code, HashMap<String, ZPEType> params) throws CompileException, ZPERuntimeException, ExitHalt, BreakPointHalt {
        YASSCompiler c = new YASSCompiler();
        IAST root = c.compile(code);
        return this.runCode(root, params);
    }

    ZPEType runCode(IAST code, HashMap<String, ZPEType> params) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        this.globalFunction.variableMap.clear();
        this.globalFunction.functionMap.clear();
        if (params != null) {
            for (String param2 : params.keySet()) {
                this.globalFunction.variableMap.put(param2, new ZPEVariable(param2, params.get(param2), this.globalFunction));
            }
        }
        this.globalFunction.code = code;
        return this.globalFunction.run();
    }

    ZPEType runCode(IAST code, ZPEType[] params) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        this.globalFunction.code = code;
        ZPEType z = this.globalFunction.run();
        ZPEFunction f = this.getMainFunction();
        if (f != null) {
            ZPEList parameters = new ZPEList();
            parameters.addAll(Arrays.asList(params));
            f.addParameter("$args");
            f.setParameter("$args", parameters);
            return f.run();
        }
        return z;
    }

    private void initiateProgram(String code) throws CompileException, ZPERuntimeException {
        if (code.isEmpty()) {
            return;
        }
        if (!this.retainVariableState) {
            this.globalFunction.functionMap.clear();
            this.globalFunction.variableMap.clear();
        }
        if (this.globalVariables != null) {
            for (String s : this.globalVariables.keySet()) {
                this.globalFunction.setProperty(s, this.globalVariables.get(s));
            }
        }
        Date date = new Date();
        long startTime = Instant.now().toEpochMilli();
        ZPEInstance.StartTime = date;
        this.addSystemVariable();
        YASSCompiler c = new YASSCompiler();
        if (this.globalVariables != null) {
            c.globalVars = this.globalVariables;
        }
        IAST rootNode = c.compile(code);
        if (ZPEInstance.AUTO_PREPEND != null) {
            IAST.getLast((IAST)ZPEInstance.AUTO_PREPEND).next = rootNode.next;
            rootNode.next = ZPEInstance.AUTO_PREPEND;
        }
        if (ZPEInstance.SHOW_COMPILE_COMPLETE_MESSAGE) {
            ZPECore.print("Compile finished: " + (Instant.now().toEpochMilli() - startTime) + "ms");
        }
        if (rootNode.left != null && rootNode.left.value instanceof HashMap) {
            this.labels = (HashMap)rootNode.left.value;
        }
        this.globalFunction.code = rootNode.next;
    }

    private ZPEFunction getMainFunction() {
        if (this.globalFunction.functionMap.containsKey("main")) {
            return this.globalFunction.functionMap.get("main");
        }
        if (this.globalFunction.functionMap.containsKey("start")) {
            return this.globalFunction.functionMap.get("start");
        }
        for (String s : this.modules.keySet()) {
            if (!this.modules.get((String)s).functions.contains("main")) continue;
            return this.modules.get((String)s).functions.get("main");
        }
        return null;
    }

    ZPEType getGlobalVariable(String name) {
        return this.globalFunction.getVariable(name);
    }

    Map<String, ZPEVariable> getGlobalVariables() {
        return (Map)((Object)this.globalFunction.variableMap.toHashMap());
    }

    ZPEType evaluateNode(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        return this.evaluateExpression(node, this.getCurrentFunction());
    }

    private ZPEObject getBuiltInStructure(String id) {
        if (!ZPEInstance.BUILT_IN_STRUCTURES.containsKey(id)) {
            ZPECore.printWarning("No such object \"" + id + "\" found.");
        } else {
            try {
                Class<? extends ZPEStructure> cl = ZPEInstance.BUILT_IN_STRUCTURES.get(id);
                Constructor<? extends ZPEStructure> c = cl.getConstructor(ZPERuntimeEnvironment.class, ZPEPropertyWrapper.class);
                return c.newInstance(this, this.getCurrentFunction());
            }
            catch (NoSuchMethodException e) {
                ZPECore.log("Error in getBuiltInStructure " + e.getMessage() + " as it hasn't been set up correctly.");
            }
            catch (Exception e) {
                ZPECore.log("Error in getBuiltInStructure " + e.getMessage());
                ZPECore.printWarning("Error in the object creation.");
            }
        }
        return null;
    }

    private ZPEObject checkForStructure(String id) throws InternalException {
        if (ZPEInstance.BUILT_IN_STRUCTURES.containsKey(id)) {
            return this.getBuiltInStructure(id);
        }
        if (ZPEInstance.IMPORTED_ZPE_LIBRARY_OBJECTS.containsKey(id)) {
            try {
                Class<?> cl = ZPEInstance.IMPORTED_ZPE_LIBRARY_OBJECTS.get(id);
                Constructor<?> c = cl.getConstructor(ZPERuntimeEnvironment.class, ZPEPropertyWrapper.class);
                return (ZPEObject)c.newInstance(this, (ZPEPropertyWrapper)((Object)this));
            }
            catch (Exception e) {
                ZPECore.log("Structure invalid. " + e.getMessage());
                ZPECore.printWarning("Structure invalid. Turn on errors to read more.");
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSet(IAST p) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType v;
        p = p.left;
        String var = p.id;
        if (p.type == 88) {
            v = this.getCurrentFunction().getVariable(p.left.id);
            ZPEType index = this.evaluateExpression((IAST)p.value, this.getCurrentFunction());
            if (v instanceof ZPEList) {
                long i = HelperFunctions.stringToLong(index.toString());
                if (i < 0L) return false;
                if (i >= (long)((ZPEList)v).size()) return false;
                return true;
            }
            if (v instanceof ZPEMap) {
                ZPEType k = this.evaluateExpression((IAST)p.value, this.getCurrentFunction());
                return ((ZPEMap)v).containsKey(k);
            }
            if (!(v instanceof ZPEString)) return false;
            long i = HelperFunctions.stringToLong(index.toString());
            if ((long)(v.toString().length() - 1) > i) {
                return true;
            }
        } else if (p.type == 66) {
            ZPEObject o = (ZPEObject)this.evaluateNode(p.middle);
            return o.hasInnerValue((IAST)p.value, this.getCurrentFunction());
        }
        if ((v = this.getCurrentFunction().getVariable(var)) == null) return false;
        if (v instanceof Undefined) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean unset(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        node = node.left;
        String var = node.id;
        ZPEFunction cur = this.getCurrentFunction();
        if (node.type == 88) {
            ZPEType v = cur.getVariable(node.left.id);
            ZPEType index = this.evaluateExpression((IAST)node.value, cur);
            if (v instanceof ZPEList) {
                if (!(index instanceof ZPENumber)) return true;
                ((ZPEList)v).removeAt((ZPENumber)index);
                return true;
            } else {
                if (!(v instanceof ZPEMap)) return false;
                ZPEType k = this.evaluateExpression((IAST)node.value, cur);
                ((ZPEMap)v).remove(k);
            }
            return true;
        } else {
            this.getCurrentFunction().removeProperty(var);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    ZPEType evaluateExpression(IAST node, ZPEPropertyWrapper vab) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (node == null) {
            return null;
        }
        value = null;
        block1 : switch (node.type) {
            case 8: {
                value = new ZPEString(node.value.toString());
                break;
            }
            case 5: 
            case 6: {
                value = new ZPENumber(HelperFunctions.stringToDouble(node.value.toString()));
                break;
            }
            case 124: {
                f = new FunctionReference(this, this.getCurrentFunction());
                if (this.getCurrentFunction().getFunction(node.id) != null) {
                    f.setRef(node.id, this.getCurrentFunction().getFunction(node.id).getInstanceOfMe());
                    value = f;
                    break;
                }
                if (YASSPredefinedFunctions.hasInternalMethod(node.id)) {
                    f.setRef(node.id, this.getInternalMethod(node.id));
                    value = f;
                    break;
                }
                if (YASSPredefinedFunctions.hasInternalAlias(node.id)) {
                    f.setRef(node.id, ZPEInstance.BUILT_IN_COMMANDS.getInternalMethodFromAlias(node.id));
                    value = f;
                    break;
                }
                value = ZPECore.UNDEFINED;
                break;
            }
            case 90: {
                if (node.left == null) ** GOTO lbl42
                bytes = new ArrayList<Byte>();
                current = node.left;
                while (current != null) {
                    bytes.add(current.type);
                    current = current.next;
                }
                obytes = new byte[bytes.size()];
                for (i = 0; i < bytes.size(); ++i) {
                    obytes[i] = (Byte)bytes.get(i);
                }
                value = new ZPETuple(obytes);
                ** GOTO lbl52
lbl42:
                // 1 sources

                if (node.middle != null) {
                    if (!this.getCurrentFunction().hasVariable(node.id)) {
                        throw new ZPERuntimeException("No tuple with the ID " + node.id + " has been defined.");
                    }
                    t = (ZPETuple)this.getCurrentFunction().getVariable(node.id);
                    params = this.generateArguments(node.middle);
                    i = 0;
                    for (ZPEType param : params) {
                        t.setValue(param, i++);
                    }
                    value = t;
                }
            }
lbl52:
            // 5 sources

            case 111: {
                current = this.getCurrentFunction().getVariable(node.id);
                if (!(current instanceof ZPERecord)) break;
                value = ((ZPERecord)current).getField(node.left.id);
                break;
            }
            case 115: {
                valuesNode = node.left;
                lower = this.evaluateExpression(valuesNode.left, vab);
                upper = this.evaluateExpression(valuesNode.middle, vab);
                list = new ZPEList();
                if (node.middle != null) {
                    f = (ZPEFunction)this.evaluateExpression(node.middle, vab);
                    for (i = ((ZPENumber)lower).doubleValue(); i < ((ZPENumber)upper).doubleValue(); i += 1.0) {
                        if (!f.parameterNames.isEmpty()) {
                            f.setParameter(f.parameterNames.get(0), new ZPENumber(i));
                        }
                        list.add(f.run());
                    }
                } else {
                    for (i = ((ZPENumber)lower).doubleValue(); i < ((ZPENumber)upper).doubleValue(); i += 1.0) {
                        list.add(new ZPENumber(i));
                    }
                }
                value = list;
                break;
            }
            case 3: {
                value = this.evaluateFunction(node);
                break;
            }
            case 114: {
                System.out.println(node.id);
            }
            case 101: {
                if (node.middle != null) {
                    value = this.evaluateNode(node.middle.left);
                }
                comparator = this.evaluateNode((IAST)node.value);
                current = node.left;
                while (current != null) {
                    currentValue = this.evaluateNode(current.left);
                    if (this.LAME.evaluateEquality(currentValue, comparator)) {
                        value = this.evaluateNode(current.middle);
                        break block1;
                    }
                    current = current.next;
                }
                break;
            }
            case 99: {
                output = new StringBuilder();
                current = (IAST)node.value;
                while (current != null) {
                    if (current.type == 8) {
                        output.append(current.value.toString());
                    } else {
                        output.append(this.evaluateNode(current).toString());
                    }
                    current = current.next;
                }
                value = new ZPEString(output.toString());
                break;
            }
            case 95: {
                params = this.generateArguments(node.left);
                o = params[0];
                if (o instanceof ZPEList) {
                    value = new ZPENumber(((ZPEList)o).size());
                    break;
                }
                if (o instanceof ZPEMap) {
                    value = new ZPENumber(((ZPEMap)o).size());
                    break;
                }
                if (o instanceof ZPEString) {
                    value = new ZPENumber(o.toString().length());
                    break;
                }
                value = new ZPENumber(-1);
                break;
            }
            case -15: {
                y = new YASSByteCodes();
                v = this.evaluateExpression((IAST)node.value, this.getCurrentFunction());
                if (v instanceof ZPEString) {
                    value = new ZPEString("STRING");
                    break;
                }
                if (v instanceof ZPEObject) {
                    value = new ZPEString("OBJECT");
                    break;
                }
                if (v instanceof ZPERecord) {
                    value = new ZPEString("RECORD");
                    break;
                }
                if (v instanceof ZPENumber) {
                    value = new ZPEString("NUMBER");
                    break;
                }
                if (v instanceof ZPEBoolean) {
                    value = new ZPEString("BOOLEAN");
                    break;
                }
                value = new ZPEString(y.symbolToString(ZPEHelperFunctions.getDataType(v)).toUpperCase());
                break;
            }
            case 14: {
                value = new ZPEBoolean(this.isSet(node));
                break;
            }
            case 15: {
                value = new ZPEBoolean(this.unset(node));
                break;
            }
            case 13: {
                params = this.generateArguments(node.left);
                o = params[0];
                if (o instanceof ZPEList) {
                    value = new ZPEBoolean(((ZPEList)o).isEmpty());
                    break;
                }
                if (o instanceof ZPEMap) {
                    value = new ZPEBoolean(((ZPEMap)o).isEmpty());
                    break;
                }
                if (o instanceof ZPEString) {
                    value = new ZPEBoolean(o.toString().isEmpty());
                    break;
                }
                if (o instanceof ZPEObject) {
                    value = new ZPEBoolean(((ZPEObject)o).isEmpty());
                    break;
                }
                value = new ZPENumber(-1);
                break;
            }
            case 86: {
                q = this.generateArguments((IAST)node.value);
                if (q[0] instanceof ZPENumber) {
                    value = ((ZPENumber)q[0]).negate();
                    break;
                }
                if (q[0] instanceof ZPEBoolean) {
                    value = ((ZPEBoolean)q[0]).invert();
                    break;
                }
                return new ZPEBoolean(false);
            }
            case -4: {
                break;
            }
            case -11: {
                x = this.evaluateExpression(node.left, vab);
                value = ZPEHelperFunctions.typeCast(x, node.middle.type);
                break;
            }
            case 67: {
                currentFunc = this.getCurrentFunction();
                s = this.evaluateExpression(node.left, currentFunc);
                if (!(s instanceof ZPEMemberType)) {
                    throw new IncorrectDataTypeException("Chainable Type", "Chained method");
                }
                obj = (ZPEMemberType)s;
                obj.setParent(this);
                f = (IAST)node.value;
                if (f.type == 3) {
                    obj = obj.runNative(f, this.generateArguments((IAST)f.value));
                    value = obj.getReturnValue();
                    break;
                }
                if (obj instanceof ZPERecord) {
                    value = ((ZPERecord)obj).getField(((IAST)node.value).id);
                    break;
                }
                value = ZPECore.UNDEFINED;
                break;
            }
            case 12: {
                f = new ZPEFunction(this, "", node.left, true);
                if (node.returnTypes != null) {
                    f.returnTypes = node.returnTypes;
                }
                f.parent = this.getCurrentFunction();
                current_node = (IAST)node.value;
                working = true;
                while (working) {
                    if (current_node != null) {
                        id = current_node.id;
                        if (this.isExpression(current_node.type)) {
                            id = ((IAST)current_node.value).id;
                        }
                        if (current_node.type == -7) {
                            f.acceptInfiniteParams = true;
                            f.addParameter(id);
                        } else if (current_node.type == -13) {
                            id = current_node.left.id;
                            f.addParameter(id, current_node.middle.type);
                        } else {
                            f.addParameter(id);
                        }
                    }
                    if (current_node != null) {
                        current_node = current_node.next;
                        continue;
                    }
                    working = false;
                }
                if (node.middle != null) {
                    parameters = this.generateArguments(node.middle);
                    pos = 0;
                    if (!f.acceptInfiniteParams && parameters.length > f.parameterNames.size()) {
                        parameters = ZPERuntimeEnvironment.sortArguments(parameters, f.parameterNames.size());
                        ZPECore.printWarning("too many arguments for the function `" + f.name + "`.");
                    }
                    for (ZPEType p : parameters) {
                        id = f.parameterNames.get(pos);
                        f.setParameter(id, p);
                        ++pos;
                    }
                    value = f.run();
                    break;
                }
                value = f;
                break;
            }
            case 71: {
                parameters = this.generateArguments((IAST)node.value);
                v = vab.getVariable(node.left.id);
                if (v instanceof FunctionReference) {
                    f = (FunctionReference)v;
                    value = f.execute((IAST)node.value);
                    break;
                }
                if (!(v instanceof ZPEFunction)) {
                    throw new IncorrectDataTypeException("function", "lambda call");
                }
                f = (ZPEFunction)v;
                pos = 0;
                if (!f.acceptInfiniteParams && parameters.length > f.parameterNames.size()) {
                    parameters = ZPERuntimeEnvironment.sortArguments(parameters, f.parameterNames.size());
                    ZPECore.printWarning("too many arguments for the function " + f.name + ".");
                }
                for (ZPEType p : parameters) {
                    id = f.parameterNames.get(pos);
                    f.setParameter(id, p);
                    ++pos;
                }
                value = f.run();
                break;
            }
            case 16: {
                this.getCurrentFunction().assignVariable(node);
                value = this.getCurrentFunction().getVariable(node.middle.id);
                break;
            }
            case 88: {
                variable = this.evaluateExpression(node.left, vab);
                if (node.value != null && ((IAST)node.value).type == 74) {
                    indices = (IAST)node.value;
                    index = new Pair(this.evaluateNode(indices.left), this.evaluateNode(indices.middle));
                } else {
                    index = this.evaluateExpression((IAST)node.value, vab);
                }
                try {
                    value = ZPERuntimeEnvironment.getIndex(variable, index);
                }
                catch (UnacceptableTypeException e) {
                    ZPECore.printWarning(e.getMessage());
                }
                break;
            }
            case 65: {
                if (!(vab instanceof ZPEEntity)) break;
                found = false;
                id = node.id;
                if (id.contains("::")) {
                    parts = id.split("::");
                    m = this.modules.get(parts[0]);
                    value = m.getStructure(parts[1], this.getCurrentFunction());
                    found = true;
                } else {
                    current = vab;
                    while (current != null && !found) {
                        currentEntity = (ZPEEntity)current;
                        if (currentEntity.hasRecord(id)) {
                            value = currentEntity.generateRecord(node, (ZPEFunction)current);
                            found = true;
                        } else if (currentEntity.hasStructure(id)) {
                            if (current instanceof ZPEFunction) {
                                value = currentEntity.generateStructure(node, (ZPEFunction)current);
                            } else if (current instanceof ZPEModule) {
                                value = currentEntity.generateStructure(node, (ZPEModule)current);
                            }
                            found = true;
                        }
                        if (found) continue;
                        current = current.getParent();
                    }
                }
                if (!found) {
                    value = this.checkForStructure(id);
                    if (value != null) {
                        ((ZPEObject)value).construct((IAST)node.value);
                    }
                } else if (value instanceof ZPEObject) {
                    ((ZPEObject)value).construct((IAST)node.value);
                }
                if (value != null) break;
                ZPECore.printWarning("Structure " + id + " not found.");
                break;
            }
            case 66: {
                value = this.accessorEvaluate(node);
                break;
            }
            case 4: {
                i = node.id;
                if (i.contains("~")) {
                    parts = i.split("~");
                    m = this.modules.get(parts[0]);
                    value = m.getVariable(parts[1]);
                    break;
                }
                value = vab.getVariable(i);
                if (!(value instanceof ZPECoreType)) break;
                value = ((ZPECoreType)value).copyOfMe();
                break;
            }
            case 87: {
                i = node.id;
                return vab.getVariable(i);
            }
            case 45: {
                i = node.id;
                value = vab.getVariable(i);
                ((ZPENumber)value).increment(1);
                vab.setProperty(i, value);
                break;
            }
            case 47: {
                i = node.id;
                value = vab.getVariable(i);
                ((ZPENumber)value).decrement(1);
                vab.setProperty(i, value);
                break;
            }
            case 44: {
                i = node.id;
                value = vab.getVariable(i);
                tmp = (ZPENumber)value;
                value = new ZPENumber(tmp.doubleValue() + 1.0);
                tmp.increment(1);
                vab.setProperty(i, tmp);
                break;
            }
            case 46: {
                i = node.id;
                value = vab.getVariable(i);
                tmp = (ZPENumber)value;
                value = new ZPENumber(tmp.doubleValue() + 1.0);
                tmp.decrement(1);
                vab.setProperty(i, tmp);
                break;
            }
            case 48: {
                i = node.id;
                v = (ZPENumber)vab.getVariable(i);
                val = (IAST)node.value;
                inc = (ZPENumber)this.evaluateExpression(val, this.getCurrentFunction());
                v.increment(inc.doubleValue());
                vab.setProperty(i, v);
                value = v;
                break;
            }
            case 49: {
                i = node.id;
                v = (ZPENumber)vab.getVariable(i);
                val = (IAST)node.value;
                inc = (ZPENumber)this.evaluateExpression(val, this.getCurrentFunction());
                v.decrement(inc.doubleValue());
                vab.setProperty(i, v);
                value = v;
                break;
            }
            case 102: {
                i = node.id;
                v = (ZPENumber)vab.getVariable(i);
                val = (IAST)node.value;
                inc = (ZPENumber)this.evaluateExpression(val, this.getCurrentFunction());
                v.setValue(v.doubleValue() * inc.doubleValue());
                vab.setProperty(i, v);
                value = v;
                break;
            }
            case 103: {
                i = node.id;
                v = (ZPENumber)vab.getVariable(i);
                val = (IAST)node.value;
                inc = (ZPENumber)this.evaluateExpression(val, this.getCurrentFunction());
                v.setValue(v.doubleValue() / inc.doubleValue());
                vab.setProperty(i, v);
                value = v;
                break;
            }
            case 104: {
                i = node.id;
                v = (ZPENumber)vab.getVariable(i);
                val = (IAST)node.value;
                inc = (ZPENumber)this.evaluateExpression(val, this.getCurrentFunction());
                v.setValue(Math.pow(v.doubleValue(), inc.doubleValue()));
                vab.setProperty(i, v);
                value = v;
                break;
            }
            case 9: {
                zo = new ZPEObject(this, this.getCurrentFunction(), "object");
                zo.anonymous = true;
                current = (IAST)node.value;
                while (current != null) {
                    v = this.evaluateExpression((IAST)current.value, this.getCurrentFunction());
                    zo.setProperty(current.id, v, (byte)2, (byte)118);
                    current = current.next;
                }
                value = zo;
                break;
            }
            case 10: {
                if (node.value == null) {
                    if (node.left != null) {
                        times = HelperFunctions.stringToLong(this.evaluateExpression(node.left, this.getCurrentFunction()).toString());
                        value = new ZPEArray(null, times);
                        break;
                    }
                    value = new ZPEList();
                    break;
                }
                items = this.generateArguments((IAST)node.value);
                if (node.left != null) {
                    times = HelperFunctions.stringToLong(this.evaluateExpression(node.left, this.getCurrentFunction()).toString());
                    base = items[0];
                    value = new ZPEArray(base, times);
                    break;
                }
                value = new ZPEList();
                for (ZPEType t : items) {
                    ((ZPEList)value).add(t);
                }
                break;
            }
            case 11: {
                if (node.value == null) {
                    value = new ZPEMap();
                    break;
                }
                value = this.generateMap(node);
                break;
            }
            case 91: {
                val = (IAST)node.value;
                if (val.type == 4) {
                    v = vab.getVariable(val.id);
                    if (!(v instanceof ZPENumber)) break;
                    value = ((ZPENumber)v).negate();
                    break;
                }
                if (val.type == 5 || val.type == 6) {
                    n = new ZPENumber((Number)val.value);
                    value = n.negate();
                    break;
                }
                if (val.type != 7) break;
                b = new ZPEBoolean((Boolean)val.value);
                value = b.invert();
                break;
            }
            case 7: {
                value = new ZPEBoolean(ZPEHelperFunctions.ToBoolean(node.value));
                break;
            }
            default: {
                if (!this.isExpression(node.type)) break;
                value = this.LAME.evaluateExpressions(node);
            }
        }
        return value;
    }

    ZPEFunction astToFunction(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEFunction f = new ZPEFunction(this, node.id, node, false);
        if (node.middle != null && node.middle.type == 72) {
            f.documentation = node.middle.value;
        }
        if (node.returnTypes != null) {
            f.returnTypes = node.returnTypes;
        }
        f.scope = node.scope;
        IAST current_node = (IAST)node.value;
        boolean working = true;
        while (working) {
            if (current_node != null) {
                String id = current_node.id;
                if (current_node.type == 16) {
                    id = current_node.middle.id;
                    ZPEType value = this.evaluateExpression((IAST)current_node.value, this.getCurrentFunction());
                    f.addParameter(id, (byte)118);
                    f.setParameter(id, value);
                } else if (current_node.type == -13) {
                    id = current_node.left.id;
                    f.addParameter(id, current_node.middle.type);
                } else {
                    if (current_node.type == -7) {
                        f.acceptInfiniteParams = true;
                    }
                    f.addParameter(id, (byte)118);
                    f.setParameter(id, null);
                }
            }
            if (current_node != null && current_node.next != null) {
                current_node = current_node.next;
                continue;
            }
            working = false;
        }
        return f;
    }

    private void addFunction(String id, ZPEFunction f) {
        if (ZPEInstance.CASE_INSENSITIVE) {
            id = id.toLowerCase();
        }
        f.parent = this.globalFunction;
        this.globalFunction.functionMap.put(id, f);
    }

    void addGlobalVariable(String name, ZPEType value, int scope, byte type) throws ZPERuntimeException {
        if (this.globalFunction.variableMap.containsKey(name)) {
            this.globalFunction.getRawVariable(name).setValue(value);
        } else {
            this.globalFunction.variableMap.put(name, new ZPEVariable(name, value, (byte)scope, this.globalFunction, type));
        }
    }

    void removeGlobalVariable(String name) {
        this.globalFunction.removeProperty(name);
    }

    boolean globalVariableExists(String name) {
        return this.globalFunction.variableMap.containsKey(name);
    }

    private Set<Map.Entry<String, ZPEVariable>> getGlobalVariableEntrySet() {
        return this.globalFunction.variableMap.entrySet();
    }

    Set<String> getGlobalVariableKeyset() {
        return this.globalFunction.variableMap.keySet();
    }

    ZPEType accessorEvaluate(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEFunction currentFunc = this.getCurrentFunction();
        ZPEType parent = node.middle != null && node.middle.type == 70 ? currentFunc.getParentObject() : this.evaluateExpression(node.middle, currentFunc);
        if (!(parent instanceof ZPEObject)) {
            throw new IncorrectDataTypeException("object or structure", "accessor evaluate");
        }
        ZPEObject obj = (ZPEObject)parent;
        obj.setRuntime(this);
        obj = obj.getInnerValue((IAST)node.value, this.getCurrentFunction());
        return obj.getReturnValue();
    }

    Object indexEvaluate(IAST node) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEFunction currentFunc = this.getCurrentFunction();
        ZPEType s = node.middle != null && node.middle.type == 70 ? currentFunc.getParentObject() : this.evaluateExpression(node.middle, currentFunc);
        if (!(s instanceof ZPEObject)) {
            throw new IncorrectDataTypeException("object or structure", "accessor evaluation");
        }
        ZPEObject obj = (ZPEObject)s;
        obj.setRuntime(this);
        obj = obj.getInnerValue((IAST)node.value, this.getCurrentFunction());
        return obj.getReturnValue();
    }

    ZPEType evaluateFunction(IAST node) throws ZPERuntimeException, ExitHalt, BreakPointHalt, ZPEException {
        if (this.currentStackDepth >= 1024) {
            throw new StackFrameDepthExceeded();
        }
        ++this.currentStackDepth;
        String id = node.id;
        try {
            IAST argumentAST = (IAST)node.value;
            ZPEType value = this.evaluateFunction(id, argumentAST);
            if (node.left != null && node.left.type == 88) {
                ZPEType index = this.evaluateExpression((IAST)node.value, this.getCurrentFunction());
                try {
                    value = ZPERuntimeEnvironment.getIndex(value, index);
                }
                catch (UnacceptableTypeException e) {
                    ZPECore.printWarning(e.getMessage());
                }
            }
            --this.currentStackDepth;
            return value;
        }
        catch (ClassCastException e) {
            System.out.println(e.getMessage());
            ZPECore.log(e.getMessage());
            if (node.type == 3) {
                ZPECore.printError("Function call to `" + node.id + " " + node.value.toString() + "` not configured correctly or incorrect call syntax.");
            }
            --this.currentStackDepth;
            return null;
        }
    }

    ZPEType evaluateFunction(String id, IAST paramsAST) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEType out;
        if ((YASSPredefinedFunctions.hasInternalMethod(id) || YASSPredefinedFunctions.hasInternalAlias(id) || ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.containsKey(id)) && !((out = ZPEInstance.BUILT_IN_COMMANDS.runFunction(id, paramsAST, this)) instanceof UndefinedPath)) {
            return out;
        }
        ZPEFunction current = this.getCurrentFunction();
        ZPEType[] parameters = this.generateArguments(paramsAST);
        ZPEFunction f = current.getFunction(id);
        if (f == null && this.globalFunction.functionMap.containsKey(id)) {
            f = this.globalFunction.functionMap.get(id);
        }
        if (f != null) {
            int pos = 0;
            if (!f.acceptInfiniteParams && parameters.length > f.parameterNames.size()) {
                parameters = ZPERuntimeEnvironment.sortArguments(parameters, f.parameterNames.size());
                ZPECore.printWarning("too many arguments for the function " + f.name + ".");
            }
            f = f.getInstanceOfMe();
            String infParamName = "";
            ZPEList listVariableValue = null;
            if (f.acceptInfiniteParams) {
                listVariableValue = new ZPEList();
                infParamName = f.parameterNames.get(f.parameterNames.size() - 1);
            }
            for (ZPEType p : parameters) {
                Object n;
                if (f.acceptInfiniteParams && pos >= f.parameterNames.size() - 1) {
                    n = infParamName + (pos - f.parameterNames.size() + 1);
                    assert (listVariableValue != null);
                    listVariableValue.add(p);
                } else {
                    n = f.parameterNames.get(pos);
                }
                f.addParameter((String)n);
                f.setParameter((String)n, p);
                ++pos;
            }
            if (f.acceptInfiniteParams) {
                f.addParameter(infParamName);
                f.setParameter(infParamName, listVariableValue);
            }
            return f.run();
        }
        if (ZPEInstance.ERROR_LEVEL >= 1) {
            if (Arrays.asList(ZPEInstance.DISABLED_COMMANDS).contains(id)) {
                ZPECore.printWarning("The function call to `" + id + "` lead to an undefined path because it is disabled by the system properties.");
            } else {
                ZPECore.printWarning("The function call to `" + id + "` lead to an undefined path.");
            }
        }
        return ZPECore.UNDEFINED;
    }

    ZPEType runFunction(ZPEFunction f, ZPEType[] arguments) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        if (f != null) {
            int pos = 0;
            if (!f.acceptInfiniteParams && arguments.length > f.parameterNames.size()) {
                arguments = ZPERuntimeEnvironment.sortArguments(arguments, f.parameterNames.size());
            }
            for (ZPEType p : arguments) {
                String id = f.parameterNames.get(pos);
                f.setParameter(id, p);
                ++pos;
            }
            return f.run();
        }
        return null;
    }

    Object substitute(String s) {
        if (this.getCurrentFunction() != null) {
            return this.getCurrentFunction().getVariable(s);
        }
        return null;
    }

    private ZPEMap generateMap(IAST a) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ZPEMap s = new ZPEMap();
        boolean working = true;
        IAST currentNode = (IAST)a.value;
        while (working) {
            ZPEType key = this.LAME.evaluateExpressions(currentNode);
            if (currentNode.next == null) {
                throw new IncorrectDataTypeException("association", "generate map");
            }
            currentNode = currentNode.next;
            ZPEType value = this.LAME.evaluateExpressions(currentNode);
            if (key != null || value != null) {
                s.put(key, value);
            }
            if (currentNode.next != null) {
                currentNode = currentNode.next;
                continue;
            }
            working = false;
        }
        return s;
    }

    boolean importLib(String f, String objectID) {
        File m = new File(f);
        if (!m.exists()) {
            if (!m.getAbsolutePath().endsWith(".yex")) {
                m = new File(f + ".yex");
            }
            if (!m.exists()) {
                m = new File(ZPEInstance.ZPE_LIBRARY_IMPORT_DIRECTORY + f);
            }
            if (!m.getAbsolutePath().endsWith(".yex")) {
                m = new File(ZPEInstance.ZPE_LIBRARY_IMPORT_DIRECTORY + f + ".yex");
            }
        }
        try {
            if (m.exists()) {
                this.includeLibrary(m.getAbsolutePath(), objectID);
                return true;
            }
            ZPECore.printWarning("Library file " + m.getAbsolutePath() + " not found.");
            return false;
        }
        catch (Exception e) {
            ZPECore.log("Could not import library " + m.getAbsolutePath() + ". " + e.getMessage());
            return false;
        }
    }

    void includeLibrary(String f, String objectID) throws ZPERuntimeException {
        ZPERuntimeEnvironment temporary_interpreter = new ZPERuntimeEnvironment(this.permission_level);
        try {
            temporary_interpreter.openCompiledFile(f, null);
        }
        catch (Exception e) {
            ZPECore.log("Could not import library " + f + ". " + e.getMessage());
            throw new ZPERuntimeException("Could not import library " + f + ". ");
        }
        if (objectID == null) {
            for (String fun : temporary_interpreter.globalFunction.functionMap.keySet()) {
                if (temporary_interpreter.globalFunction.functionMap.get((String)fun).scope == 1) continue;
                this.globalFunction.functionMap.put(fun, temporary_interpreter.globalFunction.functionMap.get(fun));
            }
            for (String struc : temporary_interpreter.globalFunction.abstractStructureMap.keySet()) {
                if (((AbstractStructure)temporary_interpreter.globalFunction.abstractStructureMap.get((Object)struc)).access == 1) continue;
                this.globalFunction.abstractStructureMap.put(struc, (AbstractStructure)temporary_interpreter.globalFunction.abstractStructureMap.get(struc));
            }
        } else if (!ZPEInstance.IMPORTED_YASS_LIBRARIES.contains(objectID)) {
            ZPEObject ownerObj = new ZPEObject(this, this.globalFunction, objectID);
            for (Map.Entry<String, ZPEVariable> entry : temporary_interpreter.getGlobalVariableEntrySet()) {
                ZPEVariable var = entry.getValue();
                ownerObj.properties.put(entry.getKey(), var);
            }
            for (Map.Entry<String, Serializable> entry : temporary_interpreter.globalFunction.functionMap.entrySet()) {
                if (entry.getKey().equals("main") || entry.getKey().equals("start")) continue;
                ZPEFunction func = (ZPEFunction)entry.getValue();
                func.parent = ownerObj;
                ownerObj.properties.put(entry.getKey(), new ZPEVariable(entry.getKey(), func, func.scope, ownerObj, 118));
            }
            for (Map.Entry<String, Serializable> entry : temporary_interpreter.globalFunction.structureMap.entrySet()) {
                ZPEStructure struct = (ZPEStructure)entry.getValue();
                struct.parent = ownerObj;
                ownerObj.setProperty(entry.getKey(), struct);
            }
            ownerObj.setId(objectID);
            ZPEStructure s = new ZPEStructure(this, this.globalFunction, objectID);
            s.properties = ownerObj.properties.clone();
            s.abstractStructureMap = (HashMap)((HashMap)ownerObj.abstractStructureMap).clone();
            this.globalFunction.structureMap.put(objectID, s);
            ZPEInstance.IMPORTED_YASS_LIBRARIES.add(objectID);
        }
    }

    Object getInternalFunction(String id) {
        if (YASSPredefinedFunctions.hasInternalMethod(id)) {
            return YASSPredefinedFunctions.getInternalMethod(id);
        }
        if (ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.containsKey(id)) {
            return ZPEPluginManager.IMPORTED_CUSTOM_COMMANDS.get(id);
        }
        if (YASSPredefinedFunctions.hasInternalAlias(id)) {
            return ZPEInstance.BUILT_IN_COMMANDS.getInternalMethodFromAlias(id);
        }
        return null;
    }

    boolean isExpression(int symbol) {
        return symbol == -9 || symbol == -8;
    }

    Object runZPEFunction(ZPEFunction f) throws ExitHalt, ZPERuntimeException, BreakPointHalt {
        return f.run();
    }

    ZPEType[] generateArguments(IAST a) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        ArrayList<ZPEType> s = new ArrayList<ZPEType>();
        IAST currentNode = a;
        if ((a.type == -1 || a.type == -6) && a.value == null && a.next == null) {
            return new ZPEType[0];
        }
        if (a.type == -6 && a.next != null) {
            currentNode = a.next;
        }
        while (true) {
            ZPEType value;
            if ((value = this.evaluateExpression(currentNode, this.getCurrentFunction())) instanceof ZPEMultipleReturnArray) {
                value = ((ZPEMultipleReturnArray)value).toList();
            }
            s.add(value);
            if (currentNode.next == null) break;
            currentNode = currentNode.next;
        }
        ZPEType[] output = new ZPEType[s.size()];
        int i = 0;
        Iterator iterator2 = s.iterator();
        while (iterator2.hasNext()) {
            ZPEType t;
            output[i] = t = (ZPEType)iterator2.next();
            ++i;
        }
        return output;
    }

    static boolean isAssignedValueOfType(byte type, byte value) {
        if (type == 119 && value == 8) {
            return true;
        }
        if (type == 120 && (value == 5 || value == 6)) {
            return true;
        }
        if (type == 121 && value == 7) {
            return true;
        }
        if (type == 122 && value == 10) {
            return true;
        }
        if (type == 122 && value == 11) {
            return true;
        }
        if (type == 124 && value == 12) {
            return true;
        }
        return type == 125;
    }

    ZPEFunction getCurrentFunction() {
        if (!this.callStack.isEmpty()) {
            return this.callStack.peek();
        }
        return this.globalFunction;
    }

    void pushToCallStack(ZPEFunction f) {
        this.callStack.push(f);
    }

    void removeFromCallStack() {
        this.callStack.pop();
    }

    protected void addSystemVariable() throws ZPERuntimeException {
        ZPEMap sys = new ZPEMap();
        sys.put(new ZPEString("HOME_DIR"), new ZPEString(System.getProperty("user.home")));
        sys.put(new ZPEString("EXEC_PATH"), new ZPEString(ZPEInstance.EXECUTABLE_PATH));
        sys.put(new ZPEString("CWD"), new ZPEString(ZPEInstance.CWD));
        sys.put(new ZPEString("DOCUMENT_ROOT"), new ZPEString(ZPEInstance.DOCUMENT_ROOT));
        sys.put(new ZPEString("SCRIPT_PATH"), new ZPEString(ZPEInstance.SCRIPT_PATH.getAbsolutePath()));
        sys.put(new ZPEString("AVAILABLE_PROCESSORS"), new ZPEString("" + Runtime.getRuntime().availableProcessors()));
        DateObject d = new DateObject(this, this.globalFunction);
        d.setDate(ZPEInstance.StartTime);
        sys.put(new ZPEString("START_TIME"), d);
        sys.put(new ZPEString("CURRENT_USER"), new ZPEString(System.getProperty("user.name", "")));
        sys.put(new ZPEString("TMP_DIR"), new ZPEString(System.getProperty("java.io.tmpdir", "")));
        this.globalFunction.setProperty("$_SYSTEM", sys);
    }

    private static ZPEType[] sortArguments(ZPEType[] args2, int len) {
        ZPEType[] duplicate = new ZPEType[len];
        System.arraycopy(args2, 0, duplicate, 0, len);
        return duplicate;
    }

    static ZPEType constructTraverse(IAST node, ZPEFunction func, ZPERuntimeEnvironment runtime) throws ZPEException, ExitHalt, BreakPointHalt, InternalException {
        if (func.mustReturn) {
            return func.lastReturn;
        }
        block1 : switch (node.type) {
            case 85: {
                func.breakBubbles = 1;
                return null;
            }
            case 82: {
                String objId = null;
                if (node.value != null) {
                    objId = node.value.toString();
                }
                return new ZPEBoolean(runtime.importLib(node.id, objId));
            }
            case 16: {
                func.assignVariable(node);
                return null;
            }
            case 89: {
                ZPEType value = runtime.evaluateExpression((IAST)node.value, func);
                if (!(value instanceof Iterable)) {
                    throw new ZPERuntimeException("Not type iterable");
                }
                IAST cur = node.left;
                int tupleSize = 1;
                while (cur.next != null) {
                    ++tupleSize;
                    cur = cur.next;
                }
                cur = node.left;
                int i = 0;
                ArrayList<ZPEType> items = new ArrayList<ZPEType>();
                for (ZPEType o : (Iterable)((Object)value)) {
                    items.add(o);
                }
                if (items.size() < tupleSize) {
                    throw new ZPERuntimeException("Not enough elements in deconstructor assignment");
                }
                while (cur != null) {
                    ZPEType o = (ZPEType)items.get(i++);
                    if (value instanceof ZPEMap) {
                        ZPEMap tmp = new ZPEMap();
                        tmp.put(o, ((ZPEMap)value).get(o));
                        func.setProperty(cur.id, tmp);
                    } else {
                        func.setProperty(cur.id, o);
                    }
                    cur = cur.next;
                }
                break;
            }
            case 114: {
                if (func.variableMap.containsKey(node.id)) {
                    runtime.globalFunction.variableMap.put(node.id, func.variableMap.get(node.id));
                } else {
                    Thread.dumpStack();
                    ZPECore.printError(node.id + " not previously defined");
                }
                return null;
            }
            case 15: {
                return new ZPEBoolean(runtime.unset(node));
            }
            case 113: {
                AbstractStructure s = runtime.getCurrentFunction().getAbstractStructure(node.id);
                if (s.hasStaticFunction(node.left.id)) {
                    ZPEFunction f = s.getStaticFunction(node.left.id);
                    ZPEType[] parameters = runtime.generateArguments((IAST)node.left.value);
                    return runtime.runFunction(f, parameters);
                }
                throw new ZPERuntimeException("No static function " + node.id + "::" + node.left.id + " defined ");
            }
            case 64: {
                String inherits = "";
                if (node.middle != null) {
                    inherits = node.middle.id;
                }
                AbstractStructure s = new AbstractStructure(runtime, node.id, (IAST)node.value, node.scope, inherits);
                s.access = node.scope;
                func.abstractStructureMap.put(node.id, s);
                return null;
            }
            case -17: {
                ZPEModule m = new ZPEModule(runtime, node.id, (IAST)node.value);
                return m;
            }
            case -19: {
                System.out.println("LABEL: " + node.id);
                return new ZPEString("Hello");
            }
            case 110: {
                AbstractRecord s = new AbstractRecord(node.id, (IAST)node.value, node.scope);
                func.abstractRecordMap.put(node.id, s);
                return null;
            }
            case 48: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                IAST val = (IAST)node.value;
                ((ZPENumber)value).increment((ZPENumber)runtime.evaluateExpression(val, func));
                func.setProperty(i, value);
                return null;
            }
            case 49: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                IAST val = (IAST)node.value;
                ((ZPENumber)value).decrement((ZPENumber)runtime.evaluateExpression(val, func));
                func.setProperty(i, value);
                return null;
            }
            case 102: {
                String i = node.id;
                ZPEType v = func.getVariable(i);
                IAST val = (IAST)node.value;
                ZPEType inc = runtime.evaluateExpression(val, func);
                if (!(inc instanceof ZPENumber)) {
                    throw new IncorrectDataTypeException("ZPENumber", "MULTI_ASSIGN");
                }
                v = new ZPENumber(((ZPENumber)v).doubleValue() * ((ZPENumber)inc).doubleValue());
                func.setProperty(i, v);
                return null;
            }
            case 103: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                IAST val = (IAST)node.value;
                if (val.type == 5 || val.type == 6) {
                    ZPENumber tmp = new ZPENumber((Number)val.value);
                    value = new ZPENumber(((ZPENumber)value).doubleValue() / tmp.doubleValue());
                }
                func.setProperty(i, value);
                return null;
            }
            case 104: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                IAST val = (IAST)node.value;
                if (val.type == 5 || val.type == 6) {
                    ZPENumber tmp = new ZPENumber((Number)val.value);
                    value = new ZPENumber(Math.pow(((ZPENumber)value).doubleValue(), tmp.doubleValue()));
                }
                func.setProperty(i, value);
                return null;
            }
            case 67: {
                ZPEType v;
                IAST thiscall = (IAST)node.value;
                if (node.left.type == 4) {
                    node.left.type = (byte)87;
                }
                if ((v = runtime.evaluateExpression(node.left, runtime.getCurrentFunction())) instanceof ZPERecord) {
                    ZPERecord record = (ZPERecord)v;
                    IAST valObj = (IAST)((IAST)node.value).value;
                    ZPEType val = runtime.evaluateExpression((IAST)valObj.value, runtime.getCurrentFunction());
                    record.setField(((IAST)node.value).middle.id, val);
                } else if (v instanceof ZPEMemberType) {
                    ZPEMemberType value = (ZPEMemberType)v;
                    ZPEType[] arguments = runtime.generateArguments((IAST)thiscall.value);
                    value.runNative(thiscall, arguments);
                }
                return null;
            }
            case 66: {
                runtime.accessorEvaluate(node);
                return null;
            }
            case 44: 
            case 45: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                ((ZPENumber)value).increment(1);
                func.setProperty(i, value);
                return null;
            }
            case 46: 
            case 47: {
                String i = node.id;
                ZPEType value = func.getVariable(i);
                ((ZPENumber)value).decrement(1);
                func.setProperty(i, value);
                return null;
            }
            case 12: 
            case 112: {
                ZPEFunction f = new ZPEFunction(runtime, node.id, node, false);
                f.parent = func;
                IAST current_node = (IAST)node.value;
                boolean working = true;
                while (working) {
                    if (current_node != null) {
                        String id = current_node.id;
                        if (current_node.type == -7) {
                            f.acceptInfiniteParams = true;
                            f.addParameter(id);
                        } else if (current_node.type == -13) {
                            id = current_node.left.id;
                            f.addParameter(id, current_node.middle.type);
                        } else {
                            f.addParameter(id);
                        }
                    }
                    if (current_node != null && current_node.next != null) {
                        current_node = current_node.next;
                        continue;
                    }
                    working = false;
                }
                if (node.returnTypes != null) {
                    f.returnTypes = node.returnTypes;
                }
                if (node.scope == 114) {
                    func.ownerRuntime.globalFunction.functionMap.put(node.id, f);
                    break;
                }
                func.functionMap.put(node.id, f);
                break;
            }
            case -14: {
                if (ZPEInstance.DEBUGGING) {
                    throw new BreakPointHalt();
                }
            }
            case 75: {
                IAST good_path = node.left;
                IAST bad_path = node.middle;
                String id = "";
                if (node.value != null) {
                    id = node.value.toString();
                }
                ZPEType temp_value = null;
                boolean reset_after = false;
                if (ZPEHelperFunctions.isUndefined(func.getVariable(id))) {
                    temp_value = func.getVariable(id);
                    reset_after = true;
                }
                try {
                    if (good_path == null) break;
                    func.traverse(good_path);
                }
                catch (ZPERuntimeException | ZPEException | IndexOutOfBoundsException e) {
                    func.setProperty(id, new ExceptionObject(runtime, func, e.getMessage()));
                    if (bad_path != null) {
                        func.traverse(bad_path);
                    }
                    if (reset_after) {
                        func.setProperty(id, temp_value);
                        break;
                    }
                    func.removeProperty(id);
                }
                break;
            }
            case 21: {
                IAST n = (IAST)node.value;
                boolean eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(n));
                if (eval && node.left != null) {
                    func.traverse(node.left);
                    break;
                }
                if (node.middle == null) break;
                IAST cur = node.middle;
                while (cur != null) {
                    if (cur.type == 23) {
                        IAST v = (IAST)cur.value;
                        if (ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(v)) && cur.left != null) {
                            func.traverse(cur.left);
                            break block1;
                        }
                        cur = cur.next;
                        continue;
                    }
                    func.traverse(cur.left);
                    break block1;
                }
                break;
            }
            case 24: {
                String v = node.id;
                Map map = (Map)node.value;
                String c = runtime.substitute(v).toString();
                c = HelperFunctions.removeExcessDecimalPoints(c);
                if (map.containsKey(c)) {
                    func.traverse((IAST)map.get(c));
                    break;
                }
                if (node.middle == null) break;
                func.traverse(node.middle);
                break;
            }
            case 30: {
                IAST n = (IAST)node.value;
                ZPEType res = runtime.LAME.evaluateExpressions(n);
                boolean eval = ZPEHelperFunctions.ToBoolean(res);
                while (eval && !func.mustReturn && !func.mustBreak() && (eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(n)))) {
                    if (node.left == null) continue;
                    func.traverse(node.left);
                }
                break;
            }
            case 52: {
                IAST n = (IAST)node.value;
                boolean eval = true;
                while (eval && !func.mustReturn && !func.mustBreak()) {
                    if (node.left != null) {
                        func.traverse(node.left);
                    }
                    eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(n));
                }
                break;
            }
            case 31: {
                IAST n = (IAST)node.value;
                boolean eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(n));
                while (!(eval || func.mustReturn || func.mustBreak() || (eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(n))))) {
                    if (node.left == null) continue;
                    func.traverse(node.left);
                }
                break;
            }
            case 33: {
                boolean ascending;
                String id = ZPERuntimeEnvironment.extractVariableId(node.middle.left);
                boolean variableAlreadyDefined = func.variableMap.containsKey(id);
                if (node.middle.left.type == 16) {
                    func.traverse(node.middle.left);
                } else {
                    ZPEType v = runtime.evaluateExpression(node.middle.left, func);
                    func.setProperty(id, v);
                }
                ZPEVariable loopVar = func.getRawVariable(id);
                long currentValue = HelperFunctions.stringToLong(runtime.evaluateNode(node.middle.left).toString());
                long maxValue = node.value instanceof IAST ? HelperFunctions.stringToLong(runtime.evaluateExpression((IAST)((IAST)node.value).value, func).toString()) : HelperFunctions.stringToLong(node.value.toString());
                ((ZPENumber)loopVar.getValue()).setValue(currentValue);
                boolean bl = ascending = currentValue < maxValue;
                while ((ascending ? currentValue < maxValue : currentValue > maxValue) && !func.mustReturn) {
                    if (node.left.next != null) {
                        func.traverse(node.left.next);
                    }
                    if (func.mustBreak()) break;
                    ((ZPENumber)loopVar.getValue()).setValue(currentValue += ascending ? 1L : -1L);
                }
                if (variableAlreadyDefined) break;
                func.variableMap.remove(id);
                break;
            }
            case 32: {
                boolean deleteAfter;
                String id = node.middle.left.id;
                if (node.middle.left.type == 16 && node.middle.left.middle != null) {
                    id = node.middle.left.middle.id;
                }
                boolean bl = deleteAfter = !func.variableMap.containsKey(id);
                if (node.middle.left.type == 16) {
                    func.traverse(node.middle.left);
                } else {
                    ZPEType v = runtime.evaluateExpression(node.middle.left, runtime.getCurrentFunction());
                    func.setProperty(id, v);
                }
                boolean singleNumberIncrement = false;
                boolean assess_before = false;
                ZPENumber inc = new ZPENumber(0);
                IAST mid = (IAST)node.middle.value;
                IAST midNode = (IAST)mid.value;
                if (midNode.type == 5 || midNode.type == 6) {
                    singleNumberIncrement = true;
                    inc = (ZPENumber)runtime.evaluateExpression((IAST)node.middle.value, func);
                } else if (mid.type == 47 || mid.type == 45) {
                    assess_before = true;
                }
                IAST condexp = (IAST)node.value;
                boolean eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(condexp));
                while (eval && !func.mustReturn) {
                    if (assess_before) {
                        func.traverse(midNode);
                    }
                    if (!(eval = ZPEHelperFunctions.ToBoolean(runtime.LAME.evaluateExpressions(condexp)))) break;
                    if (node.left.next != null) {
                        func.traverse(node.left.next);
                    }
                    if (func.mustBreak()) break;
                    if (singleNumberIncrement) {
                        ZPENumber value = (ZPENumber)func.getVariable(id);
                        value.increment(inc.currentValue());
                        func.setProperty(id, value);
                        continue;
                    }
                    if (assess_before) continue;
                    func.traverse(midNode);
                }
                if (!func.variableMap.containsKey(id) || !deleteAfter) break;
                func.variableMap.remove(id);
                break;
            }
            case 61: {
                ZPEType val;
                String id1;
                IAST assign = node.left;
                String id2 = null;
                if (assign.middle.type == 11) {
                    id1 = assign.middle.left.value.toString();
                    id2 = assign.middle.middle.value.toString();
                } else {
                    id1 = assign.middle.value.toString();
                }
                ZPEType stop = null;
                String stopid = null;
                if (node.value instanceof IAST) {
                    IAST nvalue = (IAST)node.value;
                    stopid = nvalue.id;
                    stop = runtime.evaluateExpression((IAST)nvalue.value, func);
                }
                if (!((val = runtime.evaluateNode(assign.left)) instanceof Iterable)) break;
                for (ZPEType value : (Iterable)((Object)val)) {
                    if (func.mustBreak()) break;
                    if (id2 != null) {
                        func.setProperty(id1, value);
                        if (val instanceof ZPEMap) {
                            func.setProperty(id2, ((ZPEMap)val).get(value));
                        } else if (val instanceof ZPEObject) {
                            func.setProperty(id2, ((ZPEObject)val).properties.get((String)value.toString()).value);
                        }
                    } else if (id1 != null) {
                        if (val instanceof ZPEMap) {
                            func.setProperty(id1, ((ZPEMap)val).get(value));
                        } else if (val instanceof ZPEObject) {
                            func.setProperty(id1, ((ZPEObject)val).properties.get((String)value.toString()).value);
                        } else {
                            func.setProperty(id1, value);
                        }
                    }
                    if (stop != null && stopid != null && stop == func.getVariable(stopid)) break;
                    if (node.middle == null) continue;
                    func.traverse(node.middle);
                }
                func.removeProperty(id1);
                if (id2 == null) break;
                func.removeProperty(id2);
                break;
            }
            case 71: {
                String id = node.left.id;
                ZPEType v = func.getVariable(id);
                if (v instanceof FunctionReference) {
                    FunctionReference f = (FunctionReference)v;
                    f.execute((IAST)node.value);
                    break;
                }
                if (!(v instanceof ZPEFunction)) {
                    throw new ZPERuntimeException("Variable not of type FUNCTION in LAMBDA_CALL");
                }
                ZPEFunction f = (ZPEFunction)v;
                IAST params = (IAST)node.value;
                ZPEType[] q = runtime.generateArguments(params);
                runtime.runFunction(f, q);
                break;
            }
            case 86: {
                ZPEType value = runtime.evaluateFunction(node);
                if (value instanceof ZPENumber) {
                    ((ZPENumber)value).negate();
                    break;
                }
                if (!(value instanceof ZPEBoolean)) break;
                ((ZPEBoolean)value).invert();
                break;
            }
            case 3: {
                runtime.evaluateFunction(node);
                break;
            }
            case 93: {
                ZPEType v1 = runtime.LAME.evaluateExpressions((IAST)node.value);
                boolean out = runtime.LAME.evaluateEquality(v1, new ZPEBoolean(true));
                if (out) break;
                throw new AssertionHalt(node.left.value.toString(), node.middle.value.toString());
            }
            case 83: {
                ZPEInstance.BUILT_IN_COMMANDS.addUserDefinedAlias(node.id, node.value.toString());
            }
        }
        return new ZPEBoolean(false);
    }

    private static String extractVariableId(IAST node) {
        if (node.type == 16 && node.middle != null) {
            return node.middle.id;
        }
        return node.id;
    }
}

