/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPE;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEFunction;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERandomizer;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEVariable;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.Undefined;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPERecord;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.variables.ZPEBooleanVariable;
import jamiebalfour.zpe.variables.ZPEFunctionVariable;
import jamiebalfour.zpe.variables.ZPEListVariable;
import jamiebalfour.zpe.variables.ZPEMapVariable;
import jamiebalfour.zpe.variables.ZPENumberVariable;
import jamiebalfour.zpe.variables.ZPEObjectVariable;
import jamiebalfour.zpe.variables.ZPEStringVariable;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.sound.sampled.Clip;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import org.fusesource.jansi.Ansi;
import org.jline.reader.LineReader;

public class ZPEHelperFunctions {
    static long lastemailsend = -1L;

    public static void clearScreen() {
        if (HelperFunctions.isMac() || ZPEHelperFunctions.isUnix()) {
            System.out.print("\u001b[H\u001b[2J");
            System.out.flush();
        }
    }

    public static Map<String, VariableInformation> listAllVariables(ZPERuntimeEnvironment rt) {
        HashMap<String, VariableInformation> output = new HashMap<String, VariableInformation>();
        for (int i = rt.callStack.size() - 1; i >= 0; --i) {
            for (String v : ((ZPEFunction)rt.callStack.get((int)i)).variableMap.keySet()) {
                VariableInformation var = new VariableInformation();
                var.name = v;
                var.value = ((ZPEFunction)rt.callStack.get((int)i)).variableMap.get(v);
                var.func = (ZPEFunction)rt.callStack.get(i);
                output.put(v, var);
            }
        }
        return output;
    }

    public static ZPEType typeCast(Object value, byte type) {
        switch (type) {
            case 119: {
                return new ZPEString(value.toString());
            }
            case 120: {
                return new ZPENumber(HelperFunctions.stringToDouble(value.toString()));
            }
            case 121: {
                return new ZPEBoolean(ZPEHelperFunctions.ToBoolean(value));
            }
        }
        return (ZPEType)value;
    }

    public static boolean checkType(Object value, byte type) {
        if (type == 118) {
            return true;
        }
        if (type == 119) {
            return value instanceof ZPEString;
        }
        if (type == 120) {
            return value instanceof ZPENumber;
        }
        if (type == 121) {
            return value instanceof ZPEBoolean;
        }
        if (type == 122) {
            return value instanceof ZPEList;
        }
        if (type == 123) {
            return value instanceof ZPEMap;
        }
        if (type == 125) {
            return value instanceof ZPEObject;
        }
        if (type == 124) {
            return value instanceof ZPEFunction;
        }
        return false;
    }

    public static void wol(String MAC) throws IOException, IllegalArgumentException {
        int m;
        String HEX = "0123456789ABCDEF";
        byte[] bMAC = new byte[6];
        int i = 0;
        int h = 0;
        MAC = MAC.toUpperCase();
        for (m = 0; m < MAC.length() && i < 12; ++m) {
            int n = "0123456789ABCDEF".indexOf(MAC.charAt(m));
            if (n < 0) continue;
            if (i % 2 == 0) {
                h = n;
            } else {
                bMAC[i / 2] = (byte)(h * 16 + n);
            }
            ++i;
        }
        if (m < MAC.length()) {
            throw new IllegalArgumentException("MAC Address must be 12 Hex digits exactly");
        }
        ZPEHelperFunctions.wol(bMAC);
    }

    public static void wol(byte[] MAC) throws IOException {
        if (MAC == null || MAC.length != 6) {
            throw new IllegalArgumentException("MAC array must be present and 6 bytes long");
        }
        int packetLength = 102;
        byte[] packetData = new byte[packetLength];
        int m = 0;
        packetData[m++] = -1;
        packetData[m++] = -1;
        packetData[m++] = -1;
        packetData[m++] = -1;
        packetData[m++] = -1;
        packetData[m++] = -1;
        for (int i = 0; i < 96; ++i) {
            packetData[m] = MAC[m % 6];
            ++m;
        }
        try (DatagramSocket socket = new DatagramSocket(1);){
            InetSocketAddress address = new InetSocketAddress("255.255.255.255", 2304);
            DatagramPacket datagram = new DatagramPacket(packetData, packetLength, address);
            socket.setBroadcast(true);
            socket.send(datagram);
        }
    }

    public static ZPEVariable createTypedVariable(String id, ZPEType value, int scope, ZPEPropertyWrapper container, byte type) throws ZPERuntimeException {
        if (type == 118) {
            return new ZPEVariable(id, value, scope, container, type);
        }
        if (type == 119) {
            return new ZPEStringVariable(id, (ZPEString)value, scope, container, type);
        }
        if (type == 120) {
            return new ZPENumberVariable(id, (ZPENumber)value, scope, container, type);
        }
        if (type == 121) {
            return new ZPEBooleanVariable(id, (ZPEBoolean)value, scope, container, type);
        }
        if (type == 122) {
            return new ZPEListVariable(id, (ZPEList)value, scope, container, type);
        }
        if (type == 123) {
            return new ZPEMapVariable(id, (ZPEMap)value, scope, container, type);
        }
        if (type == 125) {
            return new ZPEObjectVariable(id, (ZPEObject)value, scope, container, type);
        }
        if (type == 124) {
            return new ZPEFunctionVariable(id, (ZPEFunction)value, scope, container, type);
        }
        return null;
    }

    public static boolean isUndefined(Object out) {
        return out instanceof Undefined;
    }

    public static String readStringFromURL(String url) throws IOException {
        String inputLine;
        URL website = new URL(url);
        URLConnection ec = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(ec.getInputStream(), "UTF-8"));
        StringBuilder a = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            a.append(inputLine).append(System.lineSeparator());
        }
        in.close();
        return a.toString();
    }

    public static ZPEType urlToJson(String url) throws IOException, ZPERuntimeException, MalformedJSONException {
        String inputLine;
        URL website = new URL(url);
        URLConnection ec = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(ec.getInputStream(), "UTF-8"));
        StringBuilder a = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            a.append(inputLine);
        }
        in.close();
        String json = a.toString();
        ZenithJSONParser p = new ZenithJSONParser();
        return p.jsonDecode(json, false);
    }

    public static boolean awtExists() {
        try {
            Class.forName("java.awt.Toolkit");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getBinaryPath() {
        if (HelperFunctions.isMac()) {
            return ZPEInstance.getInstallPath() + "zpe-aarch64";
        }
        if (HelperFunctions.isWindows()) {
            return ZPEInstance.getInstallPath() + "zpe.exe";
        }
        return "";
    }

    public static boolean isTrulyCommandLine() {
        String term = System.getenv("TERM");
        return term != null && !term.equals("dumb");
    }

    public static boolean isHeadless() {
        if (!ZPEHelperFunctions.awtExists()) {
            return true;
        }
        try {
            String headlessProp = System.getProperty("java.awt.headless");
            if ("true".equalsIgnoreCase(headlessProp)) {
                return true;
            }
            return GraphicsEnvironment.isHeadless();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String generateRandomWord(int len) {
        char[] word = new char[len];
        for (int j = 0; j < word.length; ++j) {
            word[j] = (char)(97 + ZPERandomizer.generate(0, 26));
        }
        return new String(word);
    }

    public static byte getDataType(ZPEType v) {
        if (v == null) {
            return -4;
        }
        if (v instanceof ZPEList) {
            return 122;
        }
        if (v instanceof ZPEFunction) {
            return 124;
        }
        if (v instanceof ZPEMap) {
            return 123;
        }
        if (v.toString().equals("true") || v.toString().equals("false")) {
            return 121;
        }
        if (v instanceof ZPEObject) {
            return 125;
        }
        if (v instanceof Undefined) {
            return -3;
        }
        if (v instanceof ZPENumber) {
            return 120;
        }
        return 119;
    }

    public static String createRainbow(String str, boolean shuffle) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            ArrayList<Ansi.Color> colours = new ArrayList<Ansi.Color>();
            colours.add(Ansi.Color.RED);
            colours.add(Ansi.Color.YELLOW);
            colours.add(Ansi.Color.GREEN);
            colours.add(Ansi.Color.BLUE);
            colours.add(Ansi.Color.CYAN);
            colours.add(Ansi.Color.MAGENTA);
            if (shuffle) {
                Collections.shuffle(colours);
            }
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                out.append(Ansi.ansi().fg((Ansi.Color)((Object)colours.get(i % colours.size())))).append(str.charAt(i)).append(Ansi.ansi().reset());
            }
            return out.toString();
        }
        return str;
    }

    public static String setConsoleEffectToGreen(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.GREEN)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToBlue(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.BLUE)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToRed(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.RED)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToCyan(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.CYAN)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToMagenta(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.MAGENTA)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToYellow(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().fg(Ansi.Color.YELLOW)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    public static String setConsoleEffectToItalic(String str) {
        if (ZPEInstance.USE_COLOR && !ZPEInstance.FORCE_DISABLE_COLOUR) {
            return String.valueOf(Ansi.ansi().a(Ansi.Attribute.ITALIC)) + str + String.valueOf(Ansi.ansi().reset());
        }
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String beautify(ZPEType o, int indent) throws ZPERuntimeException, ExitHalt, BreakPointHalt {
        StringBuilder s = new StringBuilder();
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            spaces.append(" ");
        }
        if (o instanceof ZPEMap) {
            ZPEMap arr = (ZPEMap)o;
            s.append((CharSequence)spaces).append(System.lineSeparator()).append((CharSequence)spaces).append("[");
            int keyCount = arr.size();
            int i = 0;
            for (ZPEType k : arr.keySet()) {
                s.append(System.lineSeparator()).append((CharSequence)spaces).append("  ").append(ZPEHelperFunctions.beautify(k, indent + 1)).append(" => ").append(ZPEHelperFunctions.beautify(arr.get(k), indent + 1));
                if (i < keyCount - 1) {
                    s.append(",");
                }
                ++i;
            }
            s.append(System.lineSeparator()).append((CharSequence)spaces).append("]");
            return s.toString();
        }
        if (o instanceof ZPEList) {
            ZPEList arr = (ZPEList)o;
            int keyCount = arr.size();
            int i = 0;
            s.append((CharSequence)spaces).append(System.lineSeparator()).append((CharSequence)spaces).append("[");
            for (ZPEType k : arr) {
                s.append(System.lineSeparator()).append((CharSequence)spaces).append("  ").append(ZPEHelperFunctions.beautify(k, indent + 1));
                if (i < keyCount - 1) {
                    s.append(",");
                }
                ++i;
            }
            s.append(System.lineSeparator()).append((CharSequence)spaces).append("]");
            return s.toString();
        }
        if (o instanceof ZPEObject) {
            ZPEObject obj = (ZPEObject)o;
            if (obj.hasVariable("_beautify")) {
                ZPEType var = obj.getVariable("_beautify");
                if (var instanceof ZPEFunction) {
                    return ((ZPEFunction)var).run().toString();
                }
                if (!(var instanceof ZPEObjectNativeMethod)) return o.toString();
                return ((ZPEObjectNativeMethod)var).MainMethod(new BinarySearchTree<String, ZPEType>(), obj).toString();
            }
            s.append((CharSequence)spaces).append(obj.getDefinition()).append(System.lineSeparator()).append((CharSequence)spaces).append("{");
            int keyCount = 0;
            int i = 0;
            for (ZPEVariable k : obj.properties.values()) {
                if (k.scope == 1) continue;
                ++keyCount;
            }
            for (ZPEVariable k : obj.properties.values()) {
                if (k.scope == 1) continue;
                s.append(System.lineSeparator()).append((CharSequence)spaces).append("  ").append(ZPEHelperFunctions.beautify(new ZPEString(k.id), indent + 2)).append(" : ").append(ZPEHelperFunctions.beautify(k.value, indent + 2));
                if (i < keyCount - 1) {
                    s.append(",");
                }
                ++i;
            }
            s.append(System.lineSeparator()).append((CharSequence)spaces).append("}");
            return s.toString();
        }
        if (!(o instanceof ZPEString)) return o.toString();
        return "\"" + String.valueOf(o) + "\"";
    }

    public static boolean isFunction(Object v) {
        return v instanceof ZPEFunction;
    }

    public static boolean isObject(Object v) {
        return v instanceof ZPEObject;
    }

    public static boolean isMap(Object s) {
        return s instanceof ZPEMap;
    }

    public static boolean isList(Object s) {
        return s instanceof ZPEList;
    }

    public static boolean ToBoolean(Object value) {
        return value != null && !(value instanceof Undefined) && !value.toString().equals("false") && !value.toString().equals("0");
    }

    public static String getTypeString(Object v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof ZPEList) {
            return "list";
        }
        if (v instanceof ZPEFunction) {
            return "function";
        }
        if (v instanceof ZPEMap) {
            return "map";
        }
        if (v instanceof ZPEBoolean) {
            return "boolean";
        }
        if (v instanceof ZPEObject) {
            return "object";
        }
        if (v instanceof ZPERecord) {
            return "record";
        }
        if (v instanceof ZPEString) {
            return "string";
        }
        if (v instanceof Undefined) {
            return "undefined";
        }
        if (v instanceof ZPENumber) {
            return "number";
        }
        return "unknown";
    }

    public static String typeByteToString(byte type) {
        if (type == 119) {
            return "string";
        }
        if (type == 120) {
            return "number";
        }
        if (type == 121) {
            return "boolean";
        }
        if (type == 125) {
            return "object";
        }
        if (type == 122) {
            return "list";
        }
        if (type == 123) {
            return "map";
        }
        if (type == 124) {
            return "function";
        }
        if (type == 118) {
            return "mixed";
        }
        return "unknown";
    }

    public static void SystemBeep(double freq, double millis) throws Exception {
        HelperFunctions.systemBeep(freq, millis);
    }

    public static Clip OpenAudioClip(String url) throws Exception {
        return FileHelperFunctions.openAudioClip(url);
    }

    public static String ShellExec(String cmd) {
        try {
            return HelperFunctions.shellExec(cmd);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static Properties ReadProperties(String filename) {
        try {
            return HelperFunctions.readProperties(filename);
        }
        catch (Exception e) {
            return new Properties();
        }
    }

    public static void throwBreakPointException(ZPERuntimeEnvironment e) {
        ZPE.ThrowBreakPointException(e);
    }

    public static void saveProperties(Properties p, String path, String comment) {
        try {
            HelperFunctions.saveProperties(p, path, comment);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void RedirectSystemOutput(JTextArea j) {
        HelperFunctions.redirectSystemOutput(j);
    }

    public static double limitInteger(double i, int min, int max) {
        double out = i;
        if (i > (double)max) {
            out = max;
        }
        if (i < (double)min) {
            out = min;
        }
        return out;
    }

    public static PrintStream RedirectSystemOutput(OutputStream outputstream) {
        return HelperFunctions.redirectSystemOutput(outputstream);
    }

    public static long StringToLong(String s) {
        return (long)Math.floor(HelperFunctions.stringToDouble(s));
    }

    public static boolean IsNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("([+-]?\\d+)|([+-]?\\d*\\.?\\d+([eE][+-]?\\d+)?)");
    }

    public static boolean isUnix() {
        return HelperFunctions.isUnix();
    }

    public static boolean isSolaris() {
        return HelperFunctions.isSolaris();
    }

    public static void ConcurrentDelay(Runnable r) {
        HelperFunctions.concurrentDelay(r);
    }

    public static String makePOSTRequest(String path, Map<String, String> arguments) throws Exception {
        return HelperFunctions.makePOSTRequest(path, arguments);
    }

    public static String makePOSTRequest(String path, String body, Map<String, String> arguments) {
        return HelperFunctions.makePOSTRequest(path, body, arguments);
    }

    public static Date StringToDate(String str, String str_format) throws Exception {
        return HelperFunctions.stringToDate(str, str_format);
    }

    public static String GetIP() throws Exception {
        return HelperFunctions.GetIP();
    }

    public static String GetResource(String r) throws IOException {
        return HelperFunctions.getResource(r);
    }

    public static boolean IsDarkMode() {
        return HelperFunctions.isDarkMode();
    }

    public static void Delay(long t) {
        HelperFunctions.delay(t);
    }

    public static byte[] toByteArray(Object obj) throws IOException {
        return HelperFunctions.toByteArray(obj);
    }

    public static boolean isMathsOperatorByte(int symbol) {
        return symbol == 55 || symbol == 57 || symbol == 56 || symbol == 58 || symbol == 59 || symbol == 60;
    }

    public static boolean isComparatorSymbolByte(int s) {
        return s == 34 || s == 40 || s == 35 || s == 37 || s == 36 || s == 39 || s == 38;
    }

    public static boolean isLogicalOperatorByte(int s) {
        return s == 42 || s == 43;
    }

    public static boolean isTypeByte(byte sy) {
        return sy == 119 || sy == 120 || sy == 121 || sy == 122 || sy == 123 || sy == 12 || sy == 125 || sy == 118;
    }

    public static boolean isValueByte(byte sy) {
        return sy == 5 || sy == 6 || sy == 8 || sy == 7;
    }

    public static boolean isScopeByte(byte sy, boolean acceptsGlobal) {
        return sy == 2 || sy == 1 || acceptsGlobal && sy == 114;
    }

    public static void saveHistory(LineReader reader, String hFile) throws IOException {
        if (reader == null) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(ZPEInstance.INSTALL_PATH + "/" + hFile));
        for (int i = 0; i < reader.getHistory().size() - 1; ++i) {
            if (reader.getHistory().get(i).isEmpty()) continue;
            writer.write(reader.getHistory().get(i));
            if (i >= reader.getHistory().size() - 1) continue;
            writer.write("\n");
        }
        writer.close();
    }

    public static boolean sendFeedback(String message, String returnEmail) throws ZPERuntimeException {
        String returnvalue;
        long timesince = System.currentTimeMillis() - lastemailsend;
        lastemailsend = System.currentTimeMillis();
        if (timesince < 3600000L) {
            ZPECore.printError("You can only send feedback once every hour.");
            return false;
        }
        Object addon = "&email=zpe-feedback@balfour.scot";
        Object path = "https://www.jamiebalfour.scot/assets/actions/send_email.php/?sending_by_get=true";
        try {
            if (returnEmail != null) {
                addon = "&email=" + URLEncoder.encode(returnEmail, "UTF-8");
            }
            path = (String)path + "&subject=ZPE%20feedback&name=ZPE%20Feedback%20Agent" + (String)addon;
        }
        catch (Exception e) {
            ZPECore.print("Your feedback could not be sent at this time.");
            return false;
        }
        HashMap<String, String> args2 = new HashMap<String, String>();
        args2.put("message", message);
        try {
            returnvalue = HelperFunctions.makePOSTRequest((String)path, args2);
        }
        catch (Exception e) {
            ZPECore.print("Your feedback could not be sent at this time.");
            return false;
        }
        return returnvalue.startsWith("1");
    }

    public static void readHistory(LineReader reader, String hFile) {
        if (reader == null) {
            return;
        }
        Stack<String> data = new Stack<String>();
        if (new File(ZPEInstance.INSTALL_PATH + "/" + hFile).exists()) {
            try {
                BufferedReader freader = new BufferedReader(new FileReader(ZPEInstance.INSTALL_PATH + "/" + hFile));
                String line = freader.readLine();
                while (line != null) {
                    data.add(line);
                    line = freader.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        while (data.size() > 50) {
            data.remove(0);
        }
        while (!data.isEmpty()) {
            reader.getHistory().add((String)data.get(0));
            data.remove(0);
        }
    }

    static void installZPE() throws IOException {
        String filename;
        String out = HelperFunctions.getResource("/files/zpe_script.txt");
        String path = new File(ZPEInstance.INSTALL_PATH + "/zpe.jar").getAbsolutePath();
        if (HelperFunctions.isWindows()) {
            out = out.replace("{PATH}", path + " %*");
            filename = new File(ZPEInstance.INSTALL_PATH + "zpe.bat").getAbsolutePath();
            FileHelperFunctions.writeFile(filename, out, false);
        } else {
            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToRed("Make sure you are running this command as the root user or using sudo."));
            out = out.replace("{PATH}", path);
            filename = new File(ZPEInstance.INSTALL_PATH + "zpe").getAbsolutePath();
            FileHelperFunctions.writeFile(filename, out, false);
            String cmd = "chmod +x " + ZPEInstance.INSTALL_PATH + "zpe";
            System.out.println(HelperFunctions.shellExec(cmd));
            cmd = "mv " + ZPEInstance.INSTALL_PATH + "zpe /usr/bin/";
            System.out.println(HelperFunctions.shellExec(cmd));
        }
        File app = new File(ZPEInstance.EXECUTABLE_PATH + "/zpe.jar");
        try {
            FileHelperFunctions.copyFileUsingStream(app, new File(path));
        }
        catch (Exception e) {
            System.err.println("Failed to move " + app.getAbsolutePath() + " to " + path);
        }
        if (HelperFunctions.isMac() || HelperFunctions.isUnix()) {
            ZPECore.print("Running install scripts...");
            Object script = HelperFunctions.getResource("/files/install.txt");
            String manual = HelperFunctions.getResource("/files/zpe_manual.txt");
            Object profiles = "";
            String home = System.getProperty("user.home");
            if (new File(home + "/.profile").exists()) {
                profiles = (String)profiles + HelperFunctions.getResource("/files/profiles/profile") + "\r\n";
            }
            if (new File(home + "/.bash_profile").exists()) {
                profiles = (String)profiles + HelperFunctions.getResource("/files/profiles/bash_profile") + "\r\n";
            }
            if (new File(home + "/.bash_rc").exists()) {
                profiles = (String)profiles + HelperFunctions.getResource("/files/profiles/bash_rc") + "\r\n";
            }
            if (new File(home + "/.zprofile").exists()) {
                profiles = (String)profiles + HelperFunctions.getResource("/files/profiles/zprofile") + "\r\n";
            }
            if (new File(home + "/.zshrc").exists()) {
                profiles = (String)profiles + HelperFunctions.getResource("/files/profiles/zshrc") + "\r\n";
            }
            script = (String)script + System.lineSeparator() + (String)profiles;
            File installer = new File(new File(ZPEInstance.INSTALL_PATH).getAbsolutePath() + "/install.sh");
            FileHelperFunctions.writeFile(installer.getAbsolutePath(), (String)script, false);
            FileHelperFunctions.writeFile(new File(ZPEInstance.INSTALL_PATH).getAbsolutePath() + "/manual.txt", manual, false);
            System.out.println(new File(ZPEInstance.INSTALL_PATH).getAbsolutePath());
            String cmd = "sh " + new File(ZPEInstance.INSTALL_PATH).getAbsolutePath() + "/install.sh";
            System.out.println(cmd);
            System.out.println("Welcome to the installer");
            HelperFunctions.shellExec(cmd);
            System.out.println("Done. Now run source on your Bash, ZSH, or Bash RC profile");
            System.out.println(installer.delete() ? "Successfully deleted the installer" : "Failed to delete the installer");
        }
        System.out.println("Startup file successfully created at " + filename);
    }

    static String processDescriptionToHtml(String description) {
        StringBuilder output = new StringBuilder();
        boolean inCode = false;
        boolean inItalic = false;
        for (int pos = 0; pos < description.length(); ++pos) {
            if (description.charAt(pos) == '*' && description.charAt(pos + 1) == '*') {
                if (inCode) {
                    output.append("</code>");
                } else {
                    output.append("<code>");
                }
                inCode = !inCode;
                ++pos;
                continue;
            }
            if (description.charAt(pos) == '_' && description.charAt(pos + 1) == '_') {
                if (inItalic) {
                    output.append("</em>");
                } else {
                    output.append("<em>");
                }
                inItalic = !inItalic;
                ++pos;
                continue;
            }
            if (description.charAt(pos) == '~' && description.charAt(pos + 1) == '~') {
                if (inItalic) {
                    output.append("</span>");
                } else {
                    output.append("<span class='function'>");
                }
                inItalic = !inItalic;
                ++pos;
                continue;
            }
            if (description.charAt(pos) == '\"') {
                output.append("<span class='string'>\"");
                ++pos;
                while (pos < description.length() && description.charAt(pos) != '\"') {
                    output.append(description.charAt(pos));
                    ++pos;
                }
                output.append("\"</span>");
                continue;
            }
            output.append(description.charAt(pos));
        }
        String outStr = output.toString();
        outStr = outStr.replace("&", "&amp;");
        outStr = outStr.replace("INTERSECTS", "&cap;");
        outStr = outStr.replace("UNION", "&cup;");
        outStr = outStr.replace("DIFFERENCE", "\\");
        outStr = outStr.replace("->", "&rarr;");
        outStr = outStr.replace(" AND ", " &and; ");
        outStr = outStr.replace(" OR ", " &or; ");
        outStr = outStr.replace("\u2265", "&ge;");
        outStr = outStr.replace("\u2264", "&le;");
        outStr = outStr.replace(System.lineSeparator(), "<br>");
        return outStr;
    }

    public static ImageIcon getLogo() {
        URL imagePath = HelperFunctions.isMac() ? ZPEHelperFunctions.class.getResource("/files/ZPELogomacOS.png") : ZPEHelperFunctions.class.getResource("/files/ZPELogoLighter.png");
        assert (imagePath != null);
        return new ImageIcon(imagePath);
    }

    public static File getPlatformSpecificLockdownFile() {
        if (HelperFunctions.isMac()) {
            return new File("/Library/Application Support/ZPE/lockdown.config");
        }
        if (HelperFunctions.isWindows()) {
            return new File("C:\\ProgramData\\ZPE\\lockdown.config");
        }
        return new File("/etc/zpe/lockdown.config");
    }

    public static class VariableInformation {
        public String name = "";
        public ZPEVariable value = null;
        public ZPEFunction func = null;
    }
}

