/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.core;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.LAMEX2;
import jamiebalfour.zpe.core.Manual;
import jamiebalfour.zpe.core.YASSByteCodes;
import jamiebalfour.zpe.core.YASSCompiler;
import jamiebalfour.zpe.core.YASSInteractiveInterpreter;
import jamiebalfour.zpe.core.YASSPredefinedFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPEInstance;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEOnline;
import jamiebalfour.zpe.core.ZPEPluginManager;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStartup;
import jamiebalfour.zpe.core.ZPEUpdater;
import jamiebalfour.zpe.core.ZULEPackageManager;
import jamiebalfour.zpe.daemon.ZPERuntimeDaemon;
import jamiebalfour.zpe.editor.ZPEEditor;
import jamiebalfour.zpe.exceptions.BreakPointHalt;
import jamiebalfour.zpe.exceptions.CompileException;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.NoEntryPointException;
import jamiebalfour.zpe.exceptions.NonExecutableFileException;
import jamiebalfour.zpe.exceptions.PasswordException;
import jamiebalfour.zpe.exceptions.TranspilerNotFoundException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.gui.CommandWindow;
import jamiebalfour.zpe.interfaces.ZPEException;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import jamiebalfour.zpe.zen.ZENClient;
import jamiebalfour.zpe.zen.ZENServer;
import jamiebalfour.zpe.zen.ZENWebParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.fusesource.jansi.AnsiConsole;

class ZPE {
    ZPE() {
    }

    public static String getCopyrightInfo() {
        try {
            return HelperFunctions.getResource("/files/zpe_copyright.txt");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void createInstallScript() {
        ZPECore.print();
        ZPECore.print("To create an install script, follow these instructions:");
        ZPECore.print();
        if (HelperFunctions.isWindows()) {
            ZPECore.print(" Put the following in a batch file called zpe.bat:");
            ZPECore.print(" java -jar " + ZPEInstance.EXECUTABLE_PATH + "/zpe.jar %*");
            ZPECore.print(" Put the batch file in a folder on the system path. For example, the Windows directory in C:\\Windows");
            ZPECore.print(" Run \"zpe -v\" to test that ZPE is working from the command line.");
        } else if (HelperFunctions.isMac() || HelperFunctions.isUnix()) {
            ZPECore.print(" Put the following in a text file called zpe:");
            ZPECore.print(" java -jar " + ZPEInstance.EXECUTABLE_PATH + "/zpe.jar \"$@\"");
            ZPECore.print(" Add the location of the text file to the PATH system variable.");
            ZPECore.print(" Use nano to edit the file in ~/.profile and add to the PATH variable.");
            ZPECore.print(" Use \"chmod +x zpe\" to set the executable permissions on the zpe file.");
            ZPECore.print(" Run \"zpe -v\" to test that ZPE is working from the command line.");
        }
        ZPECore.print();
        ZPECore.print("Add --do at the end of the command here to create the script.");
        ZPECore.print();
    }

    public static String getChangeLog() {
        try {
            return HelperFunctions.getResource("/files/zpe_changelog.txt");
        }
        catch (Exception e) {
            return "";
        }
    }

    static Collection<File> listFileTree(File dir) {
        HashSet<File> fileTree = new HashSet<File>();
        if (dir == null || dir.listFiles() == null) {
            return fileTree;
        }
        for (File entry : Objects.requireNonNull(dir.listFiles())) {
            if (entry.isFile()) {
                fileTree.add(entry);
                continue;
            }
            fileTree.addAll(ZPE.listFileTree(entry));
        }
        return fileTree;
    }

    static void PrintZPELogo() {
        try {
            System.out.println(ZPEHelperFunctions.setConsoleEffectToYellow(HelperFunctions.getResource("/files/logo.txt")));
        }
        catch (Exception e) {
            System.out.println("ZPE");
        }
    }

    static void PrintIntroduction(String[] args2) {
        boolean printIntro = true;
        for (String arg : args2) {
            if (!arg.equals("-clear") && args2[0].startsWith("-")) continue;
            printIntro = false;
            break;
        }
        if (printIntro) {
            long heap = Runtime.getRuntime().maxMemory();
            Object output = "";
            output = (String)output + "ZPE Programming Environment (ZPE) 1.13.9 build " + ZPECore.getBuildVersion() + " (September 2025)";
            System.out.println(ZPEHelperFunctions.setConsoleEffectToMagenta((String)output));
            System.out.println("ZPE CLI version 1.8.1 (YASS 25.5, ZEN 20X, LAME " + LAMEX2.VERSION + "), Zenith Parsing Engine version 1.5, copyright (c) Jamie Balfour 2011 - 2025");
            System.out.println("Current maximum memory allocated to ZPE is " + heap / 1024L / 1024L + "MB. " + (String)(System.getenv("TERM") != null ? " [" + System.getenv("TERM") + "]" : ""));
            System.out.println();
            System.out.println("Executable path: " + ZPEInstance.EXECUTABLE_PATH);
            System.out.println();
            System.out.println("Information and contributions can be found at:");
            System.out.println("https://www.jamiebalfour.scot/projects/zpe/");
            if (ZPEInstance.EXPERIMENTAL) {
                System.out.println("Running in experimental mode!");
            }
            System.out.println();
        }
    }

    private static void printTitle(String t) {
        System.out.println(ZPEHelperFunctions.setConsoleEffectToGreen(t));
    }

    private static String indentText() {
        return "\t";
    }

    static void printStartupInformation() {
        ZPE.PrintIntroduction(new String[0]);
        ZPE.PrintZPELogo();
        System.out.println(ZPEHelperFunctions.setConsoleEffectToRed("You must specify a run command."));
        System.out.println();
        System.out.println(ZPEHelperFunctions.setConsoleEffectToMagenta("The following ZPE Argument Commands (ZACs) are currently supported:"));
        System.out.println();
        ZPE.printTitle("-a $filepath");
        System.out.println("   Analyses code. Checks if the code is well-formed and valid.");
        ZPE.printTitle("-b $filepath [-v $verbose]");
        System.out.println("   Byte code view. Prints a byte code tokenisation of the program.");
        ZPE.printTitle("-c $filepath [-o $outfile] [-k $key] [-optimise $optimise] [--library]");
        System.out.println("   Compile code. Compiles the code to a file for distribution.");
        ZPE.printTitle("-d $filepath [-args $args]");
        System.out.println("   Debug mode. Allows you to debug the code to a breakpoint in the code.");
        ZPE.printTitle("-e $filepath -o $outfile -t [$language] [-n $class_name]");
        System.out.println("   Export code. Exports code to another language.");
        ZPE.printTitle("-g [$filepath]");
        System.out.println("   GUI mode. This mode features a basic GUI for editing and running code.");
        ZPE.printTitle("-h [$opt]");
        System.out.println("   Help mode. A bunch of help commands for ZPE.");
        ZPE.printTitle("-i [$code]");
        System.out.println("   Interactive mode. Interactive interpreter for commands from the command line or execute $code.");
        ZPE.printTitle("-j $filepath");
        System.out.println("   JSON communication mode. Executes a command or script formatted in JSON.");
        ZPE.printTitle("-l $port");
        System.out.println("   Lite mode. ZPE runs in daemon mode over a specified port. Commands can be sent across using HTTP or as JSON.");
        ZPE.printTitle("-n $port [-h $host [-k $key] [-level $permission]]");
        System.out.println("   Network mode. Opens a ZENServer or ZENClient. If -h is provided it runs as a ZENClient.");
        ZPE.printTitle("-o [$hash]");
        System.out.println("   Online download. Lists all public downloads or downloads a public ZPE Online file.");
        ZPE.printTitle("-p [-k $key [-v $value]]");
        System.out.println("   Properties mode. Allows viewing and editing of ZPE properties.");
        ZPE.printTitle("-q");
        System.out.println("   Quickfire mode. A GUI single-line-read mode.");
        ZPE.printTitle("-r $filepath [-args $args]");
        System.out.println("   Runtime mode. Compiles and runs code using the compiler and runtime.");
        ZPE.printTitle("-s $filepath [-c $clean_up]");
        System.out.println("   String view. Prints a string tokenisation of the program.");
        ZPE.printTitle("-t $filepath");
        System.out.println("   Tree view. Prints the code tree of the code from a file.");
        ZPE.printTitle("-u $filepath [--html]");
        System.out.println("   YASS Unfold. Explains the code entered into the program.");
        ZPE.printTitle("-w $filepath");
        System.out.println("   Web parser mode. Executes a HTML page with YASS code.");
        ZPE.printTitle("$filepath [$args...]");
        System.out.println("   Runs a compiled YASS script.");
        System.out.println();
        System.out.println("--configure : Configure mode. Reinstall the default ZPE settings files.");
        System.out.println("--copyright : Copyright information. Displays the full copyright information for ZPE");
        System.out.println("--install   : Install mode. Provides instructions and installs ZPE to the ~/zpe folder.");
        System.out.println("--man       : Manual mode. Searches internal documentation for an internal function, similar to Unix man pages.");
        System.out.println("--update    : Download the latest version of the ZPE and install it.");
        System.out.println("--version   : Version information. Prints the current version information to the console.");
        System.out.println("--zule      : ZULE download. Downloads a file from the ZPE Uploaded Library Extensions (ZULE) repository.");
        System.out.println();
        System.out.println("There is more at https://www.jamiebalfour.scot/projects/zpe/documentation/getting-started/running-zpe/");
        System.out.println();
    }

    public static void ThrowBreakPointException(ZPERuntimeEnvironment rt) {
        HelperFunctions.printBlankLines(2);
        System.out.println(ZPEHelperFunctions.setConsoleEffectToRed("YASS Program Breakpoint: "));
        HelperFunctions.printBlankLines(2);
        Map<String, ZPEHelperFunctions.VariableInformation> vars = ZPEHelperFunctions.listAllVariables(rt);
        for (String s : vars.keySet()) {
            System.out.println(s + " [" + vars.get((Object)s).func.name + "] -> " + String.valueOf(vars.get((Object)s).value));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException, ExitHalt {
        ZPECore.programArguments = args;
        try {
            ZPEInstance.EXECUTABLE_PATH = new File("").getAbsolutePath();
            ZPEInstance.EXECUTABLE_PATH = new File(ZPECore.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
        ZPEInstance.Startup();
        ZPEStartup.loadSettings();
        try {
            ZPEInstance.EXECUTABLE_PATH = ZPEInstance.EXECUTABLE_PATH.substring(0, ZPEInstance.EXECUTABLE_PATH.lastIndexOf(File.separator));
        }
        catch (Exception e) {
            ZPECore.log(e.getMessage());
        }
        program_arguments = new ArrayList<String>();
        found = false;
        for (String arg : args) {
            if (found) {
                program_arguments.add(arg);
            }
            if (!arg.equals("-args")) continue;
            found = true;
        }
        try {
            argv = HelperFunctions.generateArgumentMap(args);
        }
        catch (HelperFunctions.NoArgumentValueProvided e) {
            throw new RuntimeException(e.getMessage());
        }
        if (args.length == 0) {
            if (ZPEHelperFunctions.isHeadless() || ZPEHelperFunctions.isTrulyCommandLine()) {
                ZPE.printStartupInformation();
                System.exit(0);
            } else {
                err = System.err;
                try {
                    if (ZPEInstance.GUI_START == 0) {
                        ZPEEditor.StartEditor();
                    } else if (ZPEInstance.GUI_START == 1) {
                        c = new CommandWindow();
                        c.setVisible(true);
                    }
                    return;
                }
                catch (Exception e) {
                    ZPECore.log(e.getMessage());
                    System.setErr(err);
                    System.err.println("Cannot initialise graphics device. Check that you have a display output and not just a command line.");
                    System.exit(1);
                }
            }
        }
        ZAC = args[0];
        ZAC_value = null;
        if (argv.containsKey(ZAC)) {
            ZAC_value = argv.get(ZAC);
        }
        if (argv.containsKey("--experimental")) {
            ZPEInstance.EXPERIMENTAL = true;
            argv.remove("--experimental");
        }
        if (argv.containsKey("--error")) {
            ZPEInstance.ERROR_LEVEL = HelperFunctions.stringToInteger(argv.get("--error"));
            argv.remove("--error");
        }
        if (argv.containsKey("--silent") || ZAC.equals("--version")) {
            ZPEInstance.SILENT = true;
            argv.remove("--silent");
        } else {
            ZPE.PrintIntroduction(args);
        }
        if (argv.containsKey("--color")) {
            ZPEInstance.USE_COLOR = true;
            argv.remove("--color");
        }
        if (ZPEInstance.USE_COLOR) {
            AnsiConsole.systemInstall();
        }
        if (argv.containsKey("-level")) {
            if (ZPEInstance.PERMISSION_LEVEL_LOCKED) {
                System.err.println("The permission level is locked.");
            } else {
                t = argv.get("-level");
                if (HelperFunctions.isNumeric(t)) {
                    ZPEInstance.USER_DEFINED_PERMISSION_LEVEL = (int)Math.floor(HelperFunctions.stringToDouble(t));
                } else {
                    System.out.println("The $permission_level argument must be numeric.");
                }
            }
        }
        z = new ZPERuntimeEnvironment(ZPEInstance.USER_DEFINED_PERMISSION_LEVEL);
        var7_15 = ZAC;
        var8_16 = -1;
        switch (var7_15.hashCode()) {
            case 1492: {
                if (!var7_15.equals("-a")) break;
                var8_16 = 0;
                break;
            }
            case 1493: {
                if (!var7_15.equals("-b")) break;
                var8_16 = 1;
                break;
            }
            case 1494: {
                if (!var7_15.equals("-c")) break;
                var8_16 = 2;
                break;
            }
            case 2011284007: {
                if (!var7_15.equals("--copyright")) break;
                var8_16 = 3;
                break;
            }
            case 1496: {
                if (!var7_15.equals("-e")) break;
                var8_16 = 4;
                break;
            }
            case 1498: {
                if (!var7_15.equals("-g")) break;
                var8_16 = 5;
                break;
            }
            case 1499: {
                if (!var7_15.equals("-h")) break;
                var8_16 = 6;
                break;
            }
            case 1500: {
                if (!var7_15.equals("-i")) break;
                var8_16 = 7;
                break;
            }
            case 1501: {
                if (!var7_15.equals("-j")) break;
                var8_16 = 8;
                break;
            }
            case 1503: {
                if (!var7_15.equals("-l")) break;
                var8_16 = 9;
                break;
            }
            case 43006906: {
                if (!var7_15.equals("--man")) break;
                var8_16 = 10;
                break;
            }
            case 1505: {
                if (!var7_15.equals("-n")) break;
                var8_16 = 11;
                break;
            }
            case 1506: {
                if (!var7_15.equals("-o")) break;
                var8_16 = 12;
                break;
            }
            case 1507: {
                if (!var7_15.equals("-p")) break;
                var8_16 = 13;
                break;
            }
            case 1508: {
                if (!var7_15.equals("-q")) break;
                var8_16 = 14;
                break;
            }
            case 1495: {
                if (!var7_15.equals("-d")) break;
                var8_16 = 15;
                break;
            }
            case 1509: {
                if (!var7_15.equals("-r")) break;
                var8_16 = 16;
                break;
            }
            case 1510: {
                if (!var7_15.equals("-s")) break;
                var8_16 = 17;
                break;
            }
            case 1511: {
                if (!var7_15.equals("-t")) break;
                var8_16 = 18;
                break;
            }
            case 1512: {
                if (!var7_15.equals("-u")) break;
                var8_16 = 19;
                break;
            }
            case 1737589560: {
                if (!var7_15.equals("--version")) break;
                var8_16 = 20;
                break;
            }
            case 1514: {
                if (!var7_15.equals("-w")) break;
                var8_16 = 21;
                break;
            }
            case -951415813: {
                if (!var7_15.equals("--install")) break;
                var8_16 = 22;
                break;
            }
            case 1333620628: {
                if (!var7_15.equals("--zule")) break;
                var8_16 = 23;
                break;
            }
            case -316034746: {
                if (!var7_15.equals("--configure")) break;
                var8_16 = 24;
                break;
            }
            case 1561167465: {
                if (!var7_15.equals("--update")) break;
                var8_16 = 25;
            }
        }
        switch (var8_16) {
            case 0: {
                if (argv.containsKey("-a")) {
                    q = new File(argv.get("-a"));
                    if (!q.exists() || q.isDirectory()) {
                        System.err.println("File not found.");
                        System.exit(-1);
                    }
                    code = FileHelperFunctions.readFileAsString(argv.get("-a"), "utf-8");
                    try {
                        result = ZPEKit.validateCode(code);
                    }
                    catch (CompileException e) {
                        result = false;
                    }
                    if (result) {
                        System.out.println("The provided code is valid code and would compile using the ZPE compiler.");
                        break;
                    }
                    System.out.println("The provided code has errors and is not valid code.");
                    break;
                }
                System.out.println("The -a ZAC has the following syntax:");
                System.out.println("-a $filepath");
                break;
            }
            case 1: {
                if (ZAC_value != null) {
                    q = new File(ZAC_value.toString());
                    if (!q.exists() || q.isDirectory()) {
                        System.err.println("File not found.");
                        System.exit(-1);
                    }
                    verbose = argv.containsKey("-v");
                    code = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                    b = new YASSByteCodes();
                    for (byte symb : z.parseToBytes(code)) {
                        str = new byte[]{symb};
                        try {
                            System.out.print(HelperFunctions.getHexString(str) + " ");
                        }
                        catch (Exception e) {
                            System.out.print(symb + " ");
                        }
                        symbol = b.symbolToString(symb);
                        if (!verbose) continue;
                        System.out.print("(" + symbol + ") ");
                    }
                    break;
                }
                System.out.println("The -b ZAC has the following syntax:");
                System.out.println("-b $filepath [-v $verbose]");
                break;
            }
            case 2: {
                code = new StringBuilder();
                if (argv.containsKey("-c")) {
                    filename = "out.yex";
                    if (argv.containsKey("-o")) {
                        filename = argv.get("-o");
                    }
                    if (!filename.endsWith(".yex")) {
                        filename = (String)filename + ".yex";
                    }
                    if (!(q = new File(argv.get("-c"))).exists()) {
                        System.err.println("File not found.");
                        System.exit(-1);
                    }
                    if (q.isDirectory()) {
                        System.out.println("Compiling directory");
                        x = ZPE.listFileTree(q);
                        for (File f : x) {
                            code.append(FileHelperFunctions.readFileAsString(f.getAbsolutePath(), "utf-8")).append(System.lineSeparator());
                        }
                    } else {
                        code = new StringBuilder(FileHelperFunctions.readFileAsString(argv.get("-c"), "utf-8"));
                    }
                    lib = argv.containsKey("--library");
                    passcode = null;
                    if (argv.containsKey("-k")) {
                        passcode = argv.get("-k");
                    }
                    file_list = new ArrayList<String>();
                    if (argv.containsKey("-f")) {
                        dir = new File(argv.get("-f"));
                        for (File f : Objects.requireNonNull(dir.listFiles())) {
                            file_list.add(f.getAbsolutePath());
                        }
                    }
                    if (argv.containsKey("-optimise")) {
                        ZPEInstance.OPTIMISE_COMPILES = ZPEHelperFunctions.ToBoolean(argv.get("-optimise"));
                    }
                    c = new YASSCompiler();
                    details = new YASSCompiler.CompileDetails();
                    name = "";
                    author = System.getProperty("user.name");
                    if (!ZPEInstance.SILENT) {
                        name = ZPECore.readLine("Please insert the script name for the compiled file.");
                        ZPECore.print("Would you like to add the author as " + System.getProperty("user.name") + "? Type n to change it.");
                        if (ZPECore.readLine().equalsIgnoreCase("n")) {
                            author = ZPECore.readLine("Please insert the name of the author for the compiled file.");
                        }
                    }
                    details.name = name;
                    details.author = author;
                    startTime = Instant.now().toEpochMilli();
                    ZPECore.print("Compiling code from " + argv.get("-c") + " using Zenith Parsing Engine 1.5 to " + (String)filename + ".");
                    fList = new String[file_list.size()];
                    i = 0;
                    var23_176 = file_list.iterator();
                    while (var23_176.hasNext()) {
                        fList[i] = s = (String)var23_176.next();
                        ++i;
                    }
                    try {
                        result = c.compile(code.toString(), (String)filename, details, lib == false, passcode, fList);
                        if (result.getName().toString().equals("0")) {
                            ZPECore.print("Status code: 0x00. Successful compile.");
                            ZPECore.print("Compile output located at " + (String)filename + ".");
                            ZPECore.print();
                        }
                        if (result.getName().toString().equals("1")) {
                            ZPECore.print("Status code: 0x01. Unsuccessful compile.");
                            ZPECore.print("Please check syntax.");
                        }
                        if (result.getName().toString().equals("2")) {
                            ZPECore.print("Status code: 0x02. Unsuccessful compile.");
                            ZPECore.print("There are no functions within this code. Although ZPE can interpret this code using the -i ZAC, it cannot compile it to be run later.");
                        }
                        ZPECore.print("Compiled in " + (Instant.now().toEpochMilli() - startTime) + "ms");
                    }
                    catch (StackOverflowError e) {
                        ZPECore.print("Status code: 0x03. Stack overflow. ZPE out of memory.");
                    }
                    catch (CompileException ex) {
                        ZPECore.print("Status code: 0x01. Unsuccessful compile.");
                        ZPECore.print(ex.getMessage());
                    }
                    break;
                }
                System.out.println("The -c ZAC has the syntax:");
                System.out.println("-c $filepath [-o $outfile] [-k $key] [-o $optimise] [--library]");
                break;
            }
            case 3: {
                System.out.println(ZPE.getCopyrightInfo());
                break;
            }
            case 4: {
                if (!argv.containsKey("-e") || !argv.containsKey("-t")) ** GOTO lbl356
                q = new File(argv.get("-e"));
                if (!q.exists() || q.isDirectory()) {
                    System.err.println("File not found.");
                    System.exit(-1);
                }
                className = "output";
                if (argv.containsKey("-n")) {
                    temp = new File(argv.get("-n"));
                    className = temp.getName();
                    className = className.replaceAll("\\..*", "");
                }
                code = FileHelperFunctions.readFileAsString(argv.get("-e"), "utf-8");
                c = ZPEPluginManager.getTranspiler(argv.get("-t"));
                s = "";
                try {
                    try {
                        s = ZPEKit.convertCode(code, className, c);
                    }
                    catch (ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (CompileException e1) {
                    System.out.println("Compile failed. It is possible the code is not valid.");
                    System.exit(-1);
                }
                catch (TranspilerNotFoundException e1) {
                    System.out.println("The specified transpiler was not found or did not start correctly.");
                    System.exit(-1);
                }
                catch (ZPEException e) {
                    System.out.println(e.getMessage());
                }
                System.out.println(s);
                if (!argv.containsKey("-o")) break;
                try {
                    out = new PrintWriter(new BufferedWriter(new FileWriter(argv.get("-o"), false)));
                    try {
                        out.print(s);
                    }
                    finally {
                        out.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Write failed...");
                }
                break;
lbl356:
                // 1 sources

                System.out.println("The -e ZAC has the following syntax:");
                System.out.println("-e $filepath -o $outfile -n $class_name -t $language");
                break;
            }
            case 5: {
                err = System.err;
                if (ZPEHelperFunctions.isHeadless()) {
                    System.err.println("This application cannot be run because it is being run in a headless (non-GUI supporting) environment.");
                    System.exit(1);
                }
                try {
                    if (argv.containsKey("-g")) {
                        if (argv.containsKey("--console")) {
                            ZPECore.startConsole(args);
                            break;
                        }
                        if (args.length > 1) {
                            ZPEEditor.StartEditor(args[1]);
                            break;
                        }
                        ZPEEditor.StartEditor();
                        break;
                    }
                    ZPEEditor.StartEditor();
                }
                catch (Exception e) {
                    System.setErr(err);
                    System.err.println("Cannot initialise graphics device. Check that you have a display output and not just a command line.");
                    System.exit(1);
                }
                break;
            }
            case 6: {
                if (ZAC_value != null) {
                    if (ZAC_value.equals("changes")) {
                        System.out.println(ZPE.getChangeLog());
                        break;
                    }
                    if (ZAC_value.equals("log")) {
                        path = ZPEInstance.INSTALL_PATH + "/log.txt";
                        if (new File(path).exists()) {
                            ZPECore.print(FileHelperFunctions.readFileAsString(path));
                            break;
                        }
                        ZPECore.print("Log file not found. Ensure the log exists before trying to access it.");
                        break;
                    }
                    if (ZAC_value.equals("bytes")) {
                        for (int b : ZPEKit.getByteCodes().keySet()) {
                            bx = new StringBuilder("" + b);
                            while (bx.length() < 3) {
                                bx.insert(0, " ");
                            }
                            ZPECore.print(String.valueOf(bx) + " : " + ZPEKit.getByteCodes().get(b));
                        }
                        break;
                    }
                    if (ZAC_value.equals("commands")) {
                        Manual.printCommands();
                        System.out.println("You can find more information on all of the built-in commands at:");
                        System.out.println("https://www.jamiebalfour.scot/projects/zpe/");
                        break;
                    }
                    if (ZAC_value.equals("doc")) {
                        if (argv.containsKey("-f")) {
                            file = argv.get("-f");
                            try {
                                z.openCompiledFile(file, null);
                            }
                            catch (Exception b) {
                                // empty catch block
                            }
                            System.out.println("All available function names for " + argv.get("-f") + ": ");
                            System.out.println();
                            for (String s : z.globalFunction.functionMap.keySet()) {
                                if (z.globalFunction.functionMap.get((String)s).scope != 2) continue;
                                System.out.println("[+] " + s + ":");
                                for (String doc : ZPEKit.getFunctionDocumentation(z.globalFunction.functionMap.get(s))) {
                                    System.out.println(doc);
                                }
                                System.out.println();
                            }
                            break;
                        }
                        System.out.println("The -h doc command has the syntax:");
                        System.out.println("-h doc -f $filepath");
                        break;
                    }
                    if (ZAC_value.equals("config")) {
                        System.out.println();
                        System.out.println("The configuration file contains the following properties:");
                        System.out.println();
                        p = ZPEStartup.loadProperties();
                        longest = -1;
                        for (Object prop : p.keySet()) {
                            if (prop.toString().length() <= longest) continue;
                            longest = prop.toString().length();
                        }
                        for (Object prop : p.keySet()) {
                            output = new StringBuilder("  " + ZPEHelperFunctions.setConsoleEffectToGreen(prop.toString()));
                            for (i = prop.toString().length(); i < longest; ++i) {
                                output.append(" ");
                            }
                            output.append(" : ").append(p.get(prop));
                            System.out.println(output);
                        }
                        System.out.println();
                        System.out.println("The constants file contains the following constants:");
                        System.out.println();
                        longest = -1;
                        for (String constant : ZPEInstance.CONSTANTS.keySet()) {
                            if (constant.length() <= longest) continue;
                            longest = constant.length();
                        }
                        for (String constant : ZPEInstance.CONSTANTS.keySet()) {
                            output = new StringBuilder("  " + ZPEHelperFunctions.setConsoleEffectToGreen(constant));
                            for (i = constant.length(); i < longest; ++i) {
                                output.append(" ");
                            }
                            output.append(" : ").append(ZPEInstance.CONSTANTS.get((Object)constant).value);
                            System.out.println(output);
                        }
                        System.out.println();
                        exe = new File(ZPEInstance.EXECUTABLE_PATH);
                        System.out.println("The executable location for the application can be found at:");
                        System.out.println(ZPE.indentText() + exe.getAbsolutePath());
                        config = new File(ZPEInstance.CONFIGURATION_PATH);
                        System.out.println("The configuration file for the application can be found at:");
                        System.out.println(ZPE.indentText() + config.getAbsolutePath());
                        lib = new File(ZPEInstance.LIBRARY_IMPORT_DIRECTORY);
                        System.out.println("The library directory for the application can be found at:");
                        System.out.println(ZPE.indentText() + lib.getAbsolutePath());
                        plugin = new File(ZPEInstance.PLUGIN_DIRECTORY);
                        System.out.println("The plugin directory for the application can be found at:");
                        System.out.println(ZPE.indentText() + plugin.getAbsolutePath());
                        System.out.println("The executable file for the application can be found at:");
                        System.out.println(ZPE.indentText() + ZPEInstance.getJarExecPath());
                        break;
                    }
                    if (ZAC_value.equals("plugins")) {
                        System.out.println("All plugins are listed below:");
                        for (String s : ZPEPluginManager.addPlugins()) {
                            System.out.println(s);
                        }
                        break;
                    }
                    if (ZAC_value.equals("functions")) {
                        for (String s : YASSPredefinedFunctions.Commands) {
                            fun = YASSPredefinedFunctions.getInternalMethod(s);
                            System.out.println(YASSPredefinedFunctions.getManualHeader(fun));
                            try {
                                YASSPredefinedFunctions.mainMethod(fun, null, null);
                            }
                            catch (Exception s) {}
                        }
                        break;
                    }
                    System.out.println("You may use the following arguments to the -h ZAC:");
                    System.out.println("\"-h bytes\":     command to list all byte codes in this version of ZPE.");
                    System.out.println("\"-h changes\" :  command list all changes in the current ZPE version.");
                    System.out.println("\"-h commands\" : command to get all commands in this version of ZPE.");
                    System.out.println("\"-h config\"   : command to get a list of all properties set.");
                    System.out.println("\"-h doc\"      : command to get documentation on the contents of a file.");
                    System.out.println("\"-h log\"      : command to view the ZPE Log.");
                    System.out.println("\"-h plugins\"  : command to list all plugins available to ZPE.");
                    break;
                }
                System.out.println("You may use the following arguments to the -h ZAC:");
                System.out.println("\"-h bytes\":     command to list all byte codes in this version of ZPE.");
                System.out.println("\"-h changes\" :  command list all changes in the current ZPE version.");
                System.out.println("\"-h commands\" : command to get all commands in this version of ZPE.");
                System.out.println("\"-h config\"   : command to get a list of all properties set.");
                System.out.println("\"-h doc\"      : command to get documentation on the contents of a file.");
                System.out.println("\"-h log\"      : command to view the ZPE Log.");
                System.out.println("\"-h plugins\"  : command to list all plugins available to ZPE.");
                break;
            }
            case 7: {
                if (ZAC_value != null && !ZAC_value.equals("")) {
                    if (!ZPEInstance.SILENT) {
                        System.out.println("Running code: " + String.valueOf(ZAC_value));
                    }
                    try {
                        z.runCode(ZAC_value.toString(), null);
                        break;
                    }
                    catch (CompileException e) {
                        System.exit(-1);
                        break;
                    }
                    catch (ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExitHalt e) {
                        System.exit(HelperFunctions.stringToInteger(e.getMessage()));
                        break;
                    }
                    catch (BreakPointHalt e) {
                        ZPE.ThrowBreakPointException(z);
                        break;
                    }
                }
                System.out.println("ZPE interactive shell");
                System.out.println();
                if (ZPEInstance.USE_SANDBOX) {
                    System.out.println("Running in file sandbox mode");
                }
                System.out.println("For help, type 'help()'");
                System.out.println("Type 'exit()' to leave the interactive mode YASS interpreter. Permission level " + ZPEInstance.USER_DEFINED_PERMISSION_LEVEL);
                new YASSInteractiveInterpreter();
                break;
            }
            case 8: {
                if (ZAC_value != null) {
                    json = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                    parser = new ZenithJSONParser();
                    try {
                        json_props = (ZPEMap)parser.jsonDecode(json, false);
                    }
                    catch (MalformedJSONException | ZPERuntimeException e) {
                        throw new RuntimeException(e);
                    }
                    if (json_props.containsKey(new ZPEString("command"))) {
                        System.out.println("Insert a command to run it directly.");
                        break;
                    }
                    if (!json_props.containsKey(new ZPEString("file"))) break;
                    file = json_props.get(new ZPEString("file")).toString();
                    file = file.replace("~", System.getProperty("user.home"));
                    code = FileHelperFunctions.readFileAsString(file, "utf-8");
                    l = (ZPEList)json_props.get(new ZPEString("params"));
                    params = new ZPEType[l.size()];
                    for (i = 0; i < l.size(); ++i) {
                        params[i] = l.get(i);
                    }
                    try {
                        result = z.interpret(code, params);
                        if (result == null || !json_props.containsKey(new ZPEString("output"))) break;
                        output = json_props.get(new ZPEString("output")).toString().replace("~", System.getProperty("user.home"));
                        if (result instanceof ZPEString || result instanceof ZPENumber || result instanceof ZPEBoolean) {
                            FileHelperFunctions.writeFile(output, result.toString(), false);
                            break;
                        }
                        fos = new FileOutputStream(output);
                        try {
                            fos.write(HelperFunctions.toByteArray(result));
                            fos.close();
                        }
                        catch (Exception e) {
                            fos.close();
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        System.exit(1);
                    }
                    break;
                }
                if (argv.containsKey("--info")) {
                    System.out.println("The JSON file should have the following syntax:");
                    System.out.println("{file : \"filename\", output : \"where_to_put_result\", args : \"program_arguments\"}");
                    System.exit(0);
                }
                System.out.println("The -j ZAC has the following syntax:");
                System.out.println("-j --info");
                System.out.println("-j $filepath");
                break;
            }
            case 9: {
                rd = new ZPERuntimeDaemon(ZPEInstance.getUserDefinedPermissionLevelProperty());
                rd.start();
                break;
            }
            case 10: {
                if (ZAC_value != null) {
                    if (argv.containsKey("--html")) {
                        System.out.println(ZPEKit.getFunctionManualEntryAsHtml(ZAC_value.toString()));
                        break;
                    }
                    Manual.getManualEntry(z, ZAC_value.toString());
                    break;
                }
                System.out.println("The --man ZAC has the following syntax:");
                System.out.println("--man $command_name");
                break;
            }
            case 11: {
                if (argv.containsKey("-n")) {
                    port = argv.get("-n");
                    file = null;
                    if (port == null) {
                        port = "6001";
                    }
                    v0 = server = argv.containsKey("-h") == false;
                    if (server) {
                        password = null;
                        p = ZPEInstance.USER_DEFINED_PERMISSION_LEVEL;
                        if (argv.containsKey("-level")) {
                            t = argv.get("-level");
                            if (HelperFunctions.isNumeric(t)) {
                                p = (int)Math.floor(HelperFunctions.stringToDouble(t));
                            } else {
                                System.out.println("The $permission_level argument must be numeric.");
                            }
                        }
                        if (argv.containsKey("-k")) {
                            password = argv.get("-k");
                        } else {
                            try {
                                ZPECore.printWarning("You are opening a new ZENServer instance without a password. Any communication between ZENClients will be in plain text.");
                            }
                            catch (ZPERuntimeException e) {
                                System.out.println("The server will not start as a result of this.");
                            }
                        }
                        if (argv.containsKey("-f") && new File(argv.get("-f")).exists()) {
                            file = argv.get("-f");
                            System.out.println("Prepending file " + file + " to server requests.");
                        }
                        if (ZPEInstance.SERVER_AUTO_UPDATE && ZPEUpdater.getInstance().isUpdateAvailable()) {
                            try {
                                ZPEUpdater.getInstance().runUpdate(false);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        System.out.println("Opening ZENServer on port " + port + " on " + String.valueOf(InetAddress.getLocalHost()));
                        s = new ZENServer();
                        s.Start(HelperFunctions.stringToInteger(port), p, password, file);
                        break;
                    }
                    host = argv.get("-h");
                    client = argv.containsKey("-k") != false ? new ZENClient(host, argv.get("-k"), HelperFunctions.stringToInteger(port), new ZPERuntimeEnvironment(ZPEInstance.USER_DEFINED_PERMISSION_LEVEL)) : new ZENClient(host, HelperFunctions.stringToInteger(port), new ZPERuntimeEnvironment(ZPEInstance.USER_DEFINED_PERMISSION_LEVEL));
                    if (argv.containsKey("-r")) {
                        try {
                            cmd = argv.get("-r");
                            client.openConnection();
                            result = client.sendZPECommand(cmd);
                            if (result != null) {
                                System.out.println(result);
                                throw new ExitHalt(0);
                            }
                            System.out.println("Failure.");
                            throw new ExitHalt(1);
                        }
                        catch (Exception e) {
                            System.err.println(e.getMessage());
                            break;
                        }
                    }
                    client.openPersistentConnection();
                    break;
                }
                System.err.println("No port number specified.");
                System.out.println("The -n ZAC has the following syntax:");
                System.out.println("-n $port [-level $permissions] [-k $key]");
                System.out.println("-n $port -h $host [-k $k]");
                break;
            }
            case 12: {
                if (ZAC_value == null) {
                    try {
                        list = ZPEOnline.listAllFiles();
                        output = new StringBuilder();
                        for (ZPEType item : list) {
                            map = (ZPEMap)item;
                            output.append(map.get(new ZPEString("name"))).append(" => ").append(map.get(new ZPEString("hash"))).append(System.lineSeparator());
                        }
                        System.out.println(output);
                    }
                    catch (Exception e) {
                        System.err.println("There was an error connecting to ZPE Online.");
                    }
                }
                if (!argv.containsKey("-o")) break;
                hash = argv.get("-o");
                try {
                    output = ZPEOnline.downloadAndCompileLibraryFile(hash);
                    if (argv.containsKey("-f")) break;
                    System.out.println((String)output.get("code"));
                }
                catch (Exception e) {
                    System.err.println("There was an error connecting to ZPE Online.");
                }
                break;
            }
            case 13: {
                p = ZPEStartup.loadProperties();
                if (p == null) {
                    System.err.println("Properties file does not exist. Please run ZPE configuration to create it.");
                    System.exit(1);
                }
                key = "";
                if (argv.containsKey("-k") || argv.containsKey("-v")) {
                    if (argv.containsKey("-k")) {
                        key = argv.get("-k");
                    } else {
                        System.err.println("No -k argument given.");
                        System.exit(1);
                    }
                    if (argv.containsKey("-v")) {
                        value = argv.get("-v");
                    } else {
                        ZPECore.print("Please insert a value for the property " + key + ".");
                        converter = new InputStreamReader(System.in);
                        in = new BufferedReader(converter);
                        value = in.readLine();
                    }
                    if (!value.isEmpty()) {
                        p.setProperty(key, value);
                        try {
                            output = new FileOutputStream(ZPEInstance.CONFIGURATION_PATH);
                            p.store(output, null);
                            System.out.println("Value for " + key + " is set to " + value);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to write the properties file. Please ensure that " + ZPEInstance.CONFIGURATION_PATH + " is writeable by ZPE.");
                            System.exit(1);
                        }
                    } else {
                        System.out.println("The value for the property \"" + key + "\" is \"" + p.getProperty(key) + "\"");
                    }
                } else {
                    System.out.println(ZPEInstance.CONFIGURATION_PATH);
                    System.out.println("All set properties:");
                    System.out.println();
                    for (Object prop : p.keySet()) {
                        System.out.println(ZPEHelperFunctions.setConsoleEffectToGreen(prop.toString()) + " : " + String.valueOf(p.get(prop)));
                    }
                    System.out.println();
                }
                System.exit(0);
            }
            case 14: {
                if (ZPEHelperFunctions.isHeadless()) {
                    System.err.println("This application cannot be run because it is being run in a headless (non-GUI supporting) environment.");
                    System.exit(1);
                }
                c = new CommandWindow();
                c.setVisible(true);
                break;
            }
            case 15: 
            case 16: {
                if (ZAC_value != null) {
                    code = "";
                    sha1 = "";
                    useCache = false;
                    if (ZAC.equals("-d")) {
                        ZPEInstance.DEBUGGING = true;
                    }
                    filepath = ZAC_value.toString();
                    if (ZAC_value.toString().startsWith("http://") || ZAC_value.toString().startsWith("https://")) {
                        code = HelperFunctions.readString(ZAC_value.toString());
                    } else {
                        ZPEInstance.SCRIPT_PATH = q = new File(ZAC_value.toString());
                        ZPEInstance.SCRIPT_DIRECTORY = q.getParent();
                        if (!q.exists() || q.isDirectory()) {
                            System.err.println("File " + String.valueOf(q) + "  not found.");
                            System.exit(-1);
                        }
                        if (ZPEInstance.USE_ZPEC) {
                            f = new File(filepath);
                            try {
                                sha1 = HelperFunctions.sha1(f.getAbsolutePath());
                                if (new File(ZPEInstance.getCacheDirectory() + sha1 + ".yex").exists()) {
                                    if (new File(ZPEInstance.getCacheDirectory() + sha1 + ".yex").lastModified() != f.lastModified()) ** GOTO lbl770
                                    useCache = true;
                                }
                                code = FileHelperFunctions.readFileAsString(filepath, "utf-8");
                            }
                            catch (Exception e) {
                                throw new RuntimeException("ZPE Performance Enhanced Cache is not supported on this setup. Ensure you have the sha1 message digest algorithm installed.");
                            }
                        } else {
                            code = FileHelperFunctions.readFileAsString(filepath, "utf-8");
                        }
                    }
lbl770:
                    // 5 sources

                    params = new ZPEString[program_arguments.size()];
                    for (i = 0; i < program_arguments.size(); ++i) {
                        params[i] = new ZPEString((String)program_arguments.get(i));
                    }
                    try {
                        path = ZPEInstance.getCacheDirectory() + sha1 + ".yex";
                        if (!useCache) {
                            if (ZPEInstance.USE_ZPEC) {
                                c = new YASSCompiler();
                                c.compile(code, path, new YASSCompiler.CompileDetails(), true);
                                out = z.runApplication(path, (ZPEString[])params, null);
                            } else {
                                out = z.interpret(code, params);
                            }
                        } else {
                            out = z.runApplication(path, (ZPEString[])params, null);
                        }
                        if (out == null || out.toString().isEmpty()) break;
                        System.out.println("Returned: " + String.valueOf(out));
                    }
                    catch (ExitHalt e) {
                        System.exit(HelperFunctions.stringToInteger(e.getMessage()));
                    }
                    catch (BreakPointHalt e) {
                        if (!ZPEInstance.DEBUGGING) break;
                        ZPEHelperFunctions.throwBreakPointException(z);
                    }
                    catch (ZPERuntimeException e) {
                        ZPECore.printError(e.getMessage());
                    }
                    catch (Exception e) {
                        if (ZPEInstance.ERROR_LEVEL >= 3) {
                            e.printStackTrace();
                        }
                        ZPECore.printError(e.getMessage());
                    }
                    break;
                }
                System.out.println("The " + ZAC + " ZAC has the following syntax:");
                System.out.println(ZAC + " $filepath [-args $args]");
                break;
            }
            case 17: {
                if (ZAC_value != null) {
                    q = new File(ZAC_value.toString());
                    if (!q.exists() || q.isDirectory()) {
                        System.err.println("File not found.");
                        System.exit(-1);
                    }
                    code = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                    if (argv.containsKey("-c")) {
                        System.out.println(ZPEKit.cleanUpString(code));
                        break;
                    }
                    for (String s : ZPEKit.parseToString(code)) {
                        System.out.print(s + " ");
                    }
                    break;
                }
                System.out.println("The -s ZAC has the following syntax:");
                System.out.println("-s $filepath [-c $clean_up]");
                break;
            }
            case 18: {
                if (ZAC_value != null) {
                    q = new File(ZAC_value.toString());
                    if (!q.exists() || q.isDirectory()) {
                        System.err.println("File " + args[1] + " not found.");
                        System.exit(-1);
                    }
                    code = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                    try {
                        z.printCodeTree(code);
                    }
                    catch (CompileException | ZPERuntimeException e) {
                        System.err.println("Compilation error when trying to compile the code. Tree could not be generated.");
                    }
                    break;
                }
                System.out.println("The -t ZAC has the following syntax:");
                System.out.println("-t $filepath");
                break;
            }
            case 19: {
                if (ZAC_value != null) {
                    try {
                        asHtml = argv.containsKey("--html");
                        if (!new File(ZAC_value.toString()).exists()) {
                            System.err.println("File does not exist.");
                        }
                        file = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                        ZPECore.print(ZPEKit.unfold(file, asHtml));
                    }
                    catch (Exception e) {
                        ZPECore.log(e.getMessage());
                        System.err.println("YASS Unfold failure. Check that the file exists.");
                    }
                    break;
                }
                System.out.println("The -u ZAC has the following syntax:");
                System.out.println("-u $filepath [--html]");
                break;
            }
            case 20: {
                if (argv.containsKey("--json")) {
                    parser = new ZenithJSONParser();
                    props = new ZPEMap();
                    props.put(new ZPEString("name"), new ZPEString(ZPECore.getVersionName()));
                    props.put(new ZPEString("version"), new ZPEString(ZPECore.getVersionNumber()));
                    props.put(new ZPEString("date"), new ZPEString("September 2025"));
                    props.put(new ZPEString("major_version"), new ZPEString("1.13"));
                    props.put(new ZPEString("minor_version"), new ZPEString("9"));
                    props.put(new ZPEString("build"), new ZPENumber(ZPECore.getBuildVersion()));
                    props.put(new ZPEString("build_date"), new ZPEString(ZPECore.getBuildDate()));
                    props.put(new ZPEString("build_time"), new ZPEString(ZPECore.getBuildTime()));
                    props.put(new ZPEString("zpe_cli_version"), new ZPEString("1.8.1"));
                    props.put(new ZPEString("yass_version"), new ZPEString("YASS 25.5"));
                    props.put(new ZPEString("zen_version"), new ZPEString("20X"));
                    System.out.println(parser.jsonEncode(props));
                    break;
                }
                System.out.print("ZPE Programming Environment version " + ZPEHelperFunctions.setConsoleEffectToCyan(ZPECore.getVersionNumber()) + " \"" + ZPEHelperFunctions.setConsoleEffectToItalic(ZPECore.getVersionName()) + "\" " + ZPECore.getVersionDate() + " [" + ZPECore.getBuildDate() + " @ " + ZPECore.getBuildTime() + "]");
                if (argv.containsKey("--verbose")) {
                    HelperFunctions.printBlankLines(2);
                    System.out.println("ZPE CLI version                        : 1.8.1");
                    System.out.println("YASS syntax version                    : YASS 25.5 (2025)");
                    System.out.println("LAME                                   : " + LAMEX2.VERSION);
                    System.out.println("Package version major                  : 1.13");
                    System.out.println("Package version minor                  : 9");
                    System.out.println("Package build version                  : " + ZPECore.getBuildVersion());
                    System.out.println("Package build date/time                : " + ZPECore.getBuildDate() + " @ " + ZPECore.getBuildTime());
                    System.out.println("Runtime version name                   : Gillygate");
                    System.out.println("Runtime date                           : September 2025");
                    System.out.println("ZEN version                            : 20X");
                    System.out.println("Zenith Parsing Engine version          : 1.5");
                }
                HelperFunctions.printBlankLines(2);
                System.exit(0);
                break;
            }
            case 21: {
                if (ZAC_value != null) {
                    ZPEInstance.SCRIPT_PATH = q = new File(ZAC_value.toString());
                    ZPEInstance.SCRIPT_DIRECTORY = q.getParent();
                    if (!q.exists() || q.isDirectory()) {
                        System.err.println("File not found.");
                        System.exit(-1);
                    }
                    code = FileHelperFunctions.readFileAsString(ZAC_value.toString(), "utf-8");
                    System.out.println(new ZENWebParser(ZPEInstance.USER_DEFINED_PERMISSION_LEVEL).parse(code, new HashMap<String, ZPEType>()));
                } else {
                    System.out.println("The -w ZAC has the following syntax:");
                    System.out.println("-w $filepath");
                }
                System.exit(0);
            }
            case 22: {
                main_properties = ZPEStartup.loadProperties();
                if (main_properties.getProperty("HAS_INSTALLED_LIBRARY", "false").equals("false") && !new File(ZPEInstance.LIBRARY_IMPORT_DIRECTORY + "stdLib.yex").exists()) {
                    if (ZPECore.programArguments.length != 0 || ZPECore.IGNORE_STARTUP) {
                        try {
                            main_properties.setProperty("HAS_INSTALLED_LIBRARY", "true");
                            if (ZPECore.readLine("Would you like to add the standard library to the install?").equals("y")) {
                                ZPEKit.compile(HelperFunctions.getResource("/files/stdLib.yas"), ZPEInstance.LIBRARY_IMPORT_DIRECTORY + "stdLib.yex", "stdLib", "Jamie Balfour", false);
                            }
                        }
                        catch (Exception e) {
                            main_properties.setProperty("HAS_INSTALLED_LIBRARY", "true");
                            System.err.println("Standard Library could not be compiled.");
                        }
                    }
                    try {
                        HelperFunctions.saveProperties(main_properties, ZPEInstance.CONFIGURATION_PATH, "This is a list of ZPE properties and can be modified to change ZPE settings.");
                    }
                    catch (Exception e) {
                        ZPECore.printError("Startup properties could not be saved correctly.");
                    }
                }
                if (argv.containsKey("--do")) {
                    ZPEHelperFunctions.installZPE();
                    break;
                }
                ZPE.createInstallScript();
                break;
            }
            case 23: {
                if (ZAC_value == null) {
                    System.out.println("The --zule ZAC has the following syntax:");
                    System.out.println("--zule list");
                    System.out.println("--zule install $file [-d $zpe_directory]");
                    System.exit(0);
                }
                if ((n = ZAC_value.toString()).equals("install")) {
                    try {
                        n = args[2];
                        ZULEPackageManager.install(n);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        System.err.println("Error within vector " + n);
                        System.exit(1);
                    }
                    break;
                }
                if (!n.equals("list")) break;
                try {
                    ZULEPackageManager.list();
                }
                catch (MalformedJSONException | ZPERuntimeException e) {
                    System.err.println("ZULE Packages could not be listed.");
                }
                System.out.println();
                break;
            }
            case 24: {
                ZPEStartup.writeDefaultProperties();
                break;
            }
            case 25: {
                force = argv.containsKey("-f");
                nightly = argv.containsKey("-n");
                ZPEUpdater.getInstance().checkForUpdate(nightly);
                if (!force && !ZPEUpdater.getInstance().isUpdateAvailable()) {
                    System.out.println("No updates are available at this time. The latest version is " + ZPEUpdater.getInstance().getUpdateVersionNumber() + " (" + ZPEUpdater.getInstance().getUpdateVersionName() + ").");
                    System.exit(0);
                } else if (force) {
                    name = ZPEUpdater.getInstance().getUpdateVersionName();
                    number = ZPEUpdater.getInstance().getUpdateVersionNumber();
                    if (!name.isEmpty()) {
                        name = " (\"" + (String)name + "\")";
                    }
                    System.out.println("Version " + number + (String)name + " is available to download.");
                    System.out.println("Would you like to download this version of ZPE? Type y to update or anything else to quit.");
                } else if (ZPEUpdater.getInstance().isUpdateAvailable()) {
                    name = ZPEUpdater.getInstance().getUpdateVersionName();
                    number = ZPEUpdater.getInstance().getUpdateVersionNumber();
                    if (!name.isEmpty()) {
                        name = " (\"" + (String)name + "\")";
                    }
                    System.out.println("There is an update available for ZPE. Version " + number + (String)name + " is now available to download.");
                    System.out.println("You are currently running version 1.13.9." + ZPECore.getBuildVersion() + " (Gillygate).");
                    System.out.println("Would you like to update? Type y to update or anything else to quit.");
                }
                converter = new InputStreamReader(System.in);
                in = new BufferedReader(converter);
                answer = in.readLine();
                if (!answer.equals("y")) break;
                try {
                    ZPEUpdater.getInstance().runUpdate(nightly);
                    System.out.println("ZPE has been updated successfully.");
                    ZPE.PrintIntroduction(new String[0]);
                    System.exit(0);
                }
                catch (Exception e) {
                    System.err.println("An error occurrences while trying to update. Please check https://www.jamiebalfour.scot/system-status/to see if the ZPE Updater service is running and then try again later.");
                    System.out.println(e.getMessage());
                    System.exit(1);
                }
                break;
            }
            default: {
                if (ZAC.startsWith("-")) break;
                ZPEInstance.SCRIPT_PATH = f = new File(ZAC);
                ZPEInstance.SCRIPT_DIRECTORY = f.getParent();
                if (f.exists() && !f.isDirectory()) {
                    params_start = 1;
                    passcode = null;
                    if (argv.containsKey("-k")) {
                        params_start += 2;
                        passcode = argv.get("-k");
                    }
                    if (argv.containsKey("-level")) {
                        params_start += 2;
                    }
                    if (argv.containsKey("--info")) {
                        exe = z.readCompiledApplication(ZAC);
                        if (exe != null) {
                            ZPECore.print("Compiled file path   : " + f.getAbsolutePath());
                            ZPECore.print("Compiled file name   : " + exe.name);
                            ZPECore.print("Compiled file author : " + exe.getAuthor());
                            ZPECore.print("Compiler version     : " + exe.getCompilerVersion());
                            ZPECore.print("Compiled timestamp   : " + String.valueOf(new Date(exe.getCompiledTime())));
                        } else {
                            ZPECore.print("Version could not be ascertained from the file.");
                        }
                        System.exit(0);
                    }
                    params = new ZPEString[args.length - params_start];
                    keys = new ZPEString[args.length];
                    for (i = params_start; i < args.length; ++i) {
                        params[i - params_start] = new ZPEString(args[i]);
                        keys[i - params_start] = new ZPEString(args[i]);
                    }
                    System.arraycopy(keys, params_start, params, 0, args.length - params_start);
                    try {
                        out = z.runApplication(ZAC, (ZPEString[])params, passcode);
                        if (out != null && !out.toString().isEmpty()) {
                            System.out.println(out);
                        }
                        System.exit(0);
                    }
                    catch (IOException e) {
                        ZPECore.print("File does not exist!");
                        System.exit(1);
                    }
                    catch (PasswordException e) {
                        if (passcode != null) break;
                        ZPECore.print("Please insert the password for the compiled ZPE/YASS file " + ZAC + ".");
                        passcode = String.valueOf(System.console().readPassword());
                        try {
                            out = z.runApplication(ZAC, (ZPEString[])params, passcode);
                            if (out != null && !out.toString().isEmpty()) {
                                System.out.println(out);
                            }
                            System.exit(0);
                        }
                        catch (NoEntryPointException | NonExecutableFileException | PasswordException | IOException e1) {
                            System.err.println(e1.getMessage());
                        }
                        catch (Exception e1) {
                            System.err.print("Could not open file. Check that password is correct and provided with the -k argument.");
                        }
                    }
                    catch (NoEntryPointException e) {
                        System.err.println(e.getMessage());
                        System.exit(7);
                    }
                    catch (BreakPointHalt ex) {
                        System.err.println(ex.getMessage());
                        System.exit(0);
                    }
                    catch (NonExecutableFileException e) {
                        code = FileHelperFunctions.readFileAsString(ZAC, "utf-8");
                        try {
                            out = z.interpret(code, params);
                            if (out == null || out.toString().isEmpty()) break;
                            System.out.println("Returned: " + String.valueOf(out));
                        }
                        catch (CompileException ex) {
                            System.err.println(ex.getMessage());
                            System.exit(8);
                        }
                        catch (ZPERuntimeException ex) {
                            System.err.println(ex.getMessage());
                            System.exit(9);
                        }
                        catch (BreakPointHalt ex) {
                            System.err.println(ex.getMessage());
                            System.exit(0);
                        }
                    }
                    catch (ZPERuntimeException e) {
                        System.err.println(e.getMessage());
                        System.exit(9);
                    }
                    break;
                }
                System.err.println("File could not be found");
                System.exit(-1);
            }
        }
    }
}

