/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class BalfHeader
extends JPanel {
    private final Color background;
    private boolean darkMode = false;
    private final int rounding;

    public BalfHeader(Color background, int rounding) {
        this.rounding = rounding;
        this.background = background;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            this.darkMode = enabled;
            this.repaint();
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        int r = (int)Math.min((double)this.rounding, (double)h / 2.0);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Color fill = this.darkMode ? BalfLafManager.getInstance().getDarkColorComponentBackground() : this.background;
        g2.setColor(fill);
        g2.fillRect(0, r, w, h - r);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, w, 2 * r, r, r));
        super.paintComponent(g2);
        g2.dispose();
    }
}

