/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.UITheme;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class BalfLafManager
extends UIManager.LookAndFeelInfo {
    boolean darkMode = false;
    private Color darkColorForeground = new Color(214, 216, 220);
    private Color darkColorBackground = new Color(43, 45, 48);
    private Color darkColorComponentBackground = new Color(60, 60, 60);
    private Color darkColorInputBackground = new Color(62, 62, 66);
    private Color darkColorMenuHoverBackground = new Color(120, 120, 120);
    static BalfLafManager instance;
    private UITheme theme = null;
    private final List<DarkModeListener> darkModeListeners = new ArrayList<DarkModeListener>();
    private final List<ThemeChangeListener> themeChangeListeners = new ArrayList<ThemeChangeListener>();
    static Font balfLafFont;

    private BalfLafManager() {
        super("BalfLafManager", "balflaf");
    }

    public static BalfLafManager getInstance() {
        if (instance == null) {
            instance = new BalfLafManager();
        }
        return instance;
    }

    public void addDarkModeListener(DarkModeListener listener) {
        this.darkModeListeners.add(listener);
        listener.onDarkModeChanged(this.darkMode);
    }

    public void removeDarkModeListener(DarkModeListener listener) {
        this.darkModeListeners.remove(listener);
    }

    public void toggleDarkMode(boolean enabled) {
        for (DarkModeListener l : this.darkModeListeners) {
            this.darkMode = enabled;
            l.onDarkModeChanged(enabled);
        }
    }

    public void addThemeChangeListener(ThemeChangeListener listener) {
        this.themeChangeListeners.add(listener);
        listener.onThemeChanged();
    }

    public void removeThemeChangeListener(DarkModeListener listener) {
        this.darkModeListeners.remove(listener);
    }

    public void setTheme(UITheme theme) {
        this.theme = theme;
        for (ThemeChangeListener l : this.themeChangeListeners) {
            l.onThemeChanged();
        }
    }

    public UITheme getTheme() {
        return this.theme;
    }

    public void setDarkColorForeground(Color color) {
        this.darkColorForeground = color;
    }

    public void setDarkColorBackground(Color color) {
        this.darkColorBackground = color;
    }

    public void setDarkColorInputBackground(Color color) {
        this.darkColorInputBackground = color;
    }

    public void setDarkColorComponentBackground(Color color) {
        this.darkColorComponentBackground = color;
    }

    public void setDarkColorMenuHoverBackground(Color color) {
        this.darkColorMenuHoverBackground = color;
    }

    public Color getDarkColorForeground() {
        return this.darkColorForeground;
    }

    public Color getDarkColorBackground() {
        return this.darkColorBackground;
    }

    public Color getDarkColorInputBackground() {
        return this.darkColorInputBackground;
    }

    public Color getDarkColorComponentBackground() {
        return this.darkColorComponentBackground;
    }

    public Color getDarkColorMenuHoverBackground() {
        return this.darkColorMenuHoverBackground;
    }

    public boolean isDarkModeEnabled() {
        return this.darkMode;
    }

    public static Font getBalfLafFont() {
        if (balfLafFont != null) {
            return balfLafFont;
        }
        if (!HelperFunctions.isMac()) {
            try {
                balfLafFont = HelperFunctions.loadFontFromJar("/files/InstrumentSans.ttf", 14.0f);
            }
            catch (Exception ex1) {
                try {
                    balfLafFont = HelperFunctions.getSystemUserFont(14);
                }
                catch (Exception ex) {
                    balfLafFont = new Font(HelperFunctions.getBestAvailableFont(true), 0, 14);
                }
            }
        } else {
            try {
                balfLafFont = HelperFunctions.getSystemDisplayFont(14);
            }
            catch (Exception ex) {
                balfLafFont = new Font(HelperFunctions.getBestAvailableFont(true), 0, 14);
            }
        }
        return balfLafFont;
    }

    public static interface ThemeChangeListener {
        public void onThemeChanged();
    }

    public static interface DarkModeListener {
        public void onDarkModeChanged(boolean var1);
    }
}

