/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import jamiebalfour.parsers.csv.ZenithCSVParser;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

class eTraxionHelperFunctions {
    private static final String DB_URL = "jdbc:sqlite:";

    eTraxionHelperFunctions() {
    }

    public static Connection getConnection(String database) throws SQLException {
        return DriverManager.getConnection(DB_URL + database);
    }

    public static List<List<String>> parseCSV(String csv) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        boolean inQuotes = false;
        StringBuilder current = new StringBuilder();
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < csv.length(); ++i) {
            char c = csv.charAt(i);
            if (c == '\"') {
                if (inQuotes && i + 1 < csv.length() && csv.charAt(i + 1) == '\"') {
                    current.append('\"');
                    ++i;
                    continue;
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                row.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (!(c != '\n' && c != '\r' || inQuotes)) {
                if (current.length() > 0 || !row.isEmpty()) {
                    row.add(current.toString());
                    current.setLength(0);
                }
                if (!row.isEmpty()) {
                    rows.add(new ArrayList(row));
                    row.clear();
                }
                if (c != '\r' || i + 1 >= csv.length() || csv.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0 || !row.isEmpty()) {
            row.add(current.toString());
            rows.add(row);
        }
        return rows;
    }

    public static boolean importFromCsv(String filename, TableModel tableModel) {
        if (new File(filename).exists()) {
            try {
                String content = FileHelperFunctions.readFileAsString(filename);
                List<List<String>> l = eTraxionHelperFunctions.parseCSV(content);
                DefaultTableModel model = (DefaultTableModel)tableModel;
                model.setRowCount(0);
                int i = 0;
                for (List<String> a : l) {
                    model.addRow(new Object[model.getColumnCount()]);
                    int j = 0;
                    for (String b : a) {
                        tableModel.setValueAt(b, i, j);
                        ++j;
                    }
                    ++i;
                }
                model.addRow(new Object[model.getColumnCount()]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private static boolean columnExists(ResultSetMetaData meta, String targetColumn) throws SQLException {
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            if (!meta.getColumnName(i).equalsIgnoreCase(targetColumn)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<DataTable.DataColumn> getColumns(Connection conn) {
        ArrayList<DataTable.DataColumn> columns = new ArrayList<DataTable.DataColumn>();
        try (Statement stmt = conn.createStatement();
             ResultSet rsCols = stmt.executeQuery("SELECT * FROM column_info ORDER BY display_order");){
            ResultSetMetaData meta = rsCols.getMetaData();
            while (rsCols.next()) {
                DataTable.DataColumn col = new DataTable.DataColumn(rsCols.getString("column_id"));
                col.setName(rsCols.getString("column_name"));
                col.setTypeFromString(rsCols.getString("column_type"));
                if (eTraxionHelperFunctions.columnExists(meta, "sheet_id")) {
                    col.setSheetId(rsCols.getString("sheet_id"));
                }
                col.setData(rsCols.getString("column_data"));
                col.setDisplayOrder(HelperFunctions.stringToInteger(rsCols.getString("display_order")));
                if (eTraxionHelperFunctions.columnExists(rsCols.getMetaData(), "column_formatting")) {
                    col.setFormattingRules(rsCols.getString("column_formatting"));
                }
                columns.add(col);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return columns;
    }

    public static void updateColumns(DefaultTableModel tableModel, DataTable table, ArrayList<DataTable.DataColumn> columnData) {
        int rowCount = tableModel.getRowCount();
        Object[][] data = new Object[rowCount][tableModel.getColumnCount()];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                data[i][j] = table.getValueAt(i, j);
            }
        }
        Object[] columnNames = new String[columnData.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = columnData.get(i).getName();
        }
        tableModel.setDataVector(data, columnNames);
        ZenithJSONParser jsonParser = new ZenithJSONParser();
        DataTable.CellRenderer borderRenderer = new DataTable.CellRenderer(table);
        for (int i = 0; i < columnData.size(); ++i) {
            String[] dropdownOptions;
            ZPEMemberType z2;
            table.getColumnModel().getColumn(i).setCellRenderer(borderRenderer);
            if (columnData.get(i).getType() == DataTable.ColumnType.MAP) {
                try {
                    z2 = (ZPEMap)jsonParser.jsonDecode(columnData.get(i).getData(), false);
                    dropdownOptions = new String[((ZPEMap)z2).size()];
                    int j = 0;
                    if (columnData.get(i).getType() == DataTable.ColumnType.MAP) {
                        for (ZPEType m : ((ZPEMap)z2).keySet()) {
                            dropdownOptions[j++] = m.toString();
                        }
                    }
                    table.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(new DataTable.MapComboBox(dropdownOptions, null, table, (ZPEMap)z2)));
                }
                catch (Exception z2) {}
                continue;
            }
            if (columnData.get(i).getType() != DataTable.ColumnType.LIST) continue;
            try {
                z2 = (ZPEList)jsonParser.jsonDecode(columnData.get(i).getData(), false);
                dropdownOptions = new String[((ZPEList)z2).size()];
                table.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(new DataTable.ListComboBox(dropdownOptions, null, table, (ZPEList)z2)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String loadGenericTableData(Connection conn2, ReportBuilderMain m, DefaultTableModel tableModel, DataTable table) throws SQLException {
        conn2.setAutoCommit(false);
        ArrayList<DataTable.DataColumn> columnData = eTraxionHelperFunctions.getColumns(conn2);
        String name = eTraxionHelperFunctions.getSetting(conn2, "name");
        if (m.getTitleBar() != null) {
            m.getTitleBar().setLabelText(name);
        }
        m.template = eTraxionHelperFunctions.getSetting(conn2, "template");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            String pk = eTraxionHelperFunctions.getSetting(conn2, "primary");
            for (String k : pk.split(",")) {
                primaryKeys.add(k.trim());
            }
        }
        catch (Exception e) {
            primaryKeys.add(columnData.get(0).getName());
        }
        table.setPrimaryKeyColumns(primaryKeys, true);
        ArrayList<Object[]> rowDataList = new ArrayList<Object[]>();
        try (Statement stmt = conn2.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM report_data");){
            while (rs.next()) {
                Object[] row = new Object[columnData.size()];
                for (int i = 0; i < columnData.size(); ++i) {
                    Object o;
                    String id = columnData.get(i).getId();
                    if (id == null) continue;
                    row[i] = o = rs.getObject(id);
                }
                rowDataList.add(row);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error loading data from database: " + e.getMessage());
        }
        Object[] columnNames = new String[columnData.size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = columnData.get(i).getName();
        }
        Object[][] data = (Object[][])rowDataList.toArray((T[])new Object[0][]);
        tableModel.setDataVector(data, columnNames);
        DataTable.CellRenderer borderRenderer = new DataTable.CellRenderer(table);
        for (int i = 0; i < columnData.size(); ++i) {
            table.getColumnModel().getColumn(i).setCellRenderer(borderRenderer);
        }
        table.updateColumns(columnData);
        table.clearUpdatedRows();
        conn2.close();
        table.removeToLastRow();
        ((DefaultTableModel)table.getModel()).addRow(new Object[table.getModel().getColumnCount()]);
        return name;
    }

    public static void saveSetting(Connection conn, String setting, String value) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO settings (setting_id, setting_value) VALUES (?, ?);");
        stmt.setString(1, setting);
        stmt.setString(2, value);
        stmt.executeUpdate();
    }

    public static void saveMacros(Connection conn, Map<String, String> macros) throws SQLException {
        conn.createStatement().execute("DELETE FROM macros");
        PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO macros (macro_id, code) VALUES (?, ?);");
        for (Map.Entry<String, String> entry : macros.entrySet()) {
            stmt.setString(1, entry.getKey());
            stmt.setString(2, entry.getValue());
            stmt.executeUpdate();
        }
    }

    public static String getSetting(Connection conn, String setting) {
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM settings WHERE setting_id = ?;");
            stmt.setString(1, setting);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return rs.getString("setting_value");
            }
            return "";
        }
        catch (SQLException e) {
            return "";
        }
    }

    public static boolean columnExists(Connection conn, String tableName, String columnName) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        try (ResultSet rs = meta.getColumns(null, null, tableName, columnName);){
            boolean bl = rs.next();
            return bl;
        }
    }

    static void renameColumn(Connection conn, String oldName, String newName) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("PRAGMA table_info(report_data)");
        ArrayList<String> oldCols = new ArrayList<String>();
        ArrayList<String> newCols = new ArrayList<String>();
        while (rs.next()) {
            String name = rs.getString("name");
            oldCols.add(name);
            newCols.add(name.equals(oldName) ? newName : name);
        }
        StringBuilder createSQL = new StringBuilder("CREATE TABLE report_data_new (");
        for (int i = 0; i < newCols.size(); ++i) {
            createSQL.append((String)newCols.get(i)).append(" TEXT");
            if (i >= newCols.size() - 1) continue;
            createSQL.append(", ");
        }
        createSQL.append(");");
        stmt.execute(createSQL.toString());
        StringBuilder insertSQL = new StringBuilder("INSERT INTO report_data_new SELECT ");
        for (int i = 0; i < oldCols.size(); ++i) {
            insertSQL.append((String)oldCols.get(i));
            if (i >= oldCols.size() - 1) continue;
            insertSQL.append(", ");
        }
        insertSQL.append(" FROM report_data;");
        stmt.execute(insertSQL.toString());
        stmt.execute("DROP TABLE report_data;");
        stmt.execute("ALTER TABLE report_data_new RENAME TO report_data;");
    }

    public static void saveColumnData(Connection conn, ArrayList<DataTable.DataColumn> columnData, DataTable table) throws SQLException {
        Statement columnInfoCreateStmt = conn.createStatement();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS column_info (column_id TEXT PRIMARY KEY, column_name TEXT, column_type TEXT, column_data TEXT, column_formatting TEXT, sheet_id TEXT, display_order INTEGER);");
        ArrayList<String> columnNames = new ArrayList<String>();
        ResultSet rs = conn.createStatement().executeQuery("SELECT column_name FROM column_info ORDER BY display_order");
        while (rs.next()) {
            columnNames.add(rs.getString("column_name"));
        }
        for (DataTable.DataColumn column : columnData) {
            PreparedStatement stmt2;
            if (!column.getOldName().isEmpty() && !column.getName().equals(column.getOldName()) && columnNames.contains(column.getOldName())) {
                eTraxionHelperFunctions.renameColumn(conn, column.getOldName().toLowerCase().replace(" ", ""), column.getName().toLowerCase().replace(" ", ""));
                stmt2 = conn.prepareStatement("UPDATE column_info SET column_id = ?, column_name = ? WHERE column_id = ?");
                stmt2.setString(1, column.getName().toLowerCase().replace(" ", ""));
                stmt2.setString(2, column.getName());
                stmt2.setString(3, column.getOldName().toLowerCase().replace(" ", ""));
                stmt2.executeUpdate();
                column.setOldName("");
                continue;
            }
            if (!columnNames.contains(column.getName())) {
                stmt2 = conn.prepareStatement("INSERT INTO column_info (column_id, column_name, column_type, column_data, column_formatting, sheet_id, display_order) VALUES (?, ?, ?, ?, ?, ?, ?);");
                int index = 1;
                stmt2.setString(index++, column.getName().toLowerCase().replace(" ", ""));
                stmt2.setString(index++, column.getName());
                stmt2.setString(index++, column.getTypeAsString());
                stmt2.setString(index++, column.getData());
                stmt2.setString(index++, column.getFormattingRules());
                if (column.getSheetId() != null) {
                    stmt2.setString(index++, column.getSheetId());
                } else {
                    stmt2.setString(index++, "");
                }
                stmt2.setInt(index++, column.getDisplayOrder());
                stmt2.executeUpdate();
                conn.createStatement().execute("ALTER TABLE report_data ADD COLUMN " + column.getName().toLowerCase().replace(" ", "") + " TEXT;");
                continue;
            }
            String query2 = "UPDATE column_info SET column_id = ?, column_type = ?, column_data = ?, column_formatting = ?, sheet_id = ?, display_order = ? WHERE column_name = ?;";
            PreparedStatement stmt22 = conn.prepareStatement(query2);
            stmt22.setString(1, column.getName().toLowerCase().replace(" ", ""));
            stmt22.setString(2, column.getTypeAsString());
            stmt22.setString(3, column.getData());
            stmt22.setString(4, column.getFormattingRules());
            stmt22.setString(5, column.getSheetId());
            stmt22.setInt(6, column.getDisplayOrder());
            stmt22.setString(7, column.getName());
        }
    }

    public static boolean saveCellsTableWithDynamicColumns(String name, DataTable table, Connection conn, ArrayList<DataTable.DataColumn> columnData, boolean newFile) throws SQLException {
        ArrayList<Integer> rows;
        table.removeToLastRow();
        ArrayList<String> columnsToRemove = new ArrayList<String>();
        StringBuilder queryStr = new StringBuilder();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE IF NOT EXISTS report_data (pupilNumber INTEGER PRIMARY KEY AUTOINCREMENT);");
        eTraxionHelperFunctions.saveColumnData(conn, columnData, table);
        stmt = conn.createStatement();
        stmt.execute("CREATE TABLE IF NOT EXISTS settings (setting_id TEXT PRIMARY KEY, setting_value TEXT);");
        eTraxionHelperFunctions.saveSetting(conn, "name", name);
        StringBuilder primaryKeyJson = new StringBuilder();
        for (String k : table.getPrimaryKeyColumns()) {
            primaryKeyJson.append(k).append(", ");
        }
        primaryKeyJson.deleteCharAt(primaryKeyJson.length() - 2);
        eTraxionHelperFunctions.saveSetting(conn, "name", name);
        eTraxionHelperFunctions.saveSetting(conn, "primary", primaryKeyJson.toString());
        stmt = conn.createStatement();
        stmt.execute("CREATE TABLE IF NOT EXISTS macros (macro_id TEXT PRIMARY KEY, code TEXT);");
        StringBuilder sql = new StringBuilder("INSERT OR REPLACE INTO report_data (pupilNumber");
        for (DataTable.DataColumn col : columnData) {
            sql.append(", ").append(col.getName().toLowerCase().replace(" ", ""));
            if (!col.isRemoved()) continue;
            columnsToRemove.add(col.getName().toLowerCase().replace(" ", ""));
        }
        sql.append(") VALUES (?");
        for (int i = 0; i < columnData.size(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        if (newFile) {
            rows = new ArrayList();
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (table.rowIsBlank(i)) continue;
                rows.add(i);
            }
        } else {
            rows = table.returnUpdatedRows();
        }
        table.removeToLastRow();
        try (PreparedStatement stmt2 = conn.prepareStatement(sql.toString());){
            for (int r = 0; r < rows.size(); ++r) {
                int rowId = rows.get(r);
                stmt2.setString(1, "" + table.getRowId(r));
                for (int c = 0; c < columnData.size(); ++c) {
                    Object cellValue = table.getModel().getValueAt(rowId, c);
                    stmt2.setString(c + 2, cellValue != null ? cellValue.toString() : null);
                }
                stmt2.addBatch();
            }
            stmt2.executeBatch();
        }
        catch (SQLException ex) {
            return false;
        }
        for (String col : columnsToRemove) {
            try {
                Statement stmt3 = conn.createStatement();
                try {
                    String dropQuery = "ALTER TABLE report_data DROP COLUMN " + col + ";";
                    stmt3.execute(dropQuery);
                    dropQuery = "DELETE FROM column_info WHERE column_id = \"" + col + "\";";
                    stmt3.execute(dropQuery);
                }
                finally {
                    if (stmt3 == null) continue;
                    stmt3.close();
                }
            }
            catch (SQLException e) {
                System.err.println("Failed to drop column " + col + ": " + e.getMessage());
                return false;
            }
        }
        table.clearUpdatedRows();
        return true;
    }

    public static String toCSV(DataTable table) {
        ZenithCSVParser c = new ZenithCSVParser();
        table.removeToLastRow();
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < table.getRowCount(); ++i) {
            StringBuilder row = new StringBuilder();
            for (int j = 0; j < table.getColumnCount(); ++j) {
                Object v = table.getValueAt(i, j);
                row.append(v);
                if (j >= table.getColumnCount() - 1) continue;
                row.append(",");
            }
            if (i >= table.getRowCount() - 1) continue;
            output.append((CharSequence)row).append("\n");
        }
        return output.toString();
    }

    static void pasteClipboardIntoTable(DataTable table) {
        int startRow = table.getSelectedRow();
        int startCol = table.getSelectedColumn();
        if (startRow < 0 || startCol < 0) {
            return;
        }
        try {
            String clipboardData = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            String[] rows = clipboardData.split("\\R");
            TableModel model = table.getModel();
            int row_num = 0;
            for (int i = 0; i < rows.length; ++i) {
                String[] cells = rows[i].split("\t");
                for (int j = 0; j < cells.length; ++j) {
                    int row = startRow + i;
                    int col = startCol + j;
                    if (row >= model.getRowCount() || col >= model.getColumnCount()) continue;
                    model.setValueAt(cells[j], row, col);
                    ++row_num;
                }
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            JOptionPane.showMessageDialog(table, "Failed to paste", "Error", 0);
        }
    }
}

