/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.ColourUtils;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.etraxion.reporting.ColumnChartView;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.eTraxionHelperFunctions;
import jamiebalfour.generic.BinarySearchTree;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.core.ZPEStructure;
import jamiebalfour.zpe.exceptions.ExitHalt;
import jamiebalfour.zpe.exceptions.IncorrectDataTypeException;
import jamiebalfour.zpe.exceptions.ZPERuntimeException;
import jamiebalfour.zpe.interfaces.ZPEObjectNativeMethod;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEBoolean;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.Color;
import java.io.IOException;
import javax.swing.table.DefaultTableModel;

public class TableObject
extends ZPEStructure {
    DataTable table;

    protected TableObject(ZPERuntimeEnvironment z, ZPEPropertyWrapper parent, DataTable table) {
        super(z, parent, "table");
        this.table = table;
        this.setId("table");
        this.addNativeMethod("row_count", new row_count_Command());
        this.addNativeMethod("column_count", new column_count_Command());
        this.addNativeMethod("read_cell", new read_cell_Command());
        this.addNativeMethod("write_cell", new write_cell_Command());
        this.addNativeMethod("empty_cell", new empty_cell_Command());
        this.addNativeMethod("remove_row", new remove_row_Command());
        this.addNativeMethod("to_csv", new to_csv_Command());
        this.addNativeMethod("get_column_number_by_name", new get_column_number_by_name_Command());
        this.addNativeMethod("generate_chart_by_column", new generate_chart_by_column_Command());
        this.addNativeMethod("highlight_row", new highlight_row_Command());
        this.addNativeMethod("unhighlight_row", new unhighlight_row_Command());
        this.addNativeMethod("highlight_column", new highlight_column_Command());
        this.addNativeMethod("unhighlight_column", new unhighlight_column_Command());
        this.addNativeMethod("search_by_column", new search_by_column_Command());
    }

    class search_by_column_Command
    implements ZPEObjectNativeMethod {
        search_by_column_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"column_number", "search_term"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("column_number").toString());
            ZPEList result = new ZPEList();
            String searchTerm = params.get("search_term").toString();
            for (int i = 0; i < TableObject.this.table.getRowCount(); ++i) {
                if (!TableObject.this.table.getValueAt(i, number).toString().contains(searchTerm)) continue;
                result.add(new ZPENumber(i));
            }
            return result;
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "search_by_column";
        }
    }

    class unhighlight_column_Command
    implements ZPEObjectNativeMethod {
        unhighlight_column_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"column_number"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("column_number").toString());
            TableObject.this.table.unhighlightColumn(number);
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "unhighlight_column";
        }
    }

    class highlight_column_Command
    implements ZPEObjectNativeMethod {
        highlight_column_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"column_number", "background", "foreground"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("column_number").toString());
            if (!params.containsKey("foreground") && !params.containsKey("background")) {
                TableObject.this.table.highlightColumn(number, Color.BLACK, Color.GREEN);
            } else if (!params.containsKey("foreground")) {
                Color background = ColourUtils.parseColor(params.get("background").toString());
                TableObject.this.table.highlightColumn(number, Color.BLACK, background);
            } else {
                Color foreground = ColourUtils.parseColor(params.get("foreground").toString());
                Color background = ColourUtils.parseColor(params.get("background").toString());
                TableObject.this.table.highlightColumn(number, foreground, background);
            }
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "highlight_column";
        }
    }

    class unhighlight_row_Command
    implements ZPEObjectNativeMethod {
        unhighlight_row_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row_number"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("row_number").toString());
            TableObject.this.table.unhighlightRow(number);
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "unhighlight_row";
        }
    }

    class highlight_row_Command
    implements ZPEObjectNativeMethod {
        highlight_row_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row_number", "background", "foreground"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("row_number").toString());
            if (!params.containsKey("foreground") && !params.containsKey("background")) {
                TableObject.this.table.highlightRow(number, Color.BLACK, Color.GREEN);
            } else if (!params.containsKey("foreground")) {
                Color background = ColourUtils.parseColor(params.get("background").toString());
                TableObject.this.table.highlightRow(number, Color.BLACK, background);
            } else {
                Color foreground = ColourUtils.parseColor(params.get("foreground").toString());
                Color background = ColourUtils.parseColor(params.get("background").toString());
                TableObject.this.table.highlightRow(number, foreground, background);
            }
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "highlight_row";
        }
    }

    class generate_chart_by_row_Command
    implements ZPEObjectNativeMethod {
        generate_chart_by_row_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row_number", "title"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("row_number").toString());
            new ColumnChartView(TableObject.this.table, number, params.get("title").toString()).setVisible(true);
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "generate_chart_on_column";
        }
    }

    class generate_chart_by_column_Command
    implements ZPEObjectNativeMethod {
        generate_chart_by_column_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"column_number", "title"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int number = HelperFunctions.stringToInteger(params.get("column_number").toString());
            new ColumnChartView(TableObject.this.table, number, params.get("title").toString()).setVisible(true);
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "generate_chart_on_column";
        }
    }

    class get_column_number_by_name_Command
    implements ZPEObjectNativeMethod {
        get_column_number_by_name_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"name"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            String name = params.get("name").toString();
            int i = 0;
            for (DataTable.DataColumn c : TableObject.this.table.getColumnData()) {
                if (c.getName().equals(name)) {
                    return new ZPENumber(i);
                }
                ++i;
            }
            return new ZPEBoolean(false);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "get_column_number_by_name";
        }
    }

    class to_csv_Command
    implements ZPEObjectNativeMethod {
        to_csv_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"filename"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"string"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            String output = eTraxionHelperFunctions.toCSV(TableObject.this.table);
            try {
                FileHelperFunctions.writeFile(params.get("filename").toString(), output, false);
            }
            catch (IOException e) {
                return new ZPEBoolean(false);
            }
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "to_csv";
        }
    }

    class remove_row_Command
    implements ZPEObjectNativeMethod {
        remove_row_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int r = HelperFunctions.stringToInteger(params.get("row").toString());
            ((DefaultTableModel)TableObject.this.table.getModel()).removeRow(r);
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "remove_row";
        }
    }

    class empty_cell_Command
    implements ZPEObjectNativeMethod {
        empty_cell_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row", "column"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int r = HelperFunctions.stringToInteger(params.get("row").toString());
            int c = HelperFunctions.stringToInteger(params.get("column").toString());
            TableObject.this.table.setValueAt(null, r, c);
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "empty_cell";
        }
    }

    class write_cell_Command
    implements ZPEObjectNativeMethod {
        write_cell_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row", "column", "value"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number", "mixed"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int r = HelperFunctions.stringToInteger(params.get("row").toString());
            int c = HelperFunctions.stringToInteger(params.get("column").toString());
            ZPEType value = params.get("value");
            TableObject.this.table.setValueAt(value, r, c);
            return new ZPEBoolean(true);
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "write_cell";
        }
    }

    class read_cell_Command
    implements ZPEObjectNativeMethod {
        read_cell_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"row", "column"};
        }

        @Override
        public String[] getParameterTypes() {
            return new String[]{"number", "number"};
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            int c;
            int r = HelperFunctions.stringToInteger(params.get("row").toString());
            Object value = TableObject.this.table.getValueAt(r, c = HelperFunctions.stringToInteger(params.get("column").toString()));
            if (value != null) {
                return new ZPEString(value.toString());
            }
            return new ZPEString("");
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "read_cell";
        }
    }

    class column_count_Command
    implements ZPEObjectNativeMethod {
        column_count_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            return new ZPENumber(TableObject.this.table.getColumnCount());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "column_count";
        }
    }

    class row_count_Command
    implements ZPEObjectNativeMethod {
        row_count_Command() {
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public String[] getParameterTypes() {
            return new String[0];
        }

        @Override
        public ZPEType MainMethod(BinarySearchTree<String, ZPEType> params, ZPEObject zpeObject) throws ZPERuntimeException, ExitHalt, IncorrectDataTypeException {
            return new ZPENumber(TableObject.this.table.getRowCount());
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 0;
        }

        @Override
        public String getName() {
            return "row_count";
        }
    }
}

