/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;

public class RowChartView
extends JFrame {
    private JTable table;
    private Map<Integer, String> columns;
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private int currentRow;
    BalfButton backButton = new BalfButton("Previous", 15);
    BalfButton nextButton = new BalfButton("Next", 15);

    public RowChartView(JTable table, Map<Integer, String> columns, String chartTitle) {
        this.table = table;
        this.columns = columns;
        this.currentRow = table.getSelectedRow();
        this.backButton.disableDarkMode();
        this.nextButton.disableDarkMode();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 512), "Next");
        inputMap.put(KeyStroke.getKeyStroke(37, 512), "Back");
        actionMap.put("Next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowChartView.this.nextButton.doClick();
            }
        });
        actionMap.put("Back", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowChartView.this.backButton.doClick();
            }
        });
        this.setTitle(chartTitle);
        this.setSize(600, 450);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        DefaultCategoryDataset dataset = this.buildDataset(this.currentRow);
        this.chart = ChartFactory.createBarChart(chartTitle, "Category", "", dataset);
        CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter(new StandardBarPainter());
        renderer.setDrawBarOutline(false);
        renderer.setDefaultItemLabelsVisible(true);
        Color[] colours = new Color[]{new Color(94, 14, 143), new Color(255, 128, 0), new Color(40, 75, 99), new Color(120, 120, 120), new Color(72, 213, 253)};
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            renderer.setSeriesPaint(i, colours[i % colours.length]);
        }
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(580, 370));
        this.backButton.addActionListener(e -> {
            if (this.currentRow > 0) {
                --this.currentRow;
                table.setRowSelectionInterval(this.currentRow, this.currentRow);
                this.updateChart();
            }
        });
        this.nextButton.addActionListener(e -> {
            if (this.currentRow < table.getRowCount() - 1) {
                ++this.currentRow;
                table.setRowSelectionInterval(this.currentRow, this.currentRow);
                this.updateChart();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.backButton);
        buttonPanel.add(this.nextButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chartPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private DefaultCategoryDataset buildDataset(int rowIndex) {
        HashMap<String, Integer> valueCounts = new HashMap<String, Integer>();
        for (int i : this.columns.keySet()) {
            Object value = this.table.getValueAt(rowIndex, i);
            if (value == null || value.toString().trim().isEmpty()) continue;
            valueCounts.put(this.columns.get(i), HelperFunctions.stringToInteger(value.toString()));
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry entry : valueCounts.entrySet()) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)"Count"), (Comparable)entry.getKey());
        }
        return dataset;
    }

    private void updateChart() {
        DefaultCategoryDataset newDataset = this.buildDataset(this.currentRow);
        this.chart.getCategoryPlot().setDataset(newDataset);
        this.chart.setTitle("Row " + this.currentRow);
        this.setTitle("Row " + this.currentRow);
    }

    public static void showChart(JTable table, Map<Integer, String> selectedRowData) {
        SwingUtilities.invokeLater(() -> {
            RowChartView frame = new RowChartView(table, selectedRowData, "Row " + table.getSelectedRow());
            frame.setVisible(true);
        });
    }
}

