/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReportTemplateEditor
extends JDialog {
    private final JTextArea editorArea;
    private final JList<String> columnList;

    public ReportTemplateEditor(ReportBuilderMain parent, String[] columnHeaders) {
        super(parent, "Edit Report Template", true);
        this.setSize(600, 400);
        this.setLocationRelativeTo(parent);
        this.setLayout(new BorderLayout(10, 10));
        JLabel reminder = new JLabel("<html><p><b>Note:</b> If you put a <code>!</code> in the placeholder it will capitalise the word, whereas a <code>?</code> will make it all lowercase. E.g. <code>${!Forename}</code> will capitalise the first letter of the forename field.</p></html>");
        reminder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)reminder, "North");
        this.editorArea = new JTextArea();
        this.editorArea.setLineWrap(true);
        this.editorArea.setWrapStyleWord(true);
        this.editorArea.setText(parent.template);
        JScrollPane textScrollPane = new JScrollPane(this.editorArea);
        textScrollPane.setPreferredSize(new Dimension(350, 300));
        this.add((Component)textScrollPane, "Center");
        this.columnList = new JList<String>(columnHeaders);
        this.columnList.setSelectionMode(0);
        JScrollPane listScrollPane = new JScrollPane(this.columnList);
        listScrollPane.setPreferredSize(new Dimension(200, 300));
        this.add((Component)listScrollPane, "East");
        this.columnList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String selected;
                if (e.getClickCount() == 2 && (selected = ReportTemplateEditor.this.columnList.getSelectedValue()) != null) {
                    ReportTemplateEditor.this.editorArea.insert("${" + selected + "}", ReportTemplateEditor.this.editorArea.getCaretPosition());
                }
            }
        });
        BalfButton saveButton = new BalfButton("Save", 30);
        saveButton.disableDarkMode();
        JPanel bottomPanel = new JPanel(new FlowLayout(1));
        bottomPanel.add(saveButton);
        this.add((Component)bottomPanel, "South");
        saveButton.addActionListener(e -> {
            String template = this.editorArea.getText();
            JOptionPane.showMessageDialog(this, "Saved.");
            parent.template = template;
            this.dispose();
        });
    }

    public static void open(ReportBuilderMain parent, String[] columnHeaders) {
        ReportTemplateEditor editor = new ReportTemplateEditor(parent, columnHeaders);
        editor.setVisible(true);
    }
}

