/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

class ReportGenerator {
    ReportGenerator() {
    }

    static String directReadCell(JTable t, int row, int col) {
        if (t.getValueAt(row, col) != null) {
            return t.getValueAt(row, col).toString().trim();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static void replaceInParagraph(XWPFParagraph para, Map<String, String> placeholders) {
        void var5_8;
        StringBuilder fullText = new StringBuilder();
        List<XWPFRun> runs = para.getRuns();
        for (XWPFRun xWPFRun : runs) {
            String string = xWPFRun.getText(0);
            if (string == null) continue;
            fullText.append(string);
        }
        String replacedText = fullText.toString();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String placeholder = "${" + entry.getKey() + "}";
            replacedText = replacedText.replace(placeholder, entry.getValue());
        }
        int n = runs.size() - 1;
        while (var5_8 >= 0) {
            para.removeRun((int)var5_8);
            --var5_8;
        }
        XWPFRun xWPFRun = para.createRun();
        xWPFRun.setText(replacedText);
    }

    public static void generateIndividualReports(String template, String path, DataTable table, ArrayList<DataTable.DataColumn> columnData, boolean individualFolders, String prepend, ArrayList<Integer> nameColumns) throws IOException {
        ArrayList<String> cols = new ArrayList<String>();
        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
            cols.add(table.getColumnName(i));
        }
        HashMap<Integer, ZPEType> columnDataMap = ReportGenerator.parseColumnData(columnData);
        for (int row = 0; row < table.getRowCount(); ++row) {
            XWPFParagraph para;
            Iterator<Object> comp;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            for (int col = 0; col < cols.size(); ++col) {
                ZPEType v;
                ZPEMap d;
                DefaultCellEditor defaultEditor;
                TableCellEditor editor = table.getColumnModel().getColumn(col).getCellEditor();
                Object cellValue = ReportGenerator.directReadCell(table, row, col);
                if (editor instanceof DefaultCellEditor && ((comp = (defaultEditor = (DefaultCellEditor)editor).getComponent()) instanceof JComboBox || comp instanceof JTextField) && (d = (ZPEMap)columnDataMap.get(col)) != null && (v = d.get(new ZPEString((String)cellValue))) != null) {
                    cellValue = v.toString();
                }
                placeholders.put((String)cols.get(col), cellValue != null ? ReportGenerator.produceIndividualReport(((String)cellValue).toString(), row, table, columnData) : "");
            }
            if (table.rowIsBlank(row)) continue;
            FileInputStream fis = new FileInputStream(template);
            XWPFDocument doc = new XWPFDocument(fis);
            for (XWPFParagraph para2 : doc.getParagraphs()) {
                ReportGenerator.replaceInParagraph(para2, placeholders);
            }
            for (XWPFHeader header : doc.getHeaderList()) {
                comp = header.getParagraphs().iterator();
                while (comp.hasNext()) {
                    para = (XWPFParagraph)comp.next();
                    ReportGenerator.replaceInParagraph(para, placeholders);
                }
            }
            for (XWPFFooter footer : doc.getFooterList()) {
                comp = footer.getParagraphs().iterator();
                while (comp.hasNext()) {
                    para = comp.next();
                    ReportGenerator.replaceInParagraph(para, placeholders);
                }
            }
            for (XWPFTable t : doc.getTables()) {
                comp = t.getRows().iterator();
                while (comp.hasNext()) {
                    XWPFTableRow r = (XWPFTableRow)comp.next();
                    for (XWPFTableCell cell : r.getTableCells()) {
                        for (XWPFParagraph para3 : cell.getParagraphs()) {
                            ReportGenerator.replaceInParagraph(para3, placeholders);
                        }
                    }
                }
            }
            if (prepend == null) {
                prepend = "report";
            }
            String outputFileName = path + "/";
            StringBuilder appendage = new StringBuilder();
            for (int x = 0; x < nameColumns.size(); ++x) {
                Object v = placeholders.getOrDefault(cols.get(nameColumns.get(x)), "");
                if (!((String)v).isEmpty()) {
                    v = (String)v + " ";
                }
                appendage.append((String)v);
            }
            if (appendage.toString().isEmpty()) {
                // empty if block
            }
            if (individualFolders) {
                outputFileName = outputFileName + appendage.toString().trim() + "/";
                new File(outputFileName).mkdirs();
                outputFileName = outputFileName + prepend + ".docx";
            } else {
                outputFileName = outputFileName + prepend + appendage.toString().trim() + ".docx";
            }
            FileOutputStream fos = new FileOutputStream(outputFileName);
            doc.write(fos);
            fos.close();
            doc.close();
            fis.close();
        }
        System.out.println("All templates filled successfully!");
    }

    public static String parseTemplate(String template, JTable table, int rowIndex, HashMap<Integer, ZPEType> columnDataMap) {
        for (int col = 0; col < table.getColumnCount(); ++col) {
            DefaultCellEditor dce;
            Component comp;
            String columnName = table.getColumnName(col);
            String cellValue = ReportGenerator.directReadCell(table, rowIndex, col);
            String replacement = cellValue != null ? cellValue.toString() : "";
            String placeholder = "${" + columnName + "}";
            JComboBox comboBox = null;
            TableCellEditor editor = table.getColumnModel().getColumn(col).getCellEditor();
            boolean isComboBoxColumn = false;
            if (editor instanceof DefaultCellEditor && (comp = (dce = (DefaultCellEditor)editor).getComponent()) instanceof JComboBox) {
                comboBox = (JComboBox)comp;
                if (columnDataMap.get(col) instanceof ZPEMap) {
                    ZPEMap data;
                    ZPEMap zPEMap = data = columnDataMap.get(col) != null ? (ZPEMap)columnDataMap.get(col) : new ZPEMap();
                    if (cellValue != null && data.containsKey(new ZPEString(cellValue.toString()))) {
                        replacement = data.get(new ZPEString(cellValue.toString())).toString();
                    }
                }
            }
            template = template.replace("${" + columnName + "}", replacement);
            template = template.replace("${!" + columnName + "}", ReportGenerator.capitalise(replacement));
            template = template.replace("${?" + columnName + "}", replacement.toLowerCase());
        }
        return template;
    }

    public static void exportTableToWord(String template, DataTable table, File file, Map<Integer, String> columns, ArrayList<DataTable.DataColumn> columnData) {
        try (XWPFDocument doc = new XWPFDocument();){
            XWPFParagraph title = doc.createParagraph();
            title.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun titleRun = title.createRun();
            titleRun.setText("Exported Table Data");
            titleRun.setBold(true);
            titleRun.setFontSize(16);
            XWPFTable wordTable = doc.createTable(table.getRowCount() + 1, columns.size() + 1);
            for (int row = 0; row < table.getRowCount(); ++row) {
                if (!table.rowIsBlank(row)) {
                    String report = ReportGenerator.produceIndividualReport(template, row, table, columnData);
                    int i = 0;
                    for (int col : columns.keySet()) {
                        String cellValue = ReportGenerator.directReadCell(table, row, col);
                        wordTable.getRow(row).getCell(i).setText(cellValue);
                        ++i;
                    }
                    XWPFTableCell cell = wordTable.getRow(row).getCell(i);
                    XWPFParagraph para = cell.getParagraphs().get(0);
                    XWPFRun run = para.createRun();
                    String[] lines = report.split("\\R");
                    for (int j = 0; j < lines.length; ++j) {
                        run.setText(lines[j]);
                        if (j >= lines.length - 1) continue;
                        run.addBreak();
                    }
                    continue;
                }
                wordTable.removeRow(row);
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                doc.write(out);
            }
            JOptionPane.showMessageDialog(null, "Exported to Word successfully!");
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Failed to export: " + e.getMessage(), "Error", 0);
        }
    }

    static String capitalise(String word) {
        if (word == null || word.isEmpty()) {
            return word;
        }
        if (word.length() == 1) {
            return word.toUpperCase();
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    public static HashMap<Integer, ZPEType> parseColumnData(ArrayList<DataTable.DataColumn> columnData) {
        HashMap<Integer, ZPEType> columnDataMap = new HashMap<Integer, ZPEType>();
        int i = 0;
        ZenithJSONParser parser = new ZenithJSONParser();
        for (DataTable.DataColumn column : columnData) {
            if (columnData.get(i).getType() == DataTable.ColumnType.MAP || columnData.get(i).getType() == DataTable.ColumnType.LIST) {
                try {
                    columnDataMap.put(i, parser.jsonDecode(columnData.get(i).getData(), false));
                }
                catch (MalformedJSONException e) {
                    throw new RuntimeException(e);
                }
            } else {
                columnDataMap.put(i, null);
            }
            ++i;
        }
        return columnDataMap;
    }

    public static String produceIndividualReport(String template, int rowIndex, JTable table, ArrayList<DataTable.DataColumn> columnData) {
        if (rowIndex < 0 || rowIndex >= table.getRowCount()) {
            return "[Invalid row index]";
        }
        HashMap<Integer, ZPEType> columnDataMap = ReportGenerator.parseColumnData(columnData);
        for (int col = 0; col < table.getColumnCount(); ++col) {
            DefaultCellEditor dce;
            Component comp;
            String columnName = table.getColumnName(col);
            String cellValue = ReportGenerator.directReadCell(table, rowIndex, col);
            String replacement = cellValue != null ? cellValue.toString() : "";
            JComboBox comboBox = null;
            TableCellEditor editor = table.getColumnModel().getColumn(col).getCellEditor();
            boolean isComboBoxColumn = false;
            if (editor instanceof DefaultCellEditor && (comp = (dce = (DefaultCellEditor)editor).getComponent()) instanceof JComboBox) {
                comboBox = (JComboBox)comp;
                if (columnDataMap.get(col) instanceof ZPEMap) {
                    ZPEMap data;
                    ZPEMap zPEMap = data = columnDataMap.get(col) != null ? (ZPEMap)columnDataMap.get(col) : new ZPEMap();
                    if (cellValue != null && data.containsKey(new ZPEString(cellValue.toString()))) {
                        replacement = data.get(new ZPEString(cellValue.toString())).toString();
                    }
                }
            }
            if (replacement.contains("${") && replacement.contains("}")) {
                replacement = ReportGenerator.parseTemplate(replacement, table, rowIndex, columnDataMap);
            }
            template = template.replace("${" + columnName + "}", replacement);
            template = template.replace("${!" + columnName + "}", ReportGenerator.capitalise(replacement));
            template = template.replace("${?" + columnName + "}", replacement.toLowerCase());
        }
        return template;
    }
}

