/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ReportFilterWindow
extends JDialog {
    private final JTable table;
    private final Map<Integer, Set<String>> selectedFilters = new HashMap<Integer, Set<String>>();

    public ReportFilterWindow(JFrame parent, JTable table) {
        super(parent, "Select Filters", true);
        this.table = table;
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        for (int col = 0; col < table.getColumnCount(); ++col) {
            DefaultCellEditor defaultEditor;
            String colName = table.getColumnName(col);
            TableCellEditor editor = table.getColumnModel().getColumn(col).getCellEditor();
            if (editor instanceof DefaultCellEditor && (defaultEditor = (DefaultCellEditor)editor).getComponent() instanceof JComboBox) continue;
            JPanel filterPanel = new JPanel(new BorderLayout());
            filterPanel.setBorder(BorderFactory.createTitledBorder(colName));
            TreeSet<String> uniqueValues = new TreeSet<String>();
            for (int row = 0; row < table.getRowCount(); ++row) {
                Object value = table.getValueAt(row, col);
                if (value == null) continue;
                uniqueValues.add(value.toString());
            }
            JList<String> valueList = new JList<String>(uniqueValues.toArray(new String[0]));
            valueList.setSelectionMode(2);
            JScrollPane scrollPane = new JScrollPane(valueList);
            filterPanel.add((Component)scrollPane, "Center");
            centerPanel.add(filterPanel);
            int finalCol = col;
            valueList.addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.selectedFilters.put(finalCol, new HashSet(valueList.getSelectedValuesList()));
                }
                for (Map.Entry<Integer, Set<String>> entry : this.selectedFilters.entrySet()) {
                    Set<String> set = entry.getValue();
                }
            });
        }
        this.add((Component)new JScrollPane(centerPanel), "Center");
        BalfButton applyButton = new BalfButton("Apply Filter", 15);
        applyButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(applyButton);
        BalfButton clearFilterButton = new BalfButton("Clear Filter", 15);
        clearFilterButton.addActionListener(e -> {
            table.setRowSorter(null);
            this.setVisible(false);
            this.dispose();
        });
        bottomPanel.add(clearFilterButton);
        this.add((Component)bottomPanel, "South");
        this.setSize(400, 500);
        this.setLocationRelativeTo(parent);
    }

    public Map<Integer, Set<String>> getSelectedFilters() {
        return this.selectedFilters;
    }
}

