/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.RecentFilesManager;
import jamiebalfour.etraxion.FileWatcherThread;
import jamiebalfour.etraxion.eTraxion;
import jamiebalfour.etraxion.reporting.ColumnChartView;
import jamiebalfour.etraxion.reporting.ColumnInfoEditorDialog;
import jamiebalfour.etraxion.reporting.ColumnSelectionDialog;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.FindReplaceDialog;
import jamiebalfour.etraxion.reporting.FormatRuleEditor;
import jamiebalfour.etraxion.reporting.MailMergeDialog;
import jamiebalfour.etraxion.reporting.MapViewSelector;
import jamiebalfour.etraxion.reporting.NewColumnEditorDialog;
import jamiebalfour.etraxion.reporting.PasswordEntryDialog;
import jamiebalfour.etraxion.reporting.RecordViewDialog;
import jamiebalfour.etraxion.reporting.RenameReport;
import jamiebalfour.etraxion.reporting.ReportFilterWindow;
import jamiebalfour.etraxion.reporting.ReportGenerator;
import jamiebalfour.etraxion.reporting.ReportTemplateEditor;
import jamiebalfour.etraxion.reporting.ReportView;
import jamiebalfour.etraxion.reporting.RowChartView;
import jamiebalfour.etraxion.reporting.TableObject;
import jamiebalfour.etraxion.reporting.WindowObject;
import jamiebalfour.etraxion.reporting.eTraxionHelperFunctions;
import jamiebalfour.macOS;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UITheme;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.ui.components.BalfContextMenu;
import jamiebalfour.ui.components.BalfLabel;
import jamiebalfour.ui.components.BalfMenuBar;
import jamiebalfour.ui.components.BalfPanel;
import jamiebalfour.ui.components.BalfScrollbar;
import jamiebalfour.ui.components.BalfSearchBox;
import jamiebalfour.ui.components.BalfTitleBar;
import jamiebalfour.ui.dialogs.BalfAboutDialog;
import jamiebalfour.ui.dialogs.BalfPropertiesManager;
import jamiebalfour.ui.dialogs.OutputViewer;
import jamiebalfour.ui.windows.BalfWindow;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEObject;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.editor.ZPEChangelogDialog;
import jamiebalfour.zpe.gui.ZPEMacroInterface;
import jamiebalfour.zpe.interfaces.ZPEPropertyWrapper;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ReportBuilderMain
extends BalfWindow {
    private static final List<String> outputLines = new ArrayList<String>();
    static OutputViewer outputViewer;
    final BalfMenuBar.CheckBoxMenuItem showMapPreview;
    private final BalfMenuBar menuBar;
    private final UndoManager undoManager = new UndoManager();
    private final DataTable table;
    private final DefaultTableModel tableModel;
    private final BalfWindow _frame = this;
    private final BalfMenuBar.CheckBoxMenuItem darkModeItem;
    private final BalfContextMenu.MenuItem hideColumnContextItem;
    BalfMenuBar.MenuItem undoMenuItem;
    BalfMenuBar.MenuItem redoMenuItem;
    private final BalfMenuBar.MenuItem cutItem;
    private final BalfMenuBar.MenuItem copyItem;
    private final BalfMenuBar.MenuItem duplicateUpMenuItem;
    private final BalfMenuBar.MenuItem duplicateDownMenuItem;
    private final BalfContextMenu.MenuItem cutItemContextItem;
    private final BalfContextMenu.MenuItem copyItemContextItem;
    private final BalfMenuBar.MenuItem hideColumnItem;
    private final BalfMenuBar.MenuItem showAllHiddenColumnsItem;
    RecentFilesManager recentFilesManager;
    String currentFile = null;
    Color borderColor = new Color(30, 60, 80);
    MapViewSelector floatingOptionsWindow;
    ReportView linkedReporter = null;
    final ImageIcon logoFull;
    final ImageIcon logoMain;
    String template = "";
    BalfMenuBar.Menu fileMenu;
    BalfMenuBar.Menu recentFiles;
    Properties guiProperties;
    boolean propertiesChanged = false;
    BalfScrollbar scrollPane;
    BalfMenuBar.CheckBoxMenuItem useMacMenuBarMenuItem;
    boolean useMacMenuBar;
    private String password;
    HashMap<String, String> macros = new HashMap();
    BalfPanel sidebarMacroContainer;
    BalfPanel sidebarMacroButtons;
    String themePath = eTraxion.INSTALL_PATH + "theme.blt";
    ReportBuilderMain _this = this;

    @Override
    public String toString() {
        return "" + this.isDisplayable();
    }

    public ReportBuilderMain(int rounding) {
        super("eTraxion :: Report Builder", rounding, new Color(40, 75, 99), Color.white, new ImageIcon(eTraxion.standardIcon.getImage().getScaledInstance(20, 20, 4)));
        String path = eTraxion.INSTALL_PATH + "gui.properties";
        File f = new File(path);
        if (!f.exists()) {
            this.saveGUISettings(new Properties());
        }
        try {
            this.guiProperties = HelperFunctions.readProperties(eTraxion.INSTALL_PATH + "/gui.properties");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean useSystemUi = this.guiProperties.containsKey("USE_SYSTEM_UI") ? this.guiProperties.get("USE_SYSTEM_UI").toString().equals("true") : false;
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if (!useSystemUi) {
            this.initialise();
        }
        this.setTitle("eTraxion :: Report Builder");
        this.menuBar = new BalfMenuBar(new Color(40, 75, 99), Color.white);
        this.fileMenu = new BalfMenuBar.Menu("File", this.menuBar);
        this.recentFiles = new BalfMenuBar.Menu("Recent files", this.menuBar);
        this.getContentPane().setBackground(this.borderColor);
        this.getContentPane().setMinimumSize(new Dimension(600, 400));
        if (this.guiProperties.containsKey("USE_MAC_MENUBAR")) {
            this.useMacMenuBar = this.guiProperties.get("USE_MAC_MENUBAR").toString().equals("true");
        }
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            JMenuBar newMenu = this.menuBar.toJMenuBar();
            this.setJMenuBar(newMenu);
        } else {
            this.setMenu(this.menuBar);
            this.getMenu().setPaneColour(new Color(17, 127, 251));
        }
        if (!useSystemUi) {
            this.setTitleBarText("Untitled");
            this.getTitleBar().setTitleBarLabelListener(e -> {
                if (e.getClickCount() == 2) {
                    if (this.currentFile != null) {
                        File folder = new File(this.currentFile).getParentFile();
                        if (Desktop.isDesktopSupported()) {
                            try {
                                Desktop.getDesktop().open(folder);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    String renamed = RenameReport.showRenameDialog(this, this.getTitleBar().getLabelText());
                    if (renamed != null) {
                        this.getTitleBar().setLabelText(renamed);
                    }
                }
            });
            this.getTitleBar().setCloseListener(e -> {
                this.closeUp();
                System.exit(0);
            });
        }
        URL imagePath = ReportBuilderMain.class.getResource("/files/etraxion_logo_big.png");
        assert (imagePath != null);
        this.logoFull = new ImageIcon(new ImageIcon(imagePath).getImage().getScaledInstance(200, 99, 4));
        URL imagePath2 = ReportBuilderMain.class.getResource("/files/etraxion_logo_big.png");
        assert (imagePath2 != null);
        this.logoMain = new ImageIcon(new ImageIcon(imagePath2).getImage().getScaledInstance(200, 200, 4));
        if (HelperFunctions.isMac()) {
            this.setIconImage(eTraxion.macIcon.getImage());
        } else {
            this.setIconImage(eTraxion.standardIcon.getImage());
        }
        try {
            if (Taskbar.isTaskbarSupported()) {
                Taskbar taskbar = Taskbar.getTaskbar();
                if (HelperFunctions.isMac()) {
                    taskbar.setIconImage(eTraxion.macIcon.getImage());
                } else {
                    taskbar.setIconImage(eTraxion.standardIcon.getImage());
                }
            }
        }
        catch (Exception taskbar) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("swing.aatext", Boolean.TRUE);
            System.setProperty("awt.useSystemAAFontSettings", "on");
        }
        catch (Exception taskbar) {
            // empty catch block
        }
        int modifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.setSize(800, 600);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        if (this.guiProperties.containsKey("DARK_MODE") && !useSystemUi) {
            if (this.guiProperties.get("DARK_MODE").equals("true")) {
                this.switchOnDarkMode();
            } else if (this.guiProperties.get("DARK_MODE").equals("system") && HelperFunctions.isDarkMode()) {
                this.switchOnDarkMode();
            } else {
                this.switchOffDarkMode();
            }
        }
        this.readStandardProperties(this.guiProperties);
        BalfMenuBar.MenuItem newItem = new BalfMenuBar.MenuItem("New", this.menuBar);
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, modifierKey));
        BalfMenuBar.MenuItem openItem = new BalfMenuBar.MenuItem("Open", this.menuBar);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, modifierKey));
        BalfMenuBar.MenuItem importDataFromCsv = new BalfMenuBar.MenuItem("Import Data from CSV", this.menuBar);
        BalfMenuBar.MenuItem importStructureFromConfigurationFile = new BalfMenuBar.MenuItem("Import Columns from Configuration File", this.menuBar);
        BalfMenuBar.MenuItem importStructureFromExistingDatabaseFile = new BalfMenuBar.MenuItem("Import Structure from Existing Database File", this.menuBar);
        BalfMenuBar.MenuItem saveAsItem = new BalfMenuBar.MenuItem("Save As", this.menuBar);
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, modifierKey));
        BalfMenuBar.MenuItem exportDataToCsv = new BalfMenuBar.MenuItem("Export Data to CSV", this.menuBar);
        exportDataToCsv.setAccelerator(KeyStroke.getKeyStroke(69, modifierKey));
        BalfMenuBar.MenuItem exportStructureToConfigurationFile = new BalfMenuBar.MenuItem("Export Columns to Configuration File", this.menuBar);
        BalfMenuBar.MenuItem passwordProtect = new BalfMenuBar.MenuItem("Password Protect", this.menuBar);
        BalfMenuBar.MenuItem editeTraxionProperties = new BalfMenuBar.MenuItem("Edit eTraxion Properties", this.menuBar);
        BalfMenuBar.MenuItem exitItem = new BalfMenuBar.MenuItem("Exit", this.menuBar);
        if (HelperFunctions.isMac()) {
            exitItem.setAccelerator(KeyStroke.getKeyStroke(81, modifierKey));
        } else {
            exitItem.setAccelerator(KeyStroke.getKeyStroke(115, 512));
        }
        this.recentFilesManager = new RecentFilesManager(eTraxion.INSTALL_PATH + "/etraxion.props", "eTraxion");
        BalfMenuBar.Menu importMenu = new BalfMenuBar.Menu("Import", this.menuBar);
        importMenu.add(importDataFromCsv);
        importMenu.add(importStructureFromConfigurationFile);
        importMenu.add(importStructureFromExistingDatabaseFile);
        BalfMenuBar.Menu exportMenu = new BalfMenuBar.Menu("Export", this.menuBar);
        exportMenu.add(exportDataToCsv);
        exportMenu.add(exportStructureToConfigurationFile);
        this.fileMenu.add(newItem);
        this.fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fileMenu.add(openItem);
        this.fileMenu.add(this.recentFiles);
        this.fileMenu.add(importMenu);
        this.fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fileMenu.add(saveAsItem);
        this.fileMenu.add(exportMenu);
        this.fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fileMenu.add(passwordProtect);
        this.fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fileMenu.add(editeTraxionProperties);
        this.fileMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.fileMenu.add(exitItem);
        this.menuBar.add(this.fileMenu);
        this.updateRecentFiles();
        BalfMenuBar.Menu editMenu = new BalfMenuBar.Menu("Edit", this.menuBar);
        this.undoMenuItem = new BalfMenuBar.MenuItem("Undo", this.menuBar);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, modifierKey));
        this.redoMenuItem = new BalfMenuBar.MenuItem("Redo", this.menuBar);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, modifierKey));
        this.cutItem = new BalfMenuBar.MenuItem("Cut", this.menuBar);
        this.cutItem.setAccelerator(KeyStroke.getKeyStroke(88, modifierKey));
        this.copyItem = new BalfMenuBar.MenuItem("Copy", this.menuBar);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, modifierKey));
        BalfMenuBar.MenuItem pasteItem = new BalfMenuBar.MenuItem("Paste", this.menuBar);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, modifierKey));
        final BalfMenuBar.MenuItem findItem = new BalfMenuBar.MenuItem("Find", this.menuBar);
        findItem.setAccelerator(KeyStroke.getKeyStroke(70, modifierKey));
        editMenu.add(this.undoMenuItem);
        editMenu.add(this.redoMenuItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(this.cutItem);
        editMenu.add(this.copyItem);
        editMenu.add(pasteItem);
        editMenu.add(new BalfMenuBar.Separator(this.menuBar));
        editMenu.add(findItem);
        this.menuBar.add(editMenu);
        BalfMenuBar.Menu viewMenu = new BalfMenuBar.Menu("View", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem showRowSelection = new BalfMenuBar.CheckBoxMenuItem("Show Row Selection", this.menuBar);
        BalfMenuBar.CheckBoxMenuItem showColumnSelection = new BalfMenuBar.CheckBoxMenuItem("Show Column Selection", this.menuBar);
        this.showMapPreview = new BalfMenuBar.CheckBoxMenuItem("Show Map Previews", this.menuBar);
        this.darkModeItem = new BalfMenuBar.CheckBoxMenuItem("Dark Mode", this.menuBar);
        if (BalfLafManager.getInstance().isDarkModeEnabled()) {
            this.darkModeItem.setSelected(true);
        }
        BalfMenuBar.CheckBoxMenuItem useSystemUIMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use System UI", this.menuBar);
        if (useSystemUi) {
            useSystemUIMenuItem.setSelected(true);
        }
        BalfMenuBar.MenuItem chooseATheme = new BalfMenuBar.MenuItem("Choose a Theme", this.menuBar);
        this.hideColumnItem = new BalfMenuBar.MenuItem("Hide Column(s)", this.menuBar);
        this.hideColumnItem.setAccelerator(KeyStroke.getKeyStroke(72, modifierKey | 0x40));
        this.hideColumnItem.setEnabled(false);
        this.showAllHiddenColumnsItem = new BalfMenuBar.MenuItem("Show All Hidden Column(s)", this.menuBar);
        this.showAllHiddenColumnsItem.setEnabled(false);
        BalfMenuBar.MenuItem filterMenu = new BalfMenuBar.MenuItem("Filter", this.menuBar);
        viewMenu.add(showRowSelection);
        viewMenu.add(showColumnSelection);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        viewMenu.add(this.showMapPreview);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        if (!useSystemUi) {
            viewMenu.add(this.darkModeItem);
        }
        viewMenu.add(useSystemUIMenuItem);
        if (!useSystemUi) {
            viewMenu.add(chooseATheme);
        }
        if (HelperFunctions.isMac()) {
            this.useMacMenuBarMenuItem = new BalfMenuBar.CheckBoxMenuItem("Use Mac Menubar", this.menuBar);
            if (this.useMacMenuBar) {
                this.useMacMenuBarMenuItem.setSelected(true);
            }
        }
        if (HelperFunctions.isMac()) {
            viewMenu.add(this.useMacMenuBarMenuItem);
        }
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        viewMenu.add(this.hideColumnItem);
        viewMenu.add(this.showAllHiddenColumnsItem);
        viewMenu.add(new BalfMenuBar.Separator(this.menuBar));
        viewMenu.add(filterMenu);
        this.menuBar.add(viewMenu);
        BalfMenuBar.Menu reporting = new BalfMenuBar.Menu("Reporting", this.menuBar);
        BalfMenuBar.MenuItem openReportTemplateItem = new BalfMenuBar.MenuItem("Open Report Template Editor", this.menuBar);
        BalfMenuBar.MenuItem generateAllReportItem = new BalfMenuBar.MenuItem("Generate List of Reports", this.menuBar);
        generateAllReportItem.setToolTipText("Generate all reports. Use this feature to generate a single list of everyone's reports.");
        BalfMenuBar.MenuItem mailMergeReports = new BalfMenuBar.MenuItem("Mail Merge Reports", this.menuBar);
        mailMergeReports.setToolTipText("Create a mail merge of reports. Use this feature to generate an individual report for each person.");
        BalfMenuBar.MenuItem openReportView = new BalfMenuBar.MenuItem("Open Report View", this.menuBar);
        reporting.add(openReportTemplateItem);
        reporting.add(generateAllReportItem);
        reporting.add(new BalfMenuBar.Separator(this.menuBar));
        reporting.add(mailMergeReports);
        reporting.add(new BalfMenuBar.Separator(this.menuBar));
        reporting.add(openReportView);
        this.menuBar.add(reporting);
        BalfMenuBar.Menu tableMenu = new BalfMenuBar.Menu("Table", this.menuBar);
        BalfMenuBar.MenuItem editColumnData = new BalfMenuBar.MenuItem("Edit Column Data", this.menuBar);
        editColumnData.setAccelerator(KeyStroke.getKeyStroke(75, modifierKey));
        tableMenu.add(editColumnData);
        BalfMenuBar.MenuItem insertColumn = new BalfMenuBar.MenuItem("Insert Column", this.menuBar);
        insertColumn.setAccelerator(KeyStroke.getKeyStroke(76, modifierKey));
        tableMenu.add(insertColumn);
        final BalfMenuBar.MenuItem deleteSelectedColumnsItem = new BalfMenuBar.MenuItem("Delete Selected Column(s)", this.menuBar);
        tableMenu.add(deleteSelectedColumnsItem);
        deleteSelectedColumnsItem.setAccelerator(KeyStroke.getKeyStroke(127, modifierKey | 0x40));
        tableMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem addNewEntryItem = new BalfMenuBar.MenuItem("Add New Entry", this.menuBar);
        addNewEntryItem.setAccelerator(KeyStroke.getKeyStroke(77, modifierKey));
        tableMenu.add(addNewEntryItem);
        BalfMenuBar.MenuItem removeSelectedEntriesItem = new BalfMenuBar.MenuItem("Remove Selected Entries", this.menuBar);
        removeSelectedEntriesItem.setAccelerator(KeyStroke.getKeyStroke(68, modifierKey | 0x40));
        tableMenu.add(removeSelectedEntriesItem);
        tableMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem setPrimaryKeyItem = new BalfMenuBar.MenuItem("Set Primary Key", this.menuBar);
        tableMenu.add(setPrimaryKeyItem);
        tableMenu.add(new BalfMenuBar.Separator(this.menuBar));
        this.duplicateUpMenuItem = new BalfMenuBar.MenuItem("Duplicate up", this.menuBar);
        this.duplicateUpMenuItem.setEnabled(false);
        tableMenu.add(this.duplicateUpMenuItem);
        this.duplicateUpMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 576));
        this.duplicateDownMenuItem = new BalfMenuBar.MenuItem("Duplicate down", this.menuBar);
        this.duplicateDownMenuItem.setEnabled(false);
        tableMenu.add(this.duplicateDownMenuItem);
        this.duplicateDownMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 576));
        tableMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem conditionalFormatting = new BalfMenuBar.MenuItem("Conditional Formatting", this.menuBar);
        tableMenu.add(conditionalFormatting);
        this.menuBar.add(tableMenu);
        BalfMenuBar.Menu toolsMenu = new BalfMenuBar.Menu("Tools", this.menuBar);
        BalfMenuBar.MenuItem macroEditorItem = new BalfMenuBar.MenuItem("Open ZPE Macro Interface Editor", this.menuBar);
        toolsMenu.add(macroEditorItem);
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.Menu usefulTools = new BalfMenuBar.Menu("Useful tools", this.menuBar);
        BalfMenuBar.MenuItem sexToPronoun = new BalfMenuBar.MenuItem("Convert sex to pronoun", this.menuBar);
        usefulTools.add(sexToPronoun);
        BalfMenuBar.MenuItem subjectPronounToObjectPronoun = new BalfMenuBar.MenuItem("Convert subject pronoun to object pronoun", this.menuBar);
        usefulTools.add(subjectPronounToObjectPronoun);
        toolsMenu.add(usefulTools);
        BalfMenuBar.Menu plugginsMenu = new BalfMenuBar.Menu("Plugins", this.menuBar);
        toolsMenu.add(plugginsMenu);
        toolsMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem generateChartOnColumnDataItem = new BalfMenuBar.MenuItem("Generate Chart on Column Data", this.menuBar);
        BalfMenuBar.MenuItem generateChartOnRowDataItem = new BalfMenuBar.MenuItem("Generate Chart on Row Data", this.menuBar);
        toolsMenu.add(generateChartOnColumnDataItem);
        toolsMenu.add(generateChartOnRowDataItem);
        this.menuBar.add(toolsMenu);
        BalfMenuBar.Menu windowMenu = new BalfMenuBar.Menu("Window", this.menuBar);
        BalfMenuBar.MenuItem recordViewMenuItem = new BalfMenuBar.MenuItem("Open Record View", this.menuBar);
        BalfMenuBar.Menu dock = new BalfMenuBar.Menu("Dock", this.menuBar);
        BalfMenuBar.MenuItem dockToTheTop = new BalfMenuBar.MenuItem("Dock to the Top", this.menuBar);
        dockToTheTop.setAccelerator(KeyStroke.getKeyStroke(38, modifierKey));
        BalfMenuBar.MenuItem dockToTheLeft = new BalfMenuBar.MenuItem("Dock to the Left", this.menuBar);
        dockToTheLeft.setAccelerator(KeyStroke.getKeyStroke(37, modifierKey));
        BalfMenuBar.MenuItem dockToTheRight = new BalfMenuBar.MenuItem("Dock to the Right", this.menuBar);
        dockToTheRight.setAccelerator(KeyStroke.getKeyStroke(39, modifierKey));
        BalfMenuBar.MenuItem dockToTheBottom = new BalfMenuBar.MenuItem("Dock to the Bottom", this.menuBar);
        dockToTheBottom.setAccelerator(KeyStroke.getKeyStroke(40, modifierKey));
        windowMenu.add(recordViewMenuItem);
        windowMenu.add(new BalfMenuBar.Separator(this.menuBar));
        windowMenu.add(dock);
        dock.add(dockToTheTop);
        dock.add(dockToTheLeft);
        dock.add(dockToTheRight);
        dock.add(dockToTheBottom);
        dockToTheTop.addActionListener(e -> this._frame.dockTop());
        dockToTheLeft.addActionListener(e -> this._frame.dockLeft());
        dockToTheRight.addActionListener(e -> this._frame.dockRight());
        dockToTheBottom.addActionListener(e -> this._frame.dockBottom());
        this.menuBar.add(windowMenu);
        BalfMenuBar.Menu helpMenu = new BalfMenuBar.Menu("Help", this.menuBar);
        BalfMenuBar.MenuItem showOutputViewerItem = new BalfMenuBar.MenuItem("Show Output Viewer", this.menuBar);
        helpMenu.add(showOutputViewerItem);
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem aboutItem = new BalfMenuBar.MenuItem("About", this.menuBar);
        if (!HelperFunctions.isMac() || !this.useMacMenuBar) {
            helpMenu.add(aboutItem);
            helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        }
        BalfMenuBar.MenuItem openProgramFolder = new BalfMenuBar.MenuItem("Open eTraxion Folder", this.menuBar);
        openProgramFolder.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(eTraxion.INSTALL_PATH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        helpMenu.add(openProgramFolder);
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem websiteItem = new BalfMenuBar.MenuItem("Visit my website", this.menuBar);
        helpMenu.add(websiteItem);
        BalfMenuBar.MenuItem goToProgramTrackerMenuItem = new BalfMenuBar.MenuItem("Go to eTraxion Tracker", this.menuBar);
        goToProgramTrackerMenuItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/education/etraxion/tracker/");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        helpMenu.add(goToProgramTrackerMenuItem);
        BalfMenuBar.MenuItem provideFeedbackItem = new BalfMenuBar.MenuItem("Provide Feedback", this.menuBar);
        helpMenu.add(provideFeedbackItem);
        provideFeedbackItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/contact/?subject=etraxion%20Feedback");
            }
            catch (IOException | URISyntaxException ex) {
                JOptionPane.showMessageDialog(this._frame, "Could not load the website.", "Failure", 0);
            }
        });
        BalfMenuBar.MenuItem checkForUpdate = new BalfMenuBar.MenuItem("Check For Updates", this.menuBar);
        helpMenu.add(checkForUpdate);
        checkForUpdate.addActionListener(e -> {
            if (eTraxion.checkForUpdate()) {
                JOptionPane.showMessageDialog(this._frame, "An update is available.", "Update", -1);
            } else {
                JOptionPane.showMessageDialog(this._frame, "No updates are available right now.", "Update", -1);
            }
        });
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem changeLogView = new BalfMenuBar.MenuItem("View changelog", this.menuBar);
        helpMenu.add(changeLogView);
        changeLogView.addActionListener(e -> {
            String changelog;
            try {
                changelog = HelperFunctions.getResource("/files/etraxion_changelog.txt");
            }
            catch (Exception ex) {
                changelog = "";
            }
            JOptionPane op = new JOptionPane(new ZPEChangelogDialog(changelog, "eTraxion changelog").getContentPane(), -1, -1, this.logoMain, new String[0]);
            JDialog dlg = op.createDialog(this, "eTraxion changelog");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
        });
        helpMenu.add(new BalfMenuBar.Separator(this.menuBar));
        BalfMenuBar.MenuItem saveDemoConfig = new BalfMenuBar.MenuItem("Save demo config", this.menuBar);
        saveDemoConfig.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("JSON files (*.json)", "json"));
            if (fc.showSaveDialog(this._frame) == 0) {
                Object selectedFile = fc.getSelectedFile().getAbsolutePath();
                if (!((String)selectedFile).endsWith(".json")) {
                    selectedFile = (String)selectedFile + ".json";
                }
                String data = "";
                try {
                    data = HelperFunctions.getResource("/files/demoConfig.config");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this._frame, "Could not load the demo config file.", "Failure", 0);
                }
                try {
                    FileHelperFunctions.writeFile((String)selectedFile, data, false);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this._frame, "Could not save the demo config file.", "Failure", 0);
                }
            }
        });
        helpMenu.add(saveDemoConfig);
        this.menuBar.add(helpMenu);
        if (HelperFunctions.isMac()) {
            try {
                macOS.addAboutDialog(this::showAbout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] columnHeaders = new String[]{};
        this.tableModel = new DefaultTableModel(1, columnHeaders.length);
        this.tableModel.setColumnIdentifiers(columnHeaders);
        this.table = new DataTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(true);
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        final BalfSearchBox searchBox = this.menuBar.addSearchBox();
        searchBox.setSearchText("Search for something");
        searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                String s = searchBox.getText();
                try {
                    sorter.setRowFilter(RowFilter.regexFilter("(?i)" + Pattern.quote(s), new int[0]));
                    if (s.isEmpty()) {
                        sorter.setRowFilter(null);
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        });
        InputMap im = this.table.getInputMap(1);
        ActionMap am = this.table.getActionMap();
        im.put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "none");
        im.put(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Cut");
        am.put("Cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportBuilderMain.this.table.copyTableSelectionToClipboard();
                ReportBuilderMain.this.table.deleteSelectedCells();
            }
        });
        im.put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Copy");
        am.put("Copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportBuilderMain.this.table.copyTableSelectionToClipboard();
            }
        });
        im.put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Paste");
        am.put("Paste", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                eTraxionHelperFunctions.pasteClipboardIntoTable(ReportBuilderMain.this.table);
            }
        });
        im.put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Find");
        am.put("Find", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                findItem.doClick();
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        Font headerFont = UIManager.getFont("TableHeader.font");
        Font customFont = new Font(headerFont.getName(), 0, 14);
        this.table.setFont(customFont);
        this.table.setRowHeight(customFont.getSize() + 10);
        this.table.getTableHeader().setFont(new Font(headerFont.getName(), 1, 14));
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 50));
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.getTableHeader().setDefaultRenderer(new DataTable.HeaderRenderer(this.table));
        BalfPanel mainContent = new BalfPanel(new BorderLayout());
        this.scrollPane = new BalfScrollbar();
        this.scrollPane.setViewportView(this.table);
        mainContent.add((Component)this.scrollPane, "Center");
        this.scrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        final BalfPanel sidebar = new BalfPanel();
        sidebar.setLayout(new BoxLayout(sidebar, 1));
        sidebar.setPreferredSize(new Dimension(200, this.getHeight()));
        sidebar.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.BLACK));
        BalfButton addColumn = new BalfButton("Add Column", 15);
        addColumn.setAlignmentX(0.5f);
        addColumn.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        BalfButton addEntry = new BalfButton("Add Entry", 15);
        addEntry.setAlignmentX(0.5f);
        addEntry.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        BalfButton openReportViewButton = new BalfButton("Open Report View", 15);
        openReportViewButton.setAlignmentX(0.5f);
        openReportViewButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        BalfPanel sidebarContent = new BalfPanel();
        sidebarContent.setLayout(new BoxLayout(sidebarContent, 1));
        sidebarContent.setBorder(BorderFactory.createEmptyBorder(20, 10, 5, 10));
        BalfPanel sidebarButtons = new BalfPanel();
        sidebarButtons.setLayout(new BoxLayout(sidebarButtons, 1));
        sidebarButtons.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        BalfLabel l = new BalfLabel("<html><b>Quick Actions</b></html>", Color.black);
        l.setAlignmentX(0.5f);
        l.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        sidebarButtons.add(l);
        sidebarButtons.add(Box.createVerticalStrut(5));
        sidebarButtons.add(addColumn);
        sidebarButtons.add(addEntry);
        sidebarButtons.add(openReportViewButton);
        sidebarContent.add((Component)sidebarButtons, "Center");
        sidebar.add(sidebarContent);
        this.sidebarMacroContainer = new BalfPanel();
        this.sidebarMacroContainer.setLayout(new BorderLayout());
        l = new BalfLabel("<html><b>Macros</b></html>", Color.black);
        l.setAlignmentX(0.5f);
        l.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        l.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.sidebarMacroButtons = new BalfPanel();
        this.sidebarMacroButtons.setLayout(new FlowLayout(0, 3, 3));
        this.sidebarMacroButtons.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        this.sidebarMacroContainer.add((Component)l, "North");
        this.sidebarMacroContainer.add((Component)this.sidebarMacroButtons, "Center");
        this.sidebarMacroContainer.setVisible(false);
        sidebar.add(this.sidebarMacroContainer);
        mainContent.add((Component)sidebar, "East");
        this.add((Component)mainContent, "Center");
        if (this.guiProperties.containsKey("ROW_SELECTION")) {
            showRowSelection.setSelected(this.guiProperties.get("ROW_SELECTION").equals("true"));
            this.table.setRowHighlight(showRowSelection.isSelected());
        }
        if (this.guiProperties.containsKey("COLUMN_SELECTION")) {
            showColumnSelection.setSelected(this.guiProperties.get("COLUMN_SELECTION").equals("true"));
            this.table.setColumnHighlight(showColumnSelection.isSelected());
        }
        if (!useSystemUi) {
            this.getFooter().setText("<html>&copy; J Balfour 2025 version 1.1.3 (<em>Cotton</em>) build " + eTraxion.getBuildVersion() + "</html>");
        }
        addColumn.addActionListener(e -> {
            NewColumnEditorDialog c = new NewColumnEditorDialog(this, this.table, this.table.getColumnData());
            c.setVisible(true);
        });
        addEntry.addActionListener(e -> {
            this.tableModel.addRow(new Object[this.tableModel.getColumnCount()]);
            this.table.scrollRectToVisible(this.table.getCellRect(this.tableModel.getRowCount() - 1, 0, true));
        });
        openReportViewButton.addActionListener(e -> this.openReportView());
        final BalfContextMenu popupMenu = new BalfContextMenu(new Color(244, 244, 244), new Color(50, 50, 50), new Color(230, 230, 230), new Color(174, 174, 174));
        this.cutItemContextItem = new BalfContextMenu.MenuItem("Cut", popupMenu);
        this.copyItemContextItem = new BalfContextMenu.MenuItem("Copy", popupMenu);
        popupMenu.add(this.cutItemContextItem);
        popupMenu.add(this.copyItemContextItem);
        popupMenu.add(new BalfContextMenu.Separator(popupMenu));
        BalfContextMenu.MenuItem deleteItemContextItem = new BalfContextMenu.MenuItem("Delete Row", popupMenu);
        this.hideColumnContextItem = new BalfContextMenu.MenuItem("Hide column", popupMenu);
        popupMenu.add(deleteItemContextItem);
        popupMenu.add(this.hideColumnContextItem);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateReporter();
                this.hideColumnItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.hideColumnContextItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.cutItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.copyItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.cutItemContextItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.copyItemContextItem.setEnabled(this.table.getSelectedColumnCount() > 0);
                this.duplicateUpMenuItem.setEnabled(this.table.getSelectedRowCount() > 0);
                this.duplicateDownMenuItem.setEnabled(this.table.getSelectedRowCount() > 0);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int selectedRow;
            if (!e.getValueIsAdjusting() && (selectedRow = this.table.getSelectedRow()) != -1) {
                this.updateReporter();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {});
        newItem.addActionListener(e -> {
            this.tableModel.setDataVector(new Object[0][], new Object[0]);
            this.getTitleBar().setLabelText("Untitled");
            this.currentFile = null;
        });
        openItem.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Open File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("eTraxion Database Files (*.db, *.pdb)", "db", "pdb"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String filePath = selectedFile.getAbsolutePath();
                this.openFile(filePath);
            }
        });
        importDataFromCsv.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Import from CSV");
            fileChooser.setFileFilter(new FileNameExtensionFilter("Comma Separated Values files (*.csv)", "csv"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String filePath = selectedFile.getAbsolutePath();
                boolean res = eTraxionHelperFunctions.importFromCsv(filePath, this.tableModel);
                this.table.autoResizeColumnWidths();
                if (res) {
                    JOptionPane.showMessageDialog(this._frame, "Data imported successfully.", "Success", -1);
                } else {
                    JOptionPane.showMessageDialog(this._frame, "Could not import data from the CSV file.", "Failure", 0);
                }
            }
            this.table.removeToLastRow();
        });
        importStructureFromExistingDatabaseFile.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Open File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("eTraxion Database Files (*.db)", "db"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                String filePath = selectedFile.getAbsolutePath();
                if (!new File(filePath).exists()) {
                    JOptionPane.showMessageDialog(this, "File not found.", "Error", 0);
                    return;
                }
                try (Connection conn2 = eTraxionHelperFunctions.getConnection(filePath);){
                    ArrayList<DataTable.DataColumn> cols = eTraxionHelperFunctions.getColumns(conn2);
                    String t = eTraxionHelperFunctions.getSetting(conn2, "template");
                    this.loadMacros(conn2);
                    this.tableModel.setDataVector(new Object[0][], new Object[0]);
                    this.getTitleBar().setLabelText("Untitled");
                    for (DataTable.DataColumn c : cols) {
                        this.table.addColumnData(c);
                    }
                    this.template = t;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        importStructureFromConfigurationFile.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Open File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("JSON files (*.json)", "json"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                try {
                    String s = FileHelperFunctions.readFileAsString(fileChooser.getSelectedFile().getAbsolutePath(), "utf-8");
                    ZPEMap map = (ZPEMap)ZPEKit.jsonDecode(s, false);
                    if (!map.containsKey(new ZPEString("columns"))) {
                        return;
                    }
                    ZPEMap columnData = (ZPEMap)map.get(new ZPEString("columns"));
                    int pos = 0;
                    for (ZPEType key : columnData) {
                        ZPEMap d = (ZPEMap)columnData.get(key);
                        DataTable.DataColumn data = new DataTable.DataColumn(d.get(new ZPEString("name")).toString().toLowerCase().replace(" ", ""));
                        data.setName(d.get(new ZPEString("name")).toString());
                        data.setTypeFromString(d.get(new ZPEString("type")).toString());
                        data.setDisplayOrder(pos);
                        if (d.containsKey(new ZPEString("data")) && d.get(new ZPEString("data")) != null) {
                            String dataX = d.get(new ZPEString("data")).toString();
                            data.setData(dataX);
                        }
                        this.table.addColumnData(data);
                        ++pos;
                    }
                    this.table.reload();
                    this.table.autoResizeColumnWidths();
                    if (map.containsKey(new ZPEString("settings"))) {
                        ZPEMap settings = (ZPEMap)map.get(new ZPEString("settings"));
                        if (settings.containsKey(new ZPEString("template"))) {
                            this.template = settings.get(new ZPEString("template")).toString();
                        }
                        if (settings.containsKey(new ZPEString("primary_key"))) {
                            ArrayList<String> primaryKeys = new ArrayList<String>();
                            for (String k : new ZPEString("primary_key").toString().split(",")) {
                                primaryKeys.add(k.trim());
                            }
                            this.table.setPrimaryKeyColumns(primaryKeys, false);
                        }
                    }
                }
                catch (MalformedJSONException | IOException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                }
            }
        });
        saveAsItem.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("eTraxion Database Files (*.db)", "db"));
            int result = fileChooser.showSaveDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".db")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".db");
                }
                String fullPath = selectedFile.getAbsolutePath();
                boolean r = this.saveFile(fullPath);
                this.recentFilesManager.addRecentFile(fullPath);
                this.updateRecentFiles();
                if (r) {
                    JOptionPane.showMessageDialog(this, "Successfully saved file.");
                }
            }
        });
        exportDataToCsv.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Export Data to CSV");
            fileChooser.setFileFilter(new FileNameExtensionFilter("Comma Separated Values files (*.csv)", "csv"));
            int result = fileChooser.showSaveDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".csv")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".csv");
                }
                String fullPath = selectedFile.getAbsolutePath();
                String out = eTraxionHelperFunctions.toCSV(this.table);
                try {
                    FileHelperFunctions.writeFile(fullPath, out, false);
                    JOptionPane.showMessageDialog(this, "Successfully exported data to CSV.");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error. The export was unsuccessful.", 0);
                }
            }
        });
        exportStructureToConfigurationFile.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Export Structure to File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("JSON files (*.json)", "json"));
            int result = fileChooser.showSaveDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".json")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".json");
                }
                ZenithJSONParser parser = new ZenithJSONParser();
                ZPEMap o = new ZPEMap();
                ZPEMap settings = new ZPEMap();
                StringBuilder primaryKeyJson = new StringBuilder();
                for (String k : this.table.getPrimaryKeyColumns()) {
                    primaryKeyJson.append(k).append(", ");
                }
                primaryKeyJson.deleteCharAt(primaryKeyJson.length() - 2);
                settings.put(new ZPEString("primary_key"), new ZPEString(primaryKeyJson.toString()));
                settings.put(new ZPEString("template"), new ZPEString(this.template));
                o.put(new ZPEString("settings"), settings);
                ZPEMap columns = new ZPEMap();
                int colId = 0;
                for (DataTable.DataColumn col : this.table.getColumnData()) {
                    ZPEMap column = new ZPEMap();
                    column.put(new ZPEString("name"), new ZPEString(col.getName()));
                    column.put(new ZPEString("type"), new ZPEString(col.getTypeAsString()));
                    if (col.getData() != null) {
                        column.put(new ZPEString("data"), new ZPEString(col.getData()));
                    }
                    if (col.getFormattingRules() != null) {
                        column.put(new ZPEString("formatting"), new ZPEString(col.getFormattingRules()));
                    }
                    columns.put(new ZPEString("" + colId++), column);
                }
                o.put(new ZPEString("columns"), columns);
                String output = parser.jsonEncode(o);
                try {
                    FileHelperFunctions.writeFile(selectedFile.getAbsolutePath(), output, false);
                    JOptionPane.showMessageDialog(this, "Exported to JSON File", "Success", 1);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        passwordProtect.addActionListener(e -> {
            PasswordEntryDialog dialog = new PasswordEntryDialog(null);
            dialog.setVisible(true);
            if (dialog.isConfirmed()) {
                this.password = dialog.getPassword();
            }
        });
        editeTraxionProperties.addActionListener(e -> {
            try {
                JOptionPane op = new JOptionPane(new BalfPropertiesManager(HelperFunctions.readProperties(eTraxion.INSTALL_PATH + "/gui.properties"), new File(eTraxion.INSTALL_PATH + "/gui.properties")).getContentPane(), -1, -1, this.logoMain, new String[0]);
                JDialog dlg = op.createDialog(this._this, "Manage eTraxion Properties");
                dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                dlg.setSize(800, 500);
                dlg.setLocationRelativeTo(this._this);
                dlg.setVisible(true);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this._frame, "An error was encountered whilst trying to open the eTraxion properties file.", "Error", 0);
            }
        });
        exitItem.addActionListener(e -> System.exit(0));
        this.undoMenuItem.addActionListener(e -> {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
            this.updateUndoMenuItem();
        });
        this.redoMenuItem.addActionListener(e -> {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
            this.updateUndoMenuItem();
        });
        this.cutItem.addActionListener(e -> {
            this.table.copyTableSelectionToClipboard();
            this.table.deleteSelectedCells();
        });
        this.copyItem.addActionListener(e -> this.table.copyTableSelectionToClipboard());
        pasteItem.addActionListener(e -> eTraxionHelperFunctions.pasteClipboardIntoTable(this.table));
        findItem.addActionListener(e -> {
            FindReplaceDialog findDialog = new FindReplaceDialog(this, this.table);
            findDialog.setVisible(true);
        });
        showColumnSelection.addActionListener(e -> {
            this.table.setColumnHighlight(showColumnSelection.isSelected());
            this.setProperty("COLUMN_SELECTION", "" + showColumnSelection.isSelected());
            this.saveGUISettings(this.guiProperties);
        });
        showRowSelection.addActionListener(e -> {
            this.table.setRowHighlight(showRowSelection.isSelected());
            this.setProperty("ROW_SELECTION", "" + showRowSelection.isSelected());
            this.saveGUISettings(this.guiProperties);
        });
        this.darkModeItem.addActionListener(e -> {
            BalfLafManager.getInstance().toggleDarkMode(this.darkModeItem.isSelected());
            this.setProperty("DARK_MODE", "" + this.darkModeItem.isSelected());
            this.saveGUISettings(this.guiProperties);
        });
        useSystemUIMenuItem.addActionListener(e -> {
            this.setProperty("USE_SYSTEM_UI", "" + useSystemUIMenuItem.isSelected());
            this.saveGUISettings(this.guiProperties);
            JOptionPane.showMessageDialog(this, "This will happen on the next start.", "System UI", 2);
        });
        chooseATheme.addActionListener(e -> {
            if (BalfLafManager.getInstance().getTheme() != null) {
                BalfLafManager.getInstance().setTheme(null);
                File fx = new File(this.themePath);
                if (fx.exists()) {
                    fx.delete();
                }
                chooseATheme.setText("Choose a Theme");
            } else {
                UITheme theme = this.openThemeUsingDialog();
                if (theme != null) {
                    JOptionPane.showMessageDialog(this, "Theme loaded.");
                    chooseATheme.setText("Remove current Theme");
                    try {
                        theme.saveToFile(this.themePath);
                    }
                    catch (IOException iOException) {}
                } else {
                    JOptionPane.showMessageDialog(this, "Failed to load.");
                }
            }
        });
        if (HelperFunctions.isMac()) {
            boolean macMenuBarEnabled = this.useMacMenuBar;
            this.useMacMenuBarMenuItem.addActionListener(e -> {
                this.setProperty("USE_MAC_MENUBAR", Boolean.toString(this.useMacMenuBarMenuItem.isSelected()));
                this.useMacMenuBarMenuItem.setEnabled(false);
                this.saveGUISettings(this.guiProperties);
                JOptionPane.showMessageDialog(this, "This will happen on the next start.", "macOS Menubar", 2);
            });
        }
        this.hideColumnItem.addActionListener(e -> {
            if (this.table.getSelectedColumnCount() > 0) {
                this.table.hideSelectedColumns();
                this.showAllHiddenColumnsItem.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(this, "You must selected at least one column.", "Invalid column selection", 2);
            }
        });
        this.showAllHiddenColumnsItem.addActionListener(e -> this.table.showAllHiddenColumns());
        filterMenu.addActionListener(e -> {
            ReportFilterWindow filterWindow = new ReportFilterWindow(this, this.table);
            filterWindow.setVisible(true);
            final Map<Integer, Set<String>> filters = filterWindow.getSelectedFilters();
            RowFilter<Object, Object> filter = new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<?, ?> entry) {
                    for (Map.Entry f : filters.entrySet()) {
                        Object value = entry.getValue((Integer)f.getKey());
                        if (value != null && ((Set)f.getValue()).contains(value.toString())) continue;
                        return false;
                    }
                    return true;
                }
            };
            sorter.setRowFilter(filter);
            if (this.getFooter() != null) {
                if (!filters.isEmpty()) {
                    this.getFooter().setStatusText("Filter applied");
                } else {
                    this.getFooter().setStatusText("");
                }
            }
        });
        openReportTemplateItem.addActionListener(e -> {
            String[] headers = new String[this.table.getColumnCount()];
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                headers[i] = this.table.getColumnName(i);
            }
            ReportTemplateEditor.open(this, headers);
        });
        generateAllReportItem.addActionListener(e -> this.generateReports());
        mailMergeReports.addActionListener(e -> new MailMergeDialog(this.table).setVisible(true));
        openReportView.addActionListener(e -> this.openReportView());
        editColumnData.addActionListener(e -> {
            if (this.table.getSelectedColumn() > -1) {
                ColumnInfoEditorDialog c = new ColumnInfoEditorDialog(this, this.table, this.table.getColumnName(this.table.getSelectedColumn()), this.table.getSelectedColumn(), this.table.getColumnData().get(this.table.getSelectedColumn()));
                c.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "No column selected.", "Error", 0);
            }
        });
        insertColumn.addActionListener(e -> {
            NewColumnEditorDialog c = new NewColumnEditorDialog(this, this.table, this.table.getColumnData());
            c.setVisible(true);
        });
        deleteSelectedColumnsItem.addActionListener(e -> {
            if (this.table.getSelectedColumn() > 0) {
                final ArrayList<DataTable.DataColumn> removedColumns = new ArrayList<DataTable.DataColumn>();
                int a = this.table.getSelectedColumn() + this.table.getSelectedColumnCount();
                int b = this.table.getSelectedColumn();
                for (int i = a; i > b; --i) {
                    int result = JOptionPane.showConfirmDialog(this._frame, "Are you sure that you want to delete the column " + String.valueOf(this.table.getColumnModel().getColumn(i - 1).getHeaderValue()) + "?", "Confirm column deletion", 2, 3);
                    if (result != 0) continue;
                    removedColumns.add(this.table.deleteColumn(i - 1));
                }
                this.undoManager.addEdit(new AbstractUndoableEdit(){

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        for (DataTable.DataColumn c : removedColumns) {
                            ReportBuilderMain.this.table.readdDeletedColumn(c);
                        }
                        ReportBuilderMain.this.table.reload();
                        ReportBuilderMain.this.updateUndoMenuItem();
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (DataTable.DataColumn c : removedColumns) {
                            ReportBuilderMain.this.table.deleteColumnByName(c.getName());
                        }
                        ReportBuilderMain.this.table.reload();
                        ReportBuilderMain.this.updateUndoMenuItem();
                    }

                    @Override
                    public String getPresentationName() {
                        return "Remove Columns(s)";
                    }
                });
                this.updateUndoMenuItem();
            } else {
                JOptionPane.showMessageDialog(this, "No column selected.", "Error", 0);
            }
        });
        im.put(KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40), "DeleteColumns");
        am.put("DeleteColumns", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                deleteSelectedColumnsItem.doClick();
            }
        });
        addNewEntryItem.addActionListener(e -> {
            this.tableModel.addRow(new Object[this.tableModel.getColumnCount()]);
            this.table.scrollRectToVisible(this.table.getCellRect(this.tableModel.getRowCount() - 1, 0, true));
        });
        removeSelectedEntriesItem.addActionListener(e -> {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length == 0) {
                JOptionPane.showMessageDialog(this, "You must select an entry first");
                return;
            }
            final ArrayList<Object[]> removedRows = new ArrayList<Object[]>();
            final ArrayList<Integer> removedRowIndexes = new ArrayList<Integer>();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int row = selectedRows[i];
                int columnCount = this.tableModel.getColumnCount();
                Object[] rowData = new Object[columnCount];
                for (int j = 0; j < columnCount; ++j) {
                    rowData[j] = this.tableModel.getValueAt(row, j);
                }
                removedRows.add(rowData);
                removedRowIndexes.add(row);
                this.tableModel.removeRow(row);
            }
            this.undoManager.addEdit(new AbstractUndoableEdit(){

                @Override
                public void undo() throws CannotUndoException {
                    super.undo();
                    for (int i = removedRows.size() - 1; i >= 0; --i) {
                        ReportBuilderMain.this.tableModel.insertRow((int)((Integer)removedRowIndexes.get(i)), (Object[])removedRows.get(i));
                    }
                    ReportBuilderMain.this.updateUndoMenuItem();
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    for (int i = 0; i < removedRowIndexes.size(); ++i) {
                        ReportBuilderMain.this.tableModel.removeRow((Integer)removedRowIndexes.get(i));
                    }
                    ReportBuilderMain.this.updateUndoMenuItem();
                }

                @Override
                public String getPresentationName() {
                    return "Remove Entries(s)";
                }
            });
            this.updateUndoMenuItem();
        });
        this.duplicateUpMenuItem.addActionListener(e -> {
            for (int col : this.table.getSelectedColumns()) {
                int row1 = this.table.getSelectedRows()[this.table.getSelectedRows().length - 1];
                Object value = this.table.getValueAt(row1, col);
                for (int row = this.table.getSelectedRows().length - 1; row >= 0; --row) {
                    this.table.setValueAt(value, this.table.getSelectedRows()[row], col);
                }
            }
        });
        this.duplicateDownMenuItem.addActionListener(e -> {
            for (int col : this.table.getSelectedColumns()) {
                int row1 = this.table.getSelectedRows()[0];
                Object value = this.table.getValueAt(row1, col);
                for (int row = 1; row < this.table.getSelectedRows().length; ++row) {
                    this.table.setValueAt(value, this.table.getSelectedRows()[row], col);
                }
            }
        });
        conditionalFormatting.addActionListener(e -> {
            if (this.table.getSelectedColumnCount() == 1) {
                FormatRuleEditor formatRuleEditor = new FormatRuleEditor(this, this.table.getColumnData().get(this.table.getSelectedColumn()));
                formatRuleEditor.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "You must select a column", "Error", 0);
            }
        });
        macroEditorItem.addActionListener(e -> {
            final ReportBuilderMain x = this;
            final ZPERuntimeEnvironment z = new ZPERuntimeEnvironment(3);
            ZPEMacroInterface.AddAsMacroButtonClickedListener addMacroBtn = new ZPEMacroInterface.AddAsMacroButtonClickedListener(){

                @Override
                public void onAddAsMacroButtonClicked(String s) {
                    String name = JOptionPane.showInputDialog("Enter the macro name:", (Object)"");
                    BalfButton b = new BalfButton(name, 7);
                    b.addActionListener(e -> {
                        try {
                            HashMap<String, ZPEType> vars = new HashMap<String, ZPEType>();
                            vars.put("table", new TableObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), ReportBuilderMain.this.table));
                            vars.put("window", new WindowObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), x));
                            ZPEKit.interpret(new ZPERuntimeEnvironment(), s, new ZPEType[0], false, vars, false);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(x, ex.getMessage(), "Error", 0);
                        }
                    });
                    ReportBuilderMain.this.macros.put(name, s);
                    ReportBuilderMain.this.sidebarMacroButtons.add(b);
                    ReportBuilderMain.this.sidebarMacroContainer.setVisible(true);
                    sidebar.revalidate();
                }
            };
            ZPEMacroInterface.SaveMacroButtonClickedListener saveMacroBtn = new ZPEMacroInterface.SaveMacroButtonClickedListener(){

                @Override
                public void onSaveMacroButtonClicked(String currentName, String code) {
                    String name = JOptionPane.showInputDialog("Enter the macro name:", (Object)currentName);
                    if (!name.equals(currentName)) {
                        ReportBuilderMain.this.macros.remove(currentName);
                    }
                    for (Component c : ReportBuilderMain.this.sidebarMacroButtons.getComponents()) {
                        BalfButton b;
                        if (!(c instanceof BalfButton) || !(b = (BalfButton)c).getText().equals(currentName)) continue;
                        b.setText(name);
                        for (ActionListener al : b.getActionListeners()) {
                            b.removeActionListener(al);
                        }
                        b.addActionListener(e -> {
                            try {
                                HashMap<String, ZPEType> vars = new HashMap<String, ZPEType>();
                                vars.put("table", new TableObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), ReportBuilderMain.this.table));
                                vars.put("window", new WindowObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), x));
                                ZPEKit.interpret(new ZPERuntimeEnvironment(), code, new ZPEType[0], false, vars, false);
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(x, ex.getMessage(), "Error", 0);
                            }
                        });
                        break;
                    }
                    ReportBuilderMain.this.macros.put(name, code);
                    sidebar.revalidate();
                }
            };
            ZPEMacroInterface i = new ZPEMacroInterface(z, new ZPEObject[]{new TableObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), this.table), new WindowObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), x)}, this.macros);
            i.addAddNewMacroButtonListener(addMacroBtn);
            i.addSaveMacroButtonListener(saveMacroBtn);
            i.setTraverseAction(new Runnable(){

                @Override
                public void run() {
                    ReportBuilderMain.this.table.invalidate();
                    ReportBuilderMain.this.table.repaint();
                }
            });
            i.setVisible(true);
            i.setLocationRelativeTo(this);
        });
        sexToPronoun.addActionListener(e -> {
            int col = this.table.getSelectedColumn();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                Object v = this.table.getValueAt(i, col);
                if (v == null) continue;
                if (v.toString().equalsIgnoreCase("m") || v.toString().equalsIgnoreCase("male")) {
                    this.table.setValueAt("he", i, col);
                    continue;
                }
                if (!v.toString().equalsIgnoreCase("f") && !v.toString().equalsIgnoreCase("female")) continue;
                this.table.setValueAt("she", i, col);
            }
        });
        subjectPronounToObjectPronoun.addActionListener(e -> {
            int col = this.table.getSelectedColumn();
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                Object v = this.table.getValueAt(i, col);
                if (v == null) continue;
                if (v.toString().equalsIgnoreCase("he")) {
                    this.table.setValueAt("him", i, col);
                    continue;
                }
                if (v.toString().equalsIgnoreCase("she")) {
                    this.table.setValueAt("her", i, col);
                    continue;
                }
                if (!v.toString().equalsIgnoreCase("them")) continue;
                this.table.setValueAt("they", i, col);
            }
        });
        setPrimaryKeyItem.addActionListener(e -> this.setPrimaryKey());
        generateChartOnColumnDataItem.addActionListener(e -> ColumnChartView.showChart(this.table, this.table.getSelectedColumn(), this.table.getColumnName(this.table.getSelectedColumn())));
        generateChartOnRowDataItem.addActionListener(e -> {
            ColumnSelectionDialog dialog = new ColumnSelectionDialog("Select the columns to generate a chart on:", this, this.table, true);
            dialog.setVisible(true);
            Map<Integer, String> selectedColumns = dialog.getSelectedColumns();
            RowChartView.showChart(this.table, selectedColumns);
        });
        recordViewMenuItem.addActionListener(e -> new RecordViewDialog(this, this.table).setVisible(true));
        websiteItem.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/education/etraxion/");
            }
            catch (IOException | URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        });
        showOutputViewerItem.addActionListener(e -> {
            outputViewer = new OutputViewer(outputLines);
            outputViewer.setVisible(true);
        });
        aboutItem.addActionListener(e -> this.showAbout());
        if (!useSystemUi) {
            BalfTitleBar.rightPanelButton generateReports = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/files/reports.png"))));
            generateReports.setToolTipText("Generate Reports");
            generateReports.addActionListener(e -> this.generateReports());
            this.getTitleBar().addRightButton(generateReports);
            BalfTitleBar.rightPanelButton openTemplateEditor = new BalfTitleBar.rightPanelButton(new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/files/template.png"))));
            openTemplateEditor.setToolTipText("Open template editor");
            openTemplateEditor.addActionListener(e -> {
                String[] headers = new String[this.table.getColumnCount()];
                for (int i = 0; i < this.table.getColumnCount(); ++i) {
                    headers[i] = this.table.getColumnName(i);
                }
                ReportTemplateEditor.open(this, headers);
            });
            this.getTitleBar().addRightButton(openTemplateEditor);
        }
        this.cutItemContextItem.addActionListener(e -> {
            this.table.copyTableSelectionToClipboard();
            this.table.deleteSelectedCells();
        });
        this.copyItemContextItem.addActionListener(e -> this.table.copyTableSelectionToClipboard());
        deleteItemContextItem.addActionListener(e -> {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow != -1) {
                ((DefaultTableModel)this.table.getModel()).removeRow(selectedRow);
            }
        });
        this.hideColumnContextItem.addActionListener(e -> {
            if (this.table.getSelectedColumnCount() > 0) {
                this.table.hideSelectedColumn();
                this.showAllHiddenColumnsItem.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(this, "You must selected a column.", "Invalid column selection", 2);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = ReportBuilderMain.this.table.rowAtPoint(e.getPoint());
                    if (row >= 0 && row < ReportBuilderMain.this.table.getRowCount()) {
                        ReportBuilderMain.this.table.setRowSelectionInterval(row, row);
                    } else {
                        ReportBuilderMain.this.table.clearSelection();
                    }
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (Character.isDigit(keyChar)) {
                    int selectedRow = ReportBuilderMain.this.table.getSelectedRow();
                    int selectedCol = ReportBuilderMain.this.table.getSelectedColumn();
                    if (selectedRow != -1 && selectedCol != -1) {
                        ReportBuilderMain.this.table.editCellAt(selectedRow, selectedCol);
                        Component editor = ReportBuilderMain.this.table.getEditorComponent();
                        if (editor instanceof JComboBox) {
                            JComboBox comboBox = (JComboBox)editor;
                            int index = Character.getNumericValue(keyChar);
                            if (index > 0 && index <= comboBox.getItemCount()) {
                                comboBox.setSelectedIndex(index - 1);
                            }
                            comboBox.requestFocusInWindow();
                            e.consume();
                        }
                    }
                } else if (Character.isAlphabetic(keyChar)) {
                    String code = ("" + keyChar).toUpperCase();
                    int selectedRow = ReportBuilderMain.this.table.getSelectedRow();
                    int selectedCol = ReportBuilderMain.this.table.getSelectedColumn();
                    if (selectedRow != -1 && selectedCol != -1) {
                        ReportBuilderMain.this.table.editCellAt(selectedRow, selectedCol);
                        Component editor = ReportBuilderMain.this.table.getEditorComponent();
                        if (editor instanceof JComboBox) {
                            JComboBox comboBox = (JComboBox)editor;
                            int index = 0;
                            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                                String str;
                                Object item = comboBox.getItemAt(i);
                                if (item != null && (str = item.toString()).toLowerCase().startsWith(code.toLowerCase())) {
                                    comboBox.setSelectedIndex(index);
                                }
                                ++index;
                            }
                            comboBox.requestFocusInWindow();
                            e.consume();
                        }
                    }
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ReportBuilderMain.this.table.isEditing()) {
                    return;
                }
                if (!(e.isMetaDown() || e.getKeyCode() != 127 && e.getKeyCode() != 8)) {
                    int[] selectedRows = ReportBuilderMain.this.table.getSelectedRows();
                    int[] selectedCols = ReportBuilderMain.this.table.getSelectedColumns();
                    for (int row : selectedRows) {
                        for (int col : selectedCols) {
                            ReportBuilderMain.this.tableModel.setValueAt(null, row, col);
                        }
                    }
                    e.consume();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int selectedRow = this.table.getSelectedRow();
                int selectedCol = this.table.getSelectedColumn();
                editColumnData.setEnabled(selectedCol > -1);
                deleteSelectedColumnsItem.setEnabled(selectedCol != -1);
                removeSelectedEntriesItem.setEnabled(selectedRow != -1);
                if (!useSystemUi && selectedRow != -1) {
                    if (sorter.getRowFilter() == null) {
                        this.getFooter().setStatusText("\ud83d\udd11 " + this.table.getRowId(selectedRow));
                    } else {
                        this.getFooter().setStatusText("Filter Applied | \ud83d\udd11 " + this.table.getRowId(selectedRow));
                    }
                }
            }
        });
        this.startUndoService();
        if (new File(this.themePath).exists()) {
            try {
                this.setTheme(UITheme.loadFromFile(this.themePath));
                chooseATheme.setText("Remove current Theme");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (HelperFunctions.isMac() && this.useMacMenuBar) {
            this.setJMenuBar(this.menuBar.toJMenuBar());
        } else {
            this.setMenu(this.menuBar);
        }
    }

    private void updateRecentFiles() {
        this.recentFiles.removeAll();
        for (String filePath : this.recentFilesManager.getRecentFiles()) {
            BalfMenuBar.MenuItem item = new BalfMenuBar.MenuItem(filePath, this.menuBar);
            item.addActionListener(e -> {
                this.recentFilesManager.addRecentFile(filePath);
                this.openFile(filePath);
            });
            this.recentFiles.add(item);
        }
        this.recentFiles.setVisible(!this.recentFilesManager.getRecentFiles().isEmpty());
    }

    private void updateUndoMenuItem() {
        if (this.undoMenuItem == null) {
            return;
        }
        if (this.undoManager.canUndo()) {
            this.undoMenuItem.setEnabled(true);
            this.undoMenuItem.setText("Undo " + this.undoManager.getUndoPresentationName().replace("Undo ", ""));
        } else {
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setText("Undo");
        }
        if (this.redoMenuItem == null) {
            return;
        }
        if (this.undoManager.canRedo()) {
            this.redoMenuItem.setEnabled(true);
            this.redoMenuItem.setText("Redo " + this.undoManager.getRedoPresentationName().replace("Redo ", ""));
        } else {
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setText("Redo");
        }
    }

    private void startUndoService() {
        final UndoManager undoManager = new UndoManager();
        final Object[] previousValueHolder = new Object[1];
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = ReportBuilderMain.this.table.getSelectedRow();
                int col = ReportBuilderMain.this.table.getSelectedColumn();
                if (row != -1 && col != -1) {
                    previousValueHolder[0] = ReportBuilderMain.this.table.getValueAt(row, col);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = ReportBuilderMain.this.table.getSelectedRow();
                int col = ReportBuilderMain.this.table.getSelectedColumn();
                if (row != -1 && col != -1) {
                    previousValueHolder[0] = ReportBuilderMain.this.table.getValueAt(row, col);
                }
            }
        });
        this.tableModel.addTableModelListener(e -> {
            if (e.getType() == 0) {
                Object newValue;
                Object oldValue;
                final int row = e.getFirstRow();
                final int col = e.getColumn();
                if (row >= 0 && col >= 0 && row < this.tableModel.getRowCount() && col < this.tableModel.getColumnCount() && !Objects.equals(oldValue = previousValueHolder[0], newValue = this.tableModel.getValueAt(row, col))) {
                    undoManager.addEdit(new AbstractUndoableEdit(){
                        final Object before;
                        final Object after;
                        {
                            this.before = oldValue;
                            this.after = newValue;
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            ReportBuilderMain.this.tableModel.setValueAt(this.before, row, col);
                        }

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            ReportBuilderMain.this.tableModel.setValueAt(this.after, row, col);
                        }

                        @Override
                        public String getPresentationName() {
                            return "Cell Edit";
                        }
                    });
                    this.updateUndoMenuItem();
                }
            }
        });
        InputMap im = this.table.getInputMap(1);
        ActionMap am = this.table.getActionMap();
        im.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Undo");
        am.put("Undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        im.put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "Redo");
        am.put("Redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
    }

    private void showAbout() {
        Object msg = "";
        msg = (String)msg + "eTraxion version 1.1.3." + eTraxion.getBuildVersion() + " [Cotton]\n";
        msg = (String)msg + "Built on: " + eTraxion.getBuildDate() + " at " + eTraxion.getBuildTime() + "\n";
        msg = (String)msg + "Copyright J Balfour 2025\n";
        msg = (String)msg + "\n";
        msg = (String)msg + "Powered by: \n";
        msg = (String)msg + "ZPE version 1.13.9." + ZPECore.getBuildVersion() + " [Gillygate]\n";
        msg = (String)msg + "Built on: " + ZPECore.getBuildDate() + " at " + ZPECore.getBuildTime() + "\n";
        msg = (String)msg + "Copyright Jamie B Balfour 2011 - 2025";
        msg = (String)msg + "\n\nFor more information visit\nhttps://www.jamiebalfour.scot/projects/education/etraxion/";
        BalfButton btnVisitWebsiteButton = new BalfButton("Visit website", 15);
        btnVisitWebsiteButton.addActionListener(e -> {
            try {
                HelperFunctions.openWebsite("https://www.jamiebalfour.scot/projects/education/etraxion/");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Could not open the jamiebalfour.scot website", "Failure", 0);
            }
        });
        JOptionPane op = new JOptionPane(new BalfAboutDialog("eTraxion", (String)msg, btnVisitWebsiteButton).getContentPane(), -1, -1, this.logoFull, new String[0]);
        JDialog dlg = op.createDialog(this, "About eTraxion");
        dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dlg.setVisible(true);
    }

    private void switchOnDarkMode() {
        BalfLafManager.getInstance().toggleDarkMode(true);
    }

    private void switchOffDarkMode() {
        BalfLafManager.getInstance().toggleDarkMode(false);
    }

    void generateReports() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save File");
        fileChooser.setFileFilter(new FileNameExtensionFilter("Microsoft Word files (*.docx)", "docx"));
        int result = fileChooser.showSaveDialog(null);
        if (result == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".docx")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".docx");
            }
            String fullPath = selectedFile.getAbsolutePath();
            ColumnSelectionDialog dialog = new ColumnSelectionDialog("Select columns to include in the report:", this, this.table, true);
            dialog.setVisible(true);
            Map<Integer, String> selectedColumns = dialog.getSelectedColumns();
            if (selectedColumns != null) {
                ReportGenerator.exportTableToWord(this.template, this.table, new File(fullPath), selectedColumns, this.table.getColumnData());
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(new File(fullPath));
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(this._frame, "No columns were picked.", "Failure", 0);
            }
        }
    }

    private void openReportView() {
        String report = "No row selected";
        if (this.table.getSelectedRow() > -1) {
            report = ReportGenerator.produceIndividualReport(this.template, this.table.getSelectedRow(), this.table, this.table.getColumnData());
        }
        if (this.linkedReporter == null) {
            this.linkedReporter = new ReportView(this, report);
            this.linkedReporter.setVisible(true);
        } else {
            this.linkedReporter.setContent(report);
            this.linkedReporter.setVisible(true);
        }
    }

    private void loadMacros(Connection conn2) {
        this.sidebarMacroContainer.setVisible(false);
        this.sidebarMacroButtons.removeAll();
        try (Statement stmt = conn2.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM macros");){
            ZPERuntimeEnvironment z = new ZPERuntimeEnvironment(3);
            while (rs.next()) {
                String macroName = rs.getString("macro_id");
                String code = rs.getString("code");
                BalfButton b = new BalfButton(macroName, 7);
                b.addActionListener(e -> {
                    try {
                        HashMap<String, ZPEType> vars = new HashMap<String, ZPEType>();
                        vars.put("table", new TableObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), this.table));
                        vars.put("window", new WindowObject(z, (ZPEPropertyWrapper)ZPEKit.getGlobalFunction(z), this));
                        ZPEKit.interpret(new ZPERuntimeEnvironment(), code, new ZPEType[0], false, vars, false);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                    }
                });
                this.macros.put(macroName, code);
                this.sidebarMacroContainer.setVisible(true);
                this.sidebarMacroButtons.add(b);
                this.sidebarMacroButtons.revalidate();
            }
        }
        catch (SQLException e2) {
            System.err.println(e2.getMessage());
        }
    }

    void openFile(String filePath) {
        if (!new File(filePath).exists()) {
            return;
        }
        try {
            String name;
            if (filePath.endsWith(".db")) {
                try {
                    Connection conn2 = eTraxionHelperFunctions.getConnection(filePath);
                    this.loadMacros(conn2);
                    name = eTraxionHelperFunctions.loadGenericTableData(conn2, this, this.tableModel, this.table);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            } else if (filePath.endsWith(".pdb")) {
                try {
                    String tmpPassword = "";
                    PasswordEntryDialog dialog = new PasswordEntryDialog(null);
                    dialog.setVisible(true);
                    if (dialog.isConfirmed()) {
                        tmpPassword = dialog.getPassword();
                    }
                    byte[] content = FileHelperFunctions.readFile(filePath);
                    byte[] decrypted = (byte[])HelperFunctions.readEncryptedObject(content, HelperFunctions.padString(tmpPassword, 16));
                    FileHelperFunctions.writeByteFile(eTraxion.INSTALL_PATH + "/tmp.db", decrypted);
                    Connection conn2 = eTraxionHelperFunctions.getConnection(eTraxion.INSTALL_PATH + "/tmp.db");
                    this.loadMacros(conn2);
                    name = eTraxionHelperFunctions.loadGenericTableData(conn2, this, this.tableModel, this.table);
                    new File(eTraxion.INSTALL_PATH + "/tmp.db").delete();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error. Opening this file was unsuccessful. This file could have a different format to the data format (error 0x1).", "Error opening file.", 0);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error. Opening this file was unsuccessful. This file could have a different format to the data format (error 0x1).", "Error opening file.", 0);
                return;
            }
            this.table.autoResizeColumnWidths();
            this.table.removeToLastRow();
            if (name != null && this.getTitleBar() != null) {
                this.getTitleBar().setLabelText(name);
            }
            FileWatcherThread watcher = new FileWatcherThread(Paths.get(new File(filePath).getParent(), new String[0]), filePath);
            watcher.start();
            this.recentFilesManager.addRecentFile(filePath);
            this.updateRecentFiles();
            this.hideColumnContextItem.setEnabled(false);
            this.hideColumnItem.setEnabled(false);
            this.showAllHiddenColumnsItem.setEnabled(false);
            this.table.clearHiddenColumns();
            this.table.reload();
            this.currentFile = filePath;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPrimaryKey() {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (String s : this.table.getPrimaryKeyColumns()) {
            selected.add(this.table.findColumn(s));
        }
        ColumnSelectionDialog c = new ColumnSelectionDialog("Select the keys to compose the unique key from:", this, this.table, selected, false);
        c.setVisible(true);
        ArrayList<String> selectedColumns = new ArrayList<String>();
        if (c.getSelectedColumns() != null && !c.getSelectedColumns().isEmpty()) {
            for (Map.Entry<Integer, String> col : c.getSelectedColumns().entrySet()) {
                selectedColumns.add(col.getValue());
            }
            this.table.setPrimaryKeyColumns(selectedColumns, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean saveFile(String fullPath) {
        block15: {
            if (this.table.getColumnData().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Error saving the file as there is nothing in it.", "Error saving file", 0);
                return false;
            }
            if (this.table.getPrimaryKeyColumns() == null || this.table.getPrimaryKeyColumns().isEmpty()) {
                this.setPrimaryKey();
            }
            Object path = fullPath;
            if (this.password != null) {
                path = eTraxion.INSTALL_PATH + "/tmp.db";
            }
            try (Connection conn = eTraxionHelperFunctions.getConnection((String)path);){
                eTraxionHelperFunctions.saveCellsTableWithDynamicColumns(this.getTitleBar().getLabelText(), this.table, conn, this.table.getFullColumnData(), !fullPath.equals(this.currentFile));
                eTraxionHelperFunctions.saveMacros(conn, this.macros);
                eTraxionHelperFunctions.saveSetting(conn, "template", this.template);
                if (this.password == null) break block15;
                try {
                    byte[] content = FileHelperFunctions.readFile((String)path);
                    byte[] encrypted = HelperFunctions.writeEncryptedObject((Object)content, HelperFunctions.padString(this.password, 16));
                    FileHelperFunctions.writeByteFile(fullPath.replace(".db", ".pdb"), encrypted);
                    if (new File((String)path).delete()) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(this, "SQL exception " + e.getMessage(), "Error saving file.", 0);
                return false;
            }
        }
        this.currentFile = fullPath;
        return true;
    }

    private void updateReporter() {
        int selectedRow = this.table.getSelectedRow();
        int selectedCol = this.table.getSelectedColumn();
        if (selectedRow != -1 && selectedCol != -1 && this.showMapPreview != null && this.showMapPreview.isSelected()) {
            TableColumn column = this.table.getColumnModel().getColumn(selectedCol);
            TableCellEditor editor = column.getCellEditor();
            if (editor instanceof DefaultCellEditor) {
                Component comp = ((DefaultCellEditor)editor).getComponent();
                if (comp instanceof DataTable.MapComboBox) {
                    JComboBox comboBox = (JComboBox)comp;
                    int selected = -1;
                    DataTable.DataColumn d = this.table.getColumnData().get(selectedCol);
                    ZPEMap data = (ZPEMap)d.getJsonData();
                    for (int i = 0; i < data.size(); ++i) {
                        try {
                            String v = Objects.requireNonNull(this.table.getValueAt(selectedRow, selectedCol)).toString();
                            if (!((String)comboBox.getItemAt(i)).equals(v)) continue;
                            selected = i;
                            break;
                        }
                        catch (Exception v) {
                            // empty catch block
                        }
                    }
                    HashMap<String, String> colData = new HashMap<String, String>();
                    HashMap<Integer, ZPEType> columData = ReportGenerator.parseColumnData(this.table.getColumnData());
                    for (ZPEType s : data) {
                        colData.put(s.toString(), ReportGenerator.parseTemplate(data.get(s).toString(), this.table, this.table.getSelectedRow(), columData));
                    }
                    if (this.floatingOptionsWindow == null) {
                        this.floatingOptionsWindow = new MapViewSelector(this, this.table, colData, selected);
                    } else {
                        this.floatingOptionsWindow.setOptions(colData, selected);
                    }
                    this.floatingOptionsWindow.setVisible(true);
                    this.floatingOptionsWindow.setAlwaysOnTop(true);
                } else if (this.floatingOptionsWindow != null) {
                    this.floatingOptionsWindow.setVisible(false);
                }
            } else if (this.floatingOptionsWindow != null) {
                this.floatingOptionsWindow.setVisible(false);
            }
        } else if (this.floatingOptionsWindow != null) {
            this.floatingOptionsWindow.setVisible(false);
        }
        if (this.linkedReporter != null) {
            String report = ReportGenerator.produceIndividualReport(this.template, this.table.getSelectedRow(), this.table, this.table.getColumnData());
            if (this.linkedReporter != null) {
                this.linkedReporter.setContent(report);
                if (!this.linkedReporter.isVisible()) {
                    this.linkedReporter.setVisible(true);
                }
            }
        }
    }

    public void saveGUISettings(Properties props) {
        if (this.propertiesChanged) {
            String path = eTraxion.INSTALL_PATH + "gui.properties";
            try {
                FileOutputStream output = new FileOutputStream(path);
                props.store(output, "This is a list of properties for the ZPE GUI editor and can be modified manually.");
            }
            catch (Exception e) {
                ZPECore.log("Error saving GUI settings. " + e.getMessage());
            }
        }
    }

    public void closeUp() {
        this.setProperty("HEIGHT", "" + this._frame.getNormalFrameSize().getHeight());
        this.setProperty("WIDTH", "" + this._frame.getNormalFrameSize().getWidth());
        this.setProperty("XPOS", "" + this._frame.getNormalFrameLocation().getX());
        this.setProperty("YPOS", "" + this._frame.getNormalFrameLocation().getY());
        if (this.isMaximised()) {
            this.setProperty("MAXIMISED", "true");
        } else {
            this.setProperty("MAXIMISED", "false");
        }
        this.saveGUISettings(this.guiProperties);
    }

    public void setProperty(String name, String value) {
        this.guiProperties.setProperty(name, value);
        this.propertiesChanged = true;
    }
}

