/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameReport
extends JDialog {
    private String newName = null;
    private final JTextField nameField;

    public RenameReport(JFrame parent, String currentName) {
        super(parent, "Rename", true);
        this.setLayout(new BorderLayout());
        this.setSize(300, 180);
        this.setLocationRelativeTo(parent);
        JLabel label = new JLabel("Enter new name:");
        this.nameField = new JTextField(currentName != null ? currentName : "", 20);
        JPanel inputPanel = new JPanel(new BorderLayout(5, 5));
        inputPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        inputPanel.add((Component)label, "North");
        inputPanel.add((Component)this.nameField, "Center");
        BalfButton okButton = new BalfButton("OK", -1);
        BalfButton cancelButton = new BalfButton("Cancel", -1);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)inputPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(e -> {
            this.newName = this.nameField.getText().trim();
            this.dispose();
        });
        cancelButton.addActionListener(e -> {
            this.newName = null;
            this.dispose();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RenameReport.this.newName = null;
            }
        });
    }

    public String getNewName() {
        return this.newName;
    }

    public static String showRenameDialog(JFrame parent, String currentName) {
        RenameReport dialog = new RenameReport(parent, currentName);
        dialog.setVisible(true);
        return dialog.getNewName();
    }
}

