/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import jamiebalfour.etraxion.reporting.ReportGenerator;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RecordViewDialog
extends JDialog {
    private int currentRow;
    private final DataTable table;
    private final ArrayList<DataTable.DataColumn> columnData;
    private final List<JComponent> inputFields = new ArrayList<JComponent>();
    boolean updating = false;
    JTextArea reportView = new JTextArea();
    ReportBuilderMain parent;

    public RecordViewDialog(ReportBuilderMain parent, DataTable table) {
        super(parent, "Record View", true);
        this.table = table;
        this.columnData = table.getColumnData();
        this.currentRow = table.getSelectedRow() != -1 ? table.getSelectedRow() : 0;
        this.parent = parent;
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel formPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        formPanel.add((Component)new JLabel("Press ALT + Left or ALT + Right to go between records."), gbc);
        for (int i = 0; i < this.columnData.size(); ++i) {
            JComponent input;
            String label = this.columnData.get(i).getName();
            DataTable.ColumnType type = this.columnData.get(i).getType();
            JLabel jLabel = new JLabel(label);
            gbc.gridy = i + 1;
            formPanel.add((Component)jLabel, gbc);
            if (type == DataTable.ColumnType.MAP || type == DataTable.ColumnType.LIST) {
                JComboBox<String> combo = new JComboBox<String>();
                try {
                    ZPEType data = this.columnData.get(i).getJsonData();
                    if (type == DataTable.ColumnType.MAP) {
                        ZPEMap map = (ZPEMap)data;
                        for (ZPEType key : map.keySet()) {
                            combo.addItem(key.toString());
                        }
                    } else {
                        ZPEList list = (ZPEList)data;
                        for (ZPEType item : list) {
                            combo.addItem(item.toString());
                        }
                    }
                }
                catch (Exception e2) {
                    combo.addItem("Error");
                }
                input = combo;
            } else if (type == DataTable.ColumnType.CALCULATED) {
                JTextField calculated = new JTextField(20);
                calculated.setEditable(false);
                input = calculated;
            } else {
                input = new JTextField(20);
            }
            gbc.gridx = 1;
            formPanel.add((Component)input, gbc);
            this.inputFields.add(input);
            gbc.gridx = 0;
        }
        ++gbc.gridy;
        this.reportView.setLineWrap(true);
        this.reportView.setEditable(false);
        this.reportView.setMinimumSize(new Dimension(0, 200));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        final BalfButton prevButton = new BalfButton("Previous", 15);
        final BalfButton nextButton = new BalfButton("Next", 15);
        prevButton.addActionListener(e -> {
            if (this.currentRow > 0) {
                --this.currentRow;
                this.updateForm(this.currentRow);
            }
        });
        nextButton.addActionListener(e -> {
            if (this.currentRow < table.getRowCount() - 1) {
                ++this.currentRow;
                this.updateForm(this.currentRow);
            }
        });
        buttonPanel.add(prevButton);
        buttonPanel.add(nextButton);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)formPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.reportView);
        scrollPane.setPreferredSize(new Dimension(400, 150));
        scrollPane.setMinimumSize(new Dimension(100, 150));
        centerPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)centerPanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.setContentPane(contentPanel);
        this.updateForm(this.currentRow);
        this.pack();
        this.setLocationRelativeTo(parent);
        for (int i = 0; i < this.inputFields.size(); ++i) {
            JComponent input = this.inputFields.get(i);
            if (input instanceof JTextField) {
                ((JTextField)input).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        if (!RecordViewDialog.this.updating) {
                            RecordViewDialog.this.saveForm();
                        }
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        if (!RecordViewDialog.this.updating) {
                            RecordViewDialog.this.saveForm();
                        }
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        if (!RecordViewDialog.this.updating) {
                            RecordViewDialog.this.saveForm();
                        }
                    }
                });
            } else {
                ((JComboBox)input).addActionListener(e -> {
                    if (!this.updating) {
                        this.saveForm();
                    }
                });
            }
            input.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 39 && e.isAltDown()) {
                        nextButton.doClick();
                        e.consume();
                    } else if (e.getKeyCode() == 37 && e.isAltDown()) {
                        prevButton.doClick();
                        e.consume();
                    }
                }
            });
        }
    }

    private void updateForm(int row) {
        this.updating = true;
        for (int i = 0; i < this.inputFields.size(); ++i) {
            Object value = this.table.getValueAt(this.currentRow, i);
            JComponent field = this.inputFields.get(i);
            if (field instanceof JTextField) {
                ((JTextField)field).setText(value != null ? value.toString() : "");
                continue;
            }
            if (!(field instanceof JComboBox)) continue;
            ((JComboBox)field).setSelectedItem(value);
        }
        String report = ReportGenerator.produceIndividualReport(this.parent.template, row, this.table, this.table.getColumnData());
        this.reportView.setText(report);
        this.updating = false;
    }

    private void saveForm() {
        for (int i = 0; i < this.inputFields.size(); ++i) {
            JComponent field = this.inputFields.get(i);
            Object value = null;
            if (field instanceof JTextField) {
                value = ((JTextField)field).getText();
            } else if (field instanceof JComboBox) {
                value = ((JComboBox)field).getSelectedItem();
            }
            this.table.setValueAt(value, this.currentRow, i);
        }
    }
}

