/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.HelperFunctions;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MapViewSelector
extends JFrame {
    DataTable linkedTable;
    DefaultTableModel model;
    JTable table;

    public MapViewSelector(final ReportBuilderMain r, final DataTable linkedTable, HashMap<String, String> data, int selected) {
        this.linkedTable = linkedTable;
        this.setTitle("Map View Selector");
        this.setDefaultCloseOperation(2);
        this.setSize(800, 400);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                r.showMapPreview.setSelected(false);
            }
        });
        Object[] columnNames = new String[]{"Key", "Description"};
        String[][] tableData = new String[data.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            tableData[i][0] = entry.getKey();
            tableData[i][1] = entry.getValue();
            ++i;
        }
        DefaultTableModel tableModel = new DefaultTableModel(columnNames, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        for (Object[] objectArray : tableData) {
            tableModel.addRow(objectArray);
        }
        this.setFocusableWindowState(false);
        this.table = new JTable(tableModel);
        this.model = (DefaultTableModel)this.table.getModel();
        this.table.getTableHeader().setFont(new Font("Sans-Serif", 1, 12));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(0).setMaxWidth(80);
        if (HelperFunctions.isMac()) {
            this.table.setFont(new Font("Helvetica", 0, 14));
        } else {
            this.table.setFont(new Font("Aptos", 0, 14));
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            final JLabel area = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.area.setText(value.toString());
                this.area.setSize(700, 60);
                this.area.setOpaque(true);
                this.area.setFont(table.getFont());
                if (column == 0) {
                    this.area.setHorizontalAlignment(0);
                } else {
                    this.area.setHorizontalAlignment(2);
                }
                if (isSelected) {
                    this.area.setBackground(table.getSelectionBackground());
                    this.area.setForeground(table.getSelectionForeground());
                } else {
                    this.area.setBackground(table.getBackground());
                    this.area.setForeground(table.getForeground());
                }
                return this.area;
            }
        };
        this.table.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.table.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        this.table.setTableHeader(null);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setColumnHeader(null);
        this.add(scrollPane);
        this.table.setRowSelectionInterval(selected, selected);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MapViewSelector.this.table.getSelectedRow() != -1) {
                    int selectedRow = MapViewSelector.this.table.getSelectedRow();
                    Object selectedValue = MapViewSelector.this.table.getValueAt(selectedRow, 0);
                    int targetRow = linkedTable.getSelectedRow();
                    int targetColumn = linkedTable.getSelectedColumn();
                    if (targetRow != -1 && targetColumn != -1) {
                        linkedTable.setValueAt(selectedValue, targetRow, targetColumn);
                        linkedTable.repaint();
                    } else {
                        JOptionPane.showMessageDialog(MapViewSelector.this.table, "Select a target cell in the main table first.");
                    }
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){
            private boolean keyRedirected = false;

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (!this.keyRedirected && e.getID() == 401) {
                    this.keyRedirected = true;
                    linkedTable.requestFocusInWindow();
                    linkedTable.dispatchEvent(e);
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                    return true;
                }
                return false;
            }
        });
    }

    public void setOptions(HashMap<String, String> data, int selected) {
        this.model.setRowCount(0);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.model.addRow(new String[]{entry.getKey(), entry.getValue()});
        }
        this.table.setRowSelectionInterval(selected, selected);
        this.table.repaint();
    }
}

