/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.ColumnSelectionDialog;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.ReportGenerator;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MailMergeDialog
extends JFrame {
    String templatePath;
    String outputPath;
    Color buttonColourDefault;
    BalfButton createButton;
    Map<Integer, String> selectedColumns = null;

    public MailMergeDialog(DataTable table) {
        super("Mail Merge");
        JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel formPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        formPanel.add((Component)new JLabel("Select template:"), gbc);
        gbc.gridx = 1;
        BalfButton selectTemplateButton = new BalfButton("Browse...", 30);
        selectTemplateButton.disableDarkMode();
        formPanel.add((Component)selectTemplateButton, gbc);
        selectTemplateButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Open template");
            fileChooser.setFileFilter(new FileNameExtensionFilter("Microsoft Word files (*.docx)", "docx"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".docx")) {
                    return;
                }
                this.templatePath = selectedFile.getAbsolutePath();
                this.createButton.setEnabled(true);
            } else {
                this.templatePath = null;
                this.createButton.setEnabled(false);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 1;
        formPanel.add((Component)new JLabel("Output folder:"), gbc);
        gbc.gridx = 1;
        BalfButton selectFolderButton = new BalfButton("Browse...", 30);
        selectFolderButton.disableDarkMode();
        formPanel.add((Component)selectFolderButton, gbc);
        selectFolderButton.addActionListener(e -> {
            JFileChooser templateChooser = new JFileChooser();
            templateChooser.setDialogTitle("Choose save location");
            templateChooser.setFileSelectionMode(1);
            templateChooser.setAcceptAllFileFilterUsed(false);
            if (templateChooser.showOpenDialog(this) == 0) {
                File dir = templateChooser.getSelectedFile();
                this.outputPath = dir.getAbsolutePath();
                this.createButton.setEnabled(true);
            } else {
                this.outputPath = null;
                this.createButton.setEnabled(false);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 2;
        formPanel.add((Component)new JLabel("Select columns for names:"), gbc);
        gbc.gridx = 1;
        BalfButton selectColumns = new BalfButton("Pick columns...", 30);
        selectColumns.disableDarkMode();
        formPanel.add((Component)selectColumns, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        formPanel.add((Component)new JLabel("Prepend to file:"), gbc);
        gbc.gridx = 1;
        JTextField prependField = new JTextField(20);
        formPanel.add((Component)prependField, gbc);
        contentPanel.add((Component)formPanel, "Center");
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JCheckBox folderPerRecord = new JCheckBox("Create a folder for each record?");
        bottomPanel.add((Component)folderPerRecord, "West");
        this.createButton = new BalfButton("Create", 7);
        this.createButton.addActionListener(e -> System.out.println("Creating mail merge..."));
        JPanel createWrapper = new JPanel(new FlowLayout(1));
        createWrapper.add(this.createButton);
        bottomPanel.add((Component)createWrapper, "Center");
        contentPanel.add((Component)bottomPanel, "South");
        selectColumns.addActionListener(e -> {
            ColumnSelectionDialog dialog;
            if (this.selectedColumns != null) {
                ArrayList<Integer> selected = new ArrayList<Integer>(this.selectedColumns.keySet());
                dialog = new ColumnSelectionDialog("Select columns to include in the report:", this, table, selected, false);
            } else {
                dialog = new ColumnSelectionDialog("Select columns to include in the report:", this, table, false);
            }
            dialog.setVisible(true);
            this.selectedColumns = dialog.getSelectedColumns();
        });
        this.createButton.disableDarkMode();
        this.createButton.addActionListener(e -> {
            if (this.outputPath != null) {
                try {
                    ArrayList<Integer> columns = new ArrayList<Integer>();
                    if (this.selectedColumns != null) {
                        for (Map.Entry<Integer, String> entry : this.selectedColumns.entrySet()) {
                            columns.add(entry.getKey());
                        }
                    } else {
                        columns.add(0);
                        columns.add(1);
                    }
                    ReportGenerator.generateIndividualReports(this.templatePath, this.outputPath, table, table.getColumnData(), folderPerRecord.isSelected(), prependField.getText(), columns);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(new File(this.outputPath));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.setContentPane(contentPanel);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.buttonColourDefault = this.createButton.getBackground();
    }
}

