/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class FormatRuleEditor
extends JDialog {
    private JTable ruleTable;
    private DefaultTableModel model;
    private final DataTable.DataColumn columnData;

    public FormatRuleEditor(JFrame parent, DataTable.DataColumn columnData) {
        super(parent, "Edit Formatting Rules", true);
        this.columnData = columnData;
        this.setLayout(new BorderLayout(10, 10));
        this.setSize(600, 300);
        this.setLocationRelativeTo(parent);
        this.model = new DefaultTableModel(new String[]{"Rule", "Colour", "Background", "Priority"}, 0);
        this.ruleTable = new JTable(this.model);
        try {
            for (int i = 0; i < columnData.getFormattingRules().length(); ++i) {
                DataTable.FormatRule obj = columnData.getFormatRules().get(i);
                String hexColour = String.format("#%02x%02x%02x", obj.color.getRed(), obj.color.getGreen(), obj.color.getBlue());
                String hexColour2 = String.format("#%02x%02x%02x", obj.background.getRed(), obj.background.getGreen(), obj.background.getBlue());
                this.model.addRow(new Object[]{obj.rule, hexColour, hexColour2, obj.priority});
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        this.add((Component)new JScrollPane(this.ruleTable), "Center");
        JPanel buttonBar = new JPanel();
        JButton addRule = new JButton("Add Rule");
        JButton removeRule = new JButton("Remove Selected");
        JButton save = new JButton("Save");
        JButton cancel = new JButton("Cancel");
        addRule.addActionListener(e -> this.showAddRuleDialog());
        removeRule.addActionListener(e -> {
            int row = this.ruleTable.getSelectedRow();
            if (row != -1) {
                this.model.removeRow(row);
            }
        });
        save.addActionListener(e -> {
            ZPEList output = new ZPEList();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                ZPEMap obj = new ZPEMap();
                obj.put(new ZPEString("rule"), new ZPEString(this.model.getValueAt(i, 0).toString()));
                obj.put(new ZPEString("color"), new ZPEString(this.model.getValueAt(i, 1).toString()));
                obj.put(new ZPEString("background"), new ZPEString(this.model.getValueAt(i, 2).toString()));
                obj.put(new ZPEString("priority"), new ZPENumber(Integer.parseInt(this.model.getValueAt(i, 3).toString())));
                output.add(obj);
            }
            ZenithJSONParser parser = new ZenithJSONParser();
            columnData.setFormattingRules(parser.jsonEncode(output));
            this.dispose();
        });
        cancel.addActionListener(e -> this.dispose());
        buttonBar.add(addRule);
        buttonBar.add(removeRule);
        buttonBar.add(save);
        buttonBar.add(cancel);
        this.add((Component)buttonBar, "South");
    }

    private void showAddRuleDialog() {
        JTextField ruleField = new JTextField();
        JTextField priorityField = new JTextField("0");
        JButton colourPicker = new JButton("Pick Colour");
        JPanel colourPickerPanel = new JPanel();
        JButton backgroundPicker = new JButton("Pick Colour");
        JPanel backgroundPickerPanel = new JPanel();
        Color[] selectedColour = new Color[]{Color.RED};
        Color[] selectedBackground = new Color[]{Color.GREEN};
        colourPickerPanel.setSize(new Dimension(50, 50));
        colourPickerPanel.setPreferredSize(new Dimension(50, 50));
        colourPickerPanel.setBackground(selectedColour[0]);
        backgroundPickerPanel.setSize(new Dimension(50, 50));
        backgroundPickerPanel.setPreferredSize(new Dimension(50, 50));
        backgroundPickerPanel.setBackground(selectedBackground[0]);
        colourPicker.addActionListener(e -> {
            Color chosen = JColorChooser.showDialog(this, "Pick Colour", selectedColour[0]);
            if (chosen != null) {
                selectedColour[0] = chosen;
                colourPickerPanel.setBackground(chosen);
            }
        });
        backgroundPicker.addActionListener(e -> {
            Color chosen = JColorChooser.showDialog(this, "Pick Colour", selectedColour[0]);
            if (chosen != null) {
                selectedBackground[0] = chosen;
                backgroundPickerPanel.setBackground(chosen);
            }
        });
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel panel1 = new JPanel(new GridLayout(2, 2));
        JPanel panel2 = new JPanel(new GridLayout(2, 3));
        panel1.add(new JLabel("Rule:"));
        panel1.add(ruleField);
        panel1.add(new JLabel("Priority:"));
        panel1.add(priorityField);
        panel2.add(new JLabel("Colour:"));
        panel2.add(colourPickerPanel);
        panel2.add(colourPicker);
        panel2.add(new JLabel("Background:"));
        panel2.add(backgroundPickerPanel);
        panel2.add(backgroundPicker);
        outerPanel.add((Component)panel1, "North");
        outerPanel.add((Component)panel2, "South");
        int result = JOptionPane.showConfirmDialog(this, outerPanel, "Add New Formatting Rule", 2, -1);
        if (result == 0) {
            String hexColour = String.format("#%02x%02x%02x", selectedColour[0].getRed(), selectedColour[0].getGreen(), selectedColour[0].getBlue());
            String hexColour2 = String.format("#%02x%02x%02x", selectedBackground[0].getRed(), selectedBackground[0].getGreen(), selectedBackground[0].getBlue());
            this.model.addRow(new Object[]{ruleField.getText().trim(), hexColour, hexColour2, Integer.parseInt(priorityField.getText().trim())});
        }
    }
}

