/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindReplaceDialog
extends JDialog {
    private final DataTable table;
    private final JTextField searchField;
    private final JTextField replaceField;
    private final JCheckBox matchCase;
    private final BalfButton findNextButton;
    private final BalfButton replaceButton;
    private final BalfButton replaceAllButton;
    private int lastRow = 0;
    private int lastCol = -1;

    public FindReplaceDialog(JFrame parent, DataTable table) {
        super(parent, "Find & Replace", false);
        this.table = table;
        this.searchField = new JTextField(15);
        this.replaceField = new JTextField(15);
        this.matchCase = new JCheckBox("Match case");
        this.findNextButton = new BalfButton("Find Next", 15);
        this.replaceButton = new BalfButton("Replace", 15);
        this.replaceAllButton = new BalfButton("Replace All", 15);
        JPanel fieldPanel = new JPanel(new GridLayout(3, 2, 5, 5));
        fieldPanel.add(new JLabel("Find:"));
        fieldPanel.add(this.searchField);
        fieldPanel.add(new JLabel("Replace with:"));
        fieldPanel.add(this.replaceField);
        fieldPanel.add(this.matchCase);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.findNextButton);
        buttonPanel.add(this.replaceButton);
        buttonPanel.add(this.replaceAllButton);
        this.setLayout(new BorderLayout());
        this.add((Component)fieldPanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.setSize(400, 150);
        this.setLocationRelativeTo(parent);
        this.findNextButton.addActionListener(e -> this.findNext());
        this.replaceButton.addActionListener(e -> this.replace());
        this.replaceAllButton.addActionListener(e -> this.replaceAll());
    }

    private boolean isMatch(String cellValue, String searchText) {
        return this.matchCase.isSelected() ? cellValue.contains(searchText) : cellValue.toLowerCase().contains(searchText.toLowerCase());
    }

    private void findNext() {
        String searchText = this.searchField.getText();
        if (searchText.isEmpty()) {
            return;
        }
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        for (int row = this.lastRow; row < rowCount; ++row) {
            int col;
            int n = col = row == this.lastRow ? this.lastCol + 1 : 0;
            while (col < colCount) {
                Object val = this.table.getValueAt(row, col);
                if (val != null && this.isMatch(val.toString(), searchText)) {
                    this.table.changeSelection(row, col, false, false);
                    this.table.setHighlightedCell(row, col);
                    this.lastRow = row;
                    this.lastCol = col;
                    return;
                }
                ++col;
            }
        }
        JOptionPane.showMessageDialog(this, "No more matches found.", "Find", 1);
        this.lastRow = 0;
        this.lastCol = -1;
    }

    private void replace() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (row == -1 || col == -1) {
            return;
        }
        Object val = this.table.getValueAt(row, col);
        if (val == null) {
            return;
        }
        String search = this.searchField.getText();
        String replace = this.replaceField.getText();
        String cellText = val.toString();
        if (this.isMatch(cellText, search)) {
            String updated = this.matchCase.isSelected() ? cellText.replace(search, replace) : cellText.replaceAll("(?i)" + Pattern.quote(search), replace);
            this.table.setValueAt(updated, row, col);
        }
    }

    private void replaceAll() {
        String search = this.searchField.getText();
        String replace = this.replaceField.getText();
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        int replacements = 0;
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                Object val = this.table.getValueAt(row, col);
                if (val == null || !this.isMatch(val.toString(), search)) continue;
                String updated = this.matchCase.isSelected() ? val.toString().replace(search, replace) : val.toString().replaceAll("(?i)" + Pattern.quote(search), replace);
                this.table.setValueAt(updated, row, col);
                ++replacements;
            }
        }
        JOptionPane.showMessageDialog(this, replacements + " replacements made.");
    }

    public void reset() {
        this.lastRow = 0;
        this.lastCol = -1;
    }
}

