/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.HelperFunctions;
import jamiebalfour.parsers.json.MalformedJSONException;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.zpe.core.ZPEKit;
import jamiebalfour.zpe.core.ZPEMemberType;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEList;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DataTable
extends JTable {
    private final ArrayList<Integer> updatedRows = new ArrayList();
    private ArrayList<DataColumn> columnData = new ArrayList();
    int highlightedRow = -1;
    int highlightedColumn = -1;
    private ArrayList<Integer> userHighlightedRows = new ArrayList();
    private ArrayList<Integer> userHighlightedColumns = new ArrayList();
    private Color userHighlightedColor = Color.GREEN;
    private Color userHighlightedBackgroundColor = Color.BLACK;
    boolean rowHighlight = false;
    boolean columnHighlight = false;
    DataTable _this = this;
    ArrayList<String> primaryKeyFields;
    boolean darkEnabled = false;
    HashMap<DataColumn, TableColumn> deletedColumnMap = new HashMap();
    Map<Integer, TableColumn> hiddenColumns = new HashMap<Integer, TableColumn>();
    Map<Integer, DataColumn> hiddenColumnData = new HashMap<Integer, DataColumn>();

    public DataTable(TableModel t) {
        super(t);
        this.setDoubleBuffered(true);
        this.getModel().addTableModelListener(e -> e.getType());
        this.getModel().addTableModelListener(e -> {
            if (e.getType() == 0 && e.getFirstRow() != -1) {
                if (e.getFirstRow() == e.getLastRow()) {
                    this.updatedRows.add(e.getFirstRow());
                } else {
                    for (int i = e.getFirstRow(); i < e.getLastRow(); ++i) {
                        this.updatedRows.add(i);
                    }
                }
            }
        });
        this.getColumnModel().getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                JTableHeader header = this.getTableHeader();
                if (header != null) {
                    header.repaint();
                }
                this.repaint();
            }
        });
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.tableHeader.setOpaque(false);
        this.getTableHeader().setBackground(this.getBackground());
        this.getTableHeader().setForeground(this.getForeground());
        this.getTableHeader().setOpaque(true);
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.switchOnDarkMode();
                this.darkEnabled = true;
            } else {
                this.switchOffDarkMode();
                this.darkEnabled = false;
            }
            this.getTableHeader().setBackground(this.getBackground());
            this.getTableHeader().setForeground(this.getForeground());
            this.getTableHeader().setOpaque(true);
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (e.getFromIndex() != e.getToIndex()) {
                    TableColumnModel model = DataTable.this.getColumnModel();
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        DataTable.this.setColumnPositions(model.getColumn(i).getHeaderValue().toString(), i);
                    }
                    if (e.getFromIndex() != e.getToIndex()) {
                        DataTable.this.updateColumnDataBasedOnVisualOrder();
                    }
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }
        });
    }

    private void updateColumnDataBasedOnVisualOrder() {
        ArrayList<DataColumn> newOrder = new ArrayList<DataColumn>();
        block0: for (int j = 0; j < this.getColumnCount(); ++j) {
            for (DataColumn col : this.columnData) {
                if (!this.getColumnName(j).equals(col.getName())) continue;
                newOrder.add(col);
                this.columnData.remove(col);
                continue block0;
            }
        }
        for (DataColumn col : this.columnData) {
            if (!col.hidden && !col.remove) continue;
            newOrder.add(col);
            this.columnData.remove(col);
        }
        this.columnData.addAll(newOrder);
    }

    public static <T> void moveItem(List<T> list, int fromIndex, int toIndex) {
        if (fromIndex == toIndex || fromIndex < 0 || fromIndex >= list.size() || toIndex < 0 || toIndex > list.size()) {
            return;
        }
        T item = list.remove(fromIndex);
        if (fromIndex < toIndex) {
            --toIndex;
        }
        list.add(toIndex, item);
    }

    private void setColumnPositions(String n, int pos) {
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            String name = this.getColumnData().get(i).getName();
            if (!name.equals(n)) continue;
            this.getColumnData().get(i).setDisplayOrder(pos);
            DataTable.moveItem(this.getColumnData(), i, pos);
            return;
        }
    }

    public ArrayList<String> getPrimaryKeyColumns() {
        ArrayList<String> pks = new ArrayList<String>();
        if (this.primaryKeyFields == null) {
            return pks;
        }
        for (String k : this.primaryKeyFields) {
            if (this.findColumn(k) <= -1) continue;
            pks.add(k);
        }
        return pks;
    }

    public void setPrimaryKeyColumns(ArrayList<String> pk, boolean ignoreCheck) {
        if (ignoreCheck) {
            this.primaryKeyFields = pk;
        } else {
            ArrayList<String> pks = new ArrayList<String>();
            for (String k : pk) {
                if (this.findColumn(k) <= -1) continue;
                pks.add(k);
            }
            this.primaryKeyFields = pks;
        }
    }

    public int findColumn(String column) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(column)) continue;
            return i;
        }
        return -1;
    }

    public int getRowId(int row) {
        if (this.primaryKeyFields != null && !this.primaryKeyFields.isEmpty()) {
            StringBuilder s = new StringBuilder();
            ArrayList<Integer> columns = new ArrayList<Integer>();
            for (String k : this.primaryKeyFields) {
                columns.add(this.findColumn(k));
            }
            Iterator<String> iterator2 = columns.iterator();
            while (iterator2.hasNext()) {
                int c = (Integer)((Object)iterator2.next());
                if (row >= this.getRowCount() || c >= this.getColumnCount() || c <= -1) continue;
                s.append(this.getValueAt(row, c));
            }
            return s.toString().hashCode();
        }
        return -1;
    }

    private void switchOnDarkMode() {
        Color dark = Color.decode("#282D37");
        this.setBackground(dark);
    }

    private void switchOffDarkMode() {
        Color light = Color.decode("#FFFFFF");
        this.setBackground(light);
    }

    public void setHighlightedCell(int row, int column) {
        this.highlightedRow = row;
        this.highlightedColumn = column;
    }

    public ArrayList<DataColumn> getColumnData() {
        ArrayList<DataColumn> c = new ArrayList<DataColumn>();
        for (int i = 0; i < this.columnData.size(); ++i) {
            DataColumn current = this.columnData.get(i);
            if (current.isHidden() || current.isRemoved()) continue;
            c.add(current);
        }
        return c;
    }

    public ArrayList<DataColumn> getFullColumnData() {
        return this.columnData;
    }

    public int getUpdatedRowCount() {
        return this.updatedRows.size();
    }

    public ArrayList<Integer> returnUpdatedRows() {
        return this.updatedRows;
    }

    public void clearUpdatedRows() {
        this.updatedRows.clear();
    }

    public void editColumnData(int columnNumber, DataColumn d) {
        String oldName = this.getColumnData().get(columnNumber).getName();
        this.getColumnData().get(columnNumber).setName(d.getName());
        this.getColumnData().get(columnNumber).setType(d.getType());
        this.getColumnData().get(columnNumber).setDisplayOrder(columnNumber);
        this.getColumnData().get(columnNumber).setData(d.getData());
        this.getColumnData().get(columnNumber).setFormattingRules(d.getFormattingRules());
        if (this.getColumnData().get(columnNumber).getOldName().isEmpty()) {
            this.getColumnData().get(columnNumber).setOldName(oldName);
        }
        TableColumn column = this.getColumnModel().getColumn(columnNumber);
        column.setHeaderValue(d.getName());
        this.getTableHeader().repaint();
        this.resetLook((DefaultTableModel)this.getModel());
    }

    public void addColumnData(DataColumn data) {
        this.columnData.add(data);
        this.addColumnSafely(data.getName());
        this.autoResizeColumnWidths();
    }

    private void addColumnSafely(String newColumnName) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int rowCount = model.getRowCount();
        int oldColCount = model.getColumnCount();
        Object[][] oldData = new Object[rowCount][oldColCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < oldColCount; ++col) {
                oldData[row][col] = model.getValueAt(row, col);
            }
        }
        Object[] newColumnNames = new String[oldColCount + 1];
        for (int i = 0; i < oldColCount; ++i) {
            newColumnNames[i] = model.getColumnName(i);
        }
        newColumnNames[oldColCount] = newColumnName;
        Object[][] newData = new Object[rowCount][oldColCount + 1];
        for (int row = 0; row < rowCount; ++row) {
            System.arraycopy(oldData[row], 0, newData[row], 0, oldColCount);
            newData[row][oldColCount] = "";
        }
        model.setDataVector(newData, newColumnNames);
        this.resetLook(model);
    }

    public void reload() {
        this.resetLook((DefaultTableModel)this.getModel());
    }

    void resetLook(DefaultTableModel model) {
        CellRenderer borderRenderer = new CellRenderer(this);
        for (int col = 0; col < this.getColumnCount(); ++col) {
            DataColumn c = this.getColumnData().get(col);
            this.getColumnModel().getColumn(col).setCellRenderer(borderRenderer);
            this.setColumnType(c, col);
        }
        this.repaint();
    }

    private void setColumnType(DataColumn column, int index) {
        int j;
        ZPEMemberType z2;
        if (column.getType() == ColumnType.MAP) {
            try {
                z2 = (ZPEMap)column.getJsonData();
                String[] dropdownOptions = new String[((ZPEMap)z2).size()];
                j = 0;
                if (column.getType() == ColumnType.MAP) {
                    for (ZPEType m : ((ZPEMap)z2).keySet()) {
                        dropdownOptions[j++] = m.toString();
                    }
                }
                this.getColumnModel().getColumn(index).setCellEditor(new DefaultCellEditor(new MapComboBox(dropdownOptions, null, this, (ZPEMap)z2)));
            }
            catch (Exception z2) {}
        } else if (column.getType() == ColumnType.LIST) {
            try {
                z2 = (ZPEList)column.getJsonData();
                String[] dropdownOptions = new String[((ZPEList)z2).size()];
                j = 0;
                Iterator<ZPEType> iterator2 = ((ZPEList)z2).iterator();
                while (iterator2.hasNext()) {
                    ZPEType m;
                    m = iterator2.next();
                    dropdownOptions[j++] = m.toString();
                }
                this.getColumnModel().getColumn(index).setCellEditor(new DefaultCellEditor(new ListComboBox(dropdownOptions, null, this, (ZPEList)z2)));
            }
            catch (Exception z3) {}
        } else if (column.getType() == ColumnType.CALCULATED) {
            JTextField label = new JTextField();
            label.setEditable(false);
            this.getColumnModel().getColumn(index).setCellEditor(new DefaultCellEditor(label));
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.evaluateCalculatedColumn(index, i);
            }
        } else {
            this.getColumnModel().getColumn(index).setCellEditor(new DefaultCellEditor(new JTextField()));
        }
        if (!column.formatRules.isEmpty()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
            }
        }
    }

    public void updateColumns(ArrayList<DataColumn> columnData) {
        this.columnData = columnData;
        ZenithJSONParser jsonParser = new ZenithJSONParser();
        TableColumnModel columnModel = this.getColumnModel();
        for (int i = 0; i < columnData.size(); ++i) {
            JComboBox<String> comboBox;
            int j;
            String[] dropdownOptions;
            ColumnType type = columnData.get(i).getType();
            String data = columnData.get(i).getData();
            if (type != ColumnType.MAP && type != ColumnType.LIST) continue;
            if (type == ColumnType.MAP) {
                ZPEMap z = null;
                try {
                    z = (ZPEMap)columnData.get((int)i).jsonData;
                    dropdownOptions = new String[z.size()];
                    j = 0;
                    for (ZPEType m : z.keySet()) {
                        dropdownOptions[j++] = m.toString();
                    }
                    comboBox = new JComboBox<String>(dropdownOptions);
                    columnModel.getColumn(i).setCellEditor(new DefaultCellEditor(comboBox));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                ZPEList l = (ZPEList)columnData.get((int)i).jsonData;
                dropdownOptions = new String[l.size()];
                j = 0;
                for (ZPEType m : l) {
                    dropdownOptions[j++] = m.toString();
                }
                comboBox = new JComboBox<String>(dropdownOptions);
                columnModel.getColumn(i).setCellEditor(new DefaultCellEditor(comboBox));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int removeToLastRow() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        for (int r = this.getModel().getRowCount() - 1; r > 0; --r) {
            if (!this.rowIsBlank(r)) continue;
            model.setRowCount(r);
        }
        return this.getModel().getRowCount() - 1;
    }

    public boolean rowIsBlank(int row) {
        int rowBlanks = 0;
        for (int c = 0; c < this.getModel().getColumnCount(); ++c) {
            Object cellValue = this.getModel().getValueAt(row, c);
            if (cellValue != null && !cellValue.toString().isEmpty()) continue;
            ++rowBlanks;
        }
        return rowBlanks == this.getModel().getColumnCount();
    }

    public void autoResizeColumnWidths() {
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn column = this.getColumnModel().getColumn(col);
            int width = 60;
            TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
            Component headerComp = headerRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, col);
            width = Math.max(width, headerComp.getPreferredSize().width);
            for (int row = 0; row < this.getRowCount(); ++row) {
                TableCellRenderer cellRenderer = this.getCellRenderer(row, col);
                Component comp = this.prepareRenderer(cellRenderer, row, col);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            column.setPreferredWidth(width + 60);
        }
    }

    public void readdDeletedColumn(DataColumn columnData) {
        columnData.setRemoved(false);
        this.columnModel.addColumn(this.deletedColumnMap.get(columnData));
        this.reload();
        int t = this.getColumnCount() - 1;
        int x = columnData.getDisplayOrder();
        this.moveColumn(t, x);
        this.deletedColumnMap.remove(columnData);
    }

    public DataColumn deleteColumnByName(String name) {
        int i;
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (!this.tableHeader.getColumnModel().getColumn(i).getHeaderValue().equals(name)) continue;
            return this.deleteColumn(i);
        }
        for (i = 0; i < this.columnData.size(); ++i) {
            if (!this.columnData.get(i).getName().equals(name)) continue;
            this.columnData.get(i).setRemoved(true);
        }
        return null;
    }

    public DataColumn deleteColumn(int column) {
        int actualIndex = 0;
        int i = 0;
        while (actualIndex != column) {
            if (!this.columnData.get(i).isHidden() && !this.columnData.get(i).isRemoved()) {
                ++actualIndex;
            }
            ++i;
        }
        this.deletedColumnMap.put(this.columnData.get(i), this.columnModel.getColumn(column));
        this.columnData.get(i).setRemoved(true);
        this.columnModel.removeColumn(this.columnModel.getColumn(column));
        this.reload();
        return this.columnData.get(i);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        DefaultCellEditor defaultEditor;
        Component comp;
        TableCellEditor editor;
        MouseEvent mouseEvent;
        if (e instanceof MouseEvent && (mouseEvent = (MouseEvent)e).isShiftDown() && ((editor = this.getColumnModel().getColumn(column).getCellEditor()) instanceof DefaultCellEditor ? (comp = (defaultEditor = (DefaultCellEditor)editor).getComponent()) instanceof JComboBox || comp instanceof JTextField : editor == null)) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getSelectedRow() == row && this.getSelectedColumn() == column;
    }

    public void hideSelectedColumn() {
        int colIndex = this.getSelectedColumns()[0];
        TableColumn hiddenColumn = this.columnModel.getColumn(colIndex);
        int modelIndex = hiddenColumn.getModelIndex();
        DataColumn data = this.columnData.get(modelIndex);
        if (data != null) {
            this.columnData.get(modelIndex).setHidden(true);
        }
        this.columnModel.removeColumn(hiddenColumn);
        this.hiddenColumnData.put(colIndex, data);
        this.columnData.remove(modelIndex);
        this.hiddenColumns.put(colIndex, hiddenColumn);
    }

    public void hideSelectedColumns() {
        for (int i = this.columnModel.getSelectedColumnCount() - 1; i >= 0; --i) {
            int colIndex = this.getSelectedColumns()[i];
            TableColumn hiddenColumn = this.columnModel.getColumn(colIndex);
            int modelIndex = hiddenColumn.getModelIndex();
            DataColumn data = this.columnData.get(modelIndex);
            if (data != null) {
                this.columnData.get(modelIndex).setHidden(true);
            }
            this.columnModel.removeColumn(hiddenColumn);
            this.hiddenColumnData.put(colIndex, data);
            this.columnData.remove(modelIndex);
            this.hiddenColumns.put(colIndex, hiddenColumn);
        }
    }

    public void showAllHiddenColumns() {
        int index;
        ArrayList<Integer> indices = new ArrayList<Integer>(this.hiddenColumns.keySet());
        Collections.sort(indices);
        Iterator iterator2 = indices.iterator();
        while (iterator2.hasNext()) {
            index = (Integer)iterator2.next();
            TableColumn col = this.hiddenColumns.get(index);
            DataColumn dataCol = this.hiddenColumnData.get(index);
            this.addColumn(col);
            this.columnData.add(dataCol.getDisplayOrder(), dataCol);
            dataCol.setHidden(false);
        }
        iterator2 = indices.iterator();
        while (iterator2.hasNext()) {
            index = (Integer)iterator2.next();
            int lastIndex = this.getColumnCount() - 1;
            if (index < 0 || index >= this.getColumnCount()) continue;
            this.moveColumn(lastIndex, index);
        }
        this.hiddenColumns.clear();
        this.hiddenColumnData.clear();
    }

    public void clearHiddenColumns() {
        this.hiddenColumns.clear();
    }

    public void setRowHighlight(boolean rowSelectionAllowed) {
        this.rowHighlight = rowSelectionAllowed;
    }

    public void setColumnHighlight(boolean columnSelectionAllowed) {
        this.columnHighlight = columnSelectionAllowed;
    }

    public void highlightColumn(int column, Color foreground, Color background) {
        this.userHighlightedColumns.add(column);
        this.userHighlightedColor = foreground;
        this.userHighlightedBackgroundColor = background;
        this.repaint();
    }

    public void highlightRow(int row, Color foreground, Color background) {
        this.userHighlightedRows.add(row);
        this.userHighlightedColor = foreground;
        this.userHighlightedBackgroundColor = background;
        this.repaint();
    }

    public void unhighlightColumn(int column) {
        this.userHighlightedColumns.remove(column);
        this.repaint();
    }

    public void unhighlightRow(int row) {
        this.userHighlightedRows.remove(row);
        this.repaint();
    }

    private static boolean evaluateCondition(Object value, String expression) {
        String[] andChunks;
        double numericValue = HelperFunctions.stringToDouble(value.toString());
        for (String and : andChunks = expression.toLowerCase().split("and")) {
            String[] orChunks;
            and = and.trim();
            boolean orResult = false;
            for (String or : orChunks = and.split("or")) {
                double operand;
                if ((or = or.trim()).startsWith(">=")) {
                    operand = HelperFunctions.stringToDouble(or.substring(2).trim());
                    orResult = orResult || numericValue >= operand;
                    continue;
                }
                if (or.startsWith("<=")) {
                    operand = HelperFunctions.stringToDouble(or.substring(2).trim());
                    orResult = orResult || numericValue <= operand;
                    continue;
                }
                if (or.startsWith("!=")) {
                    operand = HelperFunctions.stringToDouble(or.substring(2).trim());
                    orResult = orResult || numericValue != operand;
                    continue;
                }
                if (or.startsWith(">")) {
                    operand = HelperFunctions.stringToDouble(or.substring(1).trim());
                    orResult = orResult || numericValue > operand;
                    continue;
                }
                if (or.startsWith("<")) {
                    operand = HelperFunctions.stringToDouble(or.substring(1).trim());
                    orResult = orResult || numericValue < operand;
                    continue;
                }
                if (or.startsWith("=")) {
                    operand = HelperFunctions.stringToDouble(or.substring(1).trim());
                    if (value instanceof String) {
                        orResult = orResult || ((String)value).equalsIgnoreCase(or.substring(1).trim());
                        continue;
                    }
                    orResult = orResult || numericValue == operand;
                    continue;
                }
                operand = HelperFunctions.stringToDouble(or);
                orResult = orResult || numericValue == operand;
            }
            if (orResult) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        if (this.getColumnData().get(column).getType() != ColumnType.CALCULATED) {
            this.onCellUpdated(row);
        }
    }

    private void onCellUpdated(int row) {
        this.reevaluateRow(row);
    }

    private void reevaluateRow(int row) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnData().get(i).getType() != ColumnType.CALCULATED) continue;
            this.evaluateCalculatedColumn(i, row);
        }
    }

    public void evaluateCalculatedColumn(int column, int row) {
        DataColumn c = this.getColumnData().get(column);
        if (c.getType() == ColumnType.CALCULATED) {
            String expression = c.getData();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.getColumnData().get(i).getType() == ColumnType.CALCULATED) continue;
                String name = this.getColumnData().get(i).getName();
                Object value = this.getValueAt(row, i);
                variables.put(name, value);
            }
            for (Map.Entry entry : variables.entrySet()) {
                if (entry.getValue() == null) {
                    expression = expression.replace((CharSequence)entry.getKey(), "");
                    continue;
                }
                if (entry.getValue() instanceof Number || entry.getValue().toString().matches("-?\\d+(\\.\\d+)?")) {
                    expression = expression.replace((CharSequence)entry.getKey(), entry.getValue().toString());
                    continue;
                }
                expression = expression.replace((CharSequence)entry.getKey(), "\"" + entry.getValue().toString() + "\"");
            }
            try {
                this.setValueAt(ZPEKit.runCode(new ZPERuntimeEnvironment(), expression, null), row, column);
            }
            catch (Exception e) {
                this.setValueAt("!ERROR", row, column);
            }
        }
    }

    public void copyTableSelectionToClipboard() {
        int[] selectedRows = this.getSelectedRows();
        int[] selectedCols = this.getSelectedColumns();
        if (selectedRows.length == 0 || selectedCols.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int row : selectedRows) {
            for (int colIndex = 0; colIndex < selectedCols.length; ++colIndex) {
                int col = selectedCols[colIndex];
                Object cellValue = this.getValueAt(row, col);
                sb.append(cellValue != null ? cellValue.toString() : "");
                if (colIndex >= selectedCols.length - 1) continue;
                sb.append("\t");
            }
            sb.append("\n");
        }
        StringSelection selection = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    public void deleteSelectedCells() {
        int[] rows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        if (rows.length == 0 || cols.length == 0) {
            return;
        }
        for (int row : rows) {
            for (int col : cols) {
                this.setValueAt(null, row, col);
            }
        }
    }

    public static class DataColumn {
        private String id;
        private String name = "";
        private ColumnType type = ColumnType.TEXT;
        private String data = "";
        private String formattingRules = "";
        private final ArrayList<FormatRule> formatRules = new ArrayList();
        private int displayOrder;
        private boolean hidden = false;
        private boolean remove = false;
        private String oldName = "";
        private ZPEType jsonData;
        private String sheetId = null;
        private int oldDisplayOrder = -1;

        public DataColumn(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
            this.id = name.replace(" ", "").toLowerCase();
        }

        public void setType(ColumnType type) {
            this.type = type;
        }

        public void setData(String data) {
            this.data = data;
            ZenithJSONParser parser = new ZenithJSONParser();
            if (data != null && !data.isEmpty()) {
                try {
                    this.jsonData = parser.jsonDecode(data, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ZPEType getJsonData() {
            return this.jsonData;
        }

        public void setFormattingRules(String formattingRules) {
            this.formattingRules = formattingRules;
            this.formatRules.clear();
            ZenithJSONParser parser = new ZenithJSONParser();
            try {
                if (formattingRules != null && !formattingRules.isEmpty()) {
                    ZPEList rules = (ZPEList)parser.jsonDecode(formattingRules, false);
                    for (ZPEType t : rules) {
                        ZPEMap d = (ZPEMap)t;
                        FormatRule rule = new FormatRule(d.get(new ZPEString("rule")).toString(), Color.decode(d.get(new ZPEString("color")).toString()), Color.decode(d.get(new ZPEString("background")).toString()), 0);
                        this.formatRules.add(rule);
                    }
                }
            }
            catch (MalformedJSONException malformedJSONException) {
                // empty catch block
            }
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public void setDisplayOrder(int displayOrder) {
            this.displayOrder = displayOrder;
        }

        public void setRemoved(boolean removed) {
            this.remove = removed;
            if (removed) {
                if (this.displayOrder != 9999) {
                    this.oldDisplayOrder = this.displayOrder;
                }
                this.displayOrder = 9999;
            } else if (this.oldDisplayOrder != -1) {
                this.displayOrder = this.oldDisplayOrder;
            }
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public void setOldName(String name) {
            this.oldName = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ColumnType getType() {
            return this.type;
        }

        public String getTypeAsString() {
            if (this.type == ColumnType.MAP) {
                return "MAP";
            }
            if (this.type == ColumnType.LIST) {
                return "LIST";
            }
            if (this.type == ColumnType.CALCULATED) {
                return "CALCULATED";
            }
            return "TEXT";
        }

        public String getData() {
            return this.data;
        }

        public String getFormattingRules() {
            return this.formattingRules;
        }

        public ArrayList<FormatRule> getFormatRules() {
            return this.formatRules;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public int getDisplayOrder() {
            return this.displayOrder;
        }

        public String getOldName() {
            return this.oldName;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isRemoved() {
            return this.remove;
        }

        public void setTypeFromString(String type) {
            this.type = type.equalsIgnoreCase("map") ? ColumnType.MAP : (type.equalsIgnoreCase("list") ? ColumnType.LIST : (type.equalsIgnoreCase("calculated") ? ColumnType.CALCULATED : ColumnType.TEXT));
        }
    }

    public static class FormatRule {
        String rule;
        Color color;
        Color background;
        int priority;

        public FormatRule(String rule, Color c, Color background, int priority) {
            this.rule = rule;
            this.color = c;
            this.background = background;
            this.priority = priority;
        }
    }

    public static enum ColumnType {
        TEXT,
        LIST,
        MAP,
        CALCULATED;

    }

    public static class ListComboBox<S>
    extends DataTableComboBox {
        private final ZPEList list;

        public ListComboBox(String[] items, String selectedItem, DataTable table, ZPEList l) {
            super(items, selectedItem, table);
            this.list = l;
        }
    }

    public static class MapComboBox<S>
    extends DataTableComboBox {
        private final ZPEMap map;

        public MapComboBox(String[] items, String selectedItem, DataTable table, ZPEMap m) {
            super(items, selectedItem, table);
            this.map = m;
        }
    }

    public static class DataTableComboBox
    extends JComboBox<String> {
        private final DataTable table;

        public DataTableComboBox(String[] items, String selected, DataTable table) {
            super(items);
            this.table = table;
            if (selected != null) {
                for (String item : items) {
                    if (!item.equals(selected)) continue;
                    this.setSelectedItem(item);
                }
            }
            this.setEditable(false);
            final JTextField editor = (JTextField)this.getEditor().getEditorComponent();
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!(e.isControlDown() || e.isShiftDown() || e.isMetaDown() || e.isAltDown())) {
                        String input = editor.getText() + e.getKeyCode();
                        boolean matchFound = false;
                        for (int i = 0; i < this.getItemCount(); ++i) {
                            if (!((String)this.getItemAt(i)).equals(input)) continue;
                            matchFound = true;
                            this.setSelectedIndex(i);
                            editor.setText((String)this.getItemAt(i));
                            break;
                        }
                        if (!matchFound) {
                            e.consume();
                        } else {
                            editor.setForeground(Color.BLACK);
                        }
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    char keyChar = e.getKeyChar();
                    if (Character.isDigit(keyChar)) {
                        int index = Character.getNumericValue(keyChar);
                        if (index > 0 && index <= this.getItemCount()) {
                            this.setSelectedIndex(index - 1);
                            editor.setText((String)this.getItemAt(index - 1));
                            e.consume();
                        } else {
                            e.consume();
                        }
                    } else if (e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f') {
                        editor.setText("");
                    } else {
                        int matchFound = -1;
                        String input = "" + keyChar;
                        for (int i = 0; i < this.getItemCount(); ++i) {
                            if (!((String)this.getItemAt(i)).equals(input)) continue;
                            matchFound = i;
                            break;
                        }
                        if (matchFound >= 0) {
                            this.setSelectedIndex(matchFound);
                            editor.setText((String)this.getItemAt(matchFound));
                            e.consume();
                        } else {
                            e.consume();
                        }
                    }
                }
            });
            editor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String input = editor.getText();
                    boolean matchFound = false;
                    for (int i = 0; i < this.getItemCount(); ++i) {
                        if (!((String)this.getItemAt(i)).equals(input)) continue;
                        matchFound = true;
                        break;
                    }
                    if (!matchFound && this.getItemCount() > 0) {
                        this.setSelectedIndex(0);
                        editor.setText((String)this.getItemAt(0));
                    }
                    editor.setForeground(Color.BLACK);
                }
            });
        }
    }

    public static class HeaderRenderer
    extends DefaultTableCellRenderer {
        DataTable table;

        public HeaderRenderer(DataTable table) {
            this.table = table;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int[] selectedColumns;
            boolean columnSelected;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color borderColor = Color.LIGHT_GRAY;
            if (this.table.darkEnabled) {
                borderColor = new Color(51, 51, 51);
            }
            if (columnSelected = Arrays.stream(selectedColumns = table.getSelectedColumns()).anyMatch(c -> c == column)) {
                if (this.table.columnHighlight) {
                    comp.setBackground(new Color(187, 255, 196));
                    comp.setForeground(Color.black);
                    borderColor = Color.decode("#00aa00");
                } else if (this.table.darkEnabled) {
                    comp.setBackground(new Color(92, 92, 92));
                    comp.setForeground(Color.white);
                } else {
                    comp.setBackground(new Color(202, 202, 202));
                    comp.setForeground(Color.black);
                }
            } else if (this.table.darkEnabled) {
                comp.setBackground(new Color(40, 40, 40));
                comp.setForeground(new Color(200, 200, 200));
            } else {
                comp.setBackground(new Color(200, 200, 200));
                comp.setForeground(new Color(51, 51, 51));
            }
            if (comp instanceof JComponent) {
                JComponent jComponent = (JComponent)comp;
                jComponent.setBorder(new LineBorder(borderColor, 1));
            }
            return comp;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.dispose();
            super.paintComponent(g);
        }
    }

    public static class CellRenderer
    extends DefaultTableCellRenderer {
        private DataTable table;

        public CellRenderer(DataTable table) {
            this.table = table;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean isLastRow;
            DataTable dt;
            DataColumn colMeta;
            Component comp;
            Color borderColor = Color.LIGHT_GRAY;
            if (this.table.darkEnabled) {
                borderColor = new Color(51, 51, 51);
            }
            if ((comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                ((JComponent)comp).setBorder(new MatteBorder(1, 1, 1, 1, borderColor));
            }
            if (!isSelected) {
                if (this.table.darkEnabled) {
                    comp.setBackground(row % 2 == 0 ? new Color(22, 22, 22) : new Color(0, 0, 0));
                    comp.setForeground(new Color(251, 251, 251));
                } else {
                    comp.setBackground(row % 2 == 0 ? Color.WHITE : new Color(245, 245, 245));
                    comp.setForeground(new Color(31, 31, 31));
                }
                if (this.table.userHighlightedRows.contains(row) || this.table.userHighlightedColumns.contains(column)) {
                    comp.setForeground(this.table.userHighlightedColor);
                    comp.setBackground(this.table.userHighlightedBackgroundColor);
                }
            }
            if (row == this.table.highlightedRow && column == this.table.highlightedColumn) {
                comp.setBackground(new Color(40, 75, 99));
                comp.setForeground(Color.WHITE);
            }
            int[] selectedRows = table.getSelectedRows();
            int[] selectedColumns = table.getSelectedColumns();
            boolean rowSelected = Arrays.stream(selectedRows).anyMatch(r -> r == row);
            boolean columnSelected = Arrays.stream(selectedColumns).anyMatch(c -> c == column);
            if (table instanceof DataTable && ((colMeta = (dt = (DataTable)table).getColumnData().get(column)).getFormattingRules() == null || !colMeta.getFormattingRules().isEmpty())) {
                for (FormatRule formatRule : colMeta.formatRules) {
                    String rule = formatRule.rule;
                    try {
                        if (value != null && (value instanceof Number || value.toString().matches("-?\\d+(\\.\\d+)?"))) {
                            double num = Double.parseDouble(value.toString());
                            if (!DataTable.evaluateCondition(num, rule)) continue;
                            comp.setForeground(formatRule.color);
                            comp.setBackground(formatRule.background);
                            continue;
                        }
                        assert (value != null);
                        if (!DataTable.evaluateCondition(value.toString(), rule)) continue;
                        comp.setForeground(formatRule.color);
                        comp.setBackground(formatRule.background);
                    }
                    catch (Exception exception) {}
                }
            }
            if (rowSelected && columnSelected) {
                comp.setBackground(new Color(97, 46, 110));
                comp.setForeground(Color.WHITE);
            } else if (rowSelected && this.table.rowHighlight) {
                borderColor = new Color(0, 170, 0);
                comp.setBackground(new Color(187, 255, 196));
                comp.setForeground(Color.BLACK);
            } else if (columnSelected && this.table.columnHighlight) {
                borderColor = new Color(0, 170, 0);
                comp.setBackground(new Color(187, 255, 196));
                comp.setForeground(Color.BLACK);
            }
            boolean isLastColumn = column == table.getColumnCount() - 1;
            boolean bl = isLastRow = row == table.getRowCount() - 1;
            if (comp instanceof JComponent) {
                JComponent jComponent = (JComponent)comp;
                jComponent.setBorder(new MatteBorder(1, 1, 1, 1, borderColor));
            }
            return comp;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.dispose();
            super.paintComponent(g);
        }
    }
}

