/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.HelperFunctions;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColumnSelectionDialog
extends JDialog {
    private final Map<Integer, JCheckBox> indexToCheckBox = new LinkedHashMap<Integer, JCheckBox>();
    private Map<Integer, String> selectedColumns = new LinkedHashMap<Integer, String>();
    private ArrayList<Integer> currentColumns;

    public ColumnSelectionDialog(String message, JFrame parent, JTable table, boolean allowMaps) {
        super(parent, "Select Columns", true);
        this.setup(message, parent, table, allowMaps);
    }

    public ColumnSelectionDialog(String message, JFrame parent, JTable table, ArrayList<Integer> selectedColumns, boolean allowMaps) {
        super(parent, "Select Columns to Include", true);
        this.currentColumns = selectedColumns;
        this.setup(message, parent, table, allowMaps);
    }

    private void setup(String message, JFrame parent, JTable table, boolean allowMaps) {
        this.setSize(400, 400);
        this.setLocationRelativeTo(parent);
        this.setLayout(new BorderLayout(10, 10));
        JLabel instruction = new JLabel(message);
        instruction.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.add((Component)instruction, "North");
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 1));
        for (int i = 0; i < table.getColumnCount(); ++i) {
            DefaultCellEditor defaultEditor;
            Component comp;
            TableCellEditor editor = table.getColumnModel().getColumn(i).getCellEditor();
            if (editor instanceof DefaultCellEditor && (comp = (defaultEditor = (DefaultCellEditor)editor).getComponent()) instanceof JComboBox && !allowMaps) continue;
            String colName = table.getColumnName(i);
            JCheckBox checkBox = new JCheckBox(colName, true);
            checkBox.setFont(new Font(HelperFunctions.getBestAvailableFont(true), 0, 14));
            checkBox.setSelected(this.currentColumns != null && this.currentColumns.contains(i));
            checkboxPanel.add(checkBox);
            this.indexToCheckBox.put(i, checkBox);
        }
        JScrollPane scrollPane = new JScrollPane(checkboxPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 15, 10));
        BalfButton okButton = new BalfButton("OK", -1);
        okButton.disableDarkMode();
        BalfButton cancelButton = new BalfButton("Cancel", -1);
        cancelButton.disableDarkMode();
        okButton.addActionListener(e -> {
            this.selectedColumns = new LinkedHashMap<Integer, String>();
            for (Map.Entry<Integer, JCheckBox> entry : this.indexToCheckBox.entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                this.selectedColumns.put(entry.getKey(), entry.getValue().getText());
            }
            this.dispose();
        });
        cancelButton.addActionListener(e -> {
            this.selectedColumns = null;
            this.dispose();
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
    }

    public Map<Integer, String> getSelectedColumns() {
        return this.selectedColumns;
    }
}

