/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import jamiebalfour.FileHelperFunctions;
import jamiebalfour.etraxion.reporting.DataTable;
import jamiebalfour.etraxion.reporting.MapDataEntry;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.ui.components.BalfScrollbar;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class ColumnInfoEditorDialog
extends JDialog {
    private final JDialog _frame;
    private final String columnName;
    private final JTextField columnNameField = new JTextField();
    private final JComboBox<String> columnTypeCombo = new JComboBox<String>(new String[]{"TEXT", "LIST", "MAP", "CALCULATED"});
    private final JPanel columnDataPanel = new JPanel(new CardLayout());
    int displayOrder;
    private final JPanel textPanel = new JPanel();
    private final JTextArea calculateTextField = new JTextArea();
    private final DefaultListModel<String> listModel = new DefaultListModel();
    private final JTable mapTable = new JTable(new DefaultTableModel(new Object[]{"Display Name", "Value"}, 0));

    public ColumnInfoEditorDialog(JFrame parent, DataTable dataTable, String columnName, int columnNumber, DataTable.DataColumn columnData) {
        super(parent, "Edit Column Info", true);
        this._frame = this;
        this.displayOrder = columnNumber + 1;
        this.columnName = columnName;
        this.columnNameField.setText(columnName);
        this.setLayout(new BorderLayout());
        JPanel formPanel = new JPanel(new GridBagLayout());
        formPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        formPanel.add((Component)new JLabel("Column Name:"), gbc);
        gbc.gridx = 1;
        formPanel.add((Component)this.columnNameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        formPanel.add((Component)new JLabel("Column Type:"), gbc);
        gbc.gridx = 1;
        formPanel.add(this.columnTypeCombo, gbc);
        this.columnTypeCombo.setEnabled(false);
        gbc.gridx = 0;
        ++gbc.gridy;
        formPanel.add((Component)new JLabel("Column Data:"), gbc);
        gbc.gridx = 1;
        formPanel.add((Component)this.columnDataPanel, gbc);
        this.add((Component)formPanel, "Center");
        this.textPanel.add(new JLabel("No extra configuration needed."));
        JList<String> listBox = new JList<String>(this.listModel);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)new JScrollPane(listBox), "Center");
        BalfButton addItemBtn = new BalfButton("Add Item", 30);
        addItemBtn.disableDarkMode();
        addItemBtn.addActionListener(e -> {
            String input = JOptionPane.showInputDialog(this, (Object)"Add new list item:");
            if (input != null && !input.trim().isEmpty()) {
                this.listModel.addElement(input.trim());
            }
        });
        listPanel.add((Component)addItemBtn, "South");
        JPanel mapPanel = new JPanel(new BorderLayout());
        JScrollPane mapScrollPane = new JScrollPane(this.mapTable);
        listPanel.add((Component)new JScrollPane(listBox), "Center");
        BalfButton addMapItemBtn = new BalfButton("Add Item", 15);
        addMapItemBtn.addActionListener(e -> {
            MapDataEntry mapD = new MapDataEntry(this._frame);
            JOptionPane op = new JOptionPane(mapD.getContentPane(), -1, -1, null, new String[]{"OK"});
            JDialog dlg = op.createDialog(this, "Enter map values");
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setVisible(true);
            String k = mapD.getKey();
            String v = mapD.getValue();
            if (!k.isEmpty() && !v.isEmpty()) {
                DefaultTableModel m = (DefaultTableModel)this.mapTable.getModel();
                int row = this.rowExists(k.trim());
                if (row == -1) {
                    m.addRow(new Object[]{k.trim(), v.trim()});
                } else {
                    this.mapTable.setValueAt(v, row, 1);
                }
            }
        });
        mapPanel.add((Component)mapScrollPane, "Center");
        BalfButton deleteMapItemBtn = new BalfButton("Delete Item(s)", 15);
        JPanel mapButtons = new JPanel();
        mapButtons.add(addMapItemBtn);
        mapButtons.add(deleteMapItemBtn);
        deleteMapItemBtn.addActionListener(e -> {
            DefaultTableModel m = (DefaultTableModel)this.mapTable.getModel();
            int[] rows = this.mapTable.getSelectedRows();
            Arrays.sort(rows);
            for (int i = rows.length - 1; i >= 0; --i) {
                m.removeRow(rows[i]);
            }
        });
        mapPanel.add((Component)mapButtons, "South");
        JPanel calculatedPanel = new JPanel(new BorderLayout());
        BalfScrollbar b = new BalfScrollbar(this.calculateTextField);
        calculatedPanel.add((Component)b, "Center");
        calculatedPanel.add((Component)this.calculateTextField, "Center");
        this.columnDataPanel.add((Component)this.textPanel, "TEXT");
        this.columnDataPanel.add((Component)listPanel, "LIST");
        this.columnDataPanel.add((Component)mapPanel, "MAP");
        this.columnDataPanel.add((Component)calculatedPanel, "CALCULATED");
        this.columnTypeCombo.addActionListener(e -> this.switchColumnDataPanel());
        this.switchColumnDataPanel();
        CardLayout cl = (CardLayout)this.columnDataPanel.getLayout();
        cl.show(this.columnDataPanel, columnData.getTypeAsString());
        if (columnData.getType() == DataTable.ColumnType.MAP) {
            this.columnTypeCombo.setSelectedIndex(2);
            ZPEType d = columnData.getJsonData();
            for (ZPEType i : (ZPEMap)d) {
                ZPEString key = (ZPEString)i;
                ZPEString value = (ZPEString)((ZPEMap)d).get(key);
                ((DefaultTableModel)this.mapTable.getModel()).addRow(new Object[]{key, value});
            }
        } else if (columnData.getType() == DataTable.ColumnType.LIST) {
            this.columnTypeCombo.setSelectedIndex(1);
        } else if (columnData.getType() == DataTable.ColumnType.CALCULATED) {
            this.columnTypeCombo.setSelectedIndex(3);
            this.calculateTextField.setText(columnData.getData());
        }
        JPanel buttonPanel = new JPanel();
        BalfButton saveButton = new BalfButton("Save", 30);
        saveButton.disableDarkMode();
        BalfButton cancelButton = new BalfButton("Cancel", 30);
        cancelButton.disableDarkMode();
        BalfButton importButton = new BalfButton("Import", 30);
        importButton.disableDarkMode();
        cancelButton.addActionListener(e -> this.dispose());
        saveButton.addActionListener(e -> {
            DataTable.DataColumn data = new DataTable.DataColumn(this.columnNameField.getText().toLowerCase().replace(" ", ""));
            data.setName(this.columnNameField.getText());
            data.setDisplayOrder(this.displayOrder);
            data.setTypeFromString(Objects.requireNonNull(this.columnTypeCombo.getSelectedItem()).toString());
            data.setFormattingRules(columnData.getFormattingRules());
            data.setData(this.saveData());
            dataTable.editColumnData(columnNumber, data);
            this.dispose();
        });
        importButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Open File");
            fileChooser.setFileFilter(new FileNameExtensionFilter("Text Files (*.txt)", "txt"));
            int result = fileChooser.showOpenDialog(null);
            if (result == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                try {
                    String fileString = FileHelperFunctions.readFileAsString(selectedFile.getAbsolutePath());
                    for (String line : fileString.split("\n")) {
                        if (columnData.getType() == DataTable.ColumnType.MAP) {
                            String[] values2 = line.split(":");
                            DefaultTableModel m = (DefaultTableModel)this.mapTable.getModel();
                            int row = this.rowExists(values2[0].trim());
                            if (row == -1) {
                                m.addRow(new Object[]{values2[0].trim(), values2[1].trim()});
                                continue;
                            }
                            this.mapTable.setValueAt(values2[1].trim(), row, 1);
                            continue;
                        }
                        this.listModel.addElement(line.trim());
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(importButton);
        importButton.setEnabled(false);
        if (columnData.getType() == DataTable.ColumnType.MAP || columnData.getType() == DataTable.ColumnType.LIST) {
            importButton.setEnabled(true);
        }
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void switchColumnDataPanel() {
        String selected = (String)this.columnTypeCombo.getSelectedItem();
        CardLayout cl = (CardLayout)this.columnDataPanel.getLayout();
        cl.show(this.columnDataPanel, selected);
    }

    public String saveData() {
        StringBuilder data = new StringBuilder();
        if (Objects.equals(this.columnTypeCombo.getSelectedItem(), "LIST")) {
            data.append("[");
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                String item = this.listModel.getElementAt(i);
                data.append("\"").append(item).append("\"").append(",");
                if (i + 1 >= this.mapTable.getRowCount()) continue;
                data.append(",");
            }
            data.append("]");
        } else if (Objects.equals(this.columnTypeCombo.getSelectedItem(), "MAP")) {
            data.append("{");
            for (int i = 0; i < this.mapTable.getRowCount(); ++i) {
                data.append("\"").append(this.mapTable.getValueAt(i, 0)).append("\"").append(" : ");
                data.append("\"").append(this.mapTable.getValueAt(i, 1)).append("\"");
                if (i + 1 >= this.mapTable.getRowCount()) continue;
                data.append(",");
            }
            data.append("}");
        } else if (Objects.equals(this.columnTypeCombo.getSelectedItem(), "CALCULATED")) {
            data.append(this.calculateTextField.getText());
        }
        return data.toString();
    }

    private int rowExists(String value) {
        for (int i = 0; i < this.mapTable.getRowCount(); ++i) {
            String v = this.mapTable.getValueAt(i, 0).toString();
            if (!v.equals(value)) continue;
            return i;
        }
        return -1;
    }
}

