/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion.reporting;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.DefaultCategoryDataset;

public class ColumnChartView
extends JFrame {
    public ColumnChartView(JTable table, int columnIndex, String chartTitle) {
        this.setTitle(chartTitle);
        this.setSize(600, 400);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        DefaultCategoryDataset dataset = this.buildDataset(table, columnIndex);
        JFreeChart chart = ChartFactory.createBarChart(chartTitle, "Category", "Count", dataset);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setBarPainter(new StandardBarPainter());
        renderer.setDrawBarOutline(false);
        Color[] colours = new Color[]{new Color(94, 14, 143), new Color(255, 128, 0), new Color(40, 75, 99), new Color(120, 120, 120), new Color(72, 213, 253)};
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            renderer.setSeriesPaint(i, colours[i % colours.length]);
        }
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(580, 370));
        this.setContentPane(chartPanel);
    }

    private DefaultCategoryDataset buildDataset(JTable table, int columnIndex) {
        HashMap<String, Integer> valueCounts = new HashMap<String, Integer>();
        for (int i = 0; i < table.getRowCount(); ++i) {
            Object value = table.getValueAt(i, columnIndex);
            if (value == null || value.toString().trim().isEmpty()) continue;
            valueCounts.put(value.toString(), valueCounts.getOrDefault(value.toString(), 0) + 1);
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Map.Entry entry : valueCounts.entrySet()) {
            dataset.addValue((Number)entry.getValue(), (Comparable)((Object)"Count"), (Comparable)entry.getKey());
        }
        return dataset;
    }

    public static void showChart(JTable table, int columnIndex, String title) {
        SwingUtilities.invokeLater(() -> {
            ColumnChartView frame = new ColumnChartView(table, columnIndex, title);
            frame.setVisible(true);
        });
    }
}

