/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion;

import jamiebalfour.HelperFunctions;
import jamiebalfour.etraxion.StartScreen;
import jamiebalfour.etraxion.eTraxionBuildInformation;
import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import jamiebalfour.parsers.json.ZenithJSONParser;
import jamiebalfour.ui.windows.BalfSplashScreen;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.editor.ZPEEditor;
import jamiebalfour.zpe.interfaces.ZPEType;
import jamiebalfour.zpe.types.ZPEMap;
import jamiebalfour.zpe.types.ZPENumber;
import jamiebalfour.zpe.types.ZPEString;
import java.awt.Color;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class eTraxion {
    public static final String VERSION_NUMBER_MAJOR = "1.1";
    public static final String VERSION_NUMBER_MINOR = "3";
    public static final String VERSION_NAME = "Cotton";
    public static final String VERSION_DATE = "July 2025";
    public static ImageIcon standardIcon = new ImageIcon(Objects.requireNonNull(eTraxion.class.getResource("/files/etraxion_mini_shadow.png")));
    public static ImageIcon macIcon = new ImageIcon(Objects.requireNonNull(eTraxion.class.getResource("/files/etraxion_logo_macos.png")));
    public static final String INSTALL_PATH = HelperFunctions.getAppDataDirectory("jamiebalfour/etraxion", System.getProperty("user.home") + "/jb/etraxion/").getAbsolutePath() + "/";
    static String UPDATE_PATH = "https://www.jamiebalfour.scot/projects/education/etraxion/version.php?verbose=true";
    private static String updateVersionNumber = "";
    private static String updateVersionNumberMajor = "";
    private static String updateVersionNumberMinor = "";
    private static String updateVersionNumberBuild = "";
    private static String updateVersionName = "";

    public static void main(String[] args2) {
        HashMap<String, String> argv;
        boolean r;
        File f = new File(INSTALL_PATH);
        if (!f.exists() && (r = f.mkdirs())) {
            System.out.println("Created " + INSTALL_PATH);
        }
        try {
            argv = HelperFunctions.generateArgumentMap(args2);
        }
        catch (HelperFunctions.NoArgumentValueProvided e) {
            throw new RuntimeException(e.getMessage());
        }
        if (args2.length > 0) {
            if (args2[0].equals("-r")) {
                System.out.println("Welcome to Jamie Balfour's eTraxion application.");
                SwingUtilities.invokeLater(() -> {
                    System.setProperty("com.apple.mrj.application.apple.menu.about.name", "eTraxion Tracking & Reporting");
                    int rounding = 20;
                    if (!HelperFunctions.isMac()) {
                        rounding = 20;
                    }
                    ReportBuilderMain app = new ReportBuilderMain(rounding);
                    app.setVisible(true);
                });
            } else if (args2[0].equals("-z")) {
                SwingUtilities.invokeLater(ZPEEditor::StartEditor);
            } else if (args2[0].equals("--version")) {
                if (argv.containsKey("--json")) {
                    ZenithJSONParser parser = new ZenithJSONParser();
                    ZPEMap props = new ZPEMap();
                    props.put(new ZPEString("name"), new ZPEString(eTraxion.getVersionName()));
                    props.put(new ZPEString("version"), new ZPEString(eTraxion.getVersionNumber()));
                    props.put(new ZPEString("date"), new ZPEString(VERSION_DATE));
                    props.put(new ZPEString("major_version"), new ZPEString(VERSION_NUMBER_MAJOR));
                    props.put(new ZPEString("minor_version"), new ZPEString(VERSION_NUMBER_MINOR));
                    props.put(new ZPEString("build"), new ZPENumber(eTraxion.getBuildVersion()));
                    props.put(new ZPEString("build_date"), new ZPEString(eTraxion.getBuildDate()));
                    props.put(new ZPEString("build_time"), new ZPEString(eTraxion.getBuildTime()));
                    System.out.println(parser.jsonEncode(props));
                    System.exit(0);
                } else {
                    System.out.print("eTraxion version " + ZPEHelperFunctions.setConsoleEffectToCyan(eTraxion.getVersionNumber()) + " \"" + ZPEHelperFunctions.setConsoleEffectToItalic(eTraxion.getVersionName()) + "\" " + eTraxion.getVersionDate() + " [" + eTraxion.getBuildDate() + " @ " + eTraxion.getBuildTime() + "]");
                    if (argv.containsKey("--verbose")) {
                        HelperFunctions.printBlankLines(2);
                        System.out.println("Package version major                  : 1.1");
                        System.out.println("Package version minor                  : 3");
                        System.out.println("Package build version                  : " + ZPECore.getBuildVersion());
                        System.out.println("Package build date/time                : " + eTraxion.getBuildDate() + " @ " + eTraxion.getBuildTime());
                        System.out.println("Runtime version name                   : Cotton");
                        System.out.println("Runtime date                           : July 2025");
                        System.out.println("Zenith Parsing Engine version          : 1.5");
                    }
                    System.exit(0);
                }
            }
        } else {
            ImageIcon logo;
            if (HelperFunctions.isMac()) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "eTraxion");
                logo = macIcon;
            } else {
                logo = standardIcon;
            }
            new BalfSplashScreen("eTraxion", "eTraxion", "Copyright Jamie Balfour 2025", "Loading eTraxion", new ImageIcon(Objects.requireNonNull(eTraxion.class.getResource("/files/etraxion_logo_white.png"))), new Color(40, 75, 99), logo).showFor(1000);
            SwingUtilities.invokeLater(() -> {
                StartScreen app = new StartScreen();
                app.setTitle("eTraxion");
                app.setVisible(true);
            });
        }
    }

    public static String getVersionNumber() {
        return "1.1.3." + eTraxion.getBuildVersion();
    }

    public static int getBuildVersion() {
        return HelperFunctions.stringToInteger(eTraxionBuildInformation.build);
    }

    public static String getBuildDate() {
        return eTraxionBuildInformation.date;
    }

    public static String getBuildTime() {
        return eTraxionBuildInformation.time;
    }

    public static String getVersionName() {
        return VERSION_NAME;
    }

    public static String getVersionDate() {
        return VERSION_DATE;
    }

    public static void setToolbar() {
        try {
            if (Taskbar.isTaskbarSupported()) {
                Toolkit.getDefaultToolkit();
                Taskbar taskbar = Taskbar.getTaskbar();
                if (HelperFunctions.isMac()) {
                    Image image = macIcon.getImage();
                    taskbar.setIconImage(image);
                } else {
                    Image image = standardIcon.getImage();
                    taskbar.setIconImage(image);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkForUpdate() {
        try {
            ZPEType out = ZPEHelperFunctions.urlToJson(UPDATE_PATH);
            if (out instanceof ZPEMap) {
                if (((ZPEMap)out).containsKey(new ZPEString("number"))) {
                    ZPEMap results = (ZPEMap)out;
                    updateVersionNumber = results.get(new ZPEString("number")).toString();
                    updateVersionNumberMajor = results.get(new ZPEString("major_version")).toString();
                    updateVersionNumberMinor = results.get(new ZPEString("minor_version")).toString();
                    updateVersionNumberBuild = results.get(new ZPEString("build_version")).toString();
                    updateVersionName = results.get(new ZPEString("name")).toString();
                }
            } else {
                return false;
            }
            double newMajorVersion = HelperFunctions.stringToDouble(updateVersionNumberMajor);
            int newMinorVersion = HelperFunctions.stringToInteger(updateVersionNumberMinor);
            int newBuildVersion = HelperFunctions.stringToInteger(updateVersionNumberBuild);
            double currentMajorVersion = HelperFunctions.stringToDouble("1.13");
            int currentMinorVersion = HelperFunctions.stringToInteger("9");
            int currentBuildVersion = ZPECore.getBuildVersion();
            if (newMajorVersion > currentMajorVersion || newMajorVersion == currentMajorVersion && newMinorVersion > currentMinorVersion || newMajorVersion == currentMajorVersion && newMinorVersion == currentMinorVersion && newBuildVersion > currentBuildVersion) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

