/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion;

import jamiebalfour.HelperFunctions;
import jamiebalfour.etraxion.eTraxion;
import jamiebalfour.etraxion.reporting.ReportBuilderMain;
import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UIUtils;
import jamiebalfour.ui.components.BalfButton;
import jamiebalfour.ui.components.BalfFooter;
import jamiebalfour.ui.components.BalfHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Taskbar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StartScreen
extends JFrame {
    public StartScreen() {
        this.setUndecorated(true);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setSize(500, 360);
        this.setLocationRelativeTo(null);
        JPanel rootPanel = UIUtils.roundFrame(this, 30, new Color(240, 240, 240));
        rootPanel.setLayout(new BorderLayout(10, 0));
        this.setContentPane(rootPanel);
        if (!HelperFunctions.isMac()) {
            this.setIconImage(eTraxion.macIcon.getImage());
        } else {
            this.setIconImage(eTraxion.standardIcon.getImage());
        }
        try {
            if (Taskbar.isTaskbarSupported()) {
                Taskbar taskbar = Taskbar.getTaskbar();
                if (HelperFunctions.isMac()) {
                    taskbar.setIconImage(eTraxion.macIcon.getImage());
                } else {
                    taskbar.setIconImage(eTraxion.standardIcon.getImage());
                }
            }
        }
        catch (Exception taskbar) {
            // empty catch block
        }
        BalfHeader topPanel = new BalfHeader(Color.white, 20);
        ImageIcon logoIcon = new ImageIcon(this.getClass().getResource("/files/etraxion_logo.png"));
        Image scaledImage = logoIcon.getImage().getScaledInstance(64, 64, 4);
        JLabel logoLabel = new JLabel(new ImageIcon(scaledImage));
        logoLabel.setHorizontalAlignment(0);
        topPanel.add((Component)logoLabel, "North");
        JLabel title = new JLabel("eTraxion \u2013 Tracking & Reporting", 0);
        title.setFont(BalfLafManager.getBalfLafFont().deriveFont(0, 25.0f));
        title.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        topPanel.add((Component)title, "South");
        rootPanel.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new GridLayout(1, 2, 20, 0));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(20, 40, 20, 40));
        BalfButton reportButton = new BalfButton("<html><center>Use Report Writer</center></html>", 9);
        reportButton.setFont(new Font(reportButton.getFont().getName(), 0, 16));
        reportButton.addActionListener(e -> {
            try {
                int rounding = 20;
                if (!HelperFunctions.isMac()) {
                    rounding = 20;
                }
                ReportBuilderMain m = new ReportBuilderMain(rounding);
                m.setVisible(true);
                this.dispose();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + ". Read the error_log.txt file to see the stack trace.");
            }
        });
        reportButton.setBackground(Color.WHITE);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(30, 20, 30, 20));
        bottomPanel.setOpaque(true);
        BalfButton exitButton = new BalfButton("Exit", -1);
        exitButton.setFont(new Font("Segoe UI", 0, 14));
        exitButton.setFocusPainted(false);
        exitButton.setBackground(new Color(200, 60, 60));
        exitButton.setForeground(Color.BLACK);
        exitButton.setCursor(Cursor.getPredefinedCursor(12));
        exitButton.setPreferredSize(new Dimension(100, 30));
        exitButton.addActionListener(e -> System.exit(0));
        JPanel exitWrapper = new JPanel();
        exitWrapper.setOpaque(false);
        exitWrapper.add(exitButton);
        bottomPanel.add((Component)reportButton, "Center");
        bottomPanel.add((Component)exitWrapper, "South");
        bottomPanel.setBackground(new Color(240, 240, 240, 255));
        BalfFooter footerLabel = new BalfFooter("<html>&copy; J Balfour 2025 version 1.1.3 (<em>Cotton</em>) build " + eTraxion.getBuildVersion() + "</html>", new Color(240, 240, 240, 255), Color.black, 20, this);
        this.add((Component)bottomPanel, "Center");
        this.add((Component)footerLabel, "South");
    }
}

