/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.etraxion;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class FileWatcherThread
extends Thread {
    private final Path pathToWatch;
    private final String targetFileName;

    public FileWatcherThread(Path pathToWatch, String targetFileName) {
        this.pathToWatch = pathToWatch;
        this.targetFileName = targetFileName;
    }

    @Override
    public void run() {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            this.pathToWatch.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            while (!Thread.currentThread().isInterrupted()) {
                WatchKey key = watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    Path fileName = (Path)event.context();
                    if (!fileName.toString().equals(this.targetFileName)) continue;
                    System.out.println("Detected " + kind.name() + " on " + String.valueOf(fileName));
                }
                boolean valid = key.reset();
                if (valid) continue;
                break;
            }
            watchService.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

