/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.windows;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UITheme;
import jamiebalfour.ui.UIUtils;
import jamiebalfour.ui.components.BalfFooter;
import jamiebalfour.ui.components.BalfMenuBar;
import jamiebalfour.ui.components.BalfPanel;
import jamiebalfour.ui.components.BalfTitleBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class BalfWindow
extends JFrame {
    private BalfPanel mainPanel = null;
    private BalfTitleBar titleBar = null;
    private BalfFooter footer = null;
    private int rounding = 0;
    private BalfMenuBar menu;
    private Color backgroundColour;
    private Color foregroundColour;
    private final Color orgBackgroundColour;
    private final Color orgForegroundColour;
    private final boolean packagedMode;
    JPanel top;
    JPanel owner;
    String title;
    private Shape cachedShadowShapeMaximised = null;
    private Shape cachedShadowShapeNormal = null;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    boolean isFullScreen = false;
    boolean debug = true;
    ImageIcon icon = null;
    JPanel wrapperPanel;

    public BalfWindow(String title, int rounding, Color backgroundColour, Color foregroundColour, ImageIcon icon) {
        if (UIUtils.isOpenGLPipelineAvailable()) {
            System.setProperty("sun.java2d.opengl", "true");
        }
        this.packagedMode = false;
        this.backgroundColour = backgroundColour;
        this.foregroundColour = foregroundColour;
        this.orgBackgroundColour = backgroundColour;
        this.orgForegroundColour = foregroundColour;
        this.rounding = rounding;
        this.title = title;
        this.icon = icon;
    }

    public void disableMinimise(boolean disable) {
        if (this.titleBar != null) {
            this.titleBar.disableMinimise(disable);
        }
    }

    public void disableMaximise(boolean disable) {
        if (this.titleBar != null) {
            this.titleBar.disableMaximise(disable);
        }
    }

    public void maximiseAction() {
        if (this.owner != null) {
            this.owner.invalidate();
        }
    }

    public void initialise() {
        BalfLafManager.getInstance().addThemeChangeListener(() -> {
            if (BalfLafManager.getInstance().getTheme() == null) {
                this.backgroundColour = this.orgBackgroundColour;
                this.foregroundColour = this.orgForegroundColour;
                if (!BalfLafManager.getInstance().isDarkModeEnabled() && this.wrapperPanel != null) {
                    this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, this.backgroundColour));
                }
            } else {
                this.backgroundColour = BalfLafManager.getInstance().getTheme().getBackground();
                this.foregroundColour = BalfLafManager.getInstance().getTheme().getForeground();
                if (!BalfLafManager.getInstance().isDarkModeEnabled() && this.wrapperPanel != null) {
                    this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, this.backgroundColour));
                }
            }
        });
        if (BalfLafManager.getInstance().getTheme() != null) {
            this.backgroundColour = BalfLafManager.getInstance().getTheme().getBackground();
        }
        this.owner = UIUtils.roundFrame(this, this.rounding, this.backgroundColour);
        this.owner.setOpaque(false);
        this.owner.setDoubleBuffered(true);
        this.owner.paint(this.owner.getGraphics());
        this.titleBar = new BalfTitleBar(this, this.rounding, this.backgroundColour, this.foregroundColour);
        this.setTitle(this.title);
        this.top = new JPanel(new BorderLayout());
        this.top.add((Component)this.titleBar, "North");
        this.top.setOpaque(false);
        this.top.setBackground(new Color(0, 0, 0, 0));
        BalfPanel programMain = new BalfPanel();
        programMain.setLayout(new BorderLayout());
        this.mainPanel = new BalfPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.owner.setLayout(new BorderLayout());
        super.add((Component)this.owner, "Center");
        programMain.add((Component)this.mainPanel, "Center");
        this.owner.add((Component)this.top, "North");
        this.footer = new BalfFooter("", this.backgroundColour, this.foregroundColour, this.rounding, this);
        this.owner.add((Component)this.footer, "South");
        this.wrapperPanel = new JPanel();
        MatteBorder sideBorder = BorderFactory.createMatteBorder(0, 2, 0, 2, this.backgroundColour);
        this.wrapperPanel.setBorder(sideBorder);
        BalfLafManager.getInstance().addDarkModeListener(e -> {
            if (e) {
                this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, BalfLafManager.getInstance().getDarkColorBackground()));
            } else if (BalfLafManager.getInstance().getTheme() != null) {
                this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, BalfLafManager.getInstance().getTheme().getBackground()));
            } else {
                this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, this.backgroundColour));
            }
        });
        this.wrapperPanel.setLayout(new BorderLayout());
        this.wrapperPanel.add((Component)programMain, "Center");
        this.owner.add((Component)this.wrapperPanel, "Center");
        super.setPreferredSize(new Dimension(800, 600));
        super.setLocation(new Point(100, 100));
        ResizableWindowSupport r = new ResizableWindowSupport();
        r.enableResizing(this, this.owner);
        BalfLafManager.getInstance().addDarkModeListener(e -> {
            if (e) {
                if (this.rounding == 0) {
                    this.owner.setBorder(new LineBorder(new Color(85, 85, 85), 1));
                }
            } else if (this.rounding == 0) {
                this.owner.setBorder(new LineBorder(new Color(130, 130, 130), 1));
            }
        });
        this.pack();
    }

    public void setPanelBackground(Color c) {
        if (this.mainPanel != null) {
            this.mainPanel.setBackground(c);
        }
    }

    public void setTheme(UITheme theme) {
        if (theme == null) {
            return;
        }
        BalfLafManager.getInstance().setTheme(theme);
        if (!BalfLafManager.getInstance().isDarkModeEnabled()) {
            this.wrapperPanel.setBorder(BorderFactory.createMatteBorder(0, 2, 0, 2, theme.getBackground()));
        }
        if (this.owner != null) {
            this.owner.setBackground(theme.getBackground());
        }
        if (theme.getFont() != null) {
            this.setFont(theme.getFont());
        }
        this.repaint();
    }

    public UITheme openThemeUsingDialog() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter bltFilter = new FileNameExtensionFilter("Balfour Theme Files (*.blt)", "blt");
        chooser.setFileFilter(bltFilter);
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                UITheme theme = UITheme.loadFromFile(file.getAbsolutePath());
                this.setTheme(theme);
                return theme;
            }
            catch (Exception ex) {
                this.setTheme(null);
                return null;
            }
        }
        this.setTheme(null);
        return null;
    }

    public void dockTop() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int y = bounds.y + screenInsets.top;
        int width = bounds.width - screenInsets.left - screenInsets.right;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height / 2);
        this.setState(0);
    }

    public void dockLeft() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int y = bounds.y + screenInsets.top;
        int width = (bounds.width - screenInsets.left - screenInsets.right) / 2;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height);
        this.setState(0);
    }

    public void dockRight() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int y = bounds.y + screenInsets.top;
        int width = (bounds.width - screenInsets.left - screenInsets.right) / 2;
        int x = bounds.x + screenInsets.left + width;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        this.setBounds(x, y, width, height);
        this.setState(0);
    }

    public void dockBottom() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = bounds.x + screenInsets.left;
        int height = bounds.height - screenInsets.top - screenInsets.bottom;
        int y = bounds.y + screenInsets.top + height / 2;
        int width = bounds.width - screenInsets.left - screenInsets.right;
        this.setBounds(x, y, width, height / 2);
        this.setState(0);
    }

    public void readStandardProperties(Properties mainProperties) {
        if (mainProperties == null) {
            return;
        }
        if (mainProperties.containsKey("HEIGHT")) {
            this.setSize(this.getWidth(), this.stringToInteger(mainProperties.get("HEIGHT").toString()));
        }
        if (mainProperties.containsKey("WIDTH")) {
            this.setSize(this.stringToInteger(mainProperties.get("WIDTH").toString()), this.getHeight());
        }
        if (mainProperties.containsKey("XPOS")) {
            this.setLocation(new Point(this.stringToInteger(mainProperties.get("XPOS").toString()), this.getY()));
        }
        if (mainProperties.containsKey("YPOS")) {
            this.setLocation(new Point(this.getX(), this.stringToInteger(mainProperties.get("YPOS").toString())));
        }
        if (this.titleBar != null) {
            this.titleBar.cachedSize = new Dimension(this.getWidth(), this.getHeight());
            this.titleBar.cachedLocation = new Point(this.getX(), this.getY());
        }
        if (mainProperties.containsKey("MAXIMISED") && mainProperties.get("MAXIMISED").toString().equals("true")) {
            if (this.titleBar != null) {
                this.titleBar.activateMaximise();
            } else if (this.getExtendedState() != 6) {
                this.setExtendedState(6);
            } else {
                this.setExtendedState(0);
            }
        }
    }

    static double stringToDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if (s.equals("true")) {
            return 1.0;
        }
        if (!BalfWindow.isNumeric(s)) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    static boolean isNumeric(Object s) {
        if (s == null) {
            return false;
        }
        return s.toString().matches("(-)?[0-9]+(\\.[0-9]+)?(E(-?)[0-9]+)?");
    }

    int stringToInteger(String s) {
        return (int)Math.floor(BalfWindow.stringToDouble(s));
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.mainPanel != null) {
            this.mainPanel.setLayout(manager);
        } else {
            super.setLayout(new BorderLayout());
        }
    }

    @Override
    public Component add(Component comp) {
        this.mainPanel.add(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object layout) {
        if (this.mainPanel != null) {
            this.mainPanel.add(comp, layout);
        } else {
            super.add(comp, layout);
        }
    }

    public void setTitleBarText(String title) {
        if (this.titleBar == null) {
            return;
        }
        this.titleBar.setLabelText(title);
    }

    public BalfMenuBar getMenu() {
        return this.menu;
    }

    public void setMenu(BalfMenuBar menu) {
        this.menu = menu;
        if (this.top != null) {
            this.top.add((Component)menu, "South");
            this.titleBar.attachMenu(menu);
        } else {
            super.setJMenuBar(menu);
        }
    }

    @Override
    public void setJMenuBar(JMenuBar menu) {
        super.setJMenuBar(menu);
        if (this.top != null) {
            this.top.add((Component)menu, "South");
        } else {
            this.add((Component)menu, "North");
        }
    }

    public Dimension getNormalFrameSize() {
        if (this.titleBar != null) {
            return this.titleBar.getFrameSize();
        }
        return this.getSize();
    }

    public Point getNormalFrameLocation() {
        if (this.titleBar != null) {
            return this.titleBar.getFrameLocation();
        }
        return this.getLocation();
    }

    public BalfFooter getFooter() {
        return this.footer;
    }

    public BalfTitleBar getTitleBar() {
        return this.titleBar;
    }

    public void useMacMenuBar() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public boolean isMaximised() {
        if (this.titleBar != null) {
            return this.titleBar.isMaximised;
        }
        return this.getExtendedState() == 6;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setRounding(int rounding) {
        this.rounding = rounding;
        if (this.titleBar != null) {
            this.titleBar.setRounding(rounding);
        }
        if (this.footer != null) {
            this.footer.setRounding(rounding);
        }
    }

    public boolean goFullScreen() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.isUndecorated()) {
            this.setUndecorated(true);
        }
        if (gd.isFullScreenSupported()) {
            if (!this.isFullScreen) {
                this.isFullScreen = true;
                gd.setFullScreenWindow(this);
            } else {
                this.isFullScreen = false;
                gd.setFullScreenWindow(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFocus() {
        return this.titleBar != null && this.titleBar.windowHasFocus();
    }

    static class ResizableWindowSupport {
        private Timer resizeEndTimer;
        private static final int BORDER_DRAG = 8;
        private boolean dragging = false;
        private Point initialClick;
        private JWindow shadow;
        private Cursor activeResizeCursor;

        ResizableWindowSupport() {
        }

        private void updateCursor(JFrame frame, Point px) {
            boolean nearBottom;
            int width = frame.getWidth();
            int height = frame.getHeight();
            int x = px.x;
            int y = px.y;
            int cursor = 0;
            boolean nearLeft = x <= 8;
            boolean nearRight = x >= width - 8;
            boolean nearTop = y <= 8;
            boolean bl = nearBottom = y >= height - 8;
            if (nearLeft && nearTop) {
                cursor = 6;
            } else if (nearRight && nearTop) {
                cursor = 7;
            } else if (nearLeft && nearBottom) {
                cursor = 4;
            } else if (nearRight && nearBottom) {
                cursor = 5;
            } else if (nearLeft) {
                cursor = 10;
            } else if (nearRight) {
                cursor = 11;
            } else if (nearTop) {
                cursor = 8;
            } else if (nearBottom) {
                cursor = 9;
            }
            this.activeResizeCursor = Cursor.getPredefinedCursor(cursor);
            frame.setCursor(this.activeResizeCursor);
        }

        public void enableResizing(final JFrame frame, JPanel content) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (activeResizeCursor == null || activeResizeCursor.getType() == 0) {
                        return;
                    }
                    initialClick = e.getPoint();
                    dragging = true;
                    shadow = new JWindow();
                    shadow.setBounds(frame.getBounds());
                    shadow.setBackground(new Color(0, 0, 0, 64));
                    shadow.setAlwaysOnTop(true);
                    shadow.setVisible(true);
                    resizeEndTimer = new Timer(2000, ex -> {
                        if (shadow != null && shadow.isVisible()) {
                            frame.setBounds(shadow.getBounds());
                            shadow.dispose();
                            shadow = null;
                            dragging = false;
                            frame.setCursor(Cursor.getDefaultCursor());
                        }
                    });
                    resizeEndTimer.setRepeats(false);
                    this.enableShadowDragging(shadow);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!dragging || shadow == null) {
                        return;
                    }
                    frame.setBounds(shadow.getBounds());
                    shadow.dispose();
                    shadow = null;
                    dragging = false;
                    frame.setCursor(Cursor.getDefaultCursor());
                    if (resizeEndTimer != null) {
                        resizeEndTimer.stop();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!dragging) {
                        frame.setCursor(Cursor.getDefaultCursor());
                        activeResizeCursor = null;
                    }
                }
            };
            MouseMotionAdapter motionAdapter = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateCursor(frame, e.getPoint());
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!dragging || initialClick == null || shadow == null) {
                        return;
                    }
                    resizeEndTimer.restart();
                    int dx = e.getX() - initialClick.x;
                    int dy = e.getY() - initialClick.y;
                    Rectangle bounds = shadow.getBounds();
                    int cursorType = activeResizeCursor.getType();
                    switch (cursorType) {
                        case 8: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            break;
                        }
                        case 7: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            bounds.width += dx;
                            break;
                        }
                        case 6: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            bounds.x += dx;
                            bounds.width -= dx;
                            break;
                        }
                        case 9: {
                            bounds.height += dy;
                            break;
                        }
                        case 11: {
                            bounds.width += dx;
                            break;
                        }
                        case 10: {
                            bounds.x += dx;
                            bounds.width -= dx;
                            break;
                        }
                        case 4: {
                            bounds.x += dx;
                            bounds.width -= dx;
                            bounds.height += dy;
                            break;
                        }
                        case 5: {
                            bounds.width += dx;
                            bounds.height += dy;
                            break;
                        }
                    }
                    shadow.setBounds(bounds);
                    initialClick = e.getPoint();
                }
            };
            content.addMouseListener(mouseAdapter);
            content.addMouseMotionListener(motionAdapter);
        }

        private void enableShadowDragging(JWindow shadowWindow) {
            shadowWindow.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    initialClick = e.getPoint();
                }
            });
            shadowWindow.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!dragging || initialClick == null || shadow == null) {
                        return;
                    }
                    int dx = e.getX() - initialClick.x;
                    int dy = e.getY() - initialClick.y;
                    Rectangle bounds = shadow.getBounds();
                    int cursorType = activeResizeCursor.getType();
                    switch (cursorType) {
                        case 8: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            break;
                        }
                        case 7: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            bounds.width += dx;
                            break;
                        }
                        case 6: {
                            bounds.y += dy;
                            bounds.height -= dy;
                            bounds.x += dx;
                            bounds.width -= dx;
                            break;
                        }
                        case 9: {
                            bounds.height += dy;
                            break;
                        }
                        case 11: {
                            bounds.width += dx;
                            break;
                        }
                        case 10: {
                            bounds.x += dx;
                            bounds.width -= dx;
                            break;
                        }
                        case 4: {
                            bounds.x += dx;
                            bounds.width -= dx;
                            bounds.height += dy;
                            break;
                        }
                        case 5: {
                            bounds.width += dx;
                            bounds.height += dy;
                            break;
                        }
                    }
                    shadow.setBounds(bounds);
                    resizeEndTimer.restart();
                    initialClick = e.getPoint();
                }
            });
        }
    }
}

