/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.windows;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Taskbar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class BalfSplashScreen
extends JWindow {
    String loadingText;
    final JLabel loading;

    public BalfSplashScreen(String appName, String name, String copyright, String loadingMessage, ImageIcon logo, Color backgroundColour, ImageIcon appIcon) {
        System.setProperty("apple.awt.application.name", appName);
        System.setProperty("apple.awt.application.appearance", "system");
        if (appIcon != null) {
            this.setIconImage(appIcon.getImage());
            try {
                if (Taskbar.isTaskbarSupported()) {
                    Taskbar taskbar = Taskbar.getTaskbar();
                    taskbar.setIconImage(appIcon.getImage());
                }
            }
            catch (Exception taskbar) {
                // empty catch block
            }
        }
        JPanel container = UIUtils.roundFrame(this, 30, backgroundColour);
        JPanel content = new JPanel();
        content.setOpaque(false);
        content.setLayout(new BorderLayout(10, 10));
        this.add(container);
        this.loadingText = loadingMessage;
        JLabel logoLabel = null;
        if (logo != null) {
            Image scaledImage = logo.getImage().getScaledInstance(64, 64, 4);
            logoLabel = new JLabel(new ImageIcon(scaledImage), 0);
            logoLabel.setHorizontalAlignment(0);
        }
        JLabel title = new JLabel(name, 0);
        title.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        title.setForeground(Color.WHITE);
        title.setBorder(new EmptyBorder(8, 0, 8, 0));
        this.loading = new JLabel(loadingMessage, 0);
        this.loading.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        this.loading.setForeground(Color.LIGHT_GRAY);
        content.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        if (logo != null) {
            content.add((Component)logoLabel, "North");
        }
        JPanel mainContent = new JPanel(new BorderLayout());
        JLabel copyrightLbl = new JLabel(copyright, 0);
        copyrightLbl.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 14.0f));
        copyrightLbl.setForeground(Color.WHITE);
        copyrightLbl.setBorder(new EmptyBorder(0, 0, 20, 0));
        mainContent.add((Component)title, "North");
        mainContent.add((Component)copyrightLbl, "Center");
        mainContent.setOpaque(false);
        content.add((Component)mainContent, "Center");
        content.add((Component)this.loading, "South");
        container.add((Component)content, "Center");
        this.setContentPane(container);
        this.setSize(350, 220);
        this.setLocationRelativeTo(null);
        Timer timer = new Timer(600, e -> {
            if (this.loading.getText().endsWith("...")) {
                this.loading.setText(this.loadingText);
            } else if (this.loading.getText().endsWith("..")) {
                this.loading.setText(this.loadingText + "...");
            } else if (this.loading.getText().endsWith(".")) {
                this.loading.setText(this.loadingText + "..");
            } else {
                this.loading.setText(this.loadingText + ".");
            }
        });
        timer.start();
    }

    public void showFor(int milliseconds) {
        this.setVisible(true);
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
        this.dispose();
    }
}

