/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.dialogs;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.components.BalfButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class BalfAboutDialog
extends JFrame {
    Color background;
    private static final long serialVersionUID = -5246323084901677773L;

    public BalfAboutDialog(String aboutWhat, String msg, JButton button) {
        this.setDefaultCloseOperation(2);
        this.setTitle("About " + aboutWhat);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout(0, 0));
        JPanel top = new JPanel();
        JLabel lblTitle = new JLabel(aboutWhat);
        top.add(lblTitle);
        outerPanel.add((Component)top, "North");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        outerPanel.add((Component)scrollPane, "Center");
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setMaximumSize(new Dimension(300, 9999));
        JTextArea lblMainInformation = new JTextArea("");
        lblMainInformation.setAlignmentX(0.0f);
        scrollPane.setViewportView(lblMainInformation);
        lblMainInformation.setEditable(false);
        lblMainInformation.setBackground(this.getContentPane().getBackground());
        lblTitle.setFont(BalfLafManager.getBalfLafFont().deriveFont(1, 18.0f));
        lblMainInformation.setFont(BalfLafManager.getBalfLafFont().deriveFont(14));
        if (!((String)msg).endsWith("\n")) {
            msg = (String)msg + "\n";
        }
        msg = (String)msg + "\nUI built with BalfLaf version 1.0\nCopyright Jamie B Balfour 2025";
        String version = System.getProperty("java.version");
        if (!version.isEmpty()) {
            msg = (String)msg + "\n\nJava version: " + version + (String)(System.getenv("TERM") != null ? " [" + System.getenv("TERM") + "]" : "");
        }
        lblMainInformation.setText((String)msg);
        JPanel panel = new JPanel();
        outerPanel.add((Component)panel, "South");
        if (button != null) {
            panel.add(button);
            if (button instanceof BalfButton) {
                ((BalfButton)button).useJBStyle(true);
                ((BalfButton)button).disableDarkMode();
                ((BalfButton)button).setRounded(30);
            }
            button.addActionListener(e -> this.close(button));
        }
        final BalfButton btnDoneButton = new BalfButton("Done", 30);
        btnDoneButton.disableDarkMode();
        btnDoneButton.useJBStyle(true);
        btnDoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BalfAboutDialog.this.close(btnDoneButton);
            }
        });
        panel.add(btnDoneButton);
        outerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setContentPane(outerPanel);
        this.pack();
    }

    private void close(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null) {
            w.setVisible(false);
        }
    }
}

