/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBox;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class BalfToggleButton
extends JCheckBox {
    private static final int WIDTH = 50;
    private static final int HEIGHT = 28;
    private static final Color TRACK_OFF = new Color(204, 204, 204);
    private static final Color TRACK_ON = new Color(126, 63, 242);
    private static final int ANIM_DELAY = 10;
    private static final int ANIM_DURATION = 200;
    private float animPos;
    private final float animStep;
    private Timer animator = null;

    public BalfToggleButton() {
        this.setUI(new BasicCheckBoxUI());
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setOpaque(false);
        this.setModel(new DefaultButtonModel());
        this.animPos = this.isSelected() ? 1.0f : 0.0f;
        int frames = 20;
        this.animStep = 1.0f / (float)frames;
        this.animator = new Timer(10, e -> {
            boolean targetOn = this.isSelected();
            if (targetOn && this.animPos < 1.0f) {
                this.animPos = Math.min(1.0f, this.animPos + this.animStep);
            } else if (!targetOn && this.animPos > 0.0f) {
                this.animPos = Math.max(0.0f, this.animPos - this.animStep);
            } else {
                this.animator.stop();
            }
            this.repaint();
        });
        this.addActionListener(e -> this.animator.start());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BalfToggleButton.this.doClick();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(50, 28);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = (int)((float)TRACK_OFF.getRed() + this.animPos * (float)(TRACK_ON.getRed() - TRACK_OFF.getRed()));
        int gr = (int)((float)TRACK_OFF.getGreen() + this.animPos * (float)(TRACK_ON.getGreen() - TRACK_OFF.getGreen()));
        int b = (int)((float)TRACK_OFF.getBlue() + this.animPos * (float)(TRACK_ON.getBlue() - TRACK_OFF.getBlue()));
        g2.setColor(new Color(r, gr, b));
        g2.fillRoundRect(0, 0, w, h, h, h);
        int margin = 2;
        int dia = h - margin * 2;
        float maxOffset = w - dia - margin * 2;
        float x = (float)margin + this.animPos * maxOffset;
        g2.setColor(Color.WHITE);
        g2.fillOval(Math.round(x), margin, dia, dia);
        g2.setColor(new Color(0, 0, 0, 30));
        g2.fillOval(Math.round(x), margin + dia - 2, dia, 4);
        g2.dispose();
    }
}

