/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import jamiebalfour.ui.components.BalfMenuBar;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class BalfContextMenu
extends JPopupMenu {
    Color mainBackground;
    Color mainForeground;
    Color paneColour;
    Color hoverColor;
    boolean darkMode;
    static EmptyBorder borderStyle = new EmptyBorder(6, 0, 6, 7);

    static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public BalfContextMenu(Color mainBackground, Color mainForeground, Color paneColor, Color hoverColor) {
        this.mainBackground = mainBackground;
        this.mainForeground = mainForeground;
        this.paneColour = paneColor;
        this.hoverColor = hoverColor;
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        if (!BalfContextMenu.isMac()) {
            borderStyle = new EmptyBorder(3, 0, 3, 7);
        }
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            this.darkMode = enabled;
            if (enabled) {
                this.setForeground(Color.white);
            } else {
                this.setForeground(this.mainForeground);
            }
            this.repaint();
        });
    }

    public static class Separator
    extends JSeparator {
        BalfContextMenu contextMenu;
        boolean dashed = false;

        public Separator(BalfContextMenu contextMenu) {
            this.contextMenu = contextMenu;
        }

        public void setDashed(boolean dashed) {
            this.dashed = dashed;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(this.contextMenu.mainBackground);
            if (this.contextMenu.darkMode) {
                g2.setColor(new Color(20, 20, 20));
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(this.contextMenu.mainForeground.darker().darker());
            if (g2.getColor() == this.contextMenu.mainBackground) {
                g2.setColor(this.contextMenu.mainForeground.brighter().brighter());
            }
            if (this.contextMenu.darkMode) {
                g2.setColor(new Color(70, 70, 70));
            }
            int xPos = 10;
            if (this.contextMenu.paneColour != null) {
                g2.setColor(this.contextMenu.paneColour);
                if (this.contextMenu.darkMode) {
                    g2.setColor(new Color(51, 51, 51));
                }
                g2.fillRect(0, 0, 32, 32);
                g2.setColor(new Color(128, 128, 128));
                g2.drawLine(32, 0, 32, this.getHeight());
                xPos = 40;
            }
            if (this.dashed) {
                Stroke originalStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f));
                int y = this.getHeight() / 2;
                g2.drawLine(xPos, y, this.getWidth() - 10, y);
            } else {
                g2.fillRect(xPos, this.getHeight() / 2 - 1, this.getWidth() - xPos - 10, 1);
            }
            g2.dispose();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, 6);
        }
    }

    public static class MenuItem
    extends JMenuItem {
        private JMenuItem link = null;
        protected boolean hovered = false;
        protected BalfContextMenu contextMenu;
        private MenuItem _this = this;
        private Icon ico;
        protected Insets orgInsets;

        public MenuItem(BalfContextMenu menuBar) {
            this.orgInsets = super.getInsets();
            if (BalfContextMenu.isMac()) {
                new Insets(1, 5, 5, 5);
            } else {
                new Insets(1, 5, 5, 5);
            }
            this.setup(menuBar);
        }

        @Override
        public void setIcon(Icon icon) {
            this.ico = icon;
            if (this.link != null) {
                this.link.setIcon(icon);
            }
        }

        public MenuItem(String text, BalfContextMenu contextMenu) {
            super(text);
            this.setup(contextMenu);
        }

        public MenuItem(String text, Icon icon, BalfContextMenu contextMenu) {
            super(text, icon);
            this.setup(contextMenu);
        }

        private void setup(BalfContextMenu contextMenu) {
            this.contextMenu = contextMenu;
            this.setOpaque(false);
            this.setForeground(this.contextMenu.mainForeground);
            this.setBorder(borderStyle);
            super.setIcon(new BalfMenuBar.EmptyIcon());
            this.mouseListener();
            if (!BalfContextMenu.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            this.getModel().addChangeListener(e -> {
                this.setForeground(this.contextMenu.mainForeground);
                this.repaint();
            });
        }

        public MenuItem(Action a, BalfContextMenu contextMenu) {
            super(a);
            this.setup(contextMenu);
            if (!BalfContextMenu.isMac()) {
                this.setFont(new Font("Segoe UI", 0, 12));
            }
            BalfLafManager.getInstance().addDarkModeListener(enabled -> this.repaint());
        }

        void mouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    hovered = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    hovered = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            if (this.link != null) {
                this.link.setText(text);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.hovered) {
                g2.setColor(this.contextMenu.hoverColor);
            } else {
                g2.setColor(this.contextMenu.mainBackground);
                if (this.contextMenu.darkMode) {
                    g2.setColor(BalfLafManager.getInstance().getDarkColorBackground());
                }
            }
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.contextMenu.paneColour != null) {
                g2.setColor(this.contextMenu.paneColour);
                if (this.contextMenu.darkMode) {
                    g2.setColor(new Color(51, 51, 51));
                }
                g2.fillRect(0, 0, 32, 32);
                g2.setColor(new Color(128, 128, 128));
                g2.drawLine(32, 0, 32, this.getHeight());
            }
            if (this.ico != null) {
                int iconX = 8;
                int iconY = (this.getHeight() - this.ico.getIconHeight()) / 2;
                this.ico.paintIcon(this, g2, iconX, iconY);
            }
            super.paintComponent(g);
            g2.dispose();
        }
    }
}

