/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class BalfComboBox<E>
extends JComboBox<E> {
    private boolean isFocused = false;
    private JButton arrowBtn;

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(new CustomComboBoxUI());
    }

    public BalfComboBox() {
    }

    public BalfComboBox(E[] items) {
        super(items);
        this.setup();
    }

    private void setup() {
        this.setUI(new CustomComboBoxUI());
        this.setBackground(Color.WHITE);
        this.setForeground(Color.DARK_GRAY);
        this.setFocusable(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorder(new RoundedBorder(Color.GRAY, 4, 2));
        this.setOpaque(false);
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                label.setBorder(new EmptyBorder(4, 10, 4, 10));
                if (isSelected) {
                    label.setBackground(new Color(230, 230, 250));
                    label.setForeground(Color.BLACK);
                } else {
                    label.setBackground(Color.WHITE);
                    label.setForeground(Color.DARK_GRAY);
                }
                return label;
            }
        });
        Component editorComponent = this.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setBorder(new EmptyBorder(4, 10, 4, 10));
            field.setOpaque(false);
            field.setBackground(Color.WHITE);
            field.setForeground(Color.DARK_GRAY);
            field.setFont(new Font("Segoe UI", 0, 14));
        }
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                BalfComboBox.this.isFocused = true;
                BalfComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BalfComboBox.this.isFocused = false;
                BalfComboBox.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBorder(new RoundedBorder(this.isFocused ? new Color(255, 128, 0) : Color.GRAY, 10, 2));
        Graphics2D g2 = (Graphics2D)g;
        RoundRectangle2D.Float clip = new RoundRectangle2D.Float(0.0f, 1.0f, this.getWidth(), this.getHeight() - 1, 7.0f, 7.0f);
        g2.setColor(Color.white);
        g2.setClip(clip);
        g2.fillRect(0, 0, this.getWidth() - this.arrowBtn.getWidth() - 2, this.getHeight());
        g2.setColor(new Color(220, 220, 220));
        if (this.isFocused) {
            g2.setColor(new Color(138, 0, 255));
        }
        clip = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 12.0f, 12.0f);
        g2.setClip(clip);
        g2.fillRect(this.getWidth() - this.arrowBtn.getWidth() - 3, 1, this.arrowBtn.getWidth() + 3, this.getHeight() - 2);
    }

    private static class RoundedBorder
    extends AbstractBorder {
        private final Color colour;
        private final int radius;
        private final int thickness;

        public RoundedBorder(Color colour, int radius, int thickness) {
            this.colour = colour;
            this.radius = radius;
            this.thickness = thickness;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.colour);
            g2.setStroke(new BasicStroke(this.thickness));
            g2.drawRoundRect(x + this.thickness / 2, y + this.thickness / 2, width - this.thickness, height - this.thickness, this.radius, this.radius);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 3, 2, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(2, 3, 2, 3);
            return insets;
        }
    }

    private static class CustomComboBoxUI
    extends BasicComboBoxUI {
        private CustomComboBoxUI() {
        }

        @Override
        protected JButton createArrowButton() {
            JButton button = new JButton(){
                {
                    this.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
                    this.setContentAreaFilled(false);
                    this.setFocusPainted(false);
                    this.setOpaque(false);
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setStroke(new BasicStroke(3.0f, 1, 1));
                    g2.setColor(this.getForeground());
                    int w = this.getWidth();
                    int h = this.getHeight();
                    int size = Math.min(w, h) / 2;
                    int x1 = (w - size) / 2 + 2;
                    int x2 = w / 2 + 2;
                    int x3 = (w + size) / 2 + 2;
                    int y1 = h / 2 - 2;
                    int y2 = h / 2 + 2;
                    g2.drawLine(x1, y1, x2, y2);
                    g2.drawLine(x2, y2, x3, y1);
                    g2.setColor(new Color(128, 128, 128));
                    g2.drawLine(0, 0, 0, this.getHeight());
                    g2.dispose();
                }
            };
            if (this.comboBox instanceof BalfComboBox) {
                ((BalfComboBox)this.comboBox).arrowBtn = button;
            }
            return button;
        }
    }
}

