/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui.components;

import jamiebalfour.ui.BalfLafManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;

public class BalfPanel
extends JPanel {
    Color orgBackground;
    Color darkColour = BalfLafManager.getInstance().getDarkColorBackground().brighter();
    private int cornerRadius = 0;

    public BalfPanel() {
        this.init();
    }

    public BalfPanel(LayoutManager lm) {
        super(lm);
        this.init();
    }

    private void init() {
        this.setDoubleBuffered(true);
        this.orgBackground = this.getBackground();
        BalfLafManager.getInstance().addDarkModeListener(enabled -> {
            if (enabled) {
                this.enableDarkMode();
            } else {
                this.disableDarkMode();
            }
        });
    }

    public void setCornerRadius(int radius) {
        this.cornerRadius = radius;
        this.repaint();
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setDarkColour(Color darkColour) {
        this.darkColour = darkColour;
        this.repaint();
    }

    private void enableDarkMode() {
        this.setBackground(this.darkColour);
        this.repaint();
    }

    private void disableDarkMode() {
        this.setBackground(this.orgBackground);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float clip = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.cornerRadius, this.cornerRadius);
        g2.setColor(this.getBackground());
        g2.fill(clip);
        g2.dispose();
        super.paintComponent(g);
    }
}

