/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.ui;

import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class UITheme
implements Serializable {
    private static final long serialVersionUID = 13L;
    private final Color background;
    private final Color foreground;
    private final Font font;
    private final Color menuItemBackground;
    private final Color menuItemForeground;

    public UITheme(Color background, Color foreground) {
        this.background = background;
        this.foreground = foreground;
        this.font = null;
        this.menuItemBackground = background;
        this.menuItemForeground = foreground;
    }

    public UITheme(Color background, Color foreground, Font font) {
        this.background = background;
        this.foreground = foreground;
        this.font = font;
        this.menuItemBackground = background;
        this.menuItemForeground = foreground;
    }

    public UITheme(Color background, Color foreground, Color menuItemBackground, Color menuItemForeground) {
        this.background = background;
        this.foreground = foreground;
        this.font = null;
        this.menuItemBackground = menuItemBackground;
        this.menuItemForeground = menuItemForeground;
    }

    public UITheme(Color background, Color foreground, Font font, Color menuItemBackground, Color menuItemForeground) {
        this.background = background;
        this.foreground = foreground;
        this.font = font;
        this.menuItemBackground = menuItemBackground;
        this.menuItemForeground = menuItemForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getMenuItemBackground() {
        return this.menuItemBackground;
    }

    public Color getMenuItemForeground() {
        return this.menuItemForeground;
    }

    public String toString() {
        return "Background: " + String.valueOf(this.background) + "\nForeground: " + String.valueOf(this.foreground) + "\nFont: " + String.valueOf(this.font);
    }

    public void saveToFile(String filename) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(filename));){
            oos.writeObject(this);
        }
    }

    public static UITheme loadFromFile(String filename) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));){
            UITheme uITheme = (UITheme)ois.readObject();
            return uITheme;
        }
    }
}

