/*
 * Decompiled with CFR 0.152.
 */
package jamiebalfour.zpe.zen;

import extensions.mindrot.BCrypt;
import jamiebalfour.FileHelperFunctions;
import jamiebalfour.HelperFunctions;
import jamiebalfour.zpe.core.ZPECore;
import jamiebalfour.zpe.core.ZPEHelperFunctions;
import jamiebalfour.zpe.core.ZPERuntimeEnvironment;
import jamiebalfour.zpe.exceptions.ZENAuthenticationException;
import jamiebalfour.zpe.interfaces.ZPEType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ZENClient {
    BufferedReader in;
    PrintWriter out;
    Socket kkSocket;
    String password = null;
    String command_string = "zpe > ";
    String host_name = "";
    int port_number;
    ZPERuntimeEnvironment zx;
    ArrayList<String> serverCommands = new ArrayList();
    Terminal terminal = null;
    LineReader reader = null;
    byte[] passcode_bytes;

    private String pad(String s) {
        return HelperFunctions.padString(s, 16);
    }

    public ZENClient(String hostName, int portNumber, ZPERuntimeEnvironment z) {
        this(hostName, null, portNumber, z);
    }

    public ZENClient(String hostName, String password, int portNumber, ZPERuntimeEnvironment z) {
        this.host_name = hostName;
        this.port_number = portNumber;
        this.zx = z;
        this.password = this.pad(password);
        try {
            this.passcode_bytes = this.password.getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void send(String s, boolean encrypted) {
        try {
            if (encrypted) {
                if (this.password != null) {
                    this.out.println(HelperFunctions.encrypt(this.passcode_bytes, this.passcode_bytes, s));
                } else {
                    this.out.println(s);
                }
            } else {
                this.out.println(s);
            }
        }
        catch (Exception e) {
            this.out.println(s);
        }
    }

    public void openPersistentConnection() {
        try {
            this.openConnection();
            this.maintainConnection();
            this.closeConnection();
            ZPECore.print("Connection has been terminated.");
        }
        catch (UnknownHostException e) {
            ZPECore.print("Unknown host error. Check that host is actively running a ZENServer instance.");
        }
        catch (Exception e) {
            ZPECore.print(e.getMessage());
        }
    }

    public void closeConnection() {
        this.send("clt:close_connection", true);
        try {
            this.kkSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Disconnected from the server. Server says `bye`.");
    }

    public void openConnection() throws UnknownHostException, IOException, ZENAuthenticationException {
        String line;
        this.kkSocket = new Socket(this.host_name, this.port_number);
        this.out = new PrintWriter(this.kkSocket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.kkSocket.getInputStream()));
        this.send("clt:open_connection", false);
        this.terminal = TerminalBuilder.terminal();
        this.reader = LineReaderBuilder.builder().terminal(this.terminal).build();
        try {
            ZPEHelperFunctions.readHistory(this.reader, "client-history.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while ((line = this.in.readLine()) != null) {
            String cmd = line.substring(0, 4);
            String content = line.substring(4);
            if (cmd.equals("svr:")) {
                if (content.equals("welcome")) {
                    ZPECore.print("Connection to server succeeded on port number " + this.port_number);
                    continue;
                }
                if (content.equals("welcome_message")) {
                    Object message = "";
                    while ((line = this.in.readLine()) != null && !line.equals("svr:welcome_message_ends")) {
                        message = (String)message + line + System.lineSeparator();
                    }
                    System.out.println((String)message);
                    continue;
                }
                if (content.equals("ready")) break;
                if (content.equals("get_password")) {
                    if (this.password == null) {
                        ZPECore.print("Enter the password for the server now.", false);
                        this.password = this.pad(String.valueOf(System.console().readPassword()));
                        try {
                            this.passcode_bytes = this.password.getBytes("UTF-8");
                        }
                        catch (Exception message) {
                            // empty catch block
                        }
                    }
                    String salt = BCrypt.gensalt();
                    String s = BCrypt.hashpw(this.password, salt);
                    this.send("pwd:" + s, false);
                    continue;
                }
                if (content.equals("password_incorrect")) {
                    System.out.println("Incorrect password");
                    throw new ZENAuthenticationException("Connection refused.");
                }
                if (content.equals("server_command_list")) {
                    while ((line = this.in.readLine()) != null && !line.equals("svr:server_command_list_ends")) {
                        this.serverCommands.add(line);
                    }
                    continue;
                }
                if (!content.equals("close")) continue;
                ZPECore.print("EXIT COMMAND ISSUED. THE SERVER HAS CLOSED THE SOCKET");
                this.kkSocket.close();
                System.exit(0);
                continue;
            }
            if (!cmd.equals("msg:")) continue;
            ZPECore.print(content);
        }
    }

    public void maintainConnection() throws Exception {
        this.getInput();
        String line = "";
        while (true) {
            if ((line = this.in.readLine()) == null) {
                continue;
            }
            this.processLine(line);
        }
    }

    public ZPEType sendZPECommand(String cmd) throws Exception {
        String fromServer;
        ZPECore.print("`" + cmd + "` -> " + this.host_name + "[" + this.port_number + "]");
        this.send("zpe:" + cmd, true);
        ZPEType returnValue = null;
        while ((fromServer = this.in.readLine()) != null) {
            if ((fromServer = this.processText(fromServer)).startsWith("msg:")) {
                String msg = fromServer.substring(4, fromServer.length());
                System.out.println(msg);
                continue;
            }
            if (fromServer.startsWith("svr:done")) break;
            if (fromServer.startsWith("svr:not-accepted")) {
                System.out.println("This command is not accepted");
                break;
            }
            System.out.println(fromServer);
        }
        return returnValue;
    }

    public void sendCommand(String cmd) throws Exception {
        String fromServer;
        this.send("cmd:" + cmd, true);
        Object returnValue = null;
        while ((fromServer = this.in.readLine()) != null) {
            if ((fromServer = this.processText(fromServer)).startsWith("msg:")) {
                String msg = fromServer.substring(4);
                System.out.println(msg);
                continue;
            }
            if (fromServer.startsWith("svr:done")) break;
            if (fromServer.startsWith("svr:not-accepted")) {
                System.out.println("This command is not accepted");
                continue;
            }
            if (fromServer.startsWith("svr:close")) {
                ZPECore.print("EXIT COMMAND ISSUED. THE SERVER HAS CLOSED THE SOCKET");
                this.kkSocket.close();
                System.exit(0);
                continue;
            }
            System.out.println(fromServer);
        }
    }

    public void sendData(String f, String newFileName, byte[] data) throws Exception {
        try {
            if (this.password != null) {
                try {
                    data = HelperFunctions.writeEncryptedObject((Object)data, this.passcode_bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.send("put:" + data.length, true);
            String line = "";
            while ((line = this.in.readLine()) != null) {
                if (!(line = this.processText(line)).startsWith("svr:ready")) continue;
                this.kkSocket.getOutputStream().write(data);
                break;
            }
            this.send("put:done", true);
            this.send("put:file:" + newFileName, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String processText(String line) throws Exception {
        if (this.password != null) {
            return HelperFunctions.decrypt(this.passcode_bytes, this.passcode_bytes, line);
        }
        return line;
    }

    private void processLine(String line) throws Exception {
        boolean ready = false;
        if ((line = this.processText(line)).length() < 4) {
            System.out.println(line);
            return;
        }
        String cmd = line.substring(0, 4);
        String content = line.substring(4);
        if (cmd.equals("svr:")) {
            if (content.equals("bye")) {
                ZPECore.print("The server closed the connection.");
                return;
            }
            if (content.equals("ready")) {
                ready = true;
            }
        } else if (cmd.equals("put:")) {
            this.send("svr:ready", true);
            int len = HelperFunctions.stringToInteger(content);
            byte[] bytes = new byte[len];
            int readContent = this.kkSocket.getInputStream().read();
            for (int i = 0; i < len - 1; ++i) {
                bytes[i] = (byte)readContent;
                readContent = this.kkSocket.getInputStream().read();
            }
            bytes[len - 1] = (byte)readContent;
            String fname = "out.txt";
            while ((line = this.in.readLine()) != null) {
                if (!(line = this.processText(line)).contentEquals("put:done") || !(line = this.processText(this.in.readLine())).startsWith("put:file:")) continue;
                fname = line.substring(9);
                break;
            }
            if (this.password != null) {
                bytes = (byte[])HelperFunctions.readEncryptedObject(bytes, this.passcode_bytes);
            }
            FileHelperFunctions.writeByteFile(fname, bytes);
            ready = true;
            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToYellow(this.command_string), true);
        } else if (cmd.equals("msg:")) {
            ZPECore.print(content);
        }
        if (ready) {
            this.getInput();
        }
    }

    private void getInput() throws IOException {
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        String lineinput = "";
        if (this.reader != null) {
            lineinput = this.reader.readLine("zpe > ");
            ZPEHelperFunctions.saveHistory(this.reader, "client-history.txt");
        } else {
            ZPECore.print(ZPEHelperFunctions.setConsoleEffectToYellow(this.command_string), true);
            lineinput = stdIn.readLine();
        }
        if (lineinput.startsWith("put ")) {
            String fullCommand;
            String f = fullCommand = lineinput.substring(4);
            String newFileName = new File(f).getName();
            if (fullCommand.contains(" ")) {
                f = fullCommand.split(" ")[0];
                newFileName = fullCommand.split(" ")[1];
            }
            if (new File(f).exists()) {
                System.out.println(f + " -> " + this.host_name + "[" + this.port_number + "]");
                byte[] data = FileHelperFunctions.readFile(f);
                try {
                    this.sendData(f, newFileName, data);
                }
                catch (Exception e) {
                    System.err.println("Data could not be transmitted.");
                }
            } else {
                System.out.println("File " + f + " not found.");
            }
        } else if (lineinput.startsWith("get ")) {
            String f = lineinput.substring(4);
            this.send("get:" + f, true);
        } else if (lineinput.startsWith("lls")) {
            String dir = "";
            if (lineinput.length() > 3) {
                dir = lineinput.substring(3);
            }
            StringBuilder fileList = new StringBuilder();
            File f = new File(dir);
            if ((f = new File(f.getAbsoluteFile().toString())).exists() && f.isDirectory()) {
                for (File fi : f.listFiles()) {
                    fileList.append(fi.getAbsolutePath()).append(System.lineSeparator());
                }
                System.out.println(fileList);
            } else {
                System.out.println("This is not a directory to search.");
            }
            this.getInput();
        } else if (this.serverCommands.contains(lineinput.split(" ")[0])) {
            try {
                this.sendCommand(lineinput);
            }
            catch (Exception dir) {}
        } else if (lineinput.startsWith("bye")) {
            this.closeConnection();
            System.exit(0);
        } else {
            try {
                this.sendZPECommand(lineinput);
            }
            catch (Exception e) {
                System.err.println("Failed to execute ZPE remote command.");
            }
        }
    }
}

